/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public abstract class UnconnectedWays
extends Test {
    protected static final int UNCONNECTED_WAYS = 1301;
    protected static final String PREFIX = "validator." + UnconnectedWays.class.getSimpleName();
    private Set<MyWaySegment> ways;
    private QuadBuckets<Node> endnodes;
    private QuadBuckets<Node> endnodesHighway;
    private QuadBuckets<Node> middlenodes;
    private Set<Node> othernodes;
    private Area dsArea;
    private double mindist;
    private double minmiddledist;

    public UnconnectedWays(String title) {
        super(title, I18n.tr("This test checks if a way has an endpoint very near to another way.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.ways = new HashSet<MyWaySegment>();
        this.endnodes = new QuadBuckets();
        this.endnodesHighway = new QuadBuckets();
        this.middlenodes = new QuadBuckets();
        this.othernodes = new HashSet<Node>();
        this.mindist = Config.getPref().getDouble(PREFIX + ".node_way_distance", 10.0);
        this.minmiddledist = Config.getPref().getDouble(PREFIX + ".way_way_distance", 0.0);
        DataSet dataSet = OsmDataManager.getInstance().getEditDataSet();
        this.dsArea = dataSet == null ? null : dataSet.getDataSourceArea();
    }

    protected Map<Node, Way> getWayEndNodesNearOtherHighway() {
        HashMap<Node, Way> map = new HashMap<Node, Way>();
        for (int iter = 0; iter < 1; ++iter) {
            for (MyWaySegment s : this.ways) {
                if (this.isCanceled()) {
                    map.clear();
                    return map;
                }
                for (Node en : s.nearbyNodes(this.mindist)) {
                    if (en == null || !s.highway || !this.endnodesHighway.contains(en) || en.hasTag("highway", "turning_circle", "bus_stop") || en.hasTag("amenity", "parking_entrance") || en.hasTag("railway", "buffer_stop") || en.isKeyTrue("noexit") || en.hasKey("entrance", "barrier") || en.isConnectedTo(s.w.getNodes(), 3, null)) continue;
                    map.put(en, s.w);
                }
            }
        }
        return map;
    }

    protected Map<Node, Way> getWayEndNodesNearOtherWay() {
        HashMap<Node, Way> map = new HashMap<Node, Way>();
        for (MyWaySegment s : this.ways) {
            if (this.isCanceled()) {
                map.clear();
                return map;
            }
            for (Node en : s.nearbyNodes(this.mindist)) {
                if (en.isConnectedTo(s.w.getNodes(), 3, null)) continue;
                if (!s.highway && this.endnodesHighway.contains(en) && !s.w.concernsArea()) {
                    map.put(en, s.w);
                    continue;
                }
                if (!this.endnodes.contains(en) || s.w.concernsArea()) continue;
                map.put(en, s.w);
            }
        }
        return map;
    }

    protected Map<Node, Way> getWayNodesNearOtherWay() {
        HashMap<Node, Way> map = new HashMap<Node, Way>();
        for (MyWaySegment s : this.ways) {
            if (this.isCanceled()) {
                map.clear();
                return map;
            }
            for (Node en : s.nearbyNodes(this.minmiddledist)) {
                if (en.isConnectedTo(s.w.getNodes(), 3, null) || !this.middlenodes.contains(en)) continue;
                map.put(en, s.w);
            }
        }
        return map;
    }

    protected Map<Node, Way> getConnectedWayEndNodesNearOtherWay() {
        HashMap<Node, Way> map = new HashMap<Node, Way>();
        for (MyWaySegment s : this.ways) {
            if (this.isCanceled()) {
                map.clear();
                return map;
            }
            for (Node en : s.nearbyNodes(this.minmiddledist)) {
                if (en.isConnectedTo(s.w.getNodes(), 3, null) || !this.othernodes.contains(en)) continue;
                map.put(en, s.w);
            }
        }
        return map;
    }

    protected final void addErrors(Severity severity, Map<Node, Way> errorMap, String message) {
        for (Map.Entry<Node, Way> error : errorMap.entrySet()) {
            this.errors.add(TestError.builder(this, severity, 1301).message(message).primitives(error.getKey(), error.getValue()).highlight(error.getKey()).build());
        }
    }

    @Override
    public void endTest() {
        this.addErrors(Severity.WARNING, this.getWayEndNodesNearOtherHighway(), I18n.tr("Way end node near other highway", new Object[0]));
        this.addErrors(Severity.WARNING, this.getWayEndNodesNearOtherWay(), I18n.tr("Way end node near other way", new Object[0]));
        if (this.minmiddledist > 0.0) {
            this.addErrors(Severity.OTHER, this.getWayNodesNearOtherWay(), I18n.tr("Way node near other way", new Object[0]));
            this.addErrors(Severity.OTHER, this.getConnectedWayEndNodesNearOtherWay(), I18n.tr("Connected way end node near other way", new Object[0]));
        }
        this.ways = null;
        this.endnodes = null;
        this.endnodesHighway = null;
        this.middlenodes = null;
        this.othernodes = null;
        this.dsArea = null;
        super.endTest();
    }

    List<MyWaySegment> getWaySegments(Way w) {
        ArrayList<MyWaySegment> ret = new ArrayList<MyWaySegment>();
        if (!w.isUsable() || w.hasKey("barrier") || w.hasTag("natural", "cliff")) {
            return ret;
        }
        int size = w.getNodesCount();
        if (size < 2) {
            return ret;
        }
        for (int i = 1; i < size; ++i) {
            if (i < size - 1) {
                this.addNode(w.getNode(i), this.middlenodes);
            }
            Node a = w.getNode(i - 1);
            Node b = w.getNode(i);
            if (!a.isDrawable() || !b.isDrawable()) continue;
            MyWaySegment ws = new MyWaySegment(w, a, b);
            if (ws.isBoundary || ws.isAbandoned) continue;
            ret.add(ws);
        }
        return ret;
    }

    @Override
    public void visit(Way w) {
        if (!(w.getNodesCount() <= 0 || w.hasKey("addr:interpolation") || w.hasTag("highway", "platform") || w.hasTag("railway", "platform") || w.hasTag("natural", "tree_row"))) {
            this.ways.addAll(this.getWaySegments(w));
            QuadBuckets<Node> set = this.endnodes;
            if (w.hasKey("highway", "railway")) {
                set = this.endnodesHighway;
            }
            this.addNode(w.firstNode(), set);
            this.addNode(w.lastNode(), set);
        }
    }

    private void addNode(Node n, QuadBuckets<Node> s) {
        boolean m = this.middlenodes.contains(n);
        boolean e = this.endnodes.contains(n);
        boolean eh = this.endnodesHighway.contains(n);
        boolean o = this.othernodes.contains(n);
        if (!(m || e || o || eh)) {
            s.add(n);
        } else if (!o) {
            this.othernodes.add(n);
            if (e) {
                this.endnodes.remove(n);
            } else if (eh) {
                this.endnodesHighway.remove(n);
            } else {
                this.middlenodes.remove(n);
            }
        }
    }

    private class MyWaySegment {
        private final Line2D line;
        public final Way w;
        public final boolean isAbandoned;
        public final boolean isBoundary;
        public final boolean highway;
        private final double len;
        private Set<Node> nearbyNodeCache;
        private double nearbyNodeCacheDist = -1.0;
        private final Node n1;
        private final Node n2;

        MyWaySegment(Way w, Node n1, Node n2) {
            this.w = w;
            String railway = w.get("railway");
            String highway = w.get("highway");
            this.isAbandoned = "abandoned".equals(railway) || w.isKeyTrue("disused");
            this.highway = (highway != null || railway != null) && !this.isAbandoned;
            this.isBoundary = !this.highway && w.hasTag("boundary", "administrative");
            this.line = new Line2D.Double(n1.getEastNorth().east(), n1.getEastNorth().north(), n2.getEastNorth().east(), n2.getEastNorth().north());
            this.len = this.line.getP1().distance(this.line.getP2());
            this.n1 = n1;
            this.n2 = n2;
        }

        public boolean nearby(Node n, double dist) {
            if (this.w == null) {
                Logging.debug("way null");
                return false;
            }
            if (this.w.containsNode(n)) {
                return false;
            }
            if (n.isKeyTrue("noexit")) {
                return false;
            }
            EastNorth coord = n.getEastNorth();
            if (coord == null) {
                return false;
            }
            Point2D.Double p = new Point2D.Double(coord.east(), coord.north());
            if (this.line.getP1().distance(p) > this.len + dist) {
                return false;
            }
            if (this.line.getP2().distance(p) > this.len + dist) {
                return false;
            }
            return this.line.ptSegDist(p) < dist;
        }

        public List<LatLon> getBounds(double fudge) {
            double y2;
            double y1;
            double x2;
            double x1 = this.n1.getCoor().lon();
            if (x1 > (x2 = this.n2.getCoor().lon())) {
                double tmpx = x1;
                x1 = x2;
                x2 = tmpx;
            }
            if ((y1 = this.n1.getCoor().lat()) > (y2 = this.n2.getCoor().lat())) {
                double tmpy = y1;
                y1 = y2;
                y2 = tmpy;
            }
            LatLon topLeft = new LatLon(y2 + fudge, x1 - fudge);
            LatLon botRight = new LatLon(y1 - fudge, x2 + fudge);
            ArrayList<LatLon> ret = new ArrayList<LatLon>(2);
            ret.add(topLeft);
            ret.add(botRight);
            return ret;
        }

        public Collection<Node> nearbyNodes(double dist) {
            if (dist > this.nearbyNodeCacheDist) {
                this.nearbyNodeCache = null;
            }
            if (this.nearbyNodeCache != null) {
                if (this.nearbyNodeCacheDist > dist) {
                    HashSet<Node> trimmed = new HashSet<Node>(this.nearbyNodeCache);
                    HashSet<Node> initial = new HashSet<Node>(this.nearbyNodeCache);
                    for (Node n : initial) {
                        if (this.nearby(n, dist)) continue;
                        trimmed.remove(n);
                    }
                    return trimmed;
                }
                return this.nearbyNodeCache;
            }
            this.nearbyNodeCache = null;
            List<LatLon> bounds = this.getBounds(dist * (360.0 / (Ellipsoid.WGS84.a * 2.0 * Math.PI)));
            List foundNodes = UnconnectedWays.this.endnodesHighway.search(new BBox(bounds.get(0), bounds.get(1)));
            foundNodes.addAll(UnconnectedWays.this.endnodes.search(new BBox(bounds.get(0), bounds.get(1))));
            for (Node n : foundNodes) {
                if (!this.nearby(n, dist) || !n.getCoor().isIn(UnconnectedWays.this.dsArea)) continue;
                if (this.nearbyNodeCache == null) {
                    this.nearbyNodeCache = new HashSet<Node>();
                }
                this.nearbyNodeCache.add(n);
            }
            this.nearbyNodeCacheDist = dist;
            if (this.nearbyNodeCache == null) {
                this.nearbyNodeCache = Collections.emptySet();
            }
            return this.nearbyNodeCache;
        }
    }

    public static class UnconnectedPower
    extends UnconnectedWays {
        public UnconnectedPower() {
            super(I18n.tr("Unconnected power ways", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive p) {
            return super.isPrimitiveUsable(p) && p.hasTag("power", "line", "minor_line", "cable");
        }
    }

    public static class UnconnectedNaturalOrLanduse
    extends UnconnectedWays {
        public UnconnectedNaturalOrLanduse() {
            super(I18n.tr("Unconnected natural lands and landuses", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive p) {
            return super.isPrimitiveUsable(p) && p.hasKey("natural", "landuse");
        }
    }

    public static class UnconnectedWaterways
    extends UnconnectedWays {
        public UnconnectedWaterways() {
            super(I18n.tr("Unconnected waterways", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive p) {
            return super.isPrimitiveUsable(p) && p.hasKey("waterway");
        }
    }

    public static class UnconnectedRailways
    extends UnconnectedWays {
        public UnconnectedRailways() {
            super(I18n.tr("Unconnected railways", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive p) {
            return super.isPrimitiveUsable(p) && p.hasKey("railway");
        }
    }

    public static class UnconnectedHighways
    extends UnconnectedWays {
        public UnconnectedHighways() {
            super(I18n.tr("Unconnected highways", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive p) {
            return super.isPrimitiveUsable(p) && p.hasKey("highway");
        }
    }
}

