/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import org.openstreetmap.josm.tools.I18n;

public final class LanguageInfo {
    private LanguageInfo() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getWikiLanguagePrefix(LocaleType type) {
        if (type == LocaleType.ENGLISH) {
            return "";
        }
        String code = LanguageInfo.getJOSMLocaleCode();
        if (type == LocaleType.BASELANGUAGE) {
            if (!code.matches("[^_]+_[^_]+")) return null;
            if (!"en".equals(code = code.substring(0, 2))) return code.substring(0, 1).toUpperCase(Locale.ENGLISH) + code.substring(1) + ':';
            return null;
        }
        if (type == LocaleType.DEFAULTNOTENGLISH && "en".equals(code)) {
            return null;
        }
        if (!code.matches(".+@.+")) return code.substring(0, 1).toUpperCase(Locale.ENGLISH) + code.substring(1) + ':';
        return code.substring(0, 1).toUpperCase(Locale.ENGLISH) + code.substring(1, 2) + '-' + code.substring(3, 4).toUpperCase(Locale.ENGLISH) + code.substring(4) + ':';
    }

    public static String getWikiLanguagePrefix() {
        return LanguageInfo.getWikiLanguagePrefix(LocaleType.DEFAULT);
    }

    public static String getJOSMLocaleCode() {
        return LanguageInfo.getJOSMLocaleCode(Locale.getDefault());
    }

    public static String getJOSMLocaleCode(Locale locale) {
        if (locale == null) {
            return "en";
        }
        for (String full : LanguageInfo.getLanguageCodes(locale)) {
            if ("iw_IL".equals(full)) {
                return "he";
            }
            if ("in".equals(full)) {
                return "id";
            }
            if (!I18n.hasCode(full)) continue;
            return full;
        }
        return locale.getLanguage();
    }

    public static String getJavaLocaleCode(String localeName) {
        if (localeName == null) {
            return "en";
        }
        if ("ca@valencia".equals(localeName)) {
            localeName = "ca__valencia";
        } else if ("he".equals(localeName)) {
            localeName = "iw_IL";
        } else if ("id".equals(localeName)) {
            localeName = "in";
        }
        return localeName;
    }

    public static String getDisplayName(Locale locale) {
        return locale.getDisplayName();
    }

    public static Locale getLocale(String localeName) {
        int country = localeName.indexOf(95);
        int variant = localeName.indexOf(64);
        if (variant < 0 && country >= 0) {
            variant = localeName.indexOf(95, country + 1);
        }
        Locale l = variant > 0 && country > 0 ? new Locale(localeName.substring(0, country), localeName.substring(country + 1, variant), localeName.substring(variant + 1)) : (variant > 0 ? new Locale(localeName.substring(0, variant), "", localeName.substring(variant + 1)) : (country > 0 ? new Locale(localeName.substring(0, country), localeName.substring(country + 1)) : new Locale(localeName)));
        return l;
    }

    public static boolean isBetterLanguage(String oldLanguage, String newLanguage) {
        if (oldLanguage == null) {
            return true;
        }
        String want = LanguageInfo.getJOSMLocaleCode();
        return want.equals(newLanguage) || !want.equals(oldLanguage) && newLanguage.startsWith("en");
    }

    public static String getLanguageCodeXML() {
        String code = LanguageInfo.getJOSMLocaleCode();
        code = code.replace('@', '-');
        return code + '.';
    }

    public static String getLanguageCodeManifest() {
        String code = LanguageInfo.getJOSMLocaleCode();
        code = code.replace('@', '-');
        return code + '_';
    }

    public static Collection<String> getLanguageCodes(Locale l) {
        LinkedList<String> list = new LinkedList<String>();
        if (l == null) {
            l = Locale.getDefault();
        }
        String lang = l.getLanguage();
        String c = l.getCountry();
        String v = l.getVariant();
        if (c.isEmpty()) {
            c = null;
        }
        if (v != null && !v.isEmpty()) {
            if (c != null) {
                list.add(lang + '_' + c + '@' + v);
            }
            list.add(lang + '@' + v);
        }
        if (c != null) {
            list.add(lang + '_' + c);
        }
        list.add(lang);
        return list;
    }

    public static enum LocaleType {
        DEFAULT,
        DEFAULTNOTENGLISH,
        BASELANGUAGE,
        ENGLISH;

    }
}

