'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiXYChartTextUtils = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Word wrapper that takes a long text and wrap words into lines of the same length.
 * and return a SVG component composed by tspan tags.
 * source: https://j11y.io/snippets/wordwrap-for-javascript/
 * @param {Array of Strings} texts - an array of splitted text, one per line
 * @return {Object} Return a Fragment of SVG tspan elements to be used inside axis label formatter.
 */
function labelWordWrap(text, width) {
  var pieces = wordWrap(text, width);
  return _react2.default.createElement(
    _react.Fragment,
    null,
    pieces.map(function (piece, i) {
      return _react2.default.createElement(
        'tspan',
        { x: 0, dy: '1em', key: 'text-span-' + i },
        piece
      );
    })
  );
}

function wordWrap(text) {
  var width = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 75;
  var cut = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

  if (!text) {
    return text;
  }
  var regex = '.{1,' + width + '}(s|$)' + (cut ? '|.{' + width + '}|.+$' : '|S+?(s|$)');
  return text.match(RegExp(regex, 'g'));
}
var EuiXYChartTextUtils = exports.EuiXYChartTextUtils = {
  labelWordWrap: labelWordWrap
};