'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KuiContextMenuItem = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * this work for additional information regarding copyright
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may obtain a copy of the License at
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * software distributed under the License is distributed on an
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * specific language governing permissions and limitations
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * under the License.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var KuiContextMenuItem = exports.KuiContextMenuItem = function (_Component) {
  _inherits(KuiContextMenuItem, _Component);

  function KuiContextMenuItem() {
    _classCallCheck(this, KuiContextMenuItem);

    return _possibleConstructorReturn(this, (KuiContextMenuItem.__proto__ || Object.getPrototypeOf(KuiContextMenuItem)).apply(this, arguments));
  }

  _createClass(KuiContextMenuItem, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          children = _props.children,
          className = _props.className,
          hasPanel = _props.hasPanel,
          icon = _props.icon,
          buttonRef = _props.buttonRef,
          disabled = _props.disabled,
          rest = _objectWithoutProperties(_props, ['children', 'className', 'hasPanel', 'icon', 'buttonRef', 'disabled']);

      var iconInstance = void 0;

      if (icon) {
        iconInstance = (0, _react.cloneElement)(icon, {
          className: (0, _classnames2.default)(icon.props.className, 'kuiContextMenu__icon')
        });
      }

      var arrow = void 0;

      if (hasPanel) {
        arrow = _react2.default.createElement('span', { className: 'kuiContextMenu__arrow kuiIcon fa-angle-right' });
      }

      var classes = (0, _classnames2.default)('kuiContextMenuItem', className, {
        'kuiContextMenuItem-disabled': disabled
      });

      return _react2.default.createElement(
        'button',
        _extends({
          className: classes,
          ref: buttonRef,
          disabled: disabled
        }, rest),
        _react2.default.createElement(
          'span',
          { className: 'kuiContextMenu__itemLayout' },
          iconInstance,
          _react2.default.createElement(
            'span',
            { className: 'kuiContextMenuItem__text' },
            children
          ),
          arrow
        )
      );
    }
  }]);

  return KuiContextMenuItem;
}(_react.Component);

KuiContextMenuItem.propTypes = {
  children: _propTypes2.default.node,
  className: _propTypes2.default.string,
  icon: _propTypes2.default.element,
  onClick: _propTypes2.default.func,
  hasPanel: _propTypes2.default.bool,
  buttonRef: _propTypes2.default.func,
  disabled: _propTypes2.default.bool
};
