'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.KuiListingTable = KuiListingTable;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _listing_table_tool_bar = require('./listing_table_tool_bar');

var _listing_table_tool_bar_footer = require('./listing_table_tool_bar_footer');

var _listing_table_row = require('./listing_table_row');

var _index = require('../../index');

var _services = require('../../../services');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /*
                                                                                                                                                                                                     * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                     * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                     * this work for additional information regarding copyright
                                                                                                                                                                                                     * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                     * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                     * not use this file except in compliance with the License.
                                                                                                                                                                                                     * You may obtain a copy of the License at
                                                                                                                                                                                                     *
                                                                                                                                                                                                     *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                     *
                                                                                                                                                                                                     * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                     * software distributed under the License is distributed on an
                                                                                                                                                                                                     * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                     * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                     * specific language governing permissions and limitations
                                                                                                                                                                                                     * under the License.
                                                                                                                                                                                                     */

function KuiListingTable(_ref) {
  var rows = _ref.rows,
      header = _ref.header,
      pager = _ref.pager,
      toolBarActions = _ref.toolBarActions,
      onFilter = _ref.onFilter,
      onItemSelectionChanged = _ref.onItemSelectionChanged,
      selectedRowIds = _ref.selectedRowIds,
      filter = _ref.filter,
      prompt = _ref.prompt;


  function areAllRowsSelected() {
    return rows.length > 0 && rows.length === selectedRowIds.length;
  }

  function toggleAll() {
    if (areAllRowsSelected()) {
      onItemSelectionChanged([]);
    } else {
      onItemSelectionChanged(rows.map(function (row) {
        return row.id;
      }));
    }
  }

  function toggleRow(rowId) {
    var selectedRowIndex = selectedRowIds.indexOf(rowId);
    if (selectedRowIndex >= 0) {
      onItemSelectionChanged(selectedRowIds.filter(function (item, index) {
        return index !== selectedRowIndex;
      }));
    } else {
      onItemSelectionChanged([].concat(_toConsumableArray(selectedRowIds), [rowId]));
    }
  }

  function renderTableRows() {
    return rows.map(function (row, rowIndex) {
      return _react2.default.createElement(_listing_table_row.KuiListingTableRow, {
        key: rowIndex,
        isSelected: selectedRowIds.indexOf(row.id) >= 0,
        onSelectionChanged: toggleRow,
        row: row
      });
    });
  }

  function renderHeader() {
    return header.map(function (cell, index) {
      var content = cell.content,
          props = _objectWithoutProperties(cell, ['content']);

      if (_react2.default.isValidElement(cell) || !_lodash2.default.isObject(cell)) {
        props = [];
        content = cell;
      }
      return _react2.default.createElement(
        _index.KuiTableHeaderCell,
        _extends({
          key: index
        }, props),
        content
      );
    });
  }

  function renderInnerTable() {
    return _react2.default.createElement(
      _index.KuiTable,
      null,
      _react2.default.createElement(
        _index.KuiTableHeader,
        null,
        _react2.default.createElement(_index.KuiTableHeaderCheckBoxCell, {
          isChecked: areAllRowsSelected(),
          onChange: toggleAll
        }),
        renderHeader()
      ),
      _react2.default.createElement(
        _index.KuiTableBody,
        null,
        renderTableRows()
      )
    );
  }

  return _react2.default.createElement(
    _index.KuiControlledTable,
    null,
    _react2.default.createElement(_listing_table_tool_bar.KuiListingTableToolBar, {
      actions: toolBarActions,
      pager: pager,
      onFilter: onFilter,
      filter: filter
    }),
    prompt ? prompt : renderInnerTable(),
    _react2.default.createElement(_listing_table_tool_bar_footer.KuiListingTableToolBarFooter, {
      itemsSelectedCount: selectedRowIds.length,
      pager: pager
    })
  );
}

KuiListingTable.propTypes = {
  header: _propTypes2.default.arrayOf(_propTypes2.default.oneOfType([_propTypes2.default.node, _propTypes2.default.shape({
    content: _propTypes2.default.node,
    align: _propTypes2.default.oneOf([_services.LEFT_ALIGNMENT, _services.RIGHT_ALIGNMENT]),
    onSort: _propTypes2.default.func,
    isSortAscending: _propTypes2.default.bool,
    isSorted: _propTypes2.default.bool
  })])),
  rows: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    id: _propTypes2.default.string,
    cells: _propTypes2.default.arrayOf(_propTypes2.default.oneOfType([_propTypes2.default.node, _propTypes2.default.shape({
      content: _propTypes2.default.node,
      align: _propTypes2.default.oneOf([_services.LEFT_ALIGNMENT, _services.RIGHT_ALIGNMENT])
    })]))
  })),
  pager: _propTypes2.default.node,
  onItemSelectionChanged: _propTypes2.default.func.isRequired,
  selectedRowIds: _propTypes2.default.array,
  prompt: _propTypes2.default.node, // If given, will be shown instead of a table with rows.
  onFilter: _propTypes2.default.func,
  toolBarActions: _propTypes2.default.node,
  filter: _propTypes2.default.string
};

KuiListingTable.defaultProps = {
  rows: [],
  selectedRowIds: []
};
