"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var channel_1 = require("../../channel");
var type_1 = require("../../type");
var util_1 = require("../../util");
var dataflow_1 = require("./dataflow");
var GeoJSONNode = /** @class */ (function (_super) {
    tslib_1.__extends(GeoJSONNode, _super);
    function GeoJSONNode(parent, fields, geojson, signal) {
        var _this = _super.call(this, parent) || this;
        _this.fields = fields;
        _this.geojson = geojson;
        _this.signal = signal;
        return _this;
    }
    GeoJSONNode.prototype.clone = function () {
        return new GeoJSONNode(null, util_1.duplicate(this.fields), this.geojson, this.signal);
    };
    GeoJSONNode.parseAll = function (parent, model) {
        var geoJsonCounter = 0;
        [[channel_1.LONGITUDE, channel_1.LATITUDE], [channel_1.LONGITUDE2, channel_1.LATITUDE2]].forEach(function (coordinates) {
            var pair = coordinates.map(function (channel) { return model.channelHasField(channel) ? model.fieldDef(channel).field : undefined; });
            if (pair[0] || pair[1]) {
                parent = new GeoJSONNode(parent, pair, null, model.getName("geojson_" + geoJsonCounter++));
            }
        });
        if (model.channelHasField(channel_1.SHAPE)) {
            var fieldDef = model.fieldDef(channel_1.SHAPE);
            if (fieldDef.type === type_1.GEOJSON) {
                parent = new GeoJSONNode(parent, null, fieldDef.field, model.getName("geojson_" + geoJsonCounter++));
            }
        }
        return parent;
    };
    GeoJSONNode.prototype.assemble = function () {
        return tslib_1.__assign({ type: 'geojson' }, (this.fields ? { fields: this.fields } : {}), (this.geojson ? { geojson: this.geojson } : {}), { signal: this.signal });
    };
    return GeoJSONNode;
}(dataflow_1.DataFlowNode));
exports.GeoJSONNode = GeoJSONNode;
//# sourceMappingURL=data:application/json;base64,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