/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import nokogiri.NokogiriService;
import nokogiri.XmlAttributeDecl;
import nokogiri.XmlDocument;
import nokogiri.XmlElementContent;
import nokogiri.XmlElementDecl;
import nokogiri.XmlEntityDecl;
import nokogiri.XmlNode;
import nokogiri.XmlNodeSet;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.SaveContextVisitor;
import org.apache.xerces.xni.QName;
import org.cyberneko.dtd.DTDConfiguration;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@JRubyClass(name={"Nokogiri::XML::DTD"}, parent="Nokogiri::XML::Node")
public class XmlDtd
extends XmlNode {
    protected RubyArray allDecls = null;
    protected IRubyObject children = null;
    protected RubyHash attributes = null;
    protected RubyHash elements = null;
    protected RubyHash entities = null;
    protected RubyHash notations = null;
    protected RubyClass notationClass;
    protected RubyHash contentModels;
    protected IRubyObject name;
    protected IRubyObject pubId;
    protected IRubyObject sysId;

    public XmlDtd(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public void setNode(Ruby ruby, Node node) {
        this.node = node;
        this.notationClass = (RubyClass)ruby.getClassFromPath("Nokogiri::XML::Notation");
        this.pubId = this.sysId = ruby.getNil();
        this.name = this.sysId;
        if (node == null) {
            return;
        }
        DocumentType documentType = node.getOwnerDocument().getDoctype();
        if (documentType != null) {
            this.name = NokogiriHelpers.stringOrNil(ruby, documentType.getNodeName());
            this.pubId = NokogiriHelpers.nonEmptyStringOrNil(ruby, documentType.getPublicId());
            this.sysId = NokogiriHelpers.nonEmptyStringOrNil(ruby, documentType.getSystemId());
        }
    }

    public XmlDtd(Ruby ruby, RubyClass rubyClass, Node node) {
        super(ruby, rubyClass, node);
        this.setNode(ruby, node);
    }

    public static XmlDtd newEmpty(Ruby ruby, Document document, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        DocumentType documentType;
        Object object;
        if (document.getDoctype() == null) {
            object = NokogiriHelpers.rubyStringToString(iRubyObject);
            String string = NokogiriHelpers.rubyStringToString(iRubyObject2);
            String string2 = NokogiriHelpers.rubyStringToString(iRubyObject3);
            documentType = document.getImplementation().createDocumentType((String)object, string, string2);
            document.appendChild(documentType);
        } else {
            documentType = document.getDoctype();
        }
        object = (XmlDtd)NokogiriService.XML_DTD_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::DTD"));
        ((XmlDtd)((Object)object)).setNode(ruby, (Node)documentType);
        ((XmlDtd)((Object)object)).name = iRubyObject;
        ((XmlDtd)((Object)object)).pubId = iRubyObject2;
        ((XmlDtd)((Object)object)).sysId = iRubyObject3;
        return object;
    }

    public static XmlDtd newFromInternalSubset(Ruby ruby, Document document) {
        Object object = document.getUserData("DTD_RAW_DOCUMENT");
        if (object == null) {
            XmlDtd xmlDtd = (XmlDtd)NokogiriService.XML_DTD_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::DTD"));
            xmlDtd.setNode(ruby, null);
            return xmlDtd;
        }
        Node node = (Node)object;
        Node node2 = XmlDtd.getInternalSubset(node);
        if (node2 == null) {
            XmlDtd xmlDtd = (XmlDtd)NokogiriService.XML_DTD_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::DTD"));
            xmlDtd.setNode(ruby, null);
            return xmlDtd;
        }
        node2 = document.importNode(node2, true);
        XmlDtd xmlDtd = (XmlDtd)NokogiriService.XML_DTD_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::DTD"));
        xmlDtd.setNode(ruby, node2);
        return xmlDtd;
    }

    public static IRubyObject newFromExternalSubset(Ruby ruby, Document document) {
        Object object = document.getUserData("DTD_RAW_DOCUMENT");
        if (object == null) {
            return ruby.getNil();
        }
        Node node = (Node)object;
        Node node2 = XmlDtd.getExternalSubset(node);
        if (node2 == null) {
            return ruby.getNil();
        }
        if (!node2.hasChildNodes()) {
            return ruby.getNil();
        }
        node2 = document.importNode(node2, true);
        XmlDtd xmlDtd = (XmlDtd)NokogiriService.XML_DTD_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::DTD"));
        xmlDtd.setNode(ruby, node2);
        return xmlDtd;
    }

    protected static Node getInternalSubset(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (XmlDtd.isDTD(node2)) {
                return node2;
            }
            node2 = node2.getNextSibling();
        }
        return null;
    }

    protected static Node getExternalSubset(Node node) {
        Node node2 = XmlDtd.getInternalSubset(node);
        if (node2 == null) {
            return null;
        }
        Node node3 = node2.getFirstChild();
        while (node3 != null) {
            if (XmlDtd.isExternalSubset(node3)) {
                return node3;
            }
            node3 = node3.getNextSibling();
        }
        return null;
    }

    @JRubyMethod
    public IRubyObject attributes(ThreadContext threadContext) {
        if (this.attributes == null) {
            this.extractDecls(threadContext);
        }
        return this.attributes;
    }

    @JRubyMethod
    public IRubyObject elements(ThreadContext threadContext) {
        if (this.elements == null) {
            this.extractDecls(threadContext);
        }
        return this.elements;
    }

    @JRubyMethod
    public IRubyObject entities(ThreadContext threadContext) {
        if (this.entities == null) {
            this.extractDecls(threadContext);
        }
        return this.entities;
    }

    @JRubyMethod
    public IRubyObject notations(ThreadContext threadContext) {
        if (this.notations == null) {
            this.extractDecls(threadContext);
        }
        return this.notations;
    }

    @Override
    @JRubyMethod
    public IRubyObject children(ThreadContext threadContext) {
        if (this.children == null) {
            this.extractDecls(threadContext);
        }
        return this.children;
    }

    @Override
    @JRubyMethod
    public IRubyObject node_name(ThreadContext threadContext) {
        return this.name;
    }

    @Override
    @JRubyMethod(name={"node_name="})
    public IRubyObject node_name_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        throw threadContext.getRuntime().newRuntimeError("cannot change name of DTD");
    }

    @JRubyMethod
    public IRubyObject system_id(ThreadContext threadContext) {
        return this.sysId;
    }

    @JRubyMethod
    public IRubyObject external_id(ThreadContext threadContext) {
        return this.pubId;
    }

    @JRubyMethod
    public IRubyObject validate(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyArray rubyArray = RubyArray.newArray((Ruby)threadContext.getRuntime());
        if (iRubyObject instanceof XmlDocument) {
            rubyArray = (RubyArray)((XmlDocument)iRubyObject).getInstanceVariable("@errors");
        }
        return rubyArray;
    }

    public static boolean nameEquals(Node node, QName qName) {
        return qName.localpart.equals(node.getNodeName());
    }

    public static boolean isExternalSubset(Node node) {
        return XmlDtd.nameEquals(node, DTDConfiguration.E_EXTERNAL_SUBSET);
    }

    public static boolean isDTD(Node node) {
        return node instanceof Element && XmlDtd.nameEquals(node, DTDConfiguration.E_DTD);
    }

    public static boolean isAttributeDecl(Node node) {
        return XmlDtd.nameEquals(node, DTDConfiguration.E_ATTRIBUTE_DECL);
    }

    public static boolean isElementDecl(Node node) {
        return XmlDtd.nameEquals(node, DTDConfiguration.E_ELEMENT_DECL);
    }

    public static boolean isEntityDecl(Node node) {
        return XmlDtd.nameEquals(node, DTDConfiguration.E_INTERNAL_ENTITY_DECL) || XmlDtd.nameEquals(node, DTDConfiguration.E_UNPARSED_ENTITY_DECL);
    }

    public static boolean isNotationDecl(Node node) {
        return XmlDtd.nameEquals(node, DTDConfiguration.E_NOTATION_DECL);
    }

    public static boolean isContentModel(Node node) {
        return XmlDtd.nameEquals(node, DTDConfiguration.E_CONTENT_MODEL);
    }

    protected void extractDecls(ThreadContext threadContext) {
        XmlAttributeDecl xmlAttributeDecl;
        IRubyObject iRubyObject;
        IRubyObject iRubyObject2;
        int n;
        Ruby ruby = threadContext.getRuntime();
        this.allDecls = RubyArray.newArray((Ruby)ruby);
        this.attributes = RubyHash.newHash((Ruby)ruby);
        this.elements = RubyHash.newHash((Ruby)ruby);
        this.entities = RubyHash.newHash((Ruby)ruby);
        this.notations = RubyHash.newHash((Ruby)ruby);
        this.contentModels = RubyHash.newHash((Ruby)ruby);
        this.children = ruby.getNil();
        if (this.node == null) {
            return;
        }
        this.extractDecls(threadContext, this.node.getFirstChild());
        this.children = XmlNodeSet.newXmlNodeSet(threadContext, this.allDecls);
        RubyArray rubyArray = this.attributes.keys();
        for (n = 0; n < rubyArray.getLength(); ++n) {
            IRubyObject iRubyObject3;
            iRubyObject2 = rubyArray.entry(n);
            iRubyObject = this.attributes.op_aref(threadContext, iRubyObject2);
            if (iRubyObject.isNil() || (iRubyObject = this.elements.op_aref(threadContext, iRubyObject3 = (xmlAttributeDecl = (XmlAttributeDecl)iRubyObject).element_name(threadContext))).isNil()) continue;
            XmlElementDecl xmlElementDecl = (XmlElementDecl)iRubyObject;
            xmlElementDecl.appendAttrDecl(xmlAttributeDecl);
        }
        rubyArray = this.contentModels.keys();
        for (n = 0; n < rubyArray.getLength(); ++n) {
            iRubyObject2 = rubyArray.entry(n);
            iRubyObject = this.contentModels.op_aref(threadContext, iRubyObject2);
            xmlAttributeDecl = this.elements.op_aref(threadContext, iRubyObject2);
            if (xmlAttributeDecl.isNil() || ((XmlElementDecl)((Object)xmlAttributeDecl)).isEmpty()) continue;
            ((XmlElementDecl)((Object)xmlAttributeDecl)).setContentModel(iRubyObject);
        }
    }

    protected void extractDecls(ThreadContext threadContext, Node node) {
        while (node != null) {
            RubyObject rubyObject;
            if (XmlDtd.isExternalSubset(node)) {
                return;
            }
            if (XmlDtd.isAttributeDecl(node)) {
                rubyObject = (XmlAttributeDecl)XmlAttributeDecl.create(threadContext, node);
                this.attributes.op_aset(threadContext, rubyObject.attribute_name(threadContext), (IRubyObject)rubyObject);
                this.allDecls.append((IRubyObject)rubyObject);
            } else if (XmlDtd.isElementDecl(node)) {
                rubyObject = (XmlElementDecl)XmlElementDecl.create(threadContext, node);
                this.elements.op_aset(threadContext, rubyObject.element_name(threadContext), (IRubyObject)rubyObject);
                this.allDecls.append((IRubyObject)rubyObject);
            } else if (XmlDtd.isEntityDecl(node)) {
                rubyObject = (XmlEntityDecl)XmlEntityDecl.create(threadContext, node);
                this.entities.op_aset(threadContext, rubyObject.node_name(threadContext), (IRubyObject)rubyObject);
                this.allDecls.append((IRubyObject)rubyObject);
            } else if (XmlDtd.isNotationDecl(node)) {
                rubyObject = (XmlNode)NokogiriHelpers.constructNode(threadContext.getRuntime(), node);
                IRubyObject iRubyObject = RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.notationClass, (String)"new", (IRubyObject)rubyObject.getAttribute(threadContext, "name"), (IRubyObject)rubyObject.getAttribute(threadContext, "pubid"), (IRubyObject)rubyObject.getAttribute(threadContext, "sysid"));
                this.notations.op_aset(threadContext, rubyObject.getAttribute(threadContext, "name"), iRubyObject);
                this.allDecls.append(iRubyObject);
            } else if (XmlDtd.isContentModel(node)) {
                rubyObject = new XmlElementContent(threadContext.getRuntime(), (XmlDocument)this.document(threadContext), node);
                this.contentModels.op_aset(threadContext, rubyObject.element_name(threadContext), (IRubyObject)rubyObject);
            } else {
                this.extractDecls(threadContext, node.getFirstChild());
            }
            node = node.getNextSibling();
        }
    }

    @Override
    public void accept(ThreadContext threadContext, SaveContextVisitor saveContextVisitor) {
        DocumentType documentType = this.node.getOwnerDocument().getDoctype();
        saveContextVisitor.enter(documentType);
        saveContextVisitor.leave(documentType);
    }
}

