/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.witness.pipeline;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.logstash.instrument.metrics.Metric;
import org.logstash.instrument.metrics.gauge.TextGauge;
import org.logstash.instrument.witness.MetricSerializer;
import org.logstash.instrument.witness.SerializableWitness;

@JsonSerialize(using=Serializer.class)
public class ErrorWitness
implements SerializableWitness {
    private final TextGauge message = new TextGauge("message");
    private final TextGauge backtrace = new TextGauge("backtrace");
    private final Snitch snitch = new Snitch(this);
    private static final String KEY = "last_error";

    public void backtrace(String stackTrace) {
        this.backtrace.set(stackTrace);
    }

    public void message(String message) {
        this.message.set(message);
    }

    public Snitch snitch() {
        return this.snitch;
    }

    public void backtrace(Throwable throwable) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             PrintStream printStream = new PrintStream(byteArrayOutputStream);){
            throwable.printStackTrace(printStream);
            String backtrace = byteArrayOutputStream.toString("UTF-8");
            this.backtrace.set(backtrace);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unknown error", e);
        }
    }

    @Override
    public void genJson(JsonGenerator gen, SerializerProvider provider) throws IOException {
        Serializer.innerSerialize(this, gen);
    }

    public static final class Snitch {
        private final ErrorWitness witness;

        private Snitch(ErrorWitness witness) {
            this.witness = witness;
        }

        public String message() {
            return (String)this.witness.message.getValue();
        }

        public String backtrace() {
            return (String)this.witness.backtrace.getValue();
        }
    }

    public static final class Serializer
    extends StdSerializer<ErrorWitness> {
        private static final long serialVersionUID = 1L;

        public Serializer() {
            this(ErrorWitness.class);
        }

        protected Serializer(Class<ErrorWitness> t) {
            super(t);
        }

        public void serialize(ErrorWitness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            Serializer.innerSerialize(witness, gen);
            gen.writeEndObject();
        }

        static void innerSerialize(ErrorWitness witness, JsonGenerator gen) throws IOException {
            gen.writeObjectFieldStart(ErrorWitness.KEY);
            MetricSerializer<Metric<String>> stringSerializer = MetricSerializer.Get.stringSerializer(gen);
            stringSerializer.serialize(witness.message);
            stringSerializer.serialize(witness.backtrace);
            gen.writeEndObject();
        }
    }
}

