/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.witness.schedule;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.instrument.witness.schedule.ScheduledWitness;

public class WitnessScheduler {
    private final ScheduledWitness witness;
    private final ScheduledExecutorService executorService;
    private static final Logger LOGGER = LogManager.getLogger(WitnessScheduler.class);

    public WitnessScheduler(ScheduledWitness witness) {
        this.witness = witness;
        this.executorService = Executors.newScheduledThreadPool(1, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName(witness.threadName());
            return t;
        });
    }

    public void schedule() {
        this.executorService.scheduleAtFixedRate(new RefreshRunnable(), 0L, this.witness.every().getSeconds(), TimeUnit.SECONDS);
    }

    public void shutdown() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Witness should be scheduled from the main thread, and the main thread does not expect to be interrupted", e);
        }
    }

    class RefreshRunnable
    implements Runnable {
        long lastLogged = 0L;

        RefreshRunnable() {
        }

        @Override
        public void run() {
            try {
                WitnessScheduler.this.witness.refresh();
            }
            catch (Exception e) {
                long now = System.currentTimeMillis();
                if (this.lastLogged == 0L || now - this.lastLogged > 120000L) {
                    LOGGER.warn("Can not fully refresh the metrics for the " + WitnessScheduler.this.witness.getClass().getSimpleName(), (Throwable)e);
                }
                this.lastLogged = now;
            }
        }
    }
}

