/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.BlockJITClassGenerator;
import org.jruby.compiler.JITCompiler;
import org.jruby.ir.IRClosure;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.runtime.CompiledIRBlockBody;
import org.jruby.runtime.MixedModeIRBlockBody;
import org.jruby.util.OneShotClassLoader;

class BlockJITTask
implements Runnable {
    private JITCompiler jitCompiler;
    private final String className;
    private final MixedModeIRBlockBody body;
    private final String methodName;

    public BlockJITTask(JITCompiler jitCompiler, MixedModeIRBlockBody body, String className) {
        this.jitCompiler = jitCompiler;
        this.body = body;
        this.className = className;
        this.methodName = body.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JITCompiler jITCompiler = this.jitCompiler;
        synchronized (jITCompiler) {
            try {
                String key2 = SexpMaker.sha1(this.body.getIRScope());
                JVMVisitor visitor = new JVMVisitor();
                BlockJITClassGenerator generator = new BlockJITClassGenerator(this.className, this.methodName, key2, this.jitCompiler.runtime, this.body, visitor);
                JVMVisitorMethodContext context = new JVMVisitorMethodContext();
                generator.compile(context);
                Class sourceClass = visitor.defineFromBytecode(this.body.getIRScope(), generator.bytecode(), new OneShotClassLoader(this.jitCompiler.runtime.getJRubyClassLoader()));
                if (sourceClass == null) {
                    this.jitCompiler.counts.failCount.incrementAndGet();
                    return;
                }
                generator.updateCounters(this.jitCompiler.counts, this.body.ensureInstrsReady());
                String jittedName = context.getVariableName();
                this.body.completeBuild(new CompiledIRBlockBody(JITCompiler.PUBLIC_LOOKUP.findStatic(sourceClass, jittedName, JVMVisitor.CLOSURE_SIGNATURE.type()), this.body.getIRScope(), ((IRClosure)this.body.getIRScope()).getSignature().encode()));
                if (this.jitCompiler.config.isJitLogging()) {
                    JITCompiler.log(this.body.getImplementationClass(), this.body.getFile(), this.body.getLine(), this.className + "." + this.methodName, "done jitting", new String[0]);
                }
            }
            catch (Throwable t) {
                if (this.jitCompiler.config.isJitLogging()) {
                    JITCompiler.log(this.body.getImplementationClass(), this.body.getFile(), this.body.getLine(), this.className + "." + this.methodName, "Could not compile; passes run: " + this.body.getIRScope().getExecutedPasses(), t.getMessage());
                    if (this.jitCompiler.config.isJitLoggingVerbose()) {
                        t.printStackTrace();
                    }
                }
                this.jitCompiler.counts.failCount.incrementAndGet();
            }
        }
    }
}

