/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec2(38, 35) | abs(~ ivec2(38, 35))) => ivec2(39, 39)
 * (ivec2(38, 35) | abs(~ ivec2(64, -9))) => ivec2(103, 43)
 * (ivec2(38, 35) | abs(~ ivec2(64, 9))) => ivec2(103, 43)
 * (ivec2(64, -9) | abs(~ ivec2(38, 35))) => ivec2(103, -9)
 * (ivec2(64, -9) | abs(~ ivec2(64, -9))) => ivec2(65, -1)
 * (ivec2(64, -9) | abs(~ ivec2(64, 9))) => ivec2(65, -1)
 * (ivec2(64, 9) | abs(~ ivec2(38, 35))) => ivec2(103, 45)
 * (ivec2(64, 9) | abs(~ ivec2(64, -9))) => ivec2(65, 9)
 * (ivec2(64, 9) | abs(~ ivec2(64, 9))) => ivec2(65, 11)
 */
#version 130

void main()
{
  float[all(equal((ivec2(38, 35) | abs(~ ivec2(38, 35))), ivec2(39, 39))) ? 1 : -1] array0;
  float[all(equal((ivec2(38, 35) | abs(~ ivec2(64, -9))), ivec2(103, 43))) ? 1 : -1] array1;
  float[all(equal((ivec2(38, 35) | abs(~ ivec2(64, 9))), ivec2(103, 43))) ? 1 : -1] array2;
  float[all(equal((ivec2(64, -9) | abs(~ ivec2(38, 35))), ivec2(103, -9))) ? 1 : -1] array3;
  float[all(equal((ivec2(64, -9) | abs(~ ivec2(64, -9))), ivec2(65, -1))) ? 1 : -1] array4;
  float[all(equal((ivec2(64, -9) | abs(~ ivec2(64, 9))), ivec2(65, -1))) ? 1 : -1] array5;
  float[all(equal((ivec2(64, 9) | abs(~ ivec2(38, 35))), ivec2(103, 45))) ? 1 : -1] array6;
  float[all(equal((ivec2(64, 9) | abs(~ ivec2(64, -9))), ivec2(65, 9))) ? 1 : -1] array7;
  float[all(equal((ivec2(64, 9) | abs(~ ivec2(64, 9))), ivec2(65, 11))) ? 1 : -1] array8;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
