/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.association.InvalidAssociationException;
import com.projity.configuration.Configuration;
import com.projity.datatype.Duration;
import com.projity.datatype.DurationFormat;
import com.projity.dialog.AbstractDialog;
import com.projity.dialog.ButtonPanel;
import com.projity.field.Field;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.dependency.DependencyService;
import com.projity.pm.dependency.DependencyType;
import com.projity.pm.task.NormalTask;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class DependencyDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    protected JLabel preLabel;
    protected JLabel sucLabel;
    protected JComboBox typeCombo;
    protected JTextField lagTextField;
    protected JButton removeButton = new JButton();
    Field dependencyTypeField = Configuration.getFieldFromId("Field.dependencyType");
    boolean remove = false;
    Dependency dependency;

    public static boolean doDialog(DependencyDialog dependencyDialog, Dependency dependency) {
        dependencyDialog.setDependency(dependency);
        boolean bl = dependencyDialog.doModal();
        if (bl) {
            if (dependencyDialog.remove) {
                DependencyService.getInstance().remove(dependency, dependencyDialog, true);
            } else {
                DependencyService.getInstance().update(dependency, dependencyDialog);
            }
        }
        dependencyDialog.dependency = null;
        return bl;
    }

    public DependencyDialog(Frame frame, Dependency dependency) {
        super(frame, Messages.getString("Text.TaskDependency"), true);
        this.initControls();
        this.setDependency(dependency);
        this.addDocHelp("Task_Dependency_Dialog");
    }

    public void setDependency(Dependency dependency) {
        this.remove = false;
        this.dependency = dependency;
        if (dependency.isExternal()) {
            if (dependency.isDisabled()) {
                this.setTitle(Messages.getString("Text.DisabledExternalTaskDependency"));
            } else {
                this.setTitle(Messages.getString("Text.ExternalTaskDependency"));
            }
        } else {
            this.setTitle(Messages.getString("Text.TaskDependency"));
        }
        this.bind(true);
    }

    @Override
    protected void initComponents() {
        if (this.contentPanel != null) {
            return;
        }
        super.initComponents();
    }

    protected void initControls() {
        this.preLabel = new JLabel();
        this.sucLabel = new JLabel();
        Object[] objectArray = this.dependencyTypeField.getOptions(null);
        this.typeCombo = new JComboBox<Object>(objectArray);
        this.lagTextField = new JTextField();
        this.bind(true);
    }

    @Override
    public ButtonPanel createButtonPanel() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("Text.Remove")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DependencyDialog.this.delete();
            }
        };
        this.removeButton.setAction(abstractAction);
        this.removeButton.setEnabled(!this.isReadOnly());
        this.createOkCancelButtons();
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.addButton(this.removeButton);
        buttonPanel.addButton(this.ok);
        buttonPanel.addButton(this.cancel);
        buttonPanel.add(this.getHelpButton());
        return buttonPanel;
    }

    @Override
    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("50dlu,3dlu,50dlu,3dlu,50dlu,3dlu,50dlu", "p,3dlu,p,3dlu,p,3dlu,p,3dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.append(Messages.getString("Text.From") + ":");
        defaultFormBuilder.add((Component)this.preLabel, cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 5));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("Text.To") + ":");
        defaultFormBuilder.add((Component)this.sucLabel, cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 5));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("Text.Type") + ":", (Component)this.typeCombo);
        defaultFormBuilder.addLabel(Messages.getString("Text.Lag") + ":");
        defaultFormBuilder.nextColumn(2);
        defaultFormBuilder.add(this.lagTextField);
        return defaultFormBuilder.getPanel();
    }

    void delete() {
        this.remove = true;
        this.setDialogResult(0);
        this.setVisible(false);
    }

    @Override
    protected boolean bind(boolean bl) {
        if (this.dependency == null) {
            return false;
        }
        if (bl) {
            this.preLabel.setText(this.dependency.getQualifiedPredecessorName());
            this.sucLabel.setText(this.dependency.getQualifiedSuccessorName());
            String string = DependencyType.mapValueToString(new Integer(this.dependency.getDependencyType()));
            this.typeCombo.setSelectedItem(string);
            this.lagTextField.setText(DurationFormat.format(this.dependency.getLag()));
            boolean bl2 = ((NormalTask)this.dependency.getPredecessor()).getProject().isReadOnly();
            this.typeCombo.setEnabled(!bl2);
            this.lagTextField.setEnabled(!bl2);
            this.removeButton.setEnabled(!bl2);
        } else {
            try {
                Duration duration = (Duration)DurationFormat.getInstance().parseObject(this.lagTextField.getText());
                int n = DependencyType.mapStringToValue(this.typeCombo.getSelectedItem().toString());
                DependencyService.getInstance().setFields(this.dependency, duration.getEncodedMillis(), n, this);
            }
            catch (ParseException parseException) {
                Alert.warn(Messages.getString("Message.invalidDuration"), this);
                return false;
            }
            catch (InvalidAssociationException invalidAssociationException) {
                Alert.warn(invalidAssociationException.getMessage(), this);
                return false;
            }
        }
        return true;
    }

    private boolean isReadOnly() {
        return ((NormalTask)this.dependency.getPredecessor()).isReadOnly();
    }

    public boolean isRemove() {
        return this.remove;
    }
}

