/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core.hierarchy;

import com.projity.grouping.core.Node;
import com.projity.grouping.core.event.HierarchyEvent;
import com.projity.grouping.core.event.HierarchyListener;
import com.projity.grouping.core.hierarchy.AbstractMutableNodeHierarchy;
import com.projity.grouping.core.hierarchy.NodeHierarchy;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.transform.filtering.NodeFilter;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class FilteredNodeHierarchy
extends AbstractMutableNodeHierarchy
implements HierarchyListener {
    protected NodeHierarchy hierarchy;
    protected NodeFilter filter;

    public FilteredNodeHierarchy(NodeHierarchy nodeHierarchy) {
        this.hierarchy = nodeHierarchy;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public void setFilter(NodeFilter nodeFilter) {
        this.filter = nodeFilter;
        this.fireStructureChanged(this);
    }

    public NodeHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public void setHierarchy(NodeHierarchy nodeHierarchy) {
        this.hierarchy = nodeHierarchy;
        this.fireStructureChanged(this);
    }

    @Override
    public void add(Node node, List list, int n, int n2) {
        this.hierarchy.add(node, list, n, n2);
    }

    @Override
    public void paste(Node node, List list, int n, NodeModel nodeModel, int n2) {
        this.hierarchy.paste(node, list, n, nodeModel, n2);
    }

    @Override
    public void cleanVoidChildren() {
        this.hierarchy.cleanVoidChildren();
    }

    @Override
    public void checkEndVoidNodes(int n) {
        this.hierarchy.checkEndVoidNodes(n);
    }

    @Override
    public void checkEndVoidNodes(boolean bl, int n) {
        this.hierarchy.checkEndVoidNodes(bl, n);
    }

    @Override
    public int getLevel(Node node) {
        return this.hierarchy.getLevel(node);
    }

    @Override
    public Object getRoot() {
        return this.hierarchy.getRoot();
    }

    @Override
    public void indent(List list, int n, NodeModel nodeModel, int n2) {
        this.hierarchy.indent(list, n, nodeModel, n2);
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.hierarchy.isLeaf(object);
    }

    @Override
    public boolean isSummary(Node node) {
        return this.hierarchy.isSummary(node);
    }

    @Override
    public void remove(List list, NodeModel nodeModel, int n, boolean bl) {
        this.hierarchy.remove(list, nodeModel, n, bl);
    }

    @Override
    public void move(Node node, Node node2, int n) {
        this.hierarchy.move(node, node2, n);
    }

    @Override
    public void setNbEndVoidNodes(int n) {
        this.hierarchy.setNbEndVoidNodes(n);
    }

    @Override
    public int getNbEndVoidNodes() {
        return this.hierarchy.getNbEndVoidNodes();
    }

    @Override
    public Node getParent(Node node) {
        return this.hierarchy.getParent(node);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        this.hierarchy.valueForPathChanged(treePath, object);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.hierarchy.addTreeModelListener(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.hierarchy.removeTreeModelListener(treeModelListener);
    }

    @Override
    public void removeAll(NodeModel nodeModel, int n) {
        this.hierarchy.removeAll(nodeModel, n);
    }

    @Override
    public List getChildren(Node node) {
        return this.filter.filterList(this.hierarchy.getChildren(node));
    }

    @Override
    public Node search(Object object, Comparator comparator) {
        Node node = this.hierarchy.search(object, comparator);
        if (node == null) {
            return null;
        }
        return this.filter.evaluate(node) ? node : null;
    }

    @Override
    public Object clone() {
        FilteredNodeHierarchy filteredNodeHierarchy = new FilteredNodeHierarchy(this.hierarchy);
        filteredNodeHierarchy.setFilter(this.filter);
        return filteredNodeHierarchy;
    }

    @Override
    public void nodesChanged(HierarchyEvent hierarchyEvent) {
        Object[] objectArray = this.filter.filterArray(hierarchyEvent.getNodes());
        this.fireNodesChanged(hierarchyEvent.getSource(), objectArray, hierarchyEvent.getNodes(), hierarchyEvent.getFlag());
    }

    @Override
    public void nodesInserted(HierarchyEvent hierarchyEvent) {
        Object[] objectArray = this.filter.filterArray(hierarchyEvent.getNodes());
        this.fireNodesInserted(hierarchyEvent.getSource(), objectArray, hierarchyEvent.getNodes(), hierarchyEvent.getFlag());
    }

    @Override
    public void nodesRemoved(HierarchyEvent hierarchyEvent) {
        Object[] objectArray = this.filter.filterArray(hierarchyEvent.getNodes());
        this.fireNodesRemoved(hierarchyEvent.getSource(), objectArray, hierarchyEvent.getNodes(), hierarchyEvent.getFlag());
    }

    @Override
    public void structureChanged(HierarchyEvent hierarchyEvent) {
        Object[] objectArray = this.filter.filterArray(hierarchyEvent.getNodes());
        this.fireStructureChanged(hierarchyEvent.getSource());
    }

    @Override
    public void fireUpdate() {
        this.hierarchy.fireUpdate();
    }

    @Override
    public void fireUpdate(Node[] nodeArray) {
        this.hierarchy.fireUpdate(nodeArray);
    }

    @Override
    public void fireInsertion(Node[] nodeArray) {
        this.hierarchy.fireInsertion(nodeArray);
    }

    @Override
    public void fireRemoval(Node[] nodeArray) {
        this.hierarchy.fireRemoval(nodeArray);
    }
}

