/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment.contour;

import com.projity.pm.assignment.contour.AbstractContour;
import com.projity.pm.assignment.contour.AbstractContourBucket;
import com.projity.pm.assignment.contour.FillerContourBucket;
import com.projity.pm.assignment.contour.PersonalContourBucket;
import com.projity.pm.assignment.contour.StandardContour;
import com.projity.pm.assignment.contour.StandardContourBucket;
import com.projity.pm.time.MutableInterval;
import com.projity.strings.Messages;
import java.util.ArrayList;
import java.util.Collection;

public class PersonalContour
extends AbstractContour {
    private static final String name = Messages.getString("PersonalContour.personal");

    @Override
    public boolean isPersonal() {
        return true;
    }

    @Override
    public long calcTotalWork(long l) {
        long l2 = 0L;
        for (int i = 0; i < this.contourBuckets.length; ++i) {
            l2 += ((PersonalContourBucket)this.contourBuckets[i]).calcWork();
        }
        return l2;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getType() {
        return 8;
    }

    private PersonalContour(AbstractContourBucket[] abstractContourBucketArray) {
        super(abstractContourBucketArray);
    }

    public static PersonalContour makePersonal(AbstractContour abstractContour, long l) {
        if (abstractContour.isPersonal()) {
            return (PersonalContour)abstractContour;
        }
        AbstractContourBucket[] abstractContourBucketArray = new AbstractContourBucket[abstractContour.contourBuckets.length];
        for (int i = 0; i < abstractContour.contourBuckets.length; ++i) {
            StandardContourBucket standardContourBucket = (StandardContourBucket)abstractContour.contourBuckets[i];
            abstractContourBucketArray[i] = PersonalContourBucket.getInstance(standardContourBucket.getBucketDuration(l), standardContourBucket.getUnits());
        }
        PersonalContour personalContour = PersonalContour.getInstance(abstractContourBucketArray);
        return personalContour;
    }

    public static PersonalContour constructUsingSizeOf(AbstractContour abstractContour) {
        PersonalContour personalContour = PersonalContour.getInstance(new AbstractContourBucket[abstractContour.contourBuckets.length]);
        personalContour.maxUnits = personalContour.calcMaxUnits();
        return personalContour;
    }

    public static PersonalContour getInstance(Collection collection) {
        AbstractContourBucket[] abstractContourBucketArray = new AbstractContourBucket[collection.size()];
        collection.toArray(abstractContourBucketArray);
        PersonalContour personalContour = PersonalContour.getInstance(abstractContourBucketArray);
        personalContour.validate();
        return personalContour;
    }

    public void validate() {
        for (int i = 0; i < this.contourBuckets.length; ++i) {
            if (this.contourBuckets[i].getBucketDuration(0L) >= 0L && !(this.contourBuckets[i].getUnits() < 0.0)) continue;
            System.out.println("error neg bucket!\n" + this.toString(0L));
        }
    }

    public static PersonalContour getInstance(AbstractContourBucket[] abstractContourBucketArray) {
        return new PersonalContour(abstractContourBucketArray);
    }

    public static PersonalContour addEmptyBucket(AbstractContour abstractContour, long l, boolean bl) {
        int n = abstractContour.contourBuckets.length;
        PersonalContour personalContour = PersonalContour.getInstance(new AbstractContourBucket[n + 1]);
        System.arraycopy(abstractContour.contourBuckets, 0, personalContour.contourBuckets, bl ? 0 : 1, n);
        personalContour.contourBuckets[bl ? n : 0] = PersonalContourBucket.getInstance(l, 0.0);
        return personalContour;
    }

    @Override
    public AbstractContour adjustDuration(long l, long l2) {
        PersonalContour personalContour = PersonalContour.constructUsingSizeOf(this);
        PersonalContourBucket personalContourBucket = null;
        for (int i = 0; i < this.contourBuckets.length; ++i) {
            personalContourBucket = (PersonalContourBucket)this.contourBuckets[i];
            personalContour.contourBuckets[i] = personalContourBucket;
            if ((l -= personalContourBucket.getDuration()) > 0L) continue;
            personalContour.contourBuckets[i] = personalContourBucket.adjustDuration(l);
            if (i < this.contourBuckets.length - 1) {
                System.arraycopy(personalContour.contourBuckets, 0, personalContour.contourBuckets, 0, i + 1);
            }
            PersonalContour personalContour2 = personalContour.makePacked();
            return personalContour2;
        }
        personalContour.contourBuckets[this.contourBuckets.length - 1] = personalContourBucket.adjustDuration(l);
        return personalContour;
    }

    private ArrayList bucketsBeforeDuration(long l) {
        ArrayList<PersonalContourBucket> arrayList = new ArrayList<PersonalContourBucket>();
        boolean bl = false;
        PersonalContourBucket personalContourBucket = null;
        long l2 = 0L;
        for (int i = 0; i < this.contourBuckets.length; ++i) {
            personalContourBucket = (PersonalContourBucket)this.contourBuckets[i];
            if ((l2 += personalContourBucket.getDuration()) >= l) {
                long l3 = l - (l2 - personalContourBucket.getDuration());
                if (l3 <= 0L) break;
                if (personalContourBucket.isFiller()) {
                    arrayList.add(FillerContourBucket.getInstance(l3));
                    break;
                }
                arrayList.add(PersonalContourBucket.getInstance(l3, personalContourBucket.getUnits()));
                break;
            }
            arrayList.add(personalContourBucket);
        }
        return arrayList;
    }

    private ArrayList bucketsAfterDuration(long l, boolean bl) {
        ArrayList<PersonalContourBucket> arrayList = new ArrayList<PersonalContourBucket>();
        boolean bl2 = false;
        PersonalContourBucket personalContourBucket = null;
        long l2 = 0L;
        for (int i = 0; i < this.contourBuckets.length; ++i) {
            personalContourBucket = (PersonalContourBucket)this.contourBuckets[i];
            if (bl && personalContourBucket.isFiller() || (l2 += personalContourBucket.getDuration()) <= l) continue;
            if (l2 - personalContourBucket.getDuration() >= l) {
                arrayList.add(personalContourBucket);
                continue;
            }
            long l3 = l2 - l;
            if (l3 <= 0L) continue;
            arrayList.add(PersonalContourBucket.getInstance(l3, personalContourBucket.getUnits()));
        }
        return arrayList;
    }

    @Override
    public AbstractContour removeFillerAfter(long l) {
        ArrayList arrayList = this.bucketsBeforeDuration(l);
        arrayList.addAll(this.bucketsAfterDuration(l, false));
        return PersonalContour.getInstance(arrayList).makePacked();
    }

    @Override
    public MutableInterval getRangeThatIntervalCanBeMoved(long l, long l2) {
        PersonalContourBucket personalContourBucket;
        ArrayList arrayList = this.bucketsBeforeDuration(l);
        long l3 = l;
        long l4 = Long.MAX_VALUE;
        if (arrayList.size() > 0 && (personalContourBucket = (PersonalContourBucket)arrayList.get(arrayList.size() - 1)).getUnits() == 0.0) {
            l3 = l - personalContourBucket.getDuration();
        }
        arrayList.clear();
        arrayList = this.bucketsAfterDuration(l2, false);
        if (arrayList.size() > 0) {
            personalContourBucket = (PersonalContourBucket)arrayList.get(0);
            l4 = personalContourBucket.getUnits() == 0.0 ? l2 + personalContourBucket.getDuration() : l2;
        }
        return new MutableInterval(l3, l4);
    }

    public PersonalContour setInterval(long l, long l2, double d) {
        ArrayList<PersonalContourBucket> arrayList = new ArrayList<PersonalContourBucket>();
        arrayList.addAll(this.bucketsBeforeDuration(l));
        arrayList.add(PersonalContourBucket.getInstance(l2 - l, d));
        arrayList.addAll(this.bucketsAfterDuration(l2, false));
        return PersonalContour.getInstance(arrayList).makePacked();
    }

    public PersonalContour insertBucket(long l, AbstractContourBucket abstractContourBucket) {
        ArrayList<AbstractContourBucket> arrayList = new ArrayList<AbstractContourBucket>();
        boolean bl = false;
        PersonalContourBucket personalContourBucket = null;
        long l2 = 0L;
        for (int i = 0; i < this.contourBuckets.length; ++i) {
            personalContourBucket = (PersonalContourBucket)this.contourBuckets[i];
            if (bl || (l2 += personalContourBucket.getDuration()) < l) {
                arrayList.add(personalContourBucket);
                continue;
            }
            long l3 = l2 - l;
            arrayList.add(PersonalContourBucket.getInstance(l3, personalContourBucket.getUnits()));
            arrayList.add(abstractContourBucket);
            arrayList.add(PersonalContourBucket.getInstance(personalContourBucket.getDuration() - l3, personalContourBucket.getUnits()));
            bl = true;
        }
        return PersonalContour.getInstance(arrayList).makePacked();
    }

    public PersonalContour extendBucket(long l, long l2) {
        PersonalContour personalContour = PersonalContour.constructUsingSizeOf(this);
        PersonalContourBucket personalContourBucket = null;
        boolean bl = false;
        long l3 = 0L;
        for (int i = 0; i < this.contourBuckets.length; ++i) {
            personalContourBucket = (PersonalContourBucket)this.contourBuckets[i];
            personalContour.contourBuckets[i] = personalContourBucket;
            if (bl || (l3 += personalContourBucket.getDuration()) < l || personalContourBucket.getUnits() == 0.0) continue;
            bl = true;
            personalContour.contourBuckets[i] = PersonalContourBucket.getInstance(Math.max(0L, personalContourBucket.getDuration() + l2), personalContourBucket.getUnits());
        }
        return personalContour.makePacked();
    }

    public PersonalContour shift(long l, long l2, long l3) {
        PersonalContour personalContour;
        if (l3 == 0L) {
            return this;
        }
        ArrayList<PersonalContourBucket> arrayList = new ArrayList<PersonalContourBucket>();
        if (l3 > 0L) {
            arrayList.addAll(this.bucketsBeforeDuration(l2));
            arrayList.addAll(this.bucketsAfterDuration(l2 + l3, false));
            personalContour = PersonalContour.getInstance(arrayList).makePacked();
            arrayList.clear();
            arrayList.addAll(personalContour.bucketsBeforeDuration(l));
            arrayList.add(PersonalContourBucket.getInstance(l3, 0.0));
            arrayList.addAll(personalContour.bucketsAfterDuration(l, false));
        } else {
            arrayList.addAll(this.bucketsBeforeDuration(l2));
            arrayList.add(PersonalContourBucket.getInstance(-l3, 0.0));
            arrayList.addAll(this.bucketsAfterDuration(l2, false));
            personalContour = PersonalContour.getInstance(arrayList).makePacked();
            arrayList.clear();
            arrayList.addAll(personalContour.bucketsBeforeDuration(l + l3));
            arrayList.addAll(personalContour.bucketsAfterDuration(l, false));
        }
        personalContour = PersonalContour.getInstance(arrayList).makePacked();
        return personalContour;
    }

    @Override
    public AbstractContour extend(long l, long l2) {
        PersonalContour personalContour;
        if (l2 == 0L) {
            return this;
        }
        ArrayList<PersonalContourBucket> arrayList = new ArrayList<PersonalContourBucket>();
        if (l2 > 0L) {
            arrayList.addAll(this.bucketsBeforeDuration(l));
            arrayList.addAll(this.bucketsAfterDuration(l + l2, false));
            PersonalContour personalContour2 = PersonalContour.getInstance(arrayList).makePacked();
            personalContour = personalContour2.extendBucket(l, l2);
        } else {
            arrayList.addAll(this.bucketsBeforeDuration(l + l2));
            arrayList.add(PersonalContourBucket.getInstance(-l2, 0.0));
            arrayList.addAll(this.bucketsAfterDuration(l, false));
            personalContour = PersonalContour.getInstance(arrayList).makePacked();
        }
        return personalContour;
    }

    @Override
    public AbstractContour extendBefore(long l, long l2) {
        if (l2 == 0L) {
            return this;
        }
        ArrayList<PersonalContourBucket> arrayList = new ArrayList<PersonalContourBucket>();
        PersonalContour personalContour = this.extendBucket(l, -l2);
        if (l2 < 0L) {
            arrayList.addAll(personalContour.bucketsBeforeDuration(l + l2));
            arrayList.addAll(personalContour.bucketsAfterDuration(l, false));
        } else {
            arrayList.addAll(personalContour.bucketsBeforeDuration(l));
            arrayList.add(PersonalContourBucket.getInstance(l2, 0.0));
            arrayList.addAll(personalContour.bucketsAfterDuration(l, false));
        }
        PersonalContour personalContour2 = PersonalContour.getInstance(arrayList).makePacked();
        return personalContour2;
    }

    private PersonalContour makePacked() {
        ArrayList<PersonalContourBucket> arrayList = new ArrayList<PersonalContourBucket>();
        PersonalContourBucket personalContourBucket = null;
        PersonalContourBucket personalContourBucket2 = null;
        for (int i = 0; i < this.contourBuckets.length; ++i) {
            personalContourBucket2 = (PersonalContourBucket)this.contourBuckets[i];
            if (personalContourBucket2 == null) {
                System.out.println("null bucket " + i + " in make packed - skipping");
                continue;
            }
            if (personalContourBucket != null && personalContourBucket.getUnits() == personalContourBucket2.getUnits() && personalContourBucket.isFiller() == personalContourBucket2.isFiller()) {
                personalContourBucket = PersonalContourBucket.getInstance(personalContourBucket.getDuration() + personalContourBucket2.getDuration(), personalContourBucket2.getUnits());
                continue;
            }
            if (personalContourBucket != null && personalContourBucket.getDuration() > 0L) {
                arrayList.add(personalContourBucket);
            }
            personalContourBucket = personalContourBucket2;
        }
        if (personalContourBucket != null && personalContourBucket.getDuration() > 0L && personalContourBucket.getUnits() != 0.0) {
            arrayList.add(personalContourBucket);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(PersonalContourBucket.getInstance(0L, 1.0));
        }
        return PersonalContour.getInstance(arrayList);
    }

    public AbstractContour convertToFlatIfPossible() {
        if (this.getContourBuckets().length > 1) {
            return this;
        }
        return StandardContour.FLAT_CONTOUR;
    }

    @Override
    public AbstractContour adjustUnits(double d, long l) {
        ArrayList<PersonalContourBucket> arrayList = new ArrayList<PersonalContourBucket>();
        arrayList.addAll(this.bucketsBeforeDuration(l));
        ArrayList arrayList2 = this.bucketsAfterDuration(l, false);
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList.add(((PersonalContourBucket)arrayList2.get(i)).adjustUnits(d));
        }
        PersonalContour personalContour = PersonalContour.getInstance(arrayList).makePacked();
        personalContour.maxUnits = personalContour.calcMaxUnits();
        return personalContour;
    }

    @Override
    public AbstractContour contourAdjustWork(double d, long l) {
        if (l == 0L) {
            PersonalContour personalContour = PersonalContour.constructUsingSizeOf(this);
            for (int i = 0; i < this.contourBuckets.length; ++i) {
                personalContour.contourBuckets[i] = ((PersonalContourBucket)this.contourBuckets[i]).adjustWork(d);
            }
            personalContour.makePacked();
            personalContour.maxUnits = personalContour.calcMaxUnits();
            return personalContour;
        }
        ArrayList arrayList = this.bucketsBeforeDuration(l);
        ArrayList arrayList2 = this.bucketsAfterDuration(l, false);
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList.add(((PersonalContourBucket)arrayList2.get(i)).adjustWork(d));
        }
        PersonalContour personalContour = PersonalContour.getInstance(arrayList).makePacked();
        personalContour.maxUnits = personalContour.calcMaxUnits();
        return personalContour;
    }

    public PersonalContour(AbstractContour abstractContour, long l) {
        super(new PersonalContourBucket[abstractContour.numBuckets()]);
        for (int i = 0; i < this.contourBuckets.length; ++i) {
            this.contourBuckets[i] = PersonalContourBucket.getInstance(abstractContour.getContourBuckets()[i], l);
        }
        this.maxUnits = this.calcMaxUnits();
    }

    @Override
    public long extractDelay() {
        long l = 0L;
        if (this.contourBuckets.length < 2) {
            return 0L;
        }
        while (this.contourBuckets[0].getUnits() == 0.0) {
            l += this.contourBuckets[0].getBucketDuration(0L);
            AbstractContourBucket[] abstractContourBucketArray = new AbstractContourBucket[this.contourBuckets.length - 1];
            System.arraycopy(this.contourBuckets, 1, abstractContourBucketArray, 0, abstractContourBucketArray.length);
            this.contourBuckets = abstractContourBucketArray;
        }
        return l;
    }

    public AbstractContour removeEmptyBucketAtDuration(long l) {
        ArrayList arrayList = this.bucketsAfterDuration(l, false);
        if (arrayList.isEmpty() || ((AbstractContourBucket)arrayList.get(0)).getUnits() != 0.0) {
            return this;
        }
        arrayList.remove(0);
        ArrayList arrayList2 = this.bucketsBeforeDuration(l);
        arrayList2.addAll(arrayList);
        return PersonalContour.getInstance(arrayList2).makePacked();
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

