/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.common.transfer;

import com.projity.grouping.core.Node;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.model.NodeModelDataFactory;
import com.projity.pm.graphic.spreadsheet.SpreadSheet;
import com.projity.pm.graphic.spreadsheet.common.CommonSpreadSheetModel;
import com.projity.pm.graphic.spreadsheet.common.transfer.NodeListTransferable;
import com.projity.pm.graphic.spreadsheet.common.transfer.NodeListTransfertAction;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Project;
import com.projity.pm.task.SubProj;
import com.projity.pm.task.Task;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.tree.TreeNode;
import org.apache.commons.collections.Predicate;

public class NodeListTransferHandler
extends TransferHandler {
    protected transient SpreadSheet spreadSheet;
    protected transient NodeListTransfertAction nodeListCutAction;
    protected transient NodeListTransfertAction nodeListCopyAction;
    protected transient NodeListTransfertAction nodeListPasteAction;

    public NodeListTransferHandler(SpreadSheet spreadSheet) {
        this.spreadSheet = spreadSheet;
    }

    public SpreadSheet getSpreadSheet() {
        return this.spreadSheet;
    }

    public void setSpreadSheet(SpreadSheet spreadSheet) {
        this.spreadSheet = spreadSheet;
    }

    @Override
    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
        boolean bl = false;
        Transferable transferable = null;
        if (n != 0 && (transferable = this.createTransferable(jComponent, n)) != null) {
            clipboard.setContents(transferable, null);
            bl = true;
        }
        if (bl) {
            this.exportDone(jComponent, transferable, n);
        } else {
            this.exportDone(jComponent, null, 0);
        }
    }

    private boolean transformSubprojectBranches(Node node, NodeModelDataFactory nodeModelDataFactory, Predicate predicate) {
        if (nodeModelDataFactory instanceof Project && node.getImpl() instanceof SubProj && !predicate.evaluate(node)) {
            return false;
        }
        Enumeration<? extends TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            if (this.transformSubprojectBranches(node2, nodeModelDataFactory, predicate)) continue;
            return false;
        }
        return true;
    }

    protected Transferable createTransferable(JComponent jComponent, int n) {
        boolean bl;
        SpreadSheet spreadSheet = this.getSpreadSheet(jComponent);
        if (spreadSheet == null) {
            return null;
        }
        ArrayList arrayList = (ArrayList)spreadSheet.getSelectedNodes().clone();
        ArrayList arrayList2 = spreadSheet.getSelectedFields();
        boolean bl2 = bl = arrayList2 == null;
        if (arrayList2 == null) {
            arrayList2 = spreadSheet.getSelectableFields();
        }
        if (n == 1) {
            if (bl) {
                SpreadSheet.SpreadSheetAction spreadSheetAction = this.getNodeListCopyAction().getSpreadSheetAction();
                spreadSheetAction.execute(arrayList);
            }
            return new NodeListTransferable(arrayList, arrayList2, spreadSheet, spreadSheet.getSelectedRows(), spreadSheet.getSelectedColumns(), bl);
        }
        if (n == 2) {
            if (bl) {
                SpreadSheet.SpreadSheetAction spreadSheetAction = (bl ? this.getNodeListCutAction() : this.getNodeListCopyAction()).getSpreadSheetAction();
                for (Node node : arrayList) {
                    final boolean[] blArray = new boolean[]{false};
                    if (this.transformSubprojectBranches(node, spreadSheet.getCache().getModel().getDataFactory(), new Predicate(){

                        @Override
                        public boolean evaluate(Object object) {
                            if (blArray[0]) {
                                return true;
                            }
                            Node node = (Node)object;
                            boolean bl = Alert.okCancel(Messages.getString("Message.subprojectCut"));
                            if (bl) {
                                blArray[0] = true;
                            }
                            return bl;
                        }
                    })) continue;
                    return null;
                }
                spreadSheetAction.execute(arrayList);
            }
            return new NodeListTransferable(arrayList, arrayList2, spreadSheet, spreadSheet.getSelectedRows(), spreadSheet.getSelectedColumns(), bl);
        }
        return null;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        SpreadSheet spreadSheet = this.getSpreadSheet(jComponent);
        if (spreadSheet == null) {
            return false;
        }
        DataFlavor dataFlavor = this.getFlavor(transferable.getTransferDataFlavors());
        if (dataFlavor != null) {
            try {
                NodeModel nodeModel = ((CommonSpreadSheetModel)spreadSheet.getModel()).getCache().getModel();
                Object object = transferable.getTransferData(dataFlavor);
                if (object == null) {
                    return false;
                }
                List list = null;
                if (object instanceof ArrayList) {
                    list = (List)object;
                    for (Node node : list) {
                        this.transformSubprojectBranches(node, nodeModel.getDataFactory(), new Predicate(){

                            @Override
                            public boolean evaluate(Object object) {
                                Node node = (Node)object;
                                NormalTask normalTask = new NormalTask();
                                Task task = (Task)node.getImpl();
                                task.cloneTo(normalTask);
                                node.setImpl(normalTask);
                                return true;
                            }
                        });
                    }
                    SpreadSheet.SpreadSheetAction spreadSheetAction = this.getNodeListPasteAction().getSpreadSheetAction();
                    spreadSheetAction.execute(list);
                } else if (object instanceof String) {
                    NodeListTransferable.pasteString((String)object, spreadSheet);
                } else {
                    return false;
                }
                return true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    protected SpreadSheet getSpreadSheet(JComponent jComponent) {
        if (jComponent instanceof SpreadSheet) {
            return (SpreadSheet)jComponent;
        }
        return null;
    }

    protected DataFlavor getFlavor(DataFlavor[] dataFlavorArray) {
        NodeListTransferable nodeListTransferable = new NodeListTransferable(null, null, null, null, null, true);
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!nodeListTransferable.isDataFlavorSupported(dataFlavorArray[i])) continue;
            return dataFlavorArray[i];
        }
        return null;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return this.getFlavor(dataFlavorArray) != null;
    }

    public static void registerWith(SpreadSheet spreadSheet) {
        NodeListTransferHandler nodeListTransferHandler = new NodeListTransferHandler(spreadSheet);
        spreadSheet.setTransferHandler(nodeListTransferHandler);
        InputMap inputMap = spreadSheet.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke("ctrl X"), NodeListTransferHandler.getCutAction().getValue("Name"));
        inputMap.put(KeyStroke.getKeyStroke("ctrl C"), NodeListTransferHandler.getCopyAction().getValue("Name"));
        inputMap.put(KeyStroke.getKeyStroke("ctrl V"), NodeListTransferHandler.getPasteAction().getValue("Name"));
        ActionMap actionMap = spreadSheet.getActionMap();
        actionMap.put(NodeListTransferHandler.getCutAction().getValue("Name"), NodeListTransferHandler.getCutAction());
        actionMap.put(NodeListTransferHandler.getCopyAction().getValue("Name"), NodeListTransferHandler.getCopyAction());
        actionMap.put(NodeListTransferHandler.getPasteAction().getValue("Name"), NodeListTransferHandler.getPasteAction());
    }

    protected void initCutAction(SpreadSheet.SpreadSheetAction spreadSheetAction) {
        this.nodeListCutAction = new NodeListTransfertAction(NodeListTransferHandler.getCutAction(), spreadSheetAction, this.spreadSheet);
        this.nodeListCutAction.putValue("Name", Messages.getString("Spreadsheet.Action.cut"));
    }

    protected void initCopyAction(SpreadSheet.SpreadSheetAction spreadSheetAction) {
        this.nodeListCopyAction = new NodeListTransfertAction(NodeListTransferHandler.getCopyAction(), spreadSheetAction, this.spreadSheet);
        this.nodeListCopyAction.putValue("Name", Messages.getString("Spreadsheet.Action.copy"));
    }

    protected void initPasteAction(SpreadSheet.SpreadSheetAction spreadSheetAction) {
        this.nodeListPasteAction = new NodeListTransfertAction(NodeListTransferHandler.getPasteAction(), spreadSheetAction, this.spreadSheet);
        this.nodeListPasteAction.putValue("Name", Messages.getString("Spreadsheet.Action.paste"));
    }

    public NodeListTransfertAction getNodeListCopyAction() {
        if (this.nodeListCopyAction == null) {
            this.initCopyAction(this.spreadSheet.getCopyAction());
        }
        return this.nodeListCopyAction;
    }

    public NodeListTransfertAction getNodeListCutAction() {
        if (this.nodeListCutAction == null) {
            this.initCutAction(this.spreadSheet.getCutAction());
        }
        return this.nodeListCutAction;
    }

    public NodeListTransfertAction getNodeListPasteAction() {
        if (this.nodeListPasteAction == null) {
            this.initPasteAction(this.spreadSheet.getPasteAction());
        }
        return this.nodeListPasteAction;
    }
}

