/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.views;

import com.projity.configuration.Dictionary;
import com.projity.field.FieldContext;
import com.projity.graphic.configuration.BarStyles;
import com.projity.graphic.configuration.CellStyle;
import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.graphic.configuration.SpreadSheetFieldArray;
import com.projity.grouping.core.model.NodeModel;
import com.projity.help.HelpUtil;
import com.projity.menu.MenuManager;
import com.projity.pm.graphic.frames.DocumentFrame;
import com.projity.pm.graphic.gantt.Gantt;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.cache.NodeModelCacheFactory;
import com.projity.pm.graphic.model.cache.ReferenceNodeModelCache;
import com.projity.pm.graphic.spreadsheet.SpreadSheet;
import com.projity.pm.graphic.spreadsheet.SpreadSheetModel;
import com.projity.pm.graphic.spreadsheet.SpreadSheetUtils;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.pm.graphic.timescale.ScaledScrollPane;
import com.projity.pm.graphic.views.BaseView;
import com.projity.pm.graphic.views.SplittedView;
import com.projity.pm.graphic.views.synchro.Synchronizer;
import com.projity.pm.scheduling.ScheduleEvent;
import com.projity.pm.scheduling.ScheduleEventListener;
import com.projity.pm.task.Project;
import com.projity.pm.time.HasStartAndEnd;
import com.projity.strings.Messages;
import com.projity.undo.UndoController;
import com.projity.workspace.WorkspaceSetting;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GanttView
extends SplittedView
implements BaseView,
ScheduleEventListener {
    private static final long serialVersionUID = 514828655690086836L;
    protected SpreadSheet spreadSheet;
    protected Gantt gantt;
    protected SortedSet baseLines = new TreeSet();
    protected ScaledScrollPane ganttScrollPane;
    protected NodeModel model;
    protected NodeModelCache cache;
    protected CoordinatesConverter coord;
    private Project project;
    DocumentFrame documentFrame;
    FieldContext fieldContext;
    CellStyle cellStyle;
    private boolean tracking = false;
    public static final String spreadsheetCategory = "taskSpreadsheet";

    public GanttView(DocumentFrame documentFrame, MenuManager menuManager, Synchronizer synchronizer) {
        super(synchronizer);
        this.documentFrame = documentFrame;
        this.project = documentFrame.getProject();
        HelpUtil.addDocHelp(this, "Gantt_Chart");
        this.setNeedVoidBar(true);
    }

    public void init(ReferenceNodeModelCache referenceNodeModelCache, NodeModel nodeModel, CoordinatesConverter coordinatesConverter) {
        this.coord = coordinatesConverter;
        this.cache = NodeModelCacheFactory.getInstance().createFilteredCache(referenceNodeModelCache, this.getViewName(), null);
        this.fieldContext = new FieldContext();
        this.fieldContext.setLeftAssociation(true);
        super.init();
        this.updateHeight(this.project);
        this.updateSize();
        this.leftScrollPane.getViewport().addChangeListener(new ChangeListener(){
            private Dimension olddl = null;

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Dimension dimension = GanttView.this.leftScrollPane.getViewport().getViewSize();
                if (dimension.equals(this.olddl)) {
                    return;
                }
                this.olddl = dimension;
                ((Gantt)GanttView.this.rightScrollPane.getViewport().getView()).setPreferredSize(new Dimension(GanttView.this.rightScrollPane.getViewport().getViewSize().width, dimension.height));
            }
        });
        referenceNodeModelCache.update();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.coord.removeTimeScaleListener(this.ganttScrollPane);
        this.project.removeScheduleListener(this);
        this.spreadSheet.cleanUp();
        this.gantt.cleanUp();
        this.spreadSheet = null;
        this.gantt = null;
        this.baseLines = null;
        this.ganttScrollPane = null;
        this.model = null;
        this.cache = null;
        this.coord = null;
        this.project = null;
        this.documentFrame = null;
        this.fieldContext = null;
        this.cellStyle = null;
    }

    public void setBarStyles(String string) {
        if (this.gantt == null) {
            return;
        }
        this.gantt.setBarStyles((BarStyles)Dictionary.get("BarStylesCategory", string));
    }

    @Override
    protected JScrollPane createLeftScrollPane() {
        this.spreadSheet = new SpreadSheet();
        this.spreadSheet.setName(this.project.getName());
        this.spreadSheet.setSpreadSheetCategory(spreadsheetCategory);
        SpreadSheetFieldArray spreadSheetFieldArray = GanttView.getFields();
        if (this.project.getFieldArray() != null) {
            spreadSheetFieldArray = this.project.getFieldArray();
        }
        this.spreadSheet.setCache(this.cache, spreadSheetFieldArray, spreadSheetFieldArray.getCellStyle(), spreadSheetFieldArray.getActionList());
        if (this.project.getFieldArray() != null) {
            this.spreadSheet.setFieldArrayWithWidths(spreadSheetFieldArray);
        }
        ((SpreadSheetModel)this.spreadSheet.getModel()).setFieldContext(this.fieldContext);
        this.project.removeScheduleListener(this);
        this.project.addScheduleListener(this);
        if (this.project.isReadOnly()) {
            this.spreadSheet.setReadOnly(true);
        }
        return SpreadSheetUtils.makeSpreadsheetScrollPane(this.spreadSheet);
    }

    @Override
    protected JScrollPane createRightScrollPane() {
        this.gantt = new Gantt(this.project, "Gantt");
        this.gantt.setCache(this.cache);
        this.gantt.setBarStyles((BarStyles)Dictionary.get("BarStylesCategory", "standard"));
        this.ganttScrollPane = new ScaledScrollPane(this.gantt, this.coord, this.documentFrame, this.spreadSheet.getRowHeight());
        return this.ganttScrollPane;
    }

    public void activateEmptyRowHeader(boolean bl) {
        this.ganttScrollPane.activateEmptyRowHeader(bl);
    }

    private static SpreadSheetFieldArray getFields() {
        return (SpreadSheetFieldArray)Dictionary.get(spreadsheetCategory, Messages.getString("Spreadsheet.Task.entry"));
    }

    public ArrayList setColumns(String string) {
        ArrayList arrayList = this.spreadSheet.getFieldArray();
        this.setColumns((ArrayList)((Object)Dictionary.get(spreadsheetCategory, Messages.getString(string))));
        return arrayList;
    }

    public void setColumns(ArrayList arrayList) {
        this.spreadSheet.setFieldArray(arrayList);
    }

    @Override
    public SpreadSheet getSpreadSheet() {
        return this.spreadSheet;
    }

    public void updateHeight(Integer n, boolean bl) {
        if (bl) {
            this.baseLines.add(n);
        } else {
            this.baseLines.remove(n);
        }
        int n2 = this.baseLines.size() == 0 ? 0 : (Integer)this.baseLines.last() + 1;
        int n3 = GraphicConfiguration.getInstance().getRowHeight() + n2 * GraphicConfiguration.getInstance().getBaselineHeight();
        this.spreadSheet.setRowHeight(n3);
        this.gantt.setRowHeight(n3);
    }

    public void updateHeight(Project project) {
        this.baseLines.clear();
        int n = project.getRowHeight(this.baseLines);
        this.spreadSheet.setRowHeight(n);
        this.gantt.setRowHeight(n);
    }

    @Override
    public void scheduleChanged(ScheduleEvent scheduleEvent) {
        if (scheduleEvent.getType() != ScheduleEvent.SCHEDULE && scheduleEvent.getType() != ScheduleEvent.ACTUAL && scheduleEvent.getType() == ScheduleEvent.BASELINE) {
            this.updateHeight(scheduleEvent.getSnapshot(), scheduleEvent.isSaveSnapshot());
        }
    }

    @Override
    public void updateSize() {
        this.gantt.updateSize();
    }

    @Override
    public UndoController getUndoController() {
        return this.project.getUndoController();
    }

    @Override
    public void zoomIn() {
        this.coord.zoomIn();
    }

    @Override
    public void zoomOut() {
        this.coord.zoomOut();
    }

    @Override
    public boolean canZoomIn() {
        return this.coord.canZoomIn();
    }

    @Override
    public boolean canZoomOut() {
        return this.coord.canZoomOut();
    }

    @Override
    public int getScale() {
        return this.coord.getTimescaleManager().getCurrentScaleIndex();
    }

    @Override
    public boolean hasNormalMinWidth() {
        return true;
    }

    @Override
    public String getViewName() {
        return "Gantt";
    }

    @Override
    public boolean showsTasks() {
        return true;
    }

    @Override
    public boolean showsResources() {
        return false;
    }

    @Override
    public void onActivate(boolean bl) {
    }

    public Gantt getGantt() {
        return this.gantt;
    }

    @Override
    public boolean isPrintable() {
        return true;
    }

    public void reinitialize() {
        this.createLeftScrollPane();
    }

    @Override
    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        Workspace workspace = (Workspace)workspaceSetting;
        this.spreadSheet.restoreWorkspace(workspace.spreadSheet, n);
        this.ganttScrollPane.restoreWorkspace(workspace.scrollPane, n);
        this.setDividerLocation(workspace.dividerLocation);
    }

    @Override
    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        workspace.spreadSheet = this.spreadSheet.createWorkspace(n);
        workspace.scrollPane = this.ganttScrollPane.createWorkspace(n);
        workspace.dividerLocation = this.getDividerLocation();
        return workspace;
    }

    @Override
    public boolean canScrollToTask() {
        return true;
    }

    @Override
    public void scrollToTask() {
        ArrayList arrayList = this.spreadSheet.getSelectedNodesImpl();
        if (arrayList.size() == 0) {
            return;
        }
        Object e = arrayList.get(0);
        if (!(e instanceof HasStartAndEnd)) {
            return;
        }
        HasStartAndEnd hasStartAndEnd = (HasStartAndEnd)e;
        this.gantt.scrollToTask(hasStartAndEnd, false);
    }

    @Override
    public NodeModelCache getCache() {
        return this.cache;
    }

    public boolean isTracking() {
        return this.tracking;
    }

    public void setTracking(boolean bl) {
        this.tracking = bl;
        HelpUtil.addDocHelp(this, bl ? "Tracking_Gantt_Chart" : "Gantt_Chart");
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = -407561451956813994L;
        WorkspaceSetting spreadSheet;
        WorkspaceSetting scrollPane;
        int dividerLocation;

        public WorkspaceSetting getSpreadSheet() {
            return this.spreadSheet;
        }

        public void setSpreadSheet(WorkspaceSetting workspaceSetting) {
            this.spreadSheet = workspaceSetting;
        }

        public WorkspaceSetting getScrollPane() {
            return this.scrollPane;
        }

        public void setScrollPane(WorkspaceSetting workspaceSetting) {
            this.scrollPane = workspaceSetting;
        }

        public int getDividerLocation() {
            return this.dividerLocation;
        }

        public void setDividerLocation(int n) {
            this.dividerLocation = n;
        }
    }
}

