/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.scheduling;

import com.projity.datatype.Duration;
import com.projity.pm.assignment.Allocation;
import com.projity.pm.scheduling.SchedulingRule;
import com.projity.strings.Messages;

public class FixedUnits
implements SchedulingRule {
    private static FixedUnits instance = null;

    public String toString() {
        return Messages.getString("FixedUnits.FixedUnits");
    }

    @Override
    public void adjustRemainingUnits(Allocation allocation, double d, double d2, boolean bl, boolean bl2) {
        if (d == 0.0) {
            allocation.adjustRemainingDuration(0L, bl);
            allocation.adjustRemainingUnits(1.0, d2, bl, false);
        } else if (d2 == 0.0) {
            allocation.adjustRemainingUnits(1.0, d2, false, false);
        } else {
            allocation.adjustRemainingWork(d2 / d, bl);
        }
    }

    @Override
    public void adjustRemainingDuration(Allocation allocation, long l, boolean bl) {
        allocation.adjustRemainingDuration(l, bl);
    }

    @Override
    public void adjustRemainingWork(Allocation allocation, long l, boolean bl) {
        long l2 = allocation.getRemainingWork();
        this.adjustRemainingWork(allocation, l, l2, bl);
    }

    @Override
    public void adjustRemainingWork(Allocation allocation, long l, long l2, boolean bl) {
        long l3;
        if (l2 == 0L) {
            l3 = (long)((double)l / allocation.getRemainingUnits());
        } else {
            l = Duration.millis(l);
            l3 = (long)((double)allocation.getRemainingDuration() * (double)l / (double)l2);
        }
        allocation.adjustRemainingDuration(l3, bl);
    }

    private FixedUnits() {
    }

    public static FixedUnits getInstance() {
        if (instance == null) {
            instance = new FixedUnits();
        }
        return instance;
    }
}

