/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import net.sourceforge.plantuml.graphic.UGraphicDelegator;
import net.sourceforge.plantuml.ugraphic.CompressionTransform;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class UGraphicCompress
extends UGraphicDelegator {
    private final CompressionTransform compressionTransform;
    private final UTranslate translate;

    @Override
    public UGraphic apply(UChange change) {
        if (change instanceof UTranslate) {
            return new UGraphicCompress(this.getUg(), this.compressionTransform, this.translate.compose((UTranslate)change));
        }
        if (change instanceof UStroke || change instanceof UChangeBackColor || change instanceof UChangeColor) {
            return new UGraphicCompress(this.getUg().apply(change), this.compressionTransform, this.translate);
        }
        throw new UnsupportedOperationException();
    }

    public UGraphicCompress(UGraphic ug, CompressionTransform compressionTransform) {
        this(ug, compressionTransform, new UTranslate());
    }

    private UGraphicCompress(UGraphic ug, CompressionTransform compressionTransform, UTranslate translate) {
        super(ug);
        this.compressionTransform = compressionTransform;
        this.translate = translate;
    }

    @Override
    public void draw(UShape shape) {
        double x = this.translate.getDx();
        double y = this.translate.getDy();
        if (shape instanceof ULine) {
            this.drawLine(x, y, (ULine)shape);
        } else {
            this.getUg().apply(new UTranslate(x, this.ct(y))).draw(shape);
        }
    }

    private void drawLine(double x, double y, ULine shape) {
        this.drawLine(x, this.ct(y), x + shape.getDX(), this.ct(y + shape.getDY()));
    }

    private double ct(double v) {
        return this.compressionTransform.transform(v);
    }

    private void drawLine(double x1, double y1, double x2, double y2) {
        if (y1 > y2) {
            this.drawLine(x2, y2, x1, y1);
            return;
        }
        assert (y1 <= y2);
        double xmin = Math.min(x1, x2);
        double xmax = Math.max(x1, x2);
        double ymin = Math.min(y1, y2);
        double ymax = Math.max(y1, y2);
        if (x2 >= x1) {
            this.getUg().apply(new UTranslate(xmin, ymin)).draw(new ULine(xmax - xmin, ymax - ymin));
        } else {
            this.getUg().apply(new UTranslate(xmax, ymin)).draw(new ULine(-(xmax - xmin), ymax - ymin));
        }
    }
}

