/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.util.Processor;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalFileSystem
extends NewVirtualFileSystem {
    @NonNls
    public static final String PROTOCOL = "file";
    @NonNls
    public static final String PROTOCOL_PREFIX = "file://";

    public static LocalFileSystem getInstance() {
        return LocalFileSystemHolder.ourInstance;
    }

    @Nullable
    public abstract VirtualFile findFileByIoFile(@NotNull File var1);

    @Nullable
    public abstract VirtualFile refreshAndFindFileByIoFile(@NotNull File var1);

    public abstract void refreshIoFiles(@NotNull Iterable<File> var1);

    public abstract void refreshIoFiles(@NotNull Iterable<File> var1, boolean var2, boolean var3, @Nullable Runnable var4);

    public abstract void refreshFiles(@NotNull Iterable<VirtualFile> var1);

    public abstract void refreshFiles(@NotNull Iterable<VirtualFile> var1, boolean var2, boolean var3, @Nullable Runnable var4);

    @Nullable
    public WatchRequest addRootToWatch(@NotNull String rootPath, boolean watchRecursively) {
        Set<WatchRequest> result2;
        if (rootPath == null) {
            LocalFileSystem.$$$reportNull$$$0(0);
        }
        return (result2 = this.addRootsToWatch(Collections.singleton(rootPath), watchRecursively)).size() == 1 ? result2.iterator().next() : null;
    }

    @NotNull
    public Set<WatchRequest> addRootsToWatch(@NotNull Collection<String> rootPaths, boolean watchRecursively) {
        if (rootPaths == null) {
            LocalFileSystem.$$$reportNull$$$0(1);
        }
        if (rootPaths.isEmpty()) {
            Set<WatchRequest> set = Collections.emptySet();
            if (set == null) {
                LocalFileSystem.$$$reportNull$$$0(2);
            }
            return set;
        }
        if (watchRecursively) {
            Set<WatchRequest> set = this.replaceWatchedRoots(Collections.emptySet(), rootPaths, null);
            if (set == null) {
                LocalFileSystem.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<WatchRequest> set = this.replaceWatchedRoots(Collections.emptySet(), null, rootPaths);
        if (set == null) {
            LocalFileSystem.$$$reportNull$$$0(4);
        }
        return set;
    }

    public void removeWatchedRoot(@Nullable WatchRequest watchRequest) {
        if (watchRequest != null) {
            this.removeWatchedRoots(Collections.singleton(watchRequest));
        }
    }

    public void removeWatchedRoots(@NotNull Collection<WatchRequest> watchRequests) {
        if (watchRequests == null) {
            LocalFileSystem.$$$reportNull$$$0(5);
        }
        if (!watchRequests.isEmpty()) {
            this.replaceWatchedRoots(watchRequests, null, null);
        }
    }

    @Nullable
    public WatchRequest replaceWatchedRoot(@Nullable WatchRequest watchRequest, @NotNull String rootPath, boolean watchRecursively) {
        if (rootPath == null) {
            LocalFileSystem.$$$reportNull$$$0(6);
        }
        Set<WatchRequest> requests = watchRequest != null ? Collections.singleton(watchRequest) : Collections.emptySet();
        Set<String> roots = Collections.singleton(rootPath);
        Set<WatchRequest> result2 = watchRecursively ? this.replaceWatchedRoots(requests, roots, null) : this.replaceWatchedRoots(requests, null, roots);
        return result2.size() == 1 ? result2.iterator().next() : null;
    }

    @NotNull
    public abstract Set<WatchRequest> replaceWatchedRoots(@NotNull Collection<WatchRequest> var1, @Nullable Collection<String> var2, @Nullable Collection<String> var3);

    public abstract void registerAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler var1);

    public abstract void unregisterAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler var1);

    public abstract boolean processCachedFilesInSubtree(@NotNull VirtualFile var1, @NotNull Processor<VirtualFile> var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPaths";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/LocalFileSystem";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/LocalFileSystem";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addRootsToWatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRootToWatch";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addRootsToWatch";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeWatchedRoots";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceWatchedRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface WatchRequest {
        @NotNull
        public String getRootPath();

        public boolean isToWatchRecursively();
    }

    private static class LocalFileSystemHolder {
        private static final LocalFileSystem ourInstance = (LocalFileSystem)VirtualFileManager.getInstance().getFileSystem("file");

        private LocalFileSystemHolder() {
        }
    }
}

