/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.codeStyle.CodeStyleBlankLinesPanel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.CodeStyleSpacesPanel;
import com.intellij.application.options.codeStyle.WrappingAndBracesPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TabbedLanguageCodeStylePanel
extends CodeStyleAbstractPanel {
    private static final Logger LOG = Logger.getInstance(TabbedLanguageCodeStylePanel.class);
    private CodeStyleAbstractPanel myActiveTab;
    private List<CodeStyleAbstractPanel> myTabs;
    private JPanel myPanel;
    private TabbedPaneWrapper myTabbedPane;
    private final PredefinedCodeStyle[] myPredefinedCodeStyles = this.getPredefinedStyles();
    private JPopupMenu myCopyFromMenu;
    @Nullable
    private TabChangeListener myListener;

    protected TabbedLanguageCodeStylePanel(@Nullable Language language, CodeStyleSettings currentSettings, CodeStyleSettings settings) {
        super(language, currentSettings, settings);
    }

    protected void initTabs(CodeStyleSettings settings) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)this.getDefaultLanguage());
        this.addIndentOptionsTab(settings);
        if (provider != null) {
            this.addSpacesTab(settings);
            this.addWrappingAndBracesTab(settings);
            this.addBlankLinesTab(settings);
        }
    }

    protected void addIndentOptionsTab(CodeStyleSettings settings) {
        IndentOptionsEditor indentOptionsEditor;
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)this.getDefaultLanguage());
        if (provider != null && (indentOptionsEditor = provider.getIndentOptionsEditor()) != null) {
            MyIndentOptionsWrapper indentOptionsWrapper = new MyIndentOptionsWrapper(settings, provider, indentOptionsEditor);
            this.addTab(indentOptionsWrapper);
        }
    }

    protected void addSpacesTab(CodeStyleSettings settings) {
        this.addTab(new MySpacesPanel(settings));
    }

    protected void addBlankLinesTab(CodeStyleSettings settings) {
        this.addTab(new MyBlankLinesPanel(settings));
    }

    protected void addWrappingAndBracesTab(CodeStyleSettings settings) {
        this.addTab(new MyWrappingAndBracesPanel(settings));
    }

    protected void ensureTabs() {
        if (this.myTabs == null) {
            this.myPanel = new JPanel();
            this.myPanel.setLayout(new BorderLayout());
            this.myTabbedPane = new TabbedPaneWrapper(this);
            this.myTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    String title;
                    if (TabbedLanguageCodeStylePanel.this.myListener != null && (title = TabbedLanguageCodeStylePanel.this.myTabbedPane.getSelectedTitle()) != null) {
                        TabbedLanguageCodeStylePanel.this.myListener.tabChanged(TabbedLanguageCodeStylePanel.this, title);
                    }
                }
            });
            this.myTabs = new ArrayList<CodeStyleAbstractPanel>();
            this.myPanel.add(this.myTabbedPane.getComponent());
            this.initTabs(this.getSettings());
        }
        assert (!this.myTabs.isEmpty());
    }

    public void showSetFrom(Component component) {
        this.initCopyFromMenu();
        this.myCopyFromMenu.show(component, 0, component.getHeight());
    }

    private void initCopyFromMenu() {
        if (this.myCopyFromMenu == null) {
            this.myCopyFromMenu = new JBPopupMenu();
            this.setupCopyFromMenu(this.myCopyFromMenu);
        }
    }

    protected final void addTab(CodeStyleAbstractPanel tab) {
        this.myTabs.add(tab);
        tab.setShouldUpdatePreview(true);
        this.addPanelToWatch(tab.getPanel());
        this.myTabbedPane.addTab(tab.getTabTitle(), tab.getPanel());
        if (this.myActiveTab == null) {
            this.myActiveTab = tab;
        }
    }

    private void addTab(Configurable configurable) {
        ConfigurableWrapper wrapper2 = new ConfigurableWrapper(configurable, this.getSettings());
        this.addTab(wrapper2);
    }

    protected final void createTab(CodeStyleSettingsProvider provider) {
        if (provider.hasSettingsPage()) {
            return;
        }
        Configurable configurable = provider.createSettingsPage(this.getCurrentSettings(), this.getSettings());
        this.addTab(configurable);
    }

    @Override
    public final void setModel(CodeStyleSchemesModel model) {
        super.setModel(model);
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            tab.setModel(model);
        }
    }

    @Override
    protected int getRightMargin() {
        this.ensureTabs();
        return this.myActiveTab.getRightMargin();
    }

    @Override
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme2) {
        this.ensureTabs();
        return this.myActiveTab.createHighlighter(scheme2);
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        this.ensureTabs();
        FileType fileType = this.myActiveTab.getFileType();
        if (fileType == null) {
            TabbedLanguageCodeStylePanel.$$$reportNull$$$0(0);
        }
        return fileType;
    }

    @Override
    protected String getPreviewText() {
        this.ensureTabs();
        return this.myActiveTab.getPreviewText();
    }

    @Override
    protected void updatePreview(boolean useDefaultSample) {
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            tab.updatePreview(useDefaultSample);
        }
    }

    @Override
    public void onSomethingChanged() {
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            tab.setShouldUpdatePreview(true);
            tab.onSomethingChanged();
        }
    }

    @Override
    public void apply(CodeStyleSettings settings) throws ConfigurationException {
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            tab.apply(settings);
        }
    }

    @Override
    public void dispose() {
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            Disposer.dispose((Disposable)tab);
        }
        super.dispose();
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            if (!tab.isModified(settings)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            tab.resetImpl(settings);
        }
    }

    @Override
    public void setupCopyFromMenu(JPopupMenu copyMenu) {
        super.setupCopyFromMenu(copyMenu);
        if (this.myPredefinedCodeStyles.length > 0) {
            JMenu langs = new JMenu("Language"){

                @Override
                public void paint(Graphics g) {
                    GraphicsUtil.setupAntialiasing((Graphics)g);
                    super.paint(g);
                }
            };
            copyMenu.add(langs);
            this.fillLanguages(langs);
            JMenu predefined = new JMenu("Predefined Style"){

                @Override
                public void paint(Graphics g) {
                    GraphicsUtil.setupAntialiasing((Graphics)g);
                    super.paint(g);
                }
            };
            copyMenu.add(predefined);
            this.fillPredefined(predefined);
        } else {
            this.fillLanguages(copyMenu);
        }
    }

    private void fillLanguages(JComponent parentMenu) {
        Language[] languages = LanguageCodeStyleSettingsProvider.getLanguagesWithCodeStyleSettings();
        ArrayList<JBMenuItem> langItems = new ArrayList<JBMenuItem>();
        for (final Language lang : languages) {
            if (lang.equals(this.getDefaultLanguage())) continue;
            String langName = LanguageCodeStyleSettingsProvider.getLanguageName((Language)lang);
            JBMenuItem langItem = new JBMenuItem(langName);
            langItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedLanguageCodeStylePanel.this.applyLanguageSettings(lang);
                }
            });
            langItems.add(langItem);
        }
        Collections.sort(langItems, (item1, item2) -> item1.getText().compareToIgnoreCase(item2.getText()));
        for (JMenuItem jMenuItem : langItems) {
            parentMenu.add(jMenuItem);
        }
    }

    private void fillPredefined(JMenuItem parentMenu) {
        for (final PredefinedCodeStyle predefinedCodeStyle : this.myPredefinedCodeStyles) {
            JBMenuItem predefinedItem = new JBMenuItem(predefinedCodeStyle.getName());
            parentMenu.add((Component)predefinedItem);
            predefinedItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedLanguageCodeStylePanel.this.applyPredefinedStyle(predefinedCodeStyle.getName());
                }
            });
        }
    }

    private PredefinedCodeStyle[] getPredefinedStyles() {
        Language language = this.getDefaultLanguage();
        ArrayList<PredefinedCodeStyle> result2 = new ArrayList<PredefinedCodeStyle>();
        for (PredefinedCodeStyle codeStyle : (PredefinedCodeStyle[])PredefinedCodeStyle.EP_NAME.getExtensions()) {
            if (!codeStyle.getLanguage().equals(language)) continue;
            result2.add(codeStyle);
        }
        return result2.toArray(PredefinedCodeStyle.EMPTY_ARRAY);
    }

    private void applyLanguageSettings(Language lang) {
        Project currProject = ProjectUtil.guessCurrentProject((JComponent)this.getPanel());
        CodeStyleSettings rootSettings = CodeStyle.getSettings((Project)currProject);
        CodeStyleSettings targetSettings = this.getSettings();
        this.applyLanguageSettings(lang, rootSettings, targetSettings);
        this.reset(targetSettings);
        this.onSomethingChanged();
    }

    protected void applyLanguageSettings(Language lang, CodeStyleSettings rootSettings, CodeStyleSettings targetSettings) {
        CommonCodeStyleSettings sourceCommonSettings = rootSettings.getCommonSettings(lang);
        CommonCodeStyleSettings targetCommonSettings = targetSettings.getCommonSettings(this.getDefaultLanguage());
        targetCommonSettings.copyFrom(sourceCommonSettings);
    }

    private void applyPredefinedStyle(String styleName) {
        for (PredefinedCodeStyle style : this.myPredefinedCodeStyles) {
            if (!style.getName().equals(styleName)) continue;
            this.applyPredefinedSettings(style);
        }
    }

    @Override
    public Set<String> processListOptions() {
        HashSet result2 = new HashSet();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            result2.addAll(tab.processListOptions());
        }
        return result2;
    }

    public void setListener(@Nullable TabChangeListener listener2) {
        this.myListener = listener2;
    }

    public void changeTab(@NotNull String tabTitle) {
        if (tabTitle == null) {
            TabbedLanguageCodeStylePanel.$$$reportNull$$$0(1);
        }
        this.myTabbedPane.setSelectedTitle(tabTitle);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/TabbedLanguageCodeStylePanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/TabbedLanguageCodeStylePanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "changeTab";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface TabChangeListener {
        public void tabChanged(@NotNull TabbedLanguageCodeStylePanel var1, @NotNull String var2);
    }

    protected class MyIndentOptionsWrapper
    extends CodeStyleAbstractPanel {
        private final IndentOptionsEditor myEditor;
        private final LanguageCodeStyleSettingsProvider myProvider;
        private final JPanel myTopPanel;
        private final JPanel myLeftPanel;
        private final JPanel myRightPanel;

        protected MyIndentOptionsWrapper(CodeStyleSettings settings, LanguageCodeStyleSettingsProvider provider, IndentOptionsEditor editor) {
            super(settings);
            this.myTopPanel = new JPanel(new BorderLayout());
            this.myLeftPanel = new JPanel(new BorderLayout());
            this.myProvider = provider;
            this.myTopPanel.add((Component)this.myLeftPanel, "West");
            this.myRightPanel = new JPanel();
            this.installPreviewPanel(this.myRightPanel);
            this.myEditor = editor;
            if (this.myEditor != null) {
                JPanel panel2 = this.myEditor.createPanel();
                panel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)panel2, (boolean)true);
                scroll.setPreferredSize(new Dimension(panel2.getPreferredSize().width + scroll.getVerticalScrollBar().getPreferredSize().width + 5, -1));
                this.myLeftPanel.add((Component)scroll, "Center");
            }
            this.myTopPanel.add((Component)this.myRightPanel, "Center");
        }

        @Override
        protected int getRightMargin() {
            return this.myProvider.getRightMargin(LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS);
        }

        @Override
        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme2) {
            return EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getFileType(), scheme2, null);
        }

        @Override
        @NotNull
        protected FileType getFileType() {
            Language language = TabbedLanguageCodeStylePanel.this.getDefaultLanguage();
            LanguageFileType languageFileType = language != null ? language.getAssociatedFileType() : FileTypes.PLAIN_TEXT;
            if (languageFileType == null) {
                MyIndentOptionsWrapper.$$$reportNull$$$0(0);
            }
            return languageFileType;
        }

        @Override
        protected String getPreviewText() {
            return this.myProvider != null ? this.myProvider.getCodeSample(LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) : "Loading...";
        }

        @Override
        protected String getFileExt() {
            String ext;
            if (this.myProvider != null && (ext = this.myProvider.getFileExt()) != null) {
                return ext;
            }
            return super.getFileExt();
        }

        @Override
        public void apply(CodeStyleSettings settings) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions(settings);
            if (indentOptions == null) {
                return;
            }
            this.myEditor.apply(settings, indentOptions);
        }

        @Override
        public boolean isModified(CodeStyleSettings settings) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions(settings);
            if (indentOptions == null) {
                return false;
            }
            return this.myEditor.isModified(settings, indentOptions);
        }

        @Override
        public JComponent getPanel() {
            return this.myTopPanel;
        }

        @Override
        protected void resetImpl(CodeStyleSettings settings) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions(settings);
            if (indentOptions == null) {
                this.myEditor.setEnabled(false);
                indentOptions = settings.getIndentOptions((FileType)this.myProvider.getLanguage().getAssociatedFileType());
            }
            this.myEditor.reset(settings, indentOptions);
        }

        @Nullable
        private CommonCodeStyleSettings.IndentOptions getIndentOptions(CodeStyleSettings settings) {
            return settings.getCommonSettings(this.getDefaultLanguage()).getIndentOptions();
        }

        @Override
        public Language getDefaultLanguage() {
            return TabbedLanguageCodeStylePanel.this.getDefaultLanguage();
        }

        @Override
        protected String getTabTitle() {
            return ApplicationBundle.message((String)"title.tabs.and.indents", (Object[])new Object[0]);
        }

        @Override
        public void onSomethingChanged() {
            super.onSomethingChanged();
            this.myEditor.setEnabled(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/TabbedLanguageCodeStylePanel$MyIndentOptionsWrapper", "getFileType"));
        }
    }

    private class ConfigurableWrapper
    extends CodeStyleAbstractPanel {
        private final Configurable myConfigurable;
        private JComponent myComponent;

        public ConfigurableWrapper(Configurable configurable, CodeStyleSettings settings) {
            if (configurable == null) {
                ConfigurableWrapper.$$$reportNull$$$0(0);
            }
            super(settings);
            this.myConfigurable = configurable;
            Disposer.register((Disposable)this, (Disposable)new Disposable(){

                public void dispose() {
                    ConfigurableWrapper.this.myConfigurable.disposeUIResources();
                }
            });
        }

        @Override
        protected int getRightMargin() {
            return 0;
        }

        @Override
        @Nullable
        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme2) {
            return null;
        }

        @Override
        @NotNull
        protected FileType getFileType() {
            Language language = this.getDefaultLanguage();
            LanguageFileType languageFileType = language != null ? language.getAssociatedFileType() : FileTypes.PLAIN_TEXT;
            if (languageFileType == null) {
                ConfigurableWrapper.$$$reportNull$$$0(1);
            }
            return languageFileType;
        }

        @Override
        public Language getDefaultLanguage() {
            return TabbedLanguageCodeStylePanel.this.getDefaultLanguage();
        }

        @Override
        protected String getTabTitle() {
            return this.myConfigurable.getDisplayName();
        }

        @Override
        protected String getPreviewText() {
            return null;
        }

        @Override
        public void apply(CodeStyleSettings settings) throws ConfigurationException {
            if (this.myConfigurable instanceof CodeStyleConfigurable) {
                ((CodeStyleConfigurable)this.myConfigurable).apply(settings);
            } else {
                this.myConfigurable.apply();
            }
        }

        @Override
        public boolean isModified(CodeStyleSettings settings) {
            return this.myConfigurable.isModified();
        }

        @Override
        @Nullable
        public JComponent getPanel() {
            if (this.myComponent == null) {
                this.myComponent = this.myConfigurable.createComponent();
            }
            return this.myComponent;
        }

        @Override
        protected void resetImpl(CodeStyleSettings settings) {
            if (this.myConfigurable instanceof CodeStyleConfigurable) {
                ((CodeStyleConfigurable)this.myConfigurable).reset(settings);
            } else {
                this.myConfigurable.reset();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/TabbedLanguageCodeStylePanel$ConfigurableWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/TabbedLanguageCodeStylePanel$ConfigurableWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected class MyWrappingAndBracesPanel
    extends WrappingAndBracesPanel {
        public MyWrappingAndBracesPanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public Language getDefaultLanguage() {
            return TabbedLanguageCodeStylePanel.this.getDefaultLanguage();
        }
    }

    protected class MyBlankLinesPanel
    extends CodeStyleBlankLinesPanel {
        public MyBlankLinesPanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public Language getDefaultLanguage() {
            return TabbedLanguageCodeStylePanel.this.getDefaultLanguage();
        }
    }

    protected class MySpacesPanel
    extends CodeStyleSpacesPanel {
        public MySpacesPanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        protected boolean shouldHideOptions() {
            return true;
        }

        @Override
        public Language getDefaultLanguage() {
            return TabbedLanguageCodeStylePanel.this.getDefaultLanguage();
        }
    }
}

