/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionGroup;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedIntentions {
    private static final Logger LOG = Logger.getInstance(CachedIntentions.class);
    private final Set<IntentionActionWithTextCaching> myIntentions;
    private final Set<IntentionActionWithTextCaching> myErrorFixes;
    private final Set<IntentionActionWithTextCaching> myInspectionFixes;
    private final Set<IntentionActionWithTextCaching> myGutters;
    private final Set<IntentionActionWithTextCaching> myNotifications;
    private int myOffset;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final Project myProject;
    private static final TObjectHashingStrategy<IntentionActionWithTextCaching> ACTION_TEXT_AND_CLASS_EQUALS = new TObjectHashingStrategy<IntentionActionWithTextCaching>(){

        public int computeHashCode(IntentionActionWithTextCaching object) {
            return object.getText().hashCode();
        }

        public boolean equals(IntentionActionWithTextCaching o1, IntentionActionWithTextCaching o2) {
            return this.getActionClass(o1) == this.getActionClass(o2) && o1.getText().equals(o2.getText());
        }

        private Class<? extends IntentionAction> getActionClass(IntentionActionWithTextCaching o1) {
            IntentionAction action = o1.getAction();
            if (action instanceof IntentionActionDelegate) {
                return ((IntentionActionDelegate)action).getDelegate().getClass();
            }
            return action.getClass();
        }
    };

    public CachedIntentions(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor) {
        if (project == null) {
            CachedIntentions.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            CachedIntentions.$$$reportNull$$$0(1);
        }
        this.myIntentions = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myErrorFixes = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myInspectionFixes = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myGutters = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myNotifications = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myProject = project;
        this.myFile = file2;
        this.myEditor = editor;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getIntentions() {
        Set<IntentionActionWithTextCaching> set2 = this.myIntentions;
        if (set2 == null) {
            CachedIntentions.$$$reportNull$$$0(2);
        }
        return set2;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getErrorFixes() {
        Set<IntentionActionWithTextCaching> set2 = this.myErrorFixes;
        if (set2 == null) {
            CachedIntentions.$$$reportNull$$$0(3);
        }
        return set2;
    }

    @NotNull
    Set<IntentionActionWithTextCaching> getInspectionFixes() {
        Set<IntentionActionWithTextCaching> set2 = this.myInspectionFixes;
        if (set2 == null) {
            CachedIntentions.$$$reportNull$$$0(4);
        }
        return set2;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getGutters() {
        Set<IntentionActionWithTextCaching> set2 = this.myGutters;
        if (set2 == null) {
            CachedIntentions.$$$reportNull$$$0(5);
        }
        return set2;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getNotifications() {
        Set<IntentionActionWithTextCaching> set2 = this.myNotifications;
        if (set2 == null) {
            CachedIntentions.$$$reportNull$$$0(6);
        }
        return set2;
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            CachedIntentions.$$$reportNull$$$0(7);
        }
        return psiFile;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            CachedIntentions.$$$reportNull$$$0(8);
        }
        return project;
    }

    public int getOffset() {
        return this.myOffset;
    }

    @NotNull
    public static CachedIntentions create(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        if (project == null) {
            CachedIntentions.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            CachedIntentions.$$$reportNull$$$0(10);
        }
        if (intentions == null) {
            CachedIntentions.$$$reportNull$$$0(11);
        }
        CachedIntentions res = new CachedIntentions(project, file2, editor);
        res.wrapAndUpdateActions(intentions, false);
        CachedIntentions cachedIntentions = res;
        if (cachedIntentions == null) {
            CachedIntentions.$$$reportNull$$$0(12);
        }
        return cachedIntentions;
    }

    @NotNull
    public static CachedIntentions createAndUpdateActions(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        if (project == null) {
            CachedIntentions.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            CachedIntentions.$$$reportNull$$$0(14);
        }
        if (intentions == null) {
            CachedIntentions.$$$reportNull$$$0(15);
        }
        CachedIntentions res = new CachedIntentions(project, file2, editor);
        res.wrapAndUpdateActions(intentions, true);
        CachedIntentions cachedIntentions = res;
        if (cachedIntentions == null) {
            CachedIntentions.$$$reportNull$$$0(16);
        }
        return cachedIntentions;
    }

    public boolean wrapAndUpdateActions(@NotNull ShowIntentionsPass.IntentionsInfo newInfo, boolean callUpdate) {
        if (newInfo == null) {
            CachedIntentions.$$$reportNull$$$0(17);
        }
        this.myOffset = newInfo.getOffset();
        boolean changed = this.wrapActionsTo(newInfo.errorFixesToShow, this.myErrorFixes, callUpdate);
        changed |= this.wrapActionsTo(newInfo.inspectionFixesToShow, this.myInspectionFixes, callUpdate);
        changed |= this.wrapActionsTo(newInfo.intentionsToShow, this.myIntentions, callUpdate);
        changed |= this.wrapActionsTo(newInfo.guttersToShow, this.myGutters, callUpdate);
        return changed |= this.wrapActionsTo(newInfo.notificationActionsToShow, this.myNotifications, callUpdate);
    }

    private boolean wrapActionsTo(@NotNull List<HighlightInfo.IntentionActionDescriptor> newDescriptors, @NotNull Set<IntentionActionWithTextCaching> cachedActions, boolean callUpdate) {
        if (newDescriptors == null) {
            CachedIntentions.$$$reportNull$$$0(18);
        }
        if (cachedActions == null) {
            CachedIntentions.$$$reportNull$$$0(19);
        }
        boolean changed = false;
        if (this.myEditor == null) {
            LOG.assertTrue(!callUpdate);
            for (HighlightInfo.IntentionActionDescriptor descriptor2 : newDescriptors) {
                changed |= cachedActions.add(this.wrapAction(descriptor2, (PsiElement)this.myFile, this.myFile, null));
            }
        } else {
            Editor injectedEditor;
            PsiFile injectedFile;
            PsiFile hostElement;
            PsiFile element;
            int fileOffset;
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            int n = fileOffset = caretOffset > 0 && caretOffset == this.myFile.getTextLength() ? caretOffset - 1 : caretOffset;
            if (this.myFile instanceof PsiCompiledElement) {
                hostElement = element = this.myFile;
            } else if (PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument())) {
                FileViewProvider viewProvider = this.myFile.getViewProvider();
                hostElement = element = viewProvider.findElementAt(fileOffset, viewProvider.getBaseLanguage());
            } else {
                hostElement = this.myFile.getViewProvider().findElementAt(fileOffset, this.myFile.getLanguage());
                element = InjectedLanguageUtil.findElementAtNoCommit(this.myFile, fileOffset);
            }
            if (element == null || element == hostElement) {
                injectedFile = this.myFile;
                injectedEditor = this.myEditor;
            } else {
                injectedFile = element.getContainingFile();
                injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(this.myEditor, injectedFile);
            }
            Iterator<IntentionActionWithTextCaching> iterator = cachedActions.iterator();
            while (iterator.hasNext()) {
                IntentionActionWithTextCaching cachedAction = iterator.next();
                IntentionAction action = cachedAction.getAction();
                if (ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, action) || hostElement != element && (element == null || ShowIntentionActionsHandler.availableFor(injectedFile, injectedEditor, action))) continue;
                iterator.remove();
                changed = true;
            }
            THashSet wrappedNew = new THashSet(newDescriptors.size(), ACTION_TEXT_AND_CLASS_EQUALS);
            for (HighlightInfo.IntentionActionDescriptor descriptor3 : newDescriptors) {
                IntentionActionWithTextCaching cachedAction;
                IntentionAction action = descriptor3.getAction();
                if (element != null && element != hostElement && (!callUpdate || ShowIntentionActionsHandler.availableFor(injectedFile, injectedEditor, action))) {
                    cachedAction = this.wrapAction(descriptor3, (PsiElement)element, injectedFile, injectedEditor);
                    wrappedNew.add(cachedAction);
                    changed |= cachedActions.add(cachedAction);
                    continue;
                }
                if (hostElement == null || callUpdate && !ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, action)) continue;
                cachedAction = this.wrapAction(descriptor3, (PsiElement)hostElement, this.myFile, this.myEditor);
                wrappedNew.add(cachedAction);
                changed |= cachedActions.add(cachedAction);
            }
            Iterator<IntentionActionWithTextCaching> iterator2 = cachedActions.iterator();
            while (iterator2.hasNext()) {
                IntentionActionWithTextCaching cachedAction = iterator2.next();
                if (wrappedNew.contains(cachedAction)) continue;
                iterator2.remove();
                changed = true;
            }
        }
        return changed;
    }

    @NotNull
    IntentionActionWithTextCaching wrapAction(@NotNull HighlightInfo.IntentionActionDescriptor descriptor2, @Nullable PsiElement element, @Nullable PsiFile containingFile, @Nullable Editor containingEditor) {
        if (descriptor2 == null) {
            CachedIntentions.$$$reportNull$$$0(20);
        }
        IntentionActionWithTextCaching cachedAction = new IntentionActionWithTextCaching(descriptor2, (cached, action) -> {
            this.removeActionFromCached((IntentionActionWithTextCaching)cached);
            this.markInvoked((IntentionAction)action);
        });
        if (element == null) {
            IntentionActionWithTextCaching intentionActionWithTextCaching = cachedAction;
            if (intentionActionWithTextCaching == null) {
                CachedIntentions.$$$reportNull$$$0(21);
            }
            return intentionActionWithTextCaching;
        }
        List<IntentionAction> options = descriptor2.getOptions(element, containingEditor);
        if (options == null) {
            IntentionActionWithTextCaching intentionActionWithTextCaching = cachedAction;
            if (intentionActionWithTextCaching == null) {
                CachedIntentions.$$$reportNull$$$0(22);
            }
            return intentionActionWithTextCaching;
        }
        for (IntentionAction option : options) {
            boolean isInspectionFix;
            if (containingFile == null || containingEditor == null || this.myEditor == null ? !option.isAvailable(this.myProject, containingEditor, containingFile) && (containingEditor == this.myEditor || !option.isAvailable(this.myProject, this.myEditor, this.myFile)) : !ShowIntentionActionsHandler.availableFor(containingFile, containingEditor, option) && (containingEditor == this.myEditor || !ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, option))) continue;
            IntentionActionWithTextCaching textCaching = new IntentionActionWithTextCaching(option);
            boolean isErrorFix = this.myErrorFixes.contains(textCaching);
            if (isErrorFix) {
                cachedAction.addErrorFix(option);
            }
            if (isInspectionFix = this.myInspectionFixes.contains(textCaching)) {
                cachedAction.addInspectionFix(option);
                continue;
            }
            cachedAction.addIntention(option);
        }
        IntentionActionWithTextCaching intentionActionWithTextCaching = cachedAction;
        if (intentionActionWithTextCaching == null) {
            CachedIntentions.$$$reportNull$$$0(23);
        }
        return intentionActionWithTextCaching;
    }

    private void markInvoked(@NotNull IntentionAction action) {
        if (action == null) {
            CachedIntentions.$$$reportNull$$$0(24);
        }
        if (this.myEditor != null) {
            ShowIntentionsPass.markActionInvoked(this.myFile.getProject(), this.myEditor, action);
        }
    }

    private void removeActionFromCached(@NotNull IntentionActionWithTextCaching action) {
        if (action == null) {
            CachedIntentions.$$$reportNull$$$0(25);
        }
        this.myErrorFixes.remove(action);
        this.myGutters.remove(action);
        this.myInspectionFixes.remove(action);
        this.myIntentions.remove(action);
        this.myNotifications.remove(action);
    }

    @NotNull
    public List<IntentionActionWithTextCaching> getAllActions() {
        List<IntentionActionWithTextCaching> result2 = new ArrayList<IntentionActionWithTextCaching>(this.myErrorFixes);
        result2.addAll(this.myInspectionFixes);
        result2.addAll(this.myIntentions);
        result2.addAll(this.myGutters);
        result2.addAll(this.myNotifications);
        result2 = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(result2);
        Collections.sort(result2, (o1, o2) -> {
            int weight2;
            int weight1 = this.getWeight((IntentionActionWithTextCaching)o1);
            if (weight1 != (weight2 = this.getWeight((IntentionActionWithTextCaching)o2))) {
                return weight2 - weight1;
            }
            return o1.compareTo((IntentionActionWithTextCaching)o2);
        });
        List<IntentionActionWithTextCaching> list2 = result2;
        if (list2 == null) {
            CachedIntentions.$$$reportNull$$$0(26);
        }
        return list2;
    }

    private int getWeight(@NotNull IntentionActionWithTextCaching action) {
        if (action == null) {
            CachedIntentions.$$$reportNull$$$0(27);
        }
        IntentionAction a = action.getAction();
        int group = this.getGroup(action).getPriority();
        while (a instanceof IntentionActionDelegate) {
            a = ((IntentionActionDelegate)a).getDelegate();
        }
        if (a instanceof PriorityAction) {
            return group + CachedIntentions.getPriorityWeight(((PriorityAction)a).getPriority());
        }
        if (a instanceof SuppressIntentionActionFromFix && ((SuppressIntentionActionFromFix)a).isShouldBeAppliedToInjectionHost() == ThreeState.NO) {
            return group - 1;
        }
        return group;
    }

    private static int getPriorityWeight(PriorityAction.Priority priority) {
        switch (priority) {
            case HIGH: {
                return 3;
            }
            case LOW: {
                return -3;
            }
        }
        return 0;
    }

    @NotNull
    public IntentionGroup getGroup(@NotNull IntentionActionWithTextCaching action) {
        if (action == null) {
            CachedIntentions.$$$reportNull$$$0(28);
        }
        if (this.myErrorFixes.contains(action)) {
            IntentionGroup intentionGroup = IntentionGroup.ERROR;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(29);
            }
            return intentionGroup;
        }
        if (this.myInspectionFixes.contains(action)) {
            IntentionGroup intentionGroup = IntentionGroup.INSPECTION;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(30);
            }
            return intentionGroup;
        }
        if (this.myNotifications.contains(action)) {
            IntentionGroup intentionGroup = IntentionGroup.NOTIFICATION;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(31);
            }
            return intentionGroup;
        }
        if (this.myGutters.contains(action)) {
            IntentionGroup intentionGroup = IntentionGroup.GUTTER;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(32);
            }
            return intentionGroup;
        }
        if (action.getAction() instanceof EmptyIntentionAction) {
            IntentionGroup intentionGroup = IntentionGroup.EMPTY_ACTION;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(33);
            }
            return intentionGroup;
        }
        IntentionGroup intentionGroup = IntentionGroup.OTHER;
        if (intentionGroup == null) {
            CachedIntentions.$$$reportNull$$$0(34);
        }
        return intentionGroup;
    }

    @NotNull
    public Icon getIcon(@NotNull IntentionActionWithTextCaching value) {
        Icon icon;
        if (value == null) {
            CachedIntentions.$$$reportNull$$$0(35);
        }
        if (value.getIcon() != null) {
            Icon icon2 = value.getIcon();
            if (icon2 == null) {
                CachedIntentions.$$$reportNull$$$0(36);
            }
            return icon2;
        }
        IntentionAction action = value.getAction();
        while (action instanceof IntentionActionDelegate) {
            action = ((IntentionActionDelegate)action).getDelegate();
        }
        IntentionAction iconable = action;
        if (action instanceof QuickFixWrapper) {
            iconable = ((QuickFixWrapper)action).getFix();
        }
        if (iconable instanceof Iconable && (icon = ((Iconable)iconable).getIcon(0)) != null) {
            Icon icon3 = icon;
            if (icon3 == null) {
                CachedIntentions.$$$reportNull$$$0(37);
            }
            return icon3;
        }
        if (IntentionManagerSettings.getInstance().isShowLightBulb(action)) {
            Icon icon4 = this.myErrorFixes.contains(value) ? AllIcons.Actions.QuickfixBulb : (this.myInspectionFixes.contains(value) ? AllIcons.Actions.IntentionBulb : AllIcons.Actions.RealIntentionBulb);
            if (icon4 == null) {
                CachedIntentions.$$$reportNull$$$0(38);
            }
            return icon4;
        }
        Icon icon5 = this.myErrorFixes.contains(value) ? AllIcons.Actions.QuickfixOffBulb : AllIcons.Actions.RealIntentionOffBulb;
        if (icon5 == null) {
            CachedIntentions.$$$reportNull$$$0(39);
        }
        return icon5;
    }

    public boolean showBulb() {
        return ContainerUtil.exists(this.getAllActions(), info -> IntentionManagerSettings.getInstance().isShowLightBulb(info.getAction()));
    }

    public String toString() {
        return "CachedIntentions{myIntentions=" + this.myIntentions + ", myErrorFixes=" + this.myErrorFixes + ", myInspectionFixes=" + this.myInspectionFixes + ", myGutters=" + this.myGutters + ", myNotifications=" + this.myNotifications + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/CachedIntentions";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfo";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDescriptors";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedActions";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/CachedIntentions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorFixes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionFixes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGutters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotifications";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndUpdateActions";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapAction";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllActions";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createAndUpdateActions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "wrapAndUpdateActions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "wrapActionsTo";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "wrapAction";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "markInvoked";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeActionFromCached";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getWeight";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getGroup";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

