/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBListUpdater;
import com.intellij.openapi.ui.ListComponentUpdater;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BackgroundUpdaterTask
extends Task.Backgroundable {
    protected JBPopup myPopup;
    private ListComponentUpdater myUpdater;
    private Ref<UsageView> myUsageView;
    private final Collection<PsiElement> myData;
    private final Alarm myAlarm;
    private final Object lock;
    private volatile boolean myCanceled;
    private volatile boolean myFinished;
    private volatile ProgressIndicator myIndicator;

    @Deprecated
    public BackgroundUpdaterTask(Project project, @NotNull String title) {
        if (title == null) {
            BackgroundUpdaterTask.$$$reportNull$$$0(0);
        }
        this(project, title, null);
    }

    public BackgroundUpdaterTask(@Nullable Project project, @NotNull String title, @Nullable Comparator<PsiElement> comparator2) {
        if (title == null) {
            BackgroundUpdaterTask.$$$reportNull$$$0(1);
        }
        super(project, title);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.lock = new Object();
        this.myData = comparator2 == null ? ContainerUtil.newSmartList() : new TreeSet<PsiElement>(comparator2);
    }

    public ListComponentUpdater getUpdater() {
        return this.myUpdater;
    }

    @Deprecated
    public void init(@NotNull JBPopup popup2, @NotNull Object component, @NotNull Ref<UsageView> usageView) {
        if (popup2 == null) {
            BackgroundUpdaterTask.$$$reportNull$$$0(2);
        }
        if (component == null) {
            BackgroundUpdaterTask.$$$reportNull$$$0(3);
        }
        if (usageView == null) {
            BackgroundUpdaterTask.$$$reportNull$$$0(4);
        }
        if (component instanceof JBList) {
            this.init(popup2, new JBListUpdater((JBList)component), usageView);
        }
    }

    public void init(@NotNull JBPopup popup2, @NotNull ListComponentUpdater updater, @NotNull Ref<UsageView> usageView) {
        if (popup2 == null) {
            BackgroundUpdaterTask.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            BackgroundUpdaterTask.$$$reportNull$$$0(6);
        }
        if (usageView == null) {
            BackgroundUpdaterTask.$$$reportNull$$$0(7);
        }
        this.myPopup = popup2;
        this.myUpdater = updater;
        this.myUsageView = usageView;
    }

    public abstract String getCaption(int var1);

    protected void replaceModel(@NotNull List<PsiElement> data) {
        if (data == null) {
            BackgroundUpdaterTask.$$$reportNull$$$0(8);
        }
        this.myUpdater.replaceModel(data);
    }

    protected void paintBusy(boolean paintBusy) {
        this.myUpdater.paintBusy(paintBusy);
    }

    protected static Comparator<PsiElement> createComparatorWrapper(@NotNull Comparator comparator2) {
        if (comparator2 == null) {
            BackgroundUpdaterTask.$$$reportNull$$$0(9);
        }
        return (o1, o2) -> {
            int diff;
            if (comparator2 == null) {
                BackgroundUpdaterTask.$$$reportNull$$$0(15);
            }
            if ((diff = comparator2.compare(o1, o2)) == 0) {
                return (Integer)ReadAction.compute(() -> PsiUtilCore.compareElementsByPosition((PsiElement)o1, (PsiElement)o2));
            }
            return diff;
        };
    }

    private boolean setCanceled() {
        boolean canceled = this.myCanceled;
        this.myCanceled = true;
        return canceled;
    }

    public boolean isCanceled() {
        return this.myCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateComponent(@NotNull PsiElement element, @Nullable Comparator comparator2) {
        UsageView view;
        if (element == null) {
            BackgroundUpdaterTask.$$$reportNull$$$0(10);
        }
        if ((view = (UsageView)this.myUsageView.get()) != null && !((UsageViewImpl)view).isDisposed()) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (element == null) {
                    BackgroundUpdaterTask.$$$reportNull$$$0(14);
                }
                view.appendUsage((Usage)new UsageInfo2UsageAdapter(new UsageInfo(element)));
            });
            return true;
        }
        if (this.myCanceled) {
            return false;
        }
        JComponent content = this.myPopup.getContent();
        if (this.myPopup instanceof AbstractPopup && content == null || this.myPopup.isDisposed()) {
            return false;
        }
        ModalityState modalityState = content == null ? null : ModalityState.stateForComponent((Component)content);
        Object object = this.lock;
        synchronized (object) {
            if (this.myData.contains(element)) {
                return true;
            }
            this.myData.add(element);
            if (comparator2 != null && this.myData instanceof List) {
                Collections.sort((List)this.myData, comparator2);
            }
        }
        this.myAlarm.addRequest(() -> {
            this.myAlarm.cancelAllRequests();
            this.refreshModelImmediately();
        }, 200, modalityState);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateComponent(@NotNull PsiElement element) {
        UsageView view;
        if (element == null) {
            BackgroundUpdaterTask.$$$reportNull$$$0(11);
        }
        if ((view = (UsageView)this.myUsageView.get()) != null && !((UsageViewImpl)view).isDisposed()) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (element == null) {
                    BackgroundUpdaterTask.$$$reportNull$$$0(13);
                }
                view.appendUsage((Usage)new UsageInfo2UsageAdapter(new UsageInfo(element)));
            });
            return true;
        }
        if (this.myCanceled) {
            return false;
        }
        JComponent content = this.myPopup.getContent();
        if (content == null || this.myPopup.isDisposed()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.myData.add(element)) {
                return true;
            }
        }
        this.myAlarm.addRequest(() -> {
            this.myAlarm.cancelAllRequests();
            this.refreshModelImmediately();
        }, 200, ModalityState.stateForComponent((Component)content));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshModelImmediately() {
        ArrayList<PsiElement> data;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myCanceled) {
            return;
        }
        if (this.myPopup.isDisposed()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            data = new ArrayList<PsiElement>(this.myData);
        }
        this.replaceModel(data);
        this.myPopup.setCaption(this.getCaption(this.getCurrentSize()));
        this.myPopup.pack(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.myData.size();
        }
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            BackgroundUpdaterTask.$$$reportNull$$$0(12);
        }
        this.paintBusy(true);
        this.myIndicator = indicator;
    }

    public void onSuccess() {
        this.myFinished = true;
        this.refreshModelImmediately();
        this.paintBusy(false);
    }

    public void onFinished() {
        this.myAlarm.cancelAllRequests();
        this.myFinished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected PsiElement getTheOnlyOneElement() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myData.size() == 1) {
                return this.myData.iterator().next();
            }
        }
        return null;
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    public boolean cancelTask() {
        ProgressIndicator indicator = this.myIndicator;
        if (indicator != null) {
            indicator.cancel();
        }
        return this.setCanceled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/navigation/BackgroundUpdaterTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createComparatorWrapper";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "updateComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$updateComponent$4";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$updateComponent$2";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createComparatorWrapper$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

