/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ExportableItem;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.MultiStateElementsChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FieldPanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class ChooseComponentsToExportDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(ChooseComponentsToExportDialog.class);
    private final ElementsChooser<ComponentElementProperties> myChooser;
    private final FieldPanel myPathPanel;
    @NonNls
    public static final String DEFAULT_PATH = FileUtil.toSystemDependentName((String)(PathManager.getConfigPath() + "/settings.jar"));
    private final boolean myShowFilePath;
    private final String myDescription;

    public ChooseComponentsToExportDialog(@NotNull Map<Path, List<ExportableItem>> fileToComponents, boolean showFilePath, String title, String description) {
        if (fileToComponents == null) {
            ChooseComponentsToExportDialog.$$$reportNull$$$0(0);
        }
        super(false);
        this.myDescription = description;
        this.myShowFilePath = showFilePath;
        LinkedHashMap<ExportableItem, ComponentElementProperties> componentToContainingListElement = new LinkedHashMap<ExportableItem, ComponentElementProperties>();
        for (List<ExportableItem> list2 : fileToComponents.values()) {
            for (ExportableItem item : list2) {
                if (ChooseComponentsToExportDialog.addToExistingListElement(item, componentToContainingListElement, fileToComponents)) continue;
                ComponentElementProperties componentElementProperties = new ComponentElementProperties();
                componentElementProperties.items.add(item);
                componentToContainingListElement.put(item, componentElementProperties);
            }
        }
        this.myChooser = new ElementsChooser(true);
        this.myChooser.setColorUnmarkedElements(false);
        for (ComponentElementProperties componentElementProperty : new LinkedHashSet(componentToContainingListElement.values())) {
            this.myChooser.addElement(componentElementProperty, true, (MultiStateElementsChooser.ElementProperties)componentElementProperty);
        }
        this.myChooser.sort(Comparator.comparing(ComponentElementProperties::toString));
        ActionListener browseAction = new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ChooseComponentsToExportDialog.chooseSettingsFile(ChooseComponentsToExportDialog.this.myPathPanel.getText(), ChooseComponentsToExportDialog.this.getWindow(), IdeBundle.message((String)"title.export.file.location", (Object[])new Object[0]), IdeBundle.message((String)"prompt.choose.export.settings.file.path", (Object[])new Object[0])).onSuccess(path -> ChooseComponentsToExportDialog.this.myPathPanel.setText(FileUtil.toSystemDependentName((String)path)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/configurationStore/ChooseComponentsToExportDialog$1", "actionPerformed"));
            }
        };
        this.myPathPanel = new FieldPanel(IdeBundle.message((String)"editbox.export.settings.to", (Object[])new Object[0]), null, browseAction, null);
        String exportPath = PropertiesComponent.getInstance().getValue("export.settings.path", DEFAULT_PATH);
        this.myPathPanel.setText(exportPath);
        this.myPathPanel.setChangeListener(this::updateControls);
        this.updateControls();
        this.setTitle(title);
        this.init();
    }

    private void updateControls() {
        this.setOKActionEnabled(!StringUtil.isEmptyOrSpaces((String)this.myPathPanel.getText()));
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        AbstractAction selectAll = new AbstractAction("Select &All"){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ChooseComponentsToExportDialog.this.myChooser.setAllElementsMarked(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/configurationStore/ChooseComponentsToExportDialog$2", "actionPerformed"));
            }
        };
        AbstractAction selectNone = new AbstractAction("Select &None"){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ChooseComponentsToExportDialog.this.myChooser.setAllElementsMarked(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/configurationStore/ChooseComponentsToExportDialog$3", "actionPerformed"));
            }
        };
        AbstractAction invert = new AbstractAction("&Invert"){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                ChooseComponentsToExportDialog.this.myChooser.invertSelection();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/configurationStore/ChooseComponentsToExportDialog$4", "actionPerformed"));
            }
        };
        Action[] actionArray = new Action[]{selectAll, selectNone, invert};
        if (actionArray == null) {
            ChooseComponentsToExportDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    protected void doOKAction() {
        PropertiesComponent.getInstance().setValue("export.settings.path", this.myPathPanel.getText(), DEFAULT_PATH);
        super.doOKAction();
    }

    private static boolean addToExistingListElement(@NotNull ExportableItem item, @NotNull Map<ExportableItem, ComponentElementProperties> itemToContainingListElement, @NotNull Map<Path, List<ExportableItem>> fileToItem) {
        List<ExportableItem> list2;
        if (item == null) {
            ChooseComponentsToExportDialog.$$$reportNull$$$0(2);
        }
        if (itemToContainingListElement == null) {
            ChooseComponentsToExportDialog.$$$reportNull$$$0(3);
        }
        if (fileToItem == null) {
            ChooseComponentsToExportDialog.$$$reportNull$$$0(4);
        }
        if (ContainerUtil.isEmpty(list2 = fileToItem.get(item.getFile()))) {
            return false;
        }
        Path file2 = null;
        for (ExportableItem tiedItem : list2) {
            ComponentElementProperties elementProperties;
            if (tiedItem == item || (elementProperties = itemToContainingListElement.get(tiedItem)) == null || item.getFile() == file2) continue;
            LOG.assertTrue(file2 == null, (Object)("Component " + item + " serialize itself into " + file2 + " and " + item.getFile()));
            elementProperties.items.add(item);
            itemToContainingListElement.put(item, elementProperties);
            file2 = item.getFile();
        }
        return file2 != null;
    }

    @NotNull
    public static Promise<String> chooseSettingsFile(String oldPath, Component parent, String title, String description) {
        VirtualFile initialDir;
        FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        chooserDescriptor.setDescription(description);
        chooserDescriptor.setHideIgnored(false);
        chooserDescriptor.setTitle(title);
        if (oldPath != null) {
            File oldFile = new File(oldPath);
            initialDir = LocalFileSystem.getInstance().findFileByIoFile(oldFile);
            if (initialDir == null && oldFile.getParentFile() != null) {
                initialDir = LocalFileSystem.getInstance().findFileByIoFile(oldFile.getParentFile());
            }
        } else {
            initialDir = null;
        }
        final AsyncPromise result2 = new AsyncPromise();
        FileChooser.chooseFiles((FileChooserDescriptor)chooserDescriptor, null, (Component)parent, (VirtualFile)initialDir, (Consumer)new FileChooser.FileChooserConsumer(){

            public void consume(List<VirtualFile> files2) {
                VirtualFile file2 = files2.get(0);
                if (file2.isDirectory()) {
                    result2.setResult((Object)(file2.getPath() + '/' + new File(DEFAULT_PATH).getName()));
                } else {
                    result2.setResult((Object)file2.getPath());
                }
            }

            public void cancelled() {
                result2.setError("");
            }
        });
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            ChooseComponentsToExportDialog.$$$reportNull$$$0(5);
        }
        return asyncPromise;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPathPanel.getTextField();
    }

    protected JComponent createNorthPanel() {
        return new JLabel(this.myDescription);
    }

    protected JComponent createCenterPanel() {
        return this.myChooser;
    }

    protected JComponent createSouthPanel() {
        JComponent buttons = super.createSouthPanel();
        if (!this.myShowFilePath) {
            return buttons;
        }
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel2.add((Component)this.myPathPanel);
        panel2.add(buttons);
        return panel2;
    }

    Set<ExportableItem> getExportableComponents() {
        THashSet components = new THashSet();
        for (ComponentElementProperties elementProperties : this.myChooser.getMarkedElements()) {
            components.addAll(elementProperties.items);
        }
        return components;
    }

    @NotNull
    Path getExportFile() {
        Path path = Paths.get(this.myPathPanel.getText(), new String[0]);
        if (path == null) {
            ChooseComponentsToExportDialog.$$$reportNull$$$0(6);
        }
        return path;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.actions.ChooseComponentsToExportDialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToComponents";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/configurationStore/ChooseComponentsToExportDialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemToContainingListElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/configurationStore/ChooseComponentsToExportDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseSettingsFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addToExistingListElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ComponentElementProperties
    implements MultiStateElementsChooser.ElementProperties {
        private final Set<ExportableItem> items = new THashSet();

        private ComponentElementProperties() {
        }

        public String toString() {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            for (ExportableItem component : this.items) {
                names.add(component.getPresentableName());
            }
            return StringUtil.join((String[])ArrayUtil.toStringArray(names), (String)", ");
        }
    }
}

