/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.KdbxHeaderKt;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002>?B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00112\u0006\u00104\u001a\u000202J\u0016\u00105\u001a\u0002062\u0006\u00103\u001a\u00020\u00112\u0006\u00107\u001a\u000206J\u000e\u0010\b\u001a\u0002082\u0006\u00109\u001a\u00020\u0011J\u000e\u0010\u000e\u001a\u0002082\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u0002082\u0006\u0010=\u001a\u00020;R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R$\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u001c@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0013\"\u0004\b$\u0010\u0015R\u001a\u0010%\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0013\"\u0004\b'\u0010\u0015R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0013\"\u0004\b0\u0010\u0015\u00a8\u0006@"}, d2={"Lcom/intellij/credentialStore/kdbx/KdbxHeader;", "", "()V", "<set-?>", "Ljava/util/UUID;", "cipherUuid", "getCipherUuid", "()Ljava/util/UUID;", "setCipherUuid", "(Ljava/util/UUID;)V", "Lcom/intellij/credentialStore/kdbx/KdbxHeader$CompressionFlags;", "compressionFlags", "getCompressionFlags", "()Lcom/intellij/credentialStore/kdbx/KdbxHeader$CompressionFlags;", "setCompressionFlags", "(Lcom/intellij/credentialStore/kdbx/KdbxHeader$CompressionFlags;)V", "encryptionIv", "", "getEncryptionIv", "()[B", "setEncryptionIv", "([B)V", "headerHash", "getHeaderHash", "setHeaderHash", "masterSeed", "getMasterSeed", "setMasterSeed", "Lcom/intellij/credentialStore/kdbx/KdbxHeader$ProtectedStreamAlgorithm;", "protectedStreamAlgorithm", "getProtectedStreamAlgorithm", "()Lcom/intellij/credentialStore/kdbx/KdbxHeader$ProtectedStreamAlgorithm;", "setProtectedStreamAlgorithm", "(Lcom/intellij/credentialStore/kdbx/KdbxHeader$ProtectedStreamAlgorithm;)V", "protectedStreamKey", "getProtectedStreamKey", "setProtectedStreamKey", "streamStartBytes", "getStreamStartBytes", "setStreamStartBytes", "transformRounds", "", "getTransformRounds", "()J", "setTransformRounds", "(J)V", "transformSeed", "getTransformSeed", "setTransformSeed", "createDecryptedStream", "Ljava/io/InputStream;", "digest", "inputStream", "createEncryptedStream", "Ljava/io/OutputStream;", "outputStream", "", "uuid", "flags", "", "setInnerRandomStreamId", "innerRandomStreamId", "CompressionFlags", "ProtectedStreamAlgorithm", "intellij.platform.credentialStore"})
public final class KdbxHeader {
    @NotNull
    private UUID cipherUuid;
    @NotNull
    private CompressionFlags compressionFlags;
    @NotNull
    private byte[] masterSeed;
    @NotNull
    private byte[] transformSeed;
    private long transformRounds;
    @NotNull
    private byte[] encryptionIv;
    @NotNull
    private byte[] protectedStreamKey;
    @NotNull
    private ProtectedStreamAlgorithm protectedStreamAlgorithm;
    @NotNull
    private byte[] streamStartBytes;
    @Nullable
    private byte[] headerHash;

    @NotNull
    public final UUID getCipherUuid() {
        return this.cipherUuid;
    }

    private final void setCipherUuid(UUID uUID) {
        this.cipherUuid = uUID;
    }

    @NotNull
    public final CompressionFlags getCompressionFlags() {
        return this.compressionFlags;
    }

    private final void setCompressionFlags(CompressionFlags compressionFlags) {
        this.compressionFlags = compressionFlags;
    }

    @NotNull
    public final byte[] getMasterSeed() {
        return this.masterSeed;
    }

    public final void setMasterSeed(@NotNull byte[] byArray) {
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"<set-?>");
        this.masterSeed = byArray;
    }

    @NotNull
    public final byte[] getTransformSeed() {
        return this.transformSeed;
    }

    public final void setTransformSeed(@NotNull byte[] byArray) {
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"<set-?>");
        this.transformSeed = byArray;
    }

    public final long getTransformRounds() {
        return this.transformRounds;
    }

    public final void setTransformRounds(long l) {
        this.transformRounds = l;
    }

    @NotNull
    public final byte[] getEncryptionIv() {
        return this.encryptionIv;
    }

    public final void setEncryptionIv(@NotNull byte[] byArray) {
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"<set-?>");
        this.encryptionIv = byArray;
    }

    @NotNull
    public final byte[] getProtectedStreamKey() {
        return this.protectedStreamKey;
    }

    public final void setProtectedStreamKey(@NotNull byte[] byArray) {
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"<set-?>");
        this.protectedStreamKey = byArray;
    }

    @NotNull
    public final ProtectedStreamAlgorithm getProtectedStreamAlgorithm() {
        return this.protectedStreamAlgorithm;
    }

    private final void setProtectedStreamAlgorithm(ProtectedStreamAlgorithm protectedStreamAlgorithm) {
        this.protectedStreamAlgorithm = protectedStreamAlgorithm;
    }

    @NotNull
    public final byte[] getStreamStartBytes() {
        return this.streamStartBytes;
    }

    public final void setStreamStartBytes(@NotNull byte[] byArray) {
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"<set-?>");
        this.streamStartBytes = byArray;
    }

    @Nullable
    public final byte[] getHeaderHash() {
        return this.headerHash;
    }

    public final void setHeaderHash(@Nullable byte[] byArray) {
        this.headerHash = byArray;
    }

    @NotNull
    public final InputStream createDecryptedStream(@NotNull byte[] digest, @NotNull InputStream inputStream) {
        Intrinsics.checkParameterIsNotNull((Object)digest, (String)"digest");
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        byte[] finalKeyDigest = KdbxHeaderKt.access$getFinalKeyDigest(digest, this.masterSeed, this.transformSeed, this.transformRounds);
        return KdbxHeaderKt.access$getDecryptedInputStream(inputStream, finalKeyDigest, this.encryptionIv);
    }

    @NotNull
    public final OutputStream createEncryptedStream(@NotNull byte[] digest, @NotNull OutputStream outputStream) {
        Intrinsics.checkParameterIsNotNull((Object)digest, (String)"digest");
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        byte[] finalKeyDigest = KdbxHeaderKt.access$getFinalKeyDigest(digest, this.masterSeed, this.transformSeed, this.transformRounds);
        return KdbxHeaderKt.access$getEncryptedOutputStream(outputStream, finalKeyDigest, this.encryptionIv);
    }

    public final void setCipherUuid(@NotNull byte[] uuid) {
        ByteBuffer b;
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        ByteBuffer byteBuffer = b = ByteBuffer.wrap(uuid);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"b");
        UUID incoming = new UUID(byteBuffer.getLong(), b.getLong(8));
        if (Intrinsics.areEqual((Object)incoming, (Object)KdbxHeaderKt.access$getAES_CIPHER$p()) ^ true) {
            throw (Throwable)new IllegalStateException("Unknown Cipher UUID " + incoming);
        }
        this.cipherUuid = incoming;
    }

    public final void setCompressionFlags(int flags) {
        this.compressionFlags = CompressionFlags.values()[flags];
    }

    public final void setInnerRandomStreamId(int innerRandomStreamId) {
        this.protectedStreamAlgorithm = ProtectedStreamAlgorithm.values()[innerRandomStreamId];
    }

    public KdbxHeader() {
        UUID uUID = KdbxHeaderKt.access$getAES_CIPHER$p();
        if (uUID == null) {
            Intrinsics.throwNpe();
        }
        this.cipherUuid = uUID;
        this.compressionFlags = CompressionFlags.GZIP;
        this.transformRounds = 6000L;
        this.protectedStreamAlgorithm = ProtectedStreamAlgorithm.SALSA_20;
        this.streamStartBytes = new byte[32];
        SecureRandom random = new SecureRandom();
        byte[] byArray = random.generateSeed(32);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"random.generateSeed(32)");
        this.masterSeed = byArray;
        byte[] byArray2 = random.generateSeed(32);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"random.generateSeed(32)");
        this.transformSeed = byArray2;
        byte[] byArray3 = random.generateSeed(16);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"random.generateSeed(16)");
        this.encryptionIv = byArray3;
        byte[] byArray4 = random.generateSeed(32);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"random.generateSeed(32)");
        this.protectedStreamKey = byArray4;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/credentialStore/kdbx/KdbxHeader$CompressionFlags;", "", "(Ljava/lang/String;I)V", "NONE", "GZIP", "intellij.platform.credentialStore"})
    public static final class CompressionFlags
    extends Enum<CompressionFlags> {
        public static final /* enum */ CompressionFlags NONE;
        public static final /* enum */ CompressionFlags GZIP;
        private static final /* synthetic */ CompressionFlags[] $VALUES;

        static {
            CompressionFlags[] compressionFlagsArray = new CompressionFlags[2];
            CompressionFlags[] compressionFlagsArray2 = compressionFlagsArray;
            compressionFlagsArray[0] = NONE = new CompressionFlags();
            compressionFlagsArray[1] = GZIP = new CompressionFlags();
            $VALUES = compressionFlagsArray;
        }

        public static CompressionFlags[] values() {
            return (CompressionFlags[])$VALUES.clone();
        }

        public static CompressionFlags valueOf(String string) {
            return Enum.valueOf(CompressionFlags.class, string);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/credentialStore/kdbx/KdbxHeader$ProtectedStreamAlgorithm;", "", "(Ljava/lang/String;I)V", "NONE", "ARC_FOUR", "SALSA_20", "intellij.platform.credentialStore"})
    public static final class ProtectedStreamAlgorithm
    extends Enum<ProtectedStreamAlgorithm> {
        public static final /* enum */ ProtectedStreamAlgorithm NONE;
        public static final /* enum */ ProtectedStreamAlgorithm ARC_FOUR;
        public static final /* enum */ ProtectedStreamAlgorithm SALSA_20;
        private static final /* synthetic */ ProtectedStreamAlgorithm[] $VALUES;

        static {
            ProtectedStreamAlgorithm[] protectedStreamAlgorithmArray = new ProtectedStreamAlgorithm[3];
            ProtectedStreamAlgorithm[] protectedStreamAlgorithmArray2 = protectedStreamAlgorithmArray;
            protectedStreamAlgorithmArray[0] = NONE = new ProtectedStreamAlgorithm();
            protectedStreamAlgorithmArray[1] = ARC_FOUR = new ProtectedStreamAlgorithm();
            protectedStreamAlgorithmArray[2] = SALSA_20 = new ProtectedStreamAlgorithm();
            $VALUES = protectedStreamAlgorithmArray;
        }

        public static ProtectedStreamAlgorithm[] values() {
            return (ProtectedStreamAlgorithm[])$VALUES.clone();
        }

        public static ProtectedStreamAlgorithm valueOf(String string) {
            return Enum.valueOf(ProtectedStreamAlgorithm.class, string);
        }
    }
}

