/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class AttachmentFactory {
    private static final Logger LOG = Logger.getInstance(AttachmentFactory.class);
    private static final long BIG_FILE_THRESHOLD_BYTES = 51200L;

    public static Attachment createContext(@NotNull Object start, Object ... more) {
        if (start == null) {
            AttachmentFactory.$$$reportNull$$$0(0);
        }
        StringBuilder builder2 = new StringBuilder(String.valueOf(start));
        for (Object o : more) {
            builder2.append(",").append(o);
        }
        return new Attachment("current-context.txt", builder2.length() > 0 ? builder2.toString() : "(unknown)");
    }

    public static Attachment createAttachment(@NotNull Document document) {
        VirtualFile file2;
        if (document == null) {
            AttachmentFactory.$$$reportNull$$$0(1);
        }
        return new Attachment((file2 = FileDocumentManager.getInstance().getFile(document)) != null ? file2.getPath() : "unknown.txt", document.getText());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Attachment createAttachment(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AttachmentFactory.$$$reportNull$$$0(2);
        }
        try (InputStream inputStream = file2.getInputStream();){
            Attachment attachment = AttachmentFactory.createAttachment(file2.getPresentableUrl(), inputStream, file2.getLength(), file2.getFileType().isBinary());
            return attachment;
        }
        catch (IOException e) {
            return AttachmentFactory.handleException(e, file2.getPath());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Attachment createAttachment(@NotNull File file2, boolean isBinary) {
        if (file2 == null) {
            AttachmentFactory.$$$reportNull$$$0(3);
        }
        try (FileInputStream inputStream = new FileInputStream(file2);){
            Attachment attachment = AttachmentFactory.createAttachment(file2.getPath(), inputStream, file2.length(), isBinary);
            return attachment;
        }
        catch (IOException e) {
            return AttachmentFactory.handleException(e, file2.getPath());
        }
    }

    private static Attachment handleException(Throwable t, String path) {
        LOG.warn("failed to create an attachment from " + path, t);
        return new Attachment(path, t);
    }

    private static Attachment createAttachment(String path, InputStream content, long contentLength, boolean isBinary) throws IOException {
        if (contentLength >= 51200L) {
            File tempFile = FileUtil.createTempFile((String)("ij-attachment-" + PathUtilRt.getFileName((String)path) + "."), (String)(isBinary ? ".bin" : ".txt"), (boolean)true);
            try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                FileUtil.copy((InputStream)content, (long)contentLength, (OutputStream)outputStream);
            }
            return new Attachment(path, tempFile, "[File is too big to display]");
        }
        byte[] bytes = FileUtil.loadBytes((InputStream)content);
        String displayText = isBinary ? "[File is binary]" : new String(bytes, CharsetToolkit.UTF8_CHARSET);
        return new Attachment(path, bytes, displayText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/AttachmentFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createAttachment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

