/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.diagnostic.IdeaReportingEvent;
import com.intellij.diagnostic.LogMessage;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LogMessageEx
extends LogMessage {
    public LogMessageEx(IdeaLoggingEvent event, String title, String notificationText) {
        super(event.getThrowable(), event.getMessage(), LogMessageEx.attachments(event));
    }

    LogMessageEx(Throwable throwable, String message, List<Attachment> attachments, String notificationText) {
        super(throwable, message, attachments);
    }

    private static List<Attachment> attachments(IdeaLoggingEvent event) {
        Object data = event.getData();
        return data instanceof AbstractMessage ? ((AbstractMessage)data).getAllAttachments() : Collections.emptyList();
    }

    public static IdeaLoggingEvent createEvent(String message, String details, Attachment ... attachments) {
        return LogMessageEx.createEvent(new IdeaReportingEvent.TextBasedThrowable(details), message, attachments);
    }

    public static IdeaLoggingEvent createEvent(String message, String details, String title, String notificationText, Attachment attachment) {
        return LogMessageEx.createEvent(new IdeaReportingEvent.TextBasedThrowable(details), message, attachment);
    }

    public static IdeaLoggingEvent createEvent(String message, String details, String title, String notificationText, Collection<Attachment> attachments) {
        Attachment[] array = attachments != null ? attachments.toArray(Attachment.EMPTY_ARRAY) : Attachment.EMPTY_ARRAY;
        return LogMessageEx.createEvent(new IdeaReportingEvent.TextBasedThrowable(details), message, array);
    }

    public static void error(@NotNull Logger logger, @NotNull String message, String ... attachmentText) {
        if (logger == null) {
            LogMessageEx.$$$reportNull$$$0(0);
        }
        if (message == null) {
            LogMessageEx.$$$reportNull$$$0(1);
        }
        if (attachmentText == null) {
            LogMessageEx.$$$reportNull$$$0(2);
        }
        LogMessageEx.error(logger, message, new Throwable(), attachmentText);
    }

    public static void error(Logger logger, String message, Throwable cause, String ... attachmentText) {
        StringBuilder detailsBuffer = new StringBuilder();
        for (String detail : attachmentText) {
            detailsBuffer.append(detail).append(",");
        }
        if (attachmentText.length > 0 && detailsBuffer.length() > 0) {
            detailsBuffer.setLength(detailsBuffer.length() - 1);
        }
        if (detailsBuffer.length() > 0) {
            logger.error(message, cause, new Attachment[]{AttachmentFactory.createContext(detailsBuffer, new Object[0])});
        } else {
            logger.error(message, cause);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "logger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "message";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "attachmentText";
                break;
            }
        }
        objectArray[1] = "com/intellij/diagnostic/LogMessageEx";
        objectArray[2] = "error";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

