/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentInside {
    public int whiteSpaces = 0;
    public int tabs = 0;

    public IndentInside() {
    }

    public IndentInside(int whiteSpaces, int tabs2) {
        this.whiteSpaces = whiteSpaces;
        this.tabs = tabs2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndentInside indent = (IndentInside)o;
        if (this.tabs != indent.tabs) {
            return false;
        }
        return this.whiteSpaces == indent.whiteSpaces;
    }

    public int hashCode() {
        int result2 = this.whiteSpaces;
        result2 = 29 * result2 + this.tabs;
        return result2;
    }

    public int getTabsCount(CommonCodeStyleSettings.IndentOptions options) {
        int tabsFromSpaces = this.whiteSpaces / options.TAB_SIZE;
        return this.tabs + tabsFromSpaces;
    }

    public int getSpacesCount(CommonCodeStyleSettings.IndentOptions options) {
        return this.whiteSpaces + this.tabs * options.TAB_SIZE;
    }

    @NotNull
    static IndentInside getLastLineIndent(@NotNull CharSequence text2) {
        if (text2 == null) {
            IndentInside.$$$reportNull$$$0(0);
        }
        CharSequence lastLine = IndentInside.getLastLine(text2);
        IndentInside indentInside = IndentInside.createIndentOn(lastLine);
        if (indentInside == null) {
            IndentInside.$$$reportNull$$$0(1);
        }
        return indentInside;
    }

    @NotNull
    public static IndentInside createIndentOn(@Nullable CharSequence lastLine) {
        IndentInside result2 = new IndentInside();
        if (lastLine == null) {
            IndentInside indentInside = result2;
            if (indentInside == null) {
                IndentInside.$$$reportNull$$$0(2);
            }
            return indentInside;
        }
        for (int i = 0; i < lastLine.length(); ++i) {
            if (lastLine.charAt(i) == ' ') {
                ++result2.whiteSpaces;
            }
            if (lastLine.charAt(i) != '\t') continue;
            ++result2.tabs;
        }
        IndentInside indentInside = result2;
        if (indentInside == null) {
            IndentInside.$$$reportNull$$$0(3);
        }
        return indentInside;
    }

    @NotNull
    public static CharSequence getLastLine(@NotNull CharSequence text2) {
        int i;
        if (text2 == null) {
            IndentInside.$$$reportNull$$$0(4);
        }
        if ((i = CharArrayUtil.shiftBackwardUntil((CharSequence)text2, (int)(text2.length() - 1), (String)"\n")) < 0) {
            CharSequence charSequence = text2;
            if (charSequence == null) {
                IndentInside.$$$reportNull$$$0(5);
            }
            return charSequence;
        }
        if (i >= text2.length() - 1) {
            if ("" == null) {
                IndentInside.$$$reportNull$$$0(6);
            }
            return "";
        }
        CharSequence charSequence = text2.subSequence(i + 1, text2.length());
        if (charSequence == null) {
            IndentInside.$$$reportNull$$$0(7);
        }
        return charSequence;
    }

    public String toString() {
        return String.format("spaces: %d, tabs: %d", this.whiteSpaces, this.tabs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/IndentInside";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/IndentInside";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastLineIndent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndentOn";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLastLineIndent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLastLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

