/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.json.JsonBundle;
import com.intellij.json.JsonDialectUtil;
import com.intellij.json.codeinsight.JsonLiteralChecker;
import com.intellij.psi.PsiElement;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class StandardJsonLiteralChecker
implements JsonLiteralChecker {
    public static final Pattern VALID_ESCAPE = Pattern.compile("\\\\([\"\\\\/bfnrt]|u[0-9a-fA-F]{4})");
    private static final Pattern VALID_NUMBER_LITERAL = Pattern.compile("-?(0|[1-9][0-9]*)(\\.[0-9]+)?([eE][+-]?[0-9]+)?");
    public static final String INF = "Infinity";
    public static final String MINUS_INF = "-Infinity";
    public static final String NAN = "NaN";

    @Override
    @Nullable
    public String getErrorForNumericLiteral(String literalText) {
        if (!(INF.equals(literalText) || MINUS_INF.equals(literalText) || NAN.equals(literalText) || VALID_NUMBER_LITERAL.matcher(literalText).matches())) {
            return JsonBundle.message("syntax.error.illegal.floating.point.literal", new Object[0]);
        }
        return null;
    }

    @Override
    @Nullable
    public String getErrorForStringFragment(String fragmentText) {
        return StandardJsonLiteralChecker.getStringError(fragmentText);
    }

    @Nullable
    public static String getStringError(String fragmentText) {
        if (fragmentText.startsWith("\\") && fragmentText.length() > 1 && !VALID_ESCAPE.matcher(fragmentText).matches()) {
            if (fragmentText.startsWith("\\u")) {
                return JsonBundle.message("syntax.error.illegal.unicode.escape.sequence", new Object[0]);
            }
            return JsonBundle.message("syntax.error.illegal.escape.sequence", new Object[0]);
        }
        return null;
    }

    @Override
    public boolean isApplicable(PsiElement element) {
        return JsonDialectUtil.isStandardJson(element);
    }
}

