/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class TextComponentDocument
extends UserDataHolderBase
implements Document {
    private final JTextComponent myTextComponent;

    public TextComponentDocument(JTextComponent textComponent) {
        this.myTextComponent = textComponent;
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        String string;
        try {
            javax.swing.text.Document document = this.myTextComponent.getDocument();
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            TextComponentDocument.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText(@NotNull TextRange range2) {
        String string;
        if (range2 == null) {
            TextComponentDocument.$$$reportNull$$$0(1);
        }
        try {
            javax.swing.text.Document document = this.myTextComponent.getDocument();
            string = document.getText(range2.getStartOffset(), range2.getLength());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            TextComponentDocument.$$$reportNull$$$0(2);
        }
        return string;
    }

    public int getTextLength() {
        return this.myTextComponent.getDocument().getLength();
    }

    public int getLineCount() {
        return 1;
    }

    public int getLineNumber(int offset) {
        return 0;
    }

    public int getLineStartOffset(int line) {
        return 0;
    }

    public int getLineEndOffset(int line) {
        return this.getTextLength();
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            TextComponentDocument.$$$reportNull$$$0(3);
        }
        try {
            this.myTextComponent.getDocument().insertString(offset, s.toString(), null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteString(int startOffset, int endOffset) {
        try {
            this.myTextComponent.getDocument().remove(startOffset, endOffset - startOffset);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            TextComponentDocument.$$$reportNull$$$0(4);
        }
        javax.swing.text.Document document = this.myTextComponent.getDocument();
        try {
            document.remove(startOffset, endOffset - startOffset);
            document.insertString(startOffset, s.toString(), null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isWritable() {
        return true;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            TextComponentDocument.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getModificationStamp() {
        throw new UnsupportedOperationException("Not implemented");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/textarea/TextComponentDocument";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmutableCharSequence";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/textarea/TextComponentDocument";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "insertString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

