/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.file.exclude.ProjectPlainTextFileTypeManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnforcedPlainTextFileTypeManager
implements ProjectManagerListener {
    private final Map<Project, Collection<VirtualFile>> myPlainTextFileSets = ContainerUtil.createConcurrentWeakMap();
    private volatile boolean mySetsInitialized;
    private final Object LOCK = new Object();

    public EnforcedPlainTextFileTypeManager() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMarkedAsPlainText(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(0);
        }
        if (!(file2 instanceof VirtualFileWithId) || file2.isDirectory()) {
            return false;
        }
        if (!this.mySetsInitialized) {
            Iterator<Collection<VirtualFile>> iterator = this.LOCK;
            synchronized (iterator) {
                if (!this.mySetsInitialized) {
                    this.initPlainTextFileSets();
                    this.mySetsInitialized = true;
                }
            }
        }
        if (!this.myPlainTextFileSets.isEmpty()) {
            for (Collection<VirtualFile> projectSet : this.myPlainTextFileSets.values()) {
                if (projectSet == null || !projectSet.contains(file2)) continue;
                return true;
            }
        }
        return false;
    }

    private void initPlainTextFileSets() {
        Project[] openProjects;
        for (Project openProject : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            this.addProjectPlainTextFiles(openProject);
        }
    }

    public static boolean isApplicableFor(@Nullable VirtualFile file2) {
        if (!(file2 instanceof VirtualFileWithId) || file2.isDirectory()) {
            return false;
        }
        if (ScratchUtil.isScratch(file2)) {
            return false;
        }
        FileType originalType = FileTypeManager.getInstance().getFileTypeByFileName(file2.getName());
        return !originalType.isBinary() && originalType != FileTypes.PLAIN_TEXT && originalType != StdFileTypes.JAVA;
    }

    public void markAsPlainText(@NotNull Project project, VirtualFile ... files2) {
        if (project == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(2);
        }
        this.setPlainTextStatus(project, true, files2);
    }

    public void resetOriginalFileType(@NotNull Project project, VirtualFile ... files2) {
        if (project == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(3);
        }
        if (files2 == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(4);
        }
        this.setPlainTextStatus(project, false, files2);
    }

    private void setPlainTextStatus(@NotNull Project project, boolean isAdded, VirtualFile ... files2) {
        if (project == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(5);
        }
        if (files2 == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(10);
            }
            if (files2 == null) {
                EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(11);
            }
            ProjectPlainTextFileTypeManager projectManager2 = ProjectPlainTextFileTypeManager.getInstance(project);
            for (VirtualFile file2 : files2) {
                if (!projectManager2.isInContent(file2) && !projectManager2.isInLibrarySource(file2)) continue;
                this.ensureProjectFileSetAdded(project, projectManager2);
                if (!(isAdded ? projectManager2.addFile(file2) : projectManager2.removeFile(file2))) continue;
                FileBasedIndex.getInstance().requestReindex(file2);
            }
            FileContentUtilCore.reparseFiles((VirtualFile[])files2);
        });
    }

    private void ensureProjectFileSetAdded(@NotNull Project project, @NotNull ProjectPlainTextFileTypeManager projectPlainTextFileTypeManager) {
        if (project == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(7);
        }
        if (projectPlainTextFileTypeManager == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(8);
        }
        if (!this.myPlainTextFileSets.containsKey(project)) {
            this.myPlainTextFileSets.put(project, projectPlainTextFileTypeManager.getFiles());
        }
    }

    public static EnforcedPlainTextFileTypeManager getInstance() {
        return (EnforcedPlainTextFileTypeManager)ServiceManager.getService(EnforcedPlainTextFileTypeManager.class);
    }

    public void projectOpened(Project project) {
        this.addProjectPlainTextFiles(project);
    }

    public void projectClosed(Project project) {
        this.myPlainTextFileSets.remove(project);
    }

    private void addProjectPlainTextFiles(@NotNull Project project) {
        ProjectPlainTextFileTypeManager projectPlainTextFileTypeManager;
        if (project == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(9);
        }
        if (!project.isDisposed() && (projectPlainTextFileTypeManager = ProjectPlainTextFileTypeManager.getInstance(project)) != null) {
            this.myPlainTextFileSets.put(project, projectPlainTextFileTypeManager.getFiles());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPlainTextFileTypeManager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/file/exclude/EnforcedPlainTextFileTypeManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isMarkedAsPlainText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "markAsPlainText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "resetOriginalFileType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setPlainTextStatus";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureProjectFileSetAdded";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addProjectPlainTextFiles";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$setPlainTextStatus$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

