/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListsIndexes;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.changes.ui.PlusMinusModify;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListWorker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeListWorker");
    @NotNull
    private final Project myProject;
    @NotNull
    private final DelayedNotificator myDelayedNotificator;
    private final boolean myMainWorker;
    private final Set<ListData> myLists;
    private ListData myDefault;
    private final Map<Change, ListData> myChangeMappings;
    private final Map<FilePath, PartialChangeTracker> myPartialChangeTrackers;
    private final ChangeListsIndexes myIdx;
    @Nullable
    private Map<ListData, Set<Change>> myReadOnlyChangesCache;
    private final AtomicBoolean myReadOnlyChangesCacheInvalidated;

    public ChangeListWorker(@NotNull Project project, @NotNull DelayedNotificator delayedNotificator) {
        if (project == null) {
            ChangeListWorker.$$$reportNull$$$0(0);
        }
        if (delayedNotificator == null) {
            ChangeListWorker.$$$reportNull$$$0(1);
        }
        this.myLists = new HashSet<ListData>();
        this.myChangeMappings = new HashMap<Change, ListData>();
        this.myPartialChangeTrackers = new HashMap<FilePath, PartialChangeTracker>();
        this.myReadOnlyChangesCache = null;
        this.myReadOnlyChangesCacheInvalidated = new AtomicBoolean(false);
        this.myProject = project;
        this.myDelayedNotificator = delayedNotificator;
        this.myMainWorker = true;
        this.myIdx = new ChangeListsIndexes();
        this.ensureDefaultListExists();
    }

    private ChangeListWorker(@NotNull ChangeListWorker worker) {
        if (worker == null) {
            ChangeListWorker.$$$reportNull$$$0(2);
        }
        this.myLists = new HashSet<ListData>();
        this.myChangeMappings = new HashMap<Change, ListData>();
        this.myPartialChangeTrackers = new HashMap<FilePath, PartialChangeTracker>();
        this.myReadOnlyChangesCache = null;
        this.myReadOnlyChangesCacheInvalidated = new AtomicBoolean(false);
        this.myProject = worker.myProject;
        this.myDelayedNotificator = worker.myDelayedNotificator;
        this.myMainWorker = false;
        this.myIdx = new ChangeListsIndexes(worker.myIdx);
        Map<ListData, ListData> listMapping = this.copyListsDataFrom(worker.myLists);
        worker.myChangeMappings.forEach((change, oldList) -> {
            ListData newList = this.notNullList((ListData)listMapping.get(oldList));
            this.myChangeMappings.put((Change)change, newList);
        });
        for (Map.Entry<FilePath, PartialChangeTracker> entry : worker.myPartialChangeTrackers.entrySet()) {
            this.myPartialChangeTrackers.put(entry.getKey(), new PartialChangeTrackerDump(entry.getValue(), this.myDefault));
        }
    }

    @NotNull
    private Map<ListData, ListData> copyListsDataFrom(@NotNull Collection<ListData> lists) {
        if (lists == null) {
            ChangeListWorker.$$$reportNull$$$0(3);
        }
        ListData oldDefault = this.myDefault;
        List oldIds = ContainerUtil.map(this.myLists, list2 -> list2.id);
        this.myLists.clear();
        this.myDefault = null;
        HashMap<ListData, ListData> listMapping = new HashMap<ListData, ListData>();
        for (ListData oldList : lists) {
            ListData newList = new ListData(oldList);
            if (newList.isDefault && this.myDefault != null) {
                LOG.error("multiple default lists found when copy");
                newList.isDefault = false;
            }
            newList = this.putNewListData(newList);
            if (newList.isDefault) {
                this.myDefault = newList;
            }
            listMapping.put(oldList, newList);
        }
        this.ensureDefaultListExists();
        if (this.myMainWorker) {
            if (!oldDefault.id.equals(this.myDefault.id)) {
                this.fireDefaultListChanged(oldDefault.id, this.myDefault.id);
            }
            HashSet removedListIds = new HashSet(oldIds);
            for (ListData list3 : this.myLists) {
                removedListIds.remove(list3.id);
            }
            for (String listId : removedListIds) {
                this.fireChangeListRemoved(listId);
            }
        }
        this.myReadOnlyChangesCache = null;
        HashMap<ListData, ListData> hashMap = listMapping;
        if (hashMap == null) {
            ChangeListWorker.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private void ensureDefaultListExists() {
        if (this.myDefault != null) {
            return;
        }
        if (this.myLists.isEmpty()) {
            this.putNewListData(new ListData(null, LocalChangeList.DEFAULT_NAME));
        }
        this.myDefault = this.myLists.iterator().next();
        this.myDefault.isDefault = true;
    }

    public ChangeListWorker copy() {
        return new ChangeListWorker(this);
    }

    public void registerChangeTracker(@NotNull FilePath filePath, @NotNull PartialChangeTracker tracker) {
        if (filePath == null) {
            ChangeListWorker.$$$reportNull$$$0(5);
        }
        if (tracker == null) {
            ChangeListWorker.$$$reportNull$$$0(6);
        }
        if (this.myPartialChangeTrackers.containsKey(filePath)) {
            LOG.error(String.format("Attempt to register duplicate trackers: %s; old: %s; new: %s", filePath, this.myPartialChangeTrackers.get(filePath), tracker));
            return;
        }
        this.myPartialChangeTrackers.put(filePath, tracker);
        ListData oldList = null;
        Change change = this.getChangeForAfterPath(filePath);
        if (change != null) {
            oldList = this.removeChangeMapping(change);
        }
        tracker.initChangeTracking(this.myDefault.id, ContainerUtil.map(this.myLists, list2 -> list2.id), oldList != null ? oldList.id : null);
        List<String> oldIds = oldList != null ? Collections.singletonList(oldList.id) : Collections.emptyList();
        this.notifyChangelistsChanged(filePath, oldIds, tracker.getAffectedChangeListsIds());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[registerChangeTracker] path: %s, old list: %s", filePath, oldList != null ? oldList.id : "null"));
        }
    }

    public void unregisterChangeTracker(@NotNull FilePath filePath, @NotNull PartialChangeTracker tracker) {
        boolean trackerRemoved;
        if (filePath == null) {
            ChangeListWorker.$$$reportNull$$$0(7);
        }
        if (tracker == null) {
            ChangeListWorker.$$$reportNull$$$0(8);
        }
        if (trackerRemoved = this.myPartialChangeTrackers.remove(filePath, tracker)) {
            ListData newList = null;
            Change change = this.getChangeForAfterPath(filePath);
            if (change != null) {
                newList = this.getMainList(tracker);
                this.putChangeMapping(change, newList);
            }
            List<String> newIds = newList != null ? Collections.singletonList(newList.id) : Collections.emptyList();
            this.notifyChangelistsChanged(filePath, tracker.getAffectedChangeListsIds(), newIds);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("[unregisterChangeTracker] path: %s, new list: %s, tracker lists: %s", filePath, newList != null ? newList.id : "null", tracker.getAffectedChangeListsIds()));
            }
        } else {
            Map.Entry entry = (Map.Entry)ContainerUtil.find(this.myPartialChangeTrackers.entrySet(), it -> {
                if (tracker == null) {
                    ChangeListWorker.$$$reportNull$$$0(77);
                }
                return Comparing.equal(it.getValue(), (Object)tracker);
            });
            if (entry != null) {
                LOG.error(String.format("Unregistered tracker with wrong path: tracker: %s", tracker));
                FilePath actualFilePath = (FilePath)entry.getKey();
                this.unregisterChangeTracker(actualFilePath, tracker);
            } else {
                LOG.error(String.format("Tracker is not registered: tracker: %s", tracker));
            }
        }
    }

    @NotNull
    private ListData getMainList(@NotNull PartialChangeTracker tracker) {
        ListData list2;
        List<String> changelistIds;
        if (tracker == null) {
            ChangeListWorker.$$$reportNull$$$0(9);
        }
        if ((changelistIds = tracker.getAffectedChangeListsIds()).size() == 1 && (list2 = this.getDataByIdVerify(changelistIds.get(0))) != null) {
            ListData listData = list2;
            if (listData == null) {
                ChangeListWorker.$$$reportNull$$$0(10);
            }
            return listData;
        }
        ListData listData = this.myDefault;
        if (listData == null) {
            ChangeListWorker.$$$reportNull$$$0(11);
        }
        return listData;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ChangeListWorker.$$$reportNull$$$0(12);
        }
        return project;
    }

    @NotNull
    public LocalChangeList getDefaultList() {
        LocalChangeListImpl localChangeListImpl = this.toChangeList(this.myDefault);
        if (localChangeListImpl == null) {
            ChangeListWorker.$$$reportNull$$$0(13);
        }
        return localChangeListImpl;
    }

    @Nullable
    public LocalChangeList getChangeListByName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return this.toChangeList(this.getDataByName(name));
    }

    @Nullable
    public LocalChangeList getChangeListById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return this.toChangeList(this.getDataById(id));
    }

    @NotNull
    public List<LocalChangeList> getChangeLists() {
        List lists = ContainerUtil.map(this.myLists, this::toChangeList);
        ContainerUtil.sort((List)lists, (Comparator)ChangesUtil.CHANGELIST_COMPARATOR);
        List list2 = lists;
        if (list2 == null) {
            ChangeListWorker.$$$reportNull$$$0(14);
        }
        return list2;
    }

    public int getChangeListsNumber() {
        return this.myLists.size();
    }

    @Nullable
    public Change getChangeForPath(@Nullable FilePath filePath) {
        if (filePath == null) {
            return null;
        }
        for (Change change : this.myIdx.getChanges()) {
            ContentRevision before = change.getBeforeRevision();
            ContentRevision after2 = change.getAfterRevision();
            if ((before == null || !before.getFile().equals(filePath)) && (after2 == null || !after2.getFile().equals(filePath))) continue;
            return change;
        }
        return null;
    }

    @Nullable
    private Change getChangeForAfterPath(@Nullable FilePath filePath) {
        if (filePath == null) {
            return null;
        }
        for (Change change : this.myIdx.getChanges()) {
            ContentRevision after2 = change.getAfterRevision();
            if (after2 == null || !after2.getFile().equals(filePath)) continue;
            return change;
        }
        return null;
    }

    @NotNull
    public Collection<Change> getAllChanges() {
        ArrayList<Change> arrayList = new ArrayList<Change>(this.myIdx.getChanges());
        if (arrayList == null) {
            ChangeListWorker.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public List<LocalChangeList> getAffectedLists(@NotNull Collection<Change> changes) {
        if (changes == null) {
            ChangeListWorker.$$$reportNull$$$0(16);
        }
        List list2 = ContainerUtil.map(this.getAffectedListsData(changes), this::toChangeList);
        if (list2 == null) {
            ChangeListWorker.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @NotNull
    public List<LocalChangeList> getAffectedLists(@NotNull Change change) {
        if (change == null) {
            ChangeListWorker.$$$reportNull$$$0(18);
        }
        List<LocalChangeList> list2 = this.getAffectedLists(Collections.singletonList(change));
        if (list2 == null) {
            ChangeListWorker.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @NotNull
    private List<ListData> getAffectedListsData(@NotNull Collection<Change> changes) {
        if (changes == null) {
            ChangeListWorker.$$$reportNull$$$0(20);
        }
        HashSet<ListData> result2 = new HashSet<ListData>();
        for (Change change : changes) {
            ListData list2 = this.myChangeMappings.get(change);
            if (list2 != null) {
                result2.add(list2);
                continue;
            }
            PartialChangeTracker tracker = this.getChangeTrackerFor(change);
            if (tracker == null) continue;
            HashSet<ListData> affectedLists = this.getAffectedLists(tracker);
            if (change instanceof ChangeListChange) {
                String changeListId = ((ChangeListChange)change).getChangeListId();
                ContainerUtil.addIfNotNull(result2, (Object)ContainerUtil.find(affectedLists, partialList -> partialList.id.equals(changeListId)));
                continue;
            }
            result2.addAll(affectedLists);
        }
        ArrayList<ListData> arrayList = new ArrayList<ListData>(result2);
        if (arrayList == null) {
            ChangeListWorker.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @NotNull
    private List<Change> getChangesIn(@NotNull ListData data) {
        if (data == null) {
            ChangeListWorker.$$$reportNull$$$0(22);
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Change change : this.myIdx.getChanges()) {
            ListData list2 = this.myChangeMappings.get(change);
            if (list2 != null) {
                if (list2 != data) continue;
                changes.add(change);
                continue;
            }
            PartialChangeTracker tracker = this.getChangeTrackerFor(change);
            if (tracker == null || !tracker.getAffectedChangeListsIds().contains(data.id)) continue;
            changes.add(change);
        }
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            ChangeListWorker.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @NotNull
    private Map<ListData, Set<Change>> getChangesMapping() {
        HashMap<ListData, Set<Change>> map2 = new HashMap<ListData, Set<Change>>();
        for (Change change : this.myIdx.getChanges()) {
            ListData list2 = this.myChangeMappings.get(change);
            if (list2 != null) {
                Set listChanges = map2.computeIfAbsent(list2, key -> new HashSet());
                AbstractVcs vcs = this.myIdx.getVcsFor(change);
                if (vcs != null && vcs.arePartialChangelistsSupported()) {
                    listChanges.add(ChangeListWorker.toChangeListChange(change, list2));
                    continue;
                }
                listChanges.add(change);
                continue;
            }
            PartialChangeTracker tracker = this.getChangeTrackerFor(change);
            if (tracker == null) continue;
            HashSet<ListData> lists = this.getAffectedLists(tracker);
            for (ListData partialList : lists) {
                Set listChanges = map2.computeIfAbsent(partialList, key -> new HashSet());
                listChanges.add(ChangeListWorker.toChangeListChange(change, partialList));
            }
        }
        HashMap<ListData, Set<Change>> hashMap = map2;
        if (hashMap == null) {
            ChangeListWorker.$$$reportNull$$$0(24);
        }
        return hashMap;
    }

    @NotNull
    public List<File> getAffectedPaths() {
        List list2 = ContainerUtil.map(this.myIdx.getAffectedPaths(), FilePath::getIOFile);
        if (list2 == null) {
            ChangeListWorker.$$$reportNull$$$0(25);
        }
        return list2;
    }

    @NotNull
    public List<VirtualFile> getAffectedFiles() {
        List list2 = ContainerUtil.mapNotNull(this.myIdx.getAffectedPaths(), FilePath::getVirtualFile);
        if (list2 == null) {
            ChangeListWorker.$$$reportNull$$$0(26);
        }
        return list2;
    }

    public ThreeState haveChangesUnder(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ChangeListWorker.$$$reportNull$$$0(27);
        }
        FilePath dir = VcsUtil.getFilePath((VirtualFile)virtualFile);
        return this.myIdx.haveChangesUnder(dir);
    }

    @NotNull
    public List<Change> getChangesUnder(@NotNull FilePath dirPath) {
        if (dirPath == null) {
            ChangeListWorker.$$$reportNull$$$0(28);
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Change change : this.myIdx.getChanges()) {
            ContentRevision after2 = change.getAfterRevision();
            ContentRevision before = change.getBeforeRevision();
            if ((after2 == null || !after2.getFile().isUnder(dirPath, false)) && (before == null || !before.getFile().isUnder(dirPath, false))) continue;
            changes.add(change);
        }
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            ChangeListWorker.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    @Nullable
    public AbstractVcs getVcsFor(@NotNull Change change) {
        if (change == null) {
            ChangeListWorker.$$$reportNull$$$0(30);
        }
        return this.myIdx.getVcsFor(change);
    }

    @Nullable
    public FileStatus getStatus(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListWorker.$$$reportNull$$$0(31);
        }
        return this.myIdx.getStatus(file2);
    }

    @Nullable
    public FileStatus getStatus(@NotNull FilePath file2) {
        if (file2 == null) {
            ChangeListWorker.$$$reportNull$$$0(32);
        }
        return this.myIdx.getStatus(file2);
    }

    public boolean setDefaultList(@NotNull String name) {
        ListData newDefault;
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(33);
        }
        if ((newDefault = this.getDataByName(name)) == null || newDefault.isDefault) {
            return false;
        }
        ListData oldDefault = this.myDefault;
        this.myDefault.isDefault = false;
        newDefault.isDefault = true;
        this.myDefault = newDefault;
        this.fireDefaultListChanged(oldDefault.id, newDefault.id);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[setDefaultList %s] name: %s id: %s", this.myMainWorker ? "" : "- updater", name, newDefault.id));
        }
        return true;
    }

    public boolean setReadOnly(@NotNull String name, boolean value) {
        ListData list2;
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(34);
        }
        if ((list2 = this.getDataByName(name)) == null) {
            return false;
        }
        list2.isReadOnly = value;
        return true;
    }

    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        if (fromName == null) {
            ChangeListWorker.$$$reportNull$$$0(35);
        }
        if (toName == null) {
            ChangeListWorker.$$$reportNull$$$0(36);
        }
        if (fromName.equals(toName)) {
            return false;
        }
        if (this.getDataByName(toName) != null) {
            return false;
        }
        ListData list2 = this.getDataByName(fromName);
        if (list2 == null || list2.isReadOnly) {
            return false;
        }
        list2.name = toName;
        return true;
    }

    @Nullable
    public String editComment(@NotNull String name, @NotNull String newComment) {
        ListData list2;
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(37);
        }
        if (newComment == null) {
            ChangeListWorker.$$$reportNull$$$0(38);
        }
        if ((list2 = this.getDataByName(name)) == null) {
            return null;
        }
        String oldComment = list2.comment;
        if (!Comparing.equal((String)oldComment, (String)newComment)) {
            list2.comment = newComment;
        }
        return oldComment;
    }

    @NotNull
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String description, @Nullable String id, @Nullable ChangeListData data) {
        LocalChangeList existingList;
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(39);
        }
        if ((existingList = this.getChangeListByName(name)) != null) {
            LOG.error("Attempt to create duplicate changelist " + name);
            LocalChangeList localChangeList = existingList;
            if (localChangeList == null) {
                ChangeListWorker.$$$reportNull$$$0(40);
            }
            return localChangeList;
        }
        ListData list2 = new ListData(id, name);
        list2.comment = StringUtil.notNullize((String)description);
        list2.data = data;
        list2 = this.putNewListData(list2);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[addChangeList %s] name: %s id: %s", this.myMainWorker ? "" : "- updater", name, list2.id));
        }
        LocalChangeListImpl localChangeListImpl = this.toChangeList(list2);
        if (localChangeListImpl == null) {
            ChangeListWorker.$$$reportNull$$$0(41);
        }
        return localChangeListImpl;
    }

    public boolean removeChangeList(@NotNull String name) {
        ListData removedList;
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(42);
        }
        if ((removedList = this.getDataByName(name)) == null) {
            return false;
        }
        if (removedList.isDefault) {
            LOG.error("Cannot remove default changelist");
            return false;
        }
        ArrayList<Change> movedChanges = new ArrayList<Change>();
        this.myChangeMappings.replaceAll((change, list2) -> {
            if (list2 == removedList) {
                movedChanges.add((Change)change);
                return this.myDefault;
            }
            return list2;
        });
        this.fireChangeListRemoved(removedList.id);
        this.myReadOnlyChangesCache = null;
        if (this.myMainWorker && !movedChanges.isEmpty()) {
            this.myDelayedNotificator.changesMoved(movedChanges, (ChangeList)this.toChangeList(removedList), (ChangeList)this.toChangeList(this.myDefault));
        }
        this.myLists.remove(removedList);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[removeChangeList %s] name: %s id: %s", this.myMainWorker ? "" : "- updater", name, removedList.id));
        }
        return true;
    }

    @Nullable
    public MultiMap<LocalChangeList, Change> moveChangesTo(@NotNull String name, @NotNull List<Change> changes) {
        ListData targetList;
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(43);
        }
        if (changes == null) {
            ChangeListWorker.$$$reportNull$$$0(44);
        }
        if ((targetList = this.getDataByName(name)) == null) {
            return null;
        }
        MultiMap result2 = new MultiMap();
        for (Change change : changes) {
            ListData list2 = this.myChangeMappings.get(change);
            if (list2 != null) {
                if (list2 == targetList) continue;
                this.myChangeMappings.replace(change, targetList);
                result2.putValue((Object)list2, (Object)change);
                continue;
            }
            PartialChangeTracker tracker = this.getChangeTrackerFor(change);
            if (tracker == null) continue;
            if (change instanceof ChangeListChange) {
                String fromListId = ((ChangeListChange)change).getChangeListId();
                ListData fromList = this.getDataById(fromListId);
                if (fromList == null || fromList == targetList) continue;
                tracker.moveChanges(fromList.id, targetList.id);
                result2.putValue((Object)fromList, (Object)change);
                continue;
            }
            HashSet<ListData> fromLists = this.getAffectedLists(tracker);
            fromLists.remove(targetList);
            if (fromLists.isEmpty()) continue;
            tracker.moveChangesTo(targetList.id);
            for (ListData fromList : fromLists) {
                result2.putValue((Object)fromList, (Object)change);
            }
        }
        this.myReadOnlyChangesCache = null;
        MultiMap notifications = new MultiMap();
        for (Map.Entry entry : result2.entrySet()) {
            notifications.put((Object)this.toChangeList((ListData)entry.getKey()), (Collection)entry.getValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[moveChangesTo %s] name: %s id: %s, changes: %s", this.myMainWorker ? "" : "- updater", targetList.name, targetList.id, changes));
        }
        return notifications;
    }

    public void notifyChangelistsChanged(@NotNull FilePath path, @NotNull List<String> beforeChangeListsIds, @NotNull List<String> afterChangeListsIds) {
        if (path == null) {
            ChangeListWorker.$$$reportNull$$$0(45);
        }
        if (beforeChangeListsIds == null) {
            ChangeListWorker.$$$reportNull$$$0(46);
        }
        if (afterChangeListsIds == null) {
            ChangeListWorker.$$$reportNull$$$0(47);
        }
        this.myReadOnlyChangesCacheInvalidated.set(true);
        HashSet<String> removed = new HashSet<String>(beforeChangeListsIds);
        removed.removeAll(afterChangeListsIds);
        HashSet<String> added = new HashSet<String>(afterChangeListsIds);
        added.removeAll(beforeChangeListsIds);
        if (!removed.isEmpty() || !added.isEmpty()) {
            this.myDelayedNotificator.changeListsForFileChanged(path, removed, added);
        }
    }

    public void applyChangesFromUpdate(@NotNull ChangeListWorker updatedWorker, @NotNull PlusMinusModify<BaseRevision> deltaListener) {
        if (updatedWorker == null) {
            ChangeListWorker.$$$reportNull$$$0(48);
        }
        if (deltaListener == null) {
            ChangeListWorker.$$$reportNull$$$0(49);
        }
        HashMap<Change, ListData> oldChangeMappings = new HashMap<Change, ListData>(this.myChangeMappings);
        boolean somethingChanged = ChangeListWorker.notifyPathsChanged(this.myIdx, updatedWorker.myIdx, deltaListener);
        this.myIdx.copyFrom(updatedWorker.myIdx);
        this.myChangeMappings.clear();
        Map<ListData, ListData> listMapping = this.copyListsDataFrom(updatedWorker.myLists);
        for (Change change : this.myIdx.getChanges()) {
            ListData oldMappedList;
            PartialChangeTracker tracker = this.getChangeTrackerFor(change);
            if (tracker != null) continue;
            ListData oldList = updatedWorker.myChangeMappings.get(change);
            ListData newList = null;
            if (oldList == null) {
                if (updatedWorker.getChangeTrackerFor(change) == null) {
                    LOG.error("Change mapping not found");
                }
            } else {
                newList = listMapping.get(oldList);
                if (newList == null) {
                    LOG.error("List mapping not found");
                }
            }
            if (newList == null && (oldMappedList = oldChangeMappings.get(change)) != null) {
                newList = this.getDataById(oldMappedList.id);
            }
            if (newList == null) {
                newList = this.myDefault;
            }
            this.myChangeMappings.put(change, newList);
        }
        if (somethingChanged) {
            FileStatusManager.getInstance((Project)this.myProject).fileStatusesChanged();
        }
        if (this.myMainWorker) {
            this.myDelayedNotificator.allChangeListsMappingsChanged();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[applyChangesFromUpdate] %s", this));
        }
    }

    private static boolean notifyPathsChanged(@NotNull ChangeListsIndexes was, @NotNull ChangeListsIndexes became, @NotNull PlusMinusModify<BaseRevision> deltaListener) {
        if (was == null) {
            ChangeListWorker.$$$reportNull$$$0(50);
        }
        if (became == null) {
            ChangeListWorker.$$$reportNull$$$0(51);
        }
        if (deltaListener == null) {
            ChangeListWorker.$$$reportNull$$$0(52);
        }
        HashSet<BaseRevision> toRemove2 = new HashSet<BaseRevision>();
        HashSet<BaseRevision> toAdd = new HashSet<BaseRevision>();
        HashSet<BeforeAfter<BaseRevision>> toModify = new HashSet<BeforeAfter<BaseRevision>>();
        was.getDelta(became, toRemove2, toAdd, toModify);
        for (BaseRevision baseRevision : toRemove2) {
            deltaListener.minus(baseRevision);
        }
        for (BaseRevision baseRevision : toAdd) {
            deltaListener.plus(baseRevision);
        }
        for (BeforeAfter beforeAfter : toModify) {
            deltaListener.modify((BaseRevision)beforeAfter.getBefore(), (BaseRevision)beforeAfter.getAfter());
        }
        return !toRemove2.isEmpty() || !toAdd.isEmpty();
    }

    void setChangeLists(@NotNull Collection<LocalChangeListImpl> lists) {
        if (lists == null) {
            ChangeListWorker.$$$reportNull$$$0(53);
        }
        this.myIdx.clear();
        this.myChangeMappings.clear();
        this.copyListsDataFrom(ContainerUtil.map(lists, ListData::new));
        for (LocalChangeListImpl list2 : lists) {
            ListData listData = this.notNullList(this.getDataByIdVerify(list2.getId()));
            for (Change change : list2.getChanges()) {
                if (this.myIdx.getChanges().contains(change)) continue;
                this.myIdx.changeAdded(change, null);
                PartialChangeTracker tracker = this.getChangeTrackerFor(change);
                if (tracker != null) continue;
                this.myChangeMappings.put(change, listData);
            }
        }
        if (this.myMainWorker) {
            this.myDelayedNotificator.allChangeListsMappingsChanged();
        }
    }

    private void fireDefaultListChanged(@NotNull String oldDefaultId, @NotNull String newDefaultId) {
        if (oldDefaultId == null) {
            ChangeListWorker.$$$reportNull$$$0(54);
        }
        if (newDefaultId == null) {
            ChangeListWorker.$$$reportNull$$$0(55);
        }
        for (PartialChangeTracker tracker : this.myPartialChangeTrackers.values()) {
            tracker.defaultListChanged(oldDefaultId, newDefaultId);
        }
    }

    private void fireChangeListRemoved(@NotNull String listId) {
        if (listId == null) {
            ChangeListWorker.$$$reportNull$$$0(56);
        }
        for (PartialChangeTracker tracker : this.myPartialChangeTrackers.values()) {
            tracker.changeListRemoved(listId);
        }
    }

    @Nullable
    private ListData removeChangeMapping(@NotNull Change change) {
        if (change == null) {
            ChangeListWorker.$$$reportNull$$$0(57);
        }
        ListData oldList = this.myChangeMappings.remove(change);
        this.myReadOnlyChangesCache = null;
        return oldList;
    }

    private void putChangeMapping(@NotNull Change change, @NotNull ListData list2) {
        if (change == null) {
            ChangeListWorker.$$$reportNull$$$0(58);
        }
        if (list2 == null) {
            ChangeListWorker.$$$reportNull$$$0(59);
        }
        this.myChangeMappings.put(change, list2);
        this.myReadOnlyChangesCache = null;
    }

    @NotNull
    private ListData putNewListData(@NotNull ListData list2) {
        ListData listWithSameName;
        if (list2 == null) {
            ChangeListWorker.$$$reportNull$$$0(60);
        }
        if ((listWithSameName = this.getDataByName(list2.name)) != null) {
            LOG.error(String.format("Attempt to create changelist with same name: %s - %s", list2.name, list2.id));
            ListData listData = listWithSameName;
            if (listData == null) {
                ChangeListWorker.$$$reportNull$$$0(61);
            }
            return listData;
        }
        ListData listWithSameId = this.getDataById(list2.id);
        if (listWithSameId != null) {
            LOG.error(String.format("Attempt to create changelist with same id: %s - %s", list2.name, list2.id));
            ListData listData = listWithSameId;
            if (listData == null) {
                ChangeListWorker.$$$reportNull$$$0(62);
            }
            return listData;
        }
        this.myLists.add(list2);
        ListData listData = list2;
        if (listData == null) {
            ChangeListWorker.$$$reportNull$$$0(63);
        }
        return listData;
    }

    @NotNull
    private ListData notNullList(@Nullable ListData listData) {
        if (listData == null) {
            LOG.error("ListData not found");
        }
        ListData listData2 = (ListData)ObjectUtils.notNull((Object)listData, (Object)this.myDefault);
        if (listData2 == null) {
            ChangeListWorker.$$$reportNull$$$0(64);
        }
        return listData2;
    }

    @Nullable
    private ListData getDataById(@NotNull String id) {
        if (id == null) {
            ChangeListWorker.$$$reportNull$$$0(65);
        }
        return (ListData)ContainerUtil.find(this.myLists, list2 -> {
            if (id == null) {
                ChangeListWorker.$$$reportNull$$$0(76);
            }
            return list2.id.equals(id);
        });
    }

    @Nullable
    private ListData getDataByName(@NotNull String name) {
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(66);
        }
        return (ListData)ContainerUtil.find(this.myLists, list2 -> {
            if (name == null) {
                ChangeListWorker.$$$reportNull$$$0(75);
            }
            return list2.name.equals(name);
        });
    }

    @Nullable
    private ListData getDataByIdVerify(@NotNull String id) {
        if (id == null) {
            ChangeListWorker.$$$reportNull$$$0(67);
        }
        ListData list2 = this.getDataById(id);
        if (this.myMainWorker && list2 == null) {
            LOG.error(String.format("Unknown changelist %s", id));
        }
        return list2;
    }

    @Nullable
    private PartialChangeTracker getChangeTrackerFor(@NotNull Change change) {
        if (change == null) {
            ChangeListWorker.$$$reportNull$$$0(68);
        }
        if (this.myPartialChangeTrackers.isEmpty()) {
            return null;
        }
        if (!this.myIdx.getChanges().contains(change)) {
            return null;
        }
        ContentRevision revision = change.getAfterRevision();
        if (revision == null) {
            return null;
        }
        return this.myPartialChangeTrackers.get(revision.getFile());
    }

    @NotNull
    private HashSet<ListData> getAffectedLists(@NotNull PartialChangeTracker tracker) {
        if (tracker == null) {
            ChangeListWorker.$$$reportNull$$$0(69);
        }
        HashSet<ListData> data = new HashSet<ListData>();
        for (String listId : tracker.getAffectedChangeListsIds()) {
            ListData partialList = this.getDataById(listId);
            if (this.myMainWorker && partialList == null) {
                LOG.error(String.format("Unknown changelist %s", listId));
                tracker.initChangeTracking(this.myDefault.id, ContainerUtil.map(this.myLists, list2 -> list2.id), null);
            }
            data.add(partialList != null ? partialList : this.myDefault);
        }
        HashSet<ListData> hashSet = data;
        if (hashSet == null) {
            ChangeListWorker.$$$reportNull$$$0(70);
        }
        return hashSet;
    }

    @Contract(value="!null -> !null; null -> null")
    private LocalChangeListImpl toChangeList(@Nullable ListData data) {
        Set<Change> cachedChanges;
        if (data == null) {
            return null;
        }
        if (this.myReadOnlyChangesCache == null || this.myReadOnlyChangesCacheInvalidated.get()) {
            this.myReadOnlyChangesCacheInvalidated.set(false);
            this.myReadOnlyChangesCache = this.getChangesMapping();
        }
        Set<Change> changes = (cachedChanges = this.myReadOnlyChangesCache.get(data)) != null ? Collections.unmodifiableSet(cachedChanges) : Collections.emptySet();
        return new LocalChangeListImpl.Builder(this.myProject, data.name).setId(data.id).setComment(data.comment).setChangesCollection(changes).setData(data.data).setDefault(data.isDefault).setReadOnly(data.isReadOnly).build();
    }

    @NotNull
    private static Change toChangeListChange(@NotNull Change change, @NotNull ListData list2) {
        if (change == null) {
            ChangeListWorker.$$$reportNull$$$0(71);
        }
        if (list2 == null) {
            ChangeListWorker.$$$reportNull$$$0(72);
        }
        if (change.getClass() == Change.class) {
            ChangeListChange changeListChange = new ChangeListChange(change, list2.name, list2.id);
            if (changeListChange == null) {
                ChangeListWorker.$$$reportNull$$$0(73);
            }
            return changeListChange;
        }
        Change change2 = change;
        if (change2 == null) {
            ChangeListWorker.$$$reportNull$$$0(74);
        }
        return change2;
    }

    public String toString() {
        String lists = StringUtil.join(this.myLists, list2 -> String.format("list: %s (%s) changes: %s", list2.name, list2.id, StringUtil.join(this.getChangesIn((ListData)list2), (String)", ")), (String)"\n");
        String trackers = StringUtil.join(this.myPartialChangeTrackers.keySet(), (String)",");
        return String.format("ChangeListWorker{ default = %s, lists = {\n%s }\ntrackers = %s\n}", this.myDefault.id, lists, trackers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 40: 
            case 41: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 70: 
            case 73: 
            case 74: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 40: 
            case 41: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 70: 
            case 73: 
            case 74: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delayedNotificator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "worker";
                break;
            }
            case 3: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 40: 
            case 41: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 70: 
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListWorker";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 69: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 16: 
            case 20: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 18: 
            case 30: 
            case 57: 
            case 58: 
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPath";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: 
            case 34: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 66: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newComment";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeChangeListsIds";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterChangeListsIds";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedWorker";
                break;
            }
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deltaListener";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "was";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "became";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldDefaultId";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDefaultId";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listId";
                break;
            }
            case 59: 
            case 60: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 65: 
            case 67: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListWorker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "copyListsDataFrom";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultList";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeLists";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChanges";
                break;
            }
            case 17: 
            case 19: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedLists";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedListsData";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesIn";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesMapping";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedPaths";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedFiles";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesUnder";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "addChangeList";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "putNewListData";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullList";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "toChangeListChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyListsDataFrom";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 40: 
            case 41: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 70: 
            case 73: 
            case 74: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeTracker";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unregisterChangeTracker";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMainList";
                break;
            }
            case 16: 
            case 18: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedLists";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedListsData";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getChangesIn";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "haveChangesUnder";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getChangesUnder";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getVcsFor";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultList";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnly";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "editName";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "editComment";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addChangeList";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeList";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "moveChangesTo";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "notifyChangelistsChanged";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "applyChangesFromUpdate";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "notifyPathsChanged";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setChangeLists";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "fireDefaultListChanged";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "fireChangeListRemoved";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeMapping";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "putChangeMapping";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "putNewListData";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getDataById";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getDataByName";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getDataByIdVerify";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getChangeTrackerFor";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "toChangeListChange";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDataByName$9";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDataById$8";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "lambda$unregisterChangeTracker$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 40: 
            case 41: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 70: 
            case 73: 
            case 74: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PartialChangeTracker {
        @NotNull
        public List<String> getAffectedChangeListsIds();

        public void initChangeTracking(@NotNull String var1, @NotNull List<String> var2, @Nullable String var3);

        public void defaultListChanged(@NotNull String var1, @NotNull String var2);

        public void changeListRemoved(@NotNull String var1);

        public void moveChanges(@NotNull String var1, @NotNull String var2);

        public void moveChangesTo(@NotNull String var1);
    }

    private static class PartialChangeTrackerDump
    implements PartialChangeTracker {
        @NotNull
        private final Set<String> myChangeListsIds;
        @NotNull
        private String myDefaultId;

        public PartialChangeTrackerDump(@NotNull PartialChangeTracker tracker, @NotNull ListData defaultList) {
            if (tracker == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(0);
            }
            if (defaultList == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(1);
            }
            this.myChangeListsIds = new HashSet<String>(tracker.getAffectedChangeListsIds());
            this.myDefaultId = defaultList.id;
        }

        @Override
        @NotNull
        public List<String> getAffectedChangeListsIds() {
            ArrayList<String> arrayList = new ArrayList<String>(this.myChangeListsIds);
            if (arrayList == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @Override
        public void initChangeTracking(@NotNull String defaultId, @NotNull List<String> changelistsId, @Nullable String fileChangelistIds) {
            if (defaultId == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(3);
            }
            if (changelistsId == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(4);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void defaultListChanged(@NotNull String oldListId, @NotNull String newListId) {
            if (oldListId == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(5);
            }
            if (newListId == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(6);
            }
            this.myDefaultId = newListId;
        }

        @Override
        public void changeListRemoved(@NotNull String listId) {
            if (listId == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(7);
            }
            this.myChangeListsIds.remove(listId);
            if (this.myChangeListsIds.isEmpty()) {
                this.myChangeListsIds.add(this.myDefaultId);
            }
        }

        @Override
        public void moveChanges(@NotNull String fromListId, @NotNull String toListId) {
            if (fromListId == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(8);
            }
            if (toListId == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(9);
            }
            if (this.myChangeListsIds.remove(fromListId)) {
                this.myChangeListsIds.add(toListId);
            }
        }

        @Override
        public void moveChangesTo(@NotNull String toListId) {
            if (toListId == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(10);
            }
            this.myChangeListsIds.clear();
            this.myChangeListsIds.add(toListId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListWorker$PartialChangeTrackerDump";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultId";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changelistsId";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldListId";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newListId";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listId";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromListId";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toListId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListWorker$PartialChangeTrackerDump";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAffectedChangeListsIds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "initChangeTracking";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "defaultListChanged";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "changeListRemoved";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "moveChanges";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "moveChangesTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ChangeListUpdater
    implements ChangeListManagerGate {
        private final ChangeListWorker myWorker;
        private final Map<String, OpenTHashSet<Change>> myChangesBeforeUpdateMap;
        private static final String CONFLICT_CHANGELIST_ID = "";
        private final Map<FilePath, String> myListsForPathsBeforeUpdate;
        private final Set<String> myListsToDisappear;
        private final Comparator<Change> CHANGES_AFTER_REVISION_COMPARATOR;

        public ChangeListUpdater(@NotNull ChangeListWorker worker) {
            if (worker == null) {
                ChangeListUpdater.$$$reportNull$$$0(0);
            }
            this.myChangesBeforeUpdateMap = FactoryMap.create(it -> new OpenTHashSet());
            this.myListsForPathsBeforeUpdate = new HashMap<FilePath, String>();
            this.myListsToDisappear = new HashSet<String>();
            this.CHANGES_AFTER_REVISION_COMPARATOR = (o1, o2) -> {
                String s1 = o1.getAfterRevision().getFile().getPresentableUrl();
                String s2 = o2.getAfterRevision().getFile().getPresentableUrl();
                return SystemInfo.isFileSystemCaseSensitive ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
            };
            this.myWorker = worker.copy();
        }

        @NotNull
        public Project getProject() {
            Project project = this.myWorker.getProject();
            if (project == null) {
                ChangeListUpdater.$$$reportNull$$$0(1);
            }
            return project;
        }

        public void notifyStartProcessingChanges(@Nullable VcsModifiableDirtyScope scope) {
            this.myWorker.myChangeMappings.forEach((change, list2) -> {
                this.putPathBeforeUpdate(ChangesUtil.getBeforePath((Change)change), list2.id);
                this.putPathBeforeUpdate(ChangesUtil.getAfterPath((Change)change), list2.id);
                OpenTHashSet<Change> changes = this.myChangesBeforeUpdateMap.get(list2.id);
                changes.add(change);
            });
            List<Change> removedChanges = this.removeChangesUnderScope(scope);
            if (scope != null) {
                for (Change change2 : removedChanges) {
                    if (!change2.isMoved() && !change2.isRenamed()) continue;
                    scope.addDirtyFile(change2.getBeforeRevision().getFile());
                    scope.addDirtyFile(change2.getAfterRevision().getFile());
                }
            }
        }

        private void putPathBeforeUpdate(@Nullable FilePath path, @NotNull String listId) {
            if (listId == null) {
                ChangeListUpdater.$$$reportNull$$$0(2);
            }
            if (path == null) {
                return;
            }
            String oldListId = this.myListsForPathsBeforeUpdate.get(path);
            if (CONFLICT_CHANGELIST_ID.equals(oldListId) || listId.equals(oldListId)) {
                return;
            }
            if (oldListId == null) {
                this.myListsForPathsBeforeUpdate.put(path, listId);
            } else {
                this.myListsForPathsBeforeUpdate.put(path, CONFLICT_CHANGELIST_ID);
            }
        }

        @Nullable
        private String guessChangeListByPaths(@NotNull Change change) {
            if (change == null) {
                ChangeListUpdater.$$$reportNull$$$0(3);
            }
            FilePath bPath = ChangesUtil.getBeforePath((Change)change);
            FilePath aPath = ChangesUtil.getAfterPath((Change)change);
            String bListId = this.myListsForPathsBeforeUpdate.get(bPath);
            String aListId = this.myListsForPathsBeforeUpdate.get(aPath);
            if (CONFLICT_CHANGELIST_ID.equals(bListId) || CONFLICT_CHANGELIST_ID.equals(aListId)) {
                return null;
            }
            if (bListId == null && aListId == null) {
                return null;
            }
            if (bListId == null) {
                return aListId;
            }
            if (aListId == null) {
                return bListId;
            }
            return bListId.equals(aListId) ? bListId : null;
        }

        @NotNull
        private List<Change> removeChangesUnderScope(@Nullable VcsModifiableDirtyScope scope) {
            ArrayList<Change> removed = new ArrayList<Change>();
            for (Change change : this.myWorker.myIdx.getChanges()) {
                ContentRevision before = change.getBeforeRevision();
                ContentRevision after2 = change.getAfterRevision();
                boolean isUnderScope = scope == null || before != null && scope.belongsTo(before.getFile()) || after2 != null && scope.belongsTo(after2.getFile()) || ChangeListUpdater.isIgnoredChange(before, after2, this.getProject());
                if (!isUnderScope) continue;
                removed.add(change);
            }
            for (Change change : removed) {
                this.myWorker.myIdx.changeRemoved(change);
                this.myWorker.removeChangeMapping(change);
            }
            ArrayList<Change> arrayList = removed;
            if (arrayList == null) {
                ChangeListUpdater.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        private static boolean isIgnoredChange(@Nullable ContentRevision before, @Nullable ContentRevision after2, @NotNull Project project) {
            if (project == null) {
                ChangeListUpdater.$$$reportNull$$$0(5);
            }
            return ChangeListUpdater.isIgnoredRevision(before, project) && ChangeListUpdater.isIgnoredRevision(after2, project);
        }

        private static boolean isIgnoredRevision(@Nullable ContentRevision revision, @NotNull Project project) {
            if (project == null) {
                ChangeListUpdater.$$$reportNull$$$0(6);
            }
            if (revision == null) {
                return true;
            }
            return (Boolean)ReadAction.compute(() -> {
                if (project == null) {
                    ChangeListUpdater.$$$reportNull$$$0(37);
                }
                if (project.isDisposed()) {
                    return false;
                }
                VirtualFile vFile = revision.getFile().getVirtualFile();
                return vFile != null && ProjectLevelVcsManager.getInstance((Project)project).isIgnored(vFile);
            });
        }

        public void notifyDoneProcessingChanges(@NotNull DelayedNotificator dispatcher) {
            if (dispatcher == null) {
                ChangeListUpdater.$$$reportNull$$$0(7);
            }
            ArrayList<LocalChangeListImpl> changedLists = new ArrayList<LocalChangeListImpl>();
            HashMap<LocalChangeListImpl, List> removedChanges = new HashMap<LocalChangeListImpl, List>();
            HashMap<LocalChangeListImpl, List> addedChanges = new HashMap<LocalChangeListImpl, List>();
            for (ListData listData : this.myWorker.myLists) {
                ArrayList<Change> removed = new ArrayList<Change>();
                ArrayList<Change> added = new ArrayList<Change>();
                this.doneProcessingChanges(listData, removed, added);
                LocalChangeListImpl changeList2 = this.myWorker.toChangeList(listData);
                if (!removed.isEmpty() || !added.isEmpty()) {
                    changedLists.add(changeList2);
                }
                if (!removed.isEmpty()) {
                    removedChanges.put(changeList2, removed);
                }
                if (added.isEmpty()) continue;
                addedChanges.put(changeList2, added);
            }
            removedChanges.forEach((changeList, changes) -> {
                if (dispatcher == null) {
                    ChangeListUpdater.$$$reportNull$$$0(36);
                }
                dispatcher.changesRemoved((Collection<Change>)changes, (ChangeList)changeList);
            });
            addedChanges.forEach((changeList, changes) -> {
                if (dispatcher == null) {
                    ChangeListUpdater.$$$reportNull$$$0(35);
                }
                dispatcher.changesAdded((Collection<Change>)changes, (ChangeList)changeList);
            });
            for (ChangeList changeList2 : changedLists) {
                dispatcher.changeListChanged(changeList2);
            }
            for (String string : this.myListsToDisappear) {
                ListData list3 = this.myWorker.getDataByName(string);
                if (list3 == null || !this.myWorker.getChangesIn(list3).isEmpty() || list3.isReadOnly || list3.isDefault) continue;
                this.myWorker.removeChangeList(string);
            }
            this.myListsToDisappear.clear();
            this.myChangesBeforeUpdateMap.clear();
            this.myListsForPathsBeforeUpdate.clear();
        }

        private void doneProcessingChanges(@NotNull ListData list2, @NotNull List<Change> removedChanges, @NotNull List<Change> addedChanges) {
            if (list2 == null) {
                ChangeListUpdater.$$$reportNull$$$0(8);
            }
            if (removedChanges == null) {
                ChangeListUpdater.$$$reportNull$$$0(9);
            }
            if (addedChanges == null) {
                ChangeListUpdater.$$$reportNull$$$0(10);
            }
            OpenTHashSet<Change> changesBeforeUpdate = this.myChangesBeforeUpdateMap.get(list2.id);
            HashSet listChanges = new HashSet(this.myWorker.getChangesIn(list2));
            for (Change newChange : listChanges) {
                Change oldChange = ChangeListUpdater.findOldChange(changesBeforeUpdate, newChange);
                if (oldChange != null) continue;
                addedChanges.add(newChange);
            }
            removedChanges.addAll((Collection<Change>)changesBeforeUpdate);
            removedChanges.removeAll(listChanges);
        }

        @Nullable
        private static Change findOldChange(@NotNull OpenTHashSet<Change> changesBeforeUpdate, @NotNull Change newChange) {
            Change oldChange;
            if (changesBeforeUpdate == null) {
                ChangeListUpdater.$$$reportNull$$$0(11);
            }
            if (newChange == null) {
                ChangeListUpdater.$$$reportNull$$$0(12);
            }
            if ((oldChange = (Change)changesBeforeUpdate.get((Object)newChange)) != null && ChangeListUpdater.sameBeforeRevision(oldChange, newChange) && newChange.getFileStatus().equals(oldChange.getFileStatus())) {
                return oldChange;
            }
            return null;
        }

        private static boolean sameBeforeRevision(@NotNull Change change1, @NotNull Change change2) {
            if (change1 == null) {
                ChangeListUpdater.$$$reportNull$$$0(13);
            }
            if (change2 == null) {
                ChangeListUpdater.$$$reportNull$$$0(14);
            }
            ContentRevision b1 = change1.getBeforeRevision();
            ContentRevision b2 = change2.getBeforeRevision();
            if (b1 != null && b2 != null) {
                VcsRevisionNumber rn1 = b1.getRevisionNumber();
                VcsRevisionNumber rn2 = b2.getRevisionNumber();
                boolean isBinary1 = b1 instanceof BinaryContentRevision;
                boolean isBinary2 = b2 instanceof BinaryContentRevision;
                return rn1 != VcsRevisionNumber.NULL && rn2 != VcsRevisionNumber.NULL && rn1.compareTo((Object)rn2) == 0 && isBinary1 == isBinary2;
            }
            return b1 == null && b2 == null;
        }

        @NotNull
        public ChangeListWorker finish() {
            this.checkForMultipleCopiesNotMove();
            ChangeListWorker changeListWorker = this.myWorker;
            if (changeListWorker == null) {
                ChangeListUpdater.$$$reportNull$$$0(15);
            }
            return changeListWorker;
        }

        private void checkForMultipleCopiesNotMove() {
            MultiMap moves = new MultiMap();
            for (Change change : this.myWorker.myIdx.getChanges()) {
                if (!change.isMoved() && !change.isRenamed()) continue;
                moves.putValue((Object)change.getBeforeRevision().getFile(), (Object)change);
            }
            for (FilePath filePath : moves.keySet()) {
                List copies = (List)moves.get((Object)filePath);
                if (copies.size() == 1) continue;
                copies.sort(this.CHANGES_AFTER_REVISION_COMPARATOR);
                for (int i = 0; i < copies.size() - 1; ++i) {
                    Change oldChange = (Change)copies.get(i);
                    Change newChange = new Change(null, oldChange.getAfterRevision());
                    AbstractVcs vcs = this.myWorker.myIdx.getVcsFor(oldChange);
                    this.myWorker.myIdx.changeRemoved(oldChange);
                    this.myWorker.myIdx.changeAdded(newChange, vcs);
                    ListData list2 = this.myWorker.removeChangeMapping(oldChange);
                    this.myWorker.putChangeMapping(newChange, this.myWorker.notNullList(list2));
                }
            }
        }

        public void addChangeToList(@NotNull String name, @NotNull Change change, AbstractVcs vcs) {
            ListData list2;
            if (name == null) {
                ChangeListUpdater.$$$reportNull$$$0(16);
            }
            if (change == null) {
                ChangeListUpdater.$$$reportNull$$$0(17);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("[addChangeToList] name: %s change: %s vcs: %s", name, ChangesUtil.getFilePath((Change)change).getPath(), vcs == null ? null : vcs.getName()));
            }
            if ((list2 = this.myWorker.getDataByName(name)) == null) {
                return;
            }
            this.addChangeToList(list2, change, vcs);
        }

        public void addChangeToCorrespondingList(@NotNull Change change, AbstractVcs vcs) {
            if (change == null) {
                ChangeListUpdater.$$$reportNull$$$0(18);
            }
            ListData listData = this.guessListForChange(change);
            this.addChangeToList(listData, change, vcs);
        }

        @Nullable
        private ListData guessListForChange(@NotNull Change change) {
            ListData list22;
            if (change == null) {
                ChangeListUpdater.$$$reportNull$$$0(19);
            }
            if (LOG.isDebugEnabled()) {
                String path = ChangesUtil.getFilePath((Change)change).getPath();
                LOG.debug("[addChangeToCorrespondingList] for change " + (String)path + " type: " + change.getType() + " have before revision: " + (change.getBeforeRevision() != null));
            }
            for (ListData list22 : this.myWorker.myLists) {
                Set changesBeforeUpdate = (Set)this.myChangesBeforeUpdateMap.get(list22.id);
                if (!changesBeforeUpdate.contains(change)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[addChangeToCorrespondingList] matched by change: " + list22.name);
                }
                return list22;
            }
            String listId = this.guessChangeListByPaths(change);
            if (listId != null && (list22 = this.myWorker.getDataById(listId)) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[addChangeToCorrespondingList] matched by paths: " + list22.name);
                }
                return list22;
            }
            ContentRevision revision = change.getAfterRevision();
            if (revision != null && this.myWorker.myPartialChangeTrackers.get(revision.getFile()) != null) {
                LOG.debug("[addChangeToCorrespondingList] partial tracker found");
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("[addChangeToCorrespondingList] added to default list");
            }
            return this.myWorker.myDefault;
        }

        private void addChangeToList(@Nullable ListData list2, @NotNull Change change, AbstractVcs vcs) {
            if (change == null) {
                ChangeListUpdater.$$$reportNull$$$0(20);
            }
            if (this.myWorker.myIdx.getChanges().contains(change)) {
                LOG.warn(String.format("Multiple equal changes added: %s", change));
                return;
            }
            this.myWorker.myIdx.changeAdded(change, vcs);
            if (list2 != null) {
                this.myWorker.putChangeMapping(change, list2);
            }
            this.myWorker.myReadOnlyChangesCache = null;
        }

        public void removeRegisteredChangeFor(@Nullable FilePath filePath) {
            Change change = this.myWorker.getChangeForPath(filePath);
            if (change == null) {
                return;
            }
            this.myWorker.myIdx.changeRemoved(change);
            this.myWorker.removeChangeMapping(change);
        }

        @NotNull
        public List<LocalChangeList> getListsCopy() {
            List<LocalChangeList> list2 = this.myWorker.getChangeLists();
            if (list2 == null) {
                ChangeListUpdater.$$$reportNull$$$0(21);
            }
            return list2;
        }

        @Nullable
        public LocalChangeList findChangeList(String name) {
            return this.myWorker.getChangeListByName(name);
        }

        @NotNull
        public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment) {
            if (name == null) {
                ChangeListUpdater.$$$reportNull$$$0(22);
            }
            LocalChangeList localChangeList = this.myWorker.addChangeList(name, comment, null, null);
            if (localChangeList == null) {
                ChangeListUpdater.$$$reportNull$$$0(23);
            }
            return localChangeList;
        }

        @NotNull
        public LocalChangeList findOrCreateList(@NotNull String name, String comment) {
            LocalChangeList list2;
            if (name == null) {
                ChangeListUpdater.$$$reportNull$$$0(24);
            }
            if ((list2 = this.myWorker.getChangeListByName(name)) != null) {
                LocalChangeList localChangeList = list2;
                if (localChangeList == null) {
                    ChangeListUpdater.$$$reportNull$$$0(25);
                }
                return localChangeList;
            }
            LocalChangeList localChangeList = this.addChangeList(name, comment);
            if (localChangeList == null) {
                ChangeListUpdater.$$$reportNull$$$0(26);
            }
            return localChangeList;
        }

        public void editComment(@NotNull String name, String comment) {
            if (name == null) {
                ChangeListUpdater.$$$reportNull$$$0(27);
            }
            this.myWorker.editComment(name, StringUtil.notNullize((String)comment));
        }

        public void editName(@NotNull String oldName, @NotNull String newName) {
            if (oldName == null) {
                ChangeListUpdater.$$$reportNull$$$0(28);
            }
            if (newName == null) {
                ChangeListUpdater.$$$reportNull$$$0(29);
            }
            this.myWorker.editName(oldName, newName);
        }

        public void setListsToDisappear(@NotNull Collection<String> names) {
            if (names == null) {
                ChangeListUpdater.$$$reportNull$$$0(30);
            }
            this.myListsToDisappear.addAll(names);
        }

        public FileStatus getStatus(@NotNull VirtualFile file2) {
            if (file2 == null) {
                ChangeListUpdater.$$$reportNull$$$0(31);
            }
            return this.myWorker.getStatus(file2);
        }

        @Deprecated
        public FileStatus getStatus(@NotNull File file2) {
            if (file2 == null) {
                ChangeListUpdater.$$$reportNull$$$0(32);
            }
            return this.myWorker.getStatus(VcsUtil.getFilePath((File)file2));
        }

        public FileStatus getStatus(@NotNull FilePath filePath) {
            if (filePath == null) {
                ChangeListUpdater.$$$reportNull$$$0(33);
            }
            return this.myWorker.getStatus(filePath);
        }

        public void setDefaultChangeList(@NotNull String list2) {
            if (list2 == null) {
                ChangeListUpdater.$$$reportNull$$$0(34);
            }
            this.myWorker.setDefaultList(list2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 15: 
                case 21: 
                case 23: 
                case 25: 
                case 26: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 15: 
                case 21: 
                case 23: 
                case 25: 
                case 26: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "worker";
                    break;
                }
                case 1: 
                case 4: 
                case 15: 
                case 21: 
                case 23: 
                case 25: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListWorker$ChangeListUpdater";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listId";
                    break;
                }
                case 3: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 5: 
                case 6: 
                case 37: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: 
                case 35: 
                case 36: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dispatcher";
                    break;
                }
                case 8: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "removedChanges";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "addedChanges";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesBeforeUpdate";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newChange";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change1";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change2";
                    break;
                }
                case 16: 
                case 22: 
                case 24: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldName";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 31: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListWorker$ChangeListUpdater";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "removeChangesUnderScope";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "finish";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getListsCopy";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addChangeList";
                    break;
                }
                case 25: 
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findOrCreateList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: 
                case 15: 
                case 21: 
                case 23: 
                case 25: 
                case 26: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "putPathBeforeUpdate";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "guessChangeListByPaths";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isIgnoredChange";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isIgnoredRevision";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyDoneProcessingChanges";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "doneProcessingChanges";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "findOldChange";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "sameBeforeRevision";
                    break;
                }
                case 16: 
                case 17: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "addChangeToList";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "addChangeToCorrespondingList";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "guessListForChange";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "addChangeList";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "findOrCreateList";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "editComment";
                    break;
                }
                case 28: 
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "editName";
                    break;
                }
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "setListsToDisappear";
                    break;
                }
                case 31: 
                case 32: 
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatus";
                    break;
                }
                case 34: {
                    objectArray = objectArray;
                    objectArray[2] = "setDefaultChangeList";
                    break;
                }
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$notifyDoneProcessingChanges$4";
                    break;
                }
                case 36: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$notifyDoneProcessingChanges$3";
                    break;
                }
                case 37: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$isIgnoredRevision$2";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 15: 
                case 21: 
                case 23: 
                case 25: 
                case 26: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ListData {
        @NotNull
        public final String id;
        @NotNull
        public String name;
        @NotNull
        public String comment;
        @Nullable
        public ChangeListData data;
        public boolean isDefault;
        public boolean isReadOnly;

        public ListData(@Nullable String id, @NotNull String name) {
            if (name == null) {
                ListData.$$$reportNull$$$0(0);
            }
            this.comment = "";
            this.isDefault = false;
            this.isReadOnly = false;
            this.id = id != null ? id : LocalChangeListImpl.generateChangelistId();
            this.name = name;
        }

        public ListData(@NotNull LocalChangeListImpl list2) {
            if (list2 == null) {
                ListData.$$$reportNull$$$0(1);
            }
            this.comment = "";
            this.isDefault = false;
            this.isReadOnly = false;
            this.id = list2.getId();
            this.name = list2.getName();
            this.comment = list2.getComment();
            this.data = list2.getData();
            this.isDefault = list2.isDefault();
            this.isReadOnly = list2.isReadOnly();
        }

        public ListData(@NotNull ListData list2) {
            if (list2 == null) {
                ListData.$$$reportNull$$$0(2);
            }
            this.comment = "";
            this.isDefault = false;
            this.isReadOnly = false;
            this.id = list2.id;
            this.name = list2.name;
            this.comment = list2.comment;
            this.data = list2.data;
            this.isDefault = list2.isDefault;
            this.isReadOnly = list2.isReadOnly;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "list";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/ChangeListWorker$ListData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

