/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.SelectContentStep;
import com.intellij.openapi.wm.impl.content.TabbedContentTabLabel;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.tabs.impl.singleRow.MoreTabsIcon;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

class TabContentLayout
extends ContentLayout {
    static final int MORE_ICON_BORDER = 6;
    LayoutData myLastLayout;
    ArrayList<ContentTabLabel> myTabs = new ArrayList();
    final Map<Content, ContentTabLabel> myContent2Tabs = new HashMap<Content, ContentTabLabel>();
    private final MoreTabsIcon myMoreIcon = new MoreTabsIcon(){

        @Nullable
        protected Rectangle getIconRec() {
            return TabContentLayout.this.myLastLayout.moreRect;
        }
    };

    TabContentLayout(ToolWindowContentUi ui2) {
        super(ui2);
        new BaseButtonBehavior(this.myUi){

            protected void execute(MouseEvent e) {
                Rectangle moreRect;
                if (!TabContentLayout.this.myUi.isCurrent(TabContentLayout.this)) {
                    return;
                }
                if (TabContentLayout.this.myLastLayout != null && (moreRect = TabContentLayout.this.myLastLayout.moreRect) != null && moreRect.contains(e.getPoint())) {
                    TabContentLayout.showPopup(e, ContainerUtil.filter(TabContentLayout.this.myTabs, TabContentLayout.this.myLastLayout.toDrop::contains));
                }
            }
        };
    }

    @Override
    public void init() {
        this.reset();
        this.myIdLabel = new BaseLabel(this.myUi, false){

            @Override
            protected boolean allowEngravement() {
                return this.myUi.myWindow.isActive();
            }
        };
        for (int i = 0; i < this.myUi.myManager.getContentCount(); ++i) {
            this.contentAdded(new ContentManagerEvent((Object)this, this.myUi.myManager.getContent(i), i));
        }
    }

    @Override
    public void reset() {
        this.myTabs.clear();
        this.myContent2Tabs.clear();
        this.myIdLabel = null;
    }

    private static void showPopup(MouseEvent e, List<ContentTabLabel> tabs2) {
        List contentsToShow = ContainerUtil.map(tabs2, ContentTabLabel::getContent);
        SelectContentStep step = new SelectContentStep(contentsToShow);
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).show(new RelativePoint(e));
    }

    @Override
    public void layout() {
        Rectangle bounds = this.myUi.getBounds();
        ContentManager manager = this.myUi.myManager;
        LayoutData data = new LayoutData(this.myUi);
        data.eachX = 4;
        data.eachY = 0;
        if (this.isIdVisible()) {
            this.myIdLabel.setBounds(data.eachX, data.eachY, this.myIdLabel.getPreferredSize().width, bounds.height);
            data.eachX += this.myIdLabel.getPreferredSize().width;
        }
        int tabsStart = data.eachX;
        if (manager.getContentCount() == 0) {
            return;
        }
        Content selected = manager.getSelectedContent();
        if (selected == null) {
            selected = manager.getContents()[0];
        }
        if (this.myLastLayout != null && this.myLastLayout.layoutSize.equals(bounds.getSize()) && this.myLastLayout.contentCount == manager.getContentCount()) {
            for (ContentTabLabel each : this.myTabs) {
                if (!each.isValid()) break;
                if (each.getContent() != selected || each.getBounds().width == 0) continue;
                data = this.myLastLayout;
                data.fullLayout = false;
            }
        }
        if (data.fullLayout) {
            for (ContentTabLabel eachTab : this.myTabs) {
                Dimension eachSize = eachTab.getPreferredSize();
                data.requiredWidth += eachSize.width;
                ++data.requiredWidth;
                data.toLayout.add(eachTab);
            }
            data.moreRectWidth = this.myMoreIcon.getIconWidth() + 12;
            data.toFitWidth = bounds.getSize().width - data.eachX;
            ContentTabLabel selectedTab = this.myContent2Tabs.get(selected);
            while (data.requiredWidth > data.toFitWidth && data.toLayout.size() > 1) {
                if (data.toLayout.get(0) != selectedTab) {
                    TabContentLayout.dropTab(data, data.toLayout.remove(0));
                    continue;
                }
                if (data.toLayout.get(data.toLayout.size() - 1) == selectedTab) break;
                TabContentLayout.dropTab(data, data.toLayout.remove(data.toLayout.size() - 1));
            }
            boolean reachedBounds = false;
            data.moreRect = null;
            for (ContentTabLabel each : data.toLayout) {
                data.eachY = 0;
                Dimension eachSize = each.getPreferredSize();
                if (data.eachX + eachSize.width < data.toFitWidth + tabsStart) {
                    each.setBounds(data.eachX, data.eachY, eachSize.width, bounds.height - data.eachY);
                    data.eachX += eachSize.width;
                    continue;
                }
                if (!reachedBounds) {
                    int width = bounds.width - data.eachX - data.moreRectWidth;
                    each.setBounds(data.eachX, data.eachY, width, bounds.height - data.eachY);
                    data.eachX += width;
                } else {
                    each.setBounds(0, 0, 0, 0);
                }
                reachedBounds = true;
            }
            for (ContentTabLabel each : data.toDrop) {
                each.setBounds(0, 0, 0, 0);
            }
        }
        if (data.toDrop.size() > 0) {
            data.moreRect = new Rectangle(data.eachX + 6, 0, this.myMoreIcon.getIconWidth(), bounds.height);
            this.myMoreIcon.updateCounter(data.toDrop.size());
        } else {
            data.moreRect = null;
        }
        Rectangle moreRect = data.moreRect == null ? null : new Rectangle(data.eachX, 0, this.myMoreIcon.getIconWidth() + 6, bounds.height);
        this.myUi.isResizableArea = p -> moreRect == null || !moreRect.contains((Point)p);
        this.myLastLayout = data;
    }

    @Override
    public int getMinimumWidth() {
        int result2 = 0;
        if (this.myIdLabel != null) {
            result2 += this.myIdLabel.getPreferredSize().width;
            Insets insets = this.myIdLabel.getInsets();
            if (insets != null) {
                result2 += insets.left + insets.right;
            }
        }
        if (this.myLastLayout != null) {
            result2 += this.myLastLayout.moreRectWidth + this.myLastLayout.requiredWidth;
            result2 -= this.myLastLayout.toLayout.size() > 1 ? this.myLastLayout.moreRectWidth + 1 : -14;
        }
        return result2;
    }

    static void dropTab(LayoutData data, ContentTabLabel toDropLabel) {
        data.requiredWidth -= toDropLabel.getPreferredSize().width + 1;
        data.toDrop.add(toDropLabel);
        if (data.toDrop.size() == 1) {
            data.toFitWidth -= data.moreRectWidth;
        }
    }

    boolean isToDrawTabs() {
        if (this.myTabs.size() > 1) {
            return true;
        }
        if (this.myTabs.size() == 1) {
            String title = this.myTabs.get(0).getContent().getToolwindowTitle();
            return !StringUtil.isEmpty((String)title);
        }
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isToDrawTabs()) {
            return;
        }
        for (ContentTabLabel each : this.myTabs) {
            if (!each.isSelected() && !each.isHovered()) continue;
            Color color = each.isSelected() ? JBUI.CurrentTheme.ToolWindow.tabSelectedBackground((boolean)this.myUi.myWindow.isActive()) : JBUI.CurrentTheme.ToolWindow.tabHoveredBackground((boolean)this.myUi.myWindow.isActive());
            Rectangle r = each.getBounds();
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(color);
            g2d.fillRect(this.isIdVisible() ? r.x : r.x - 2, r.y, r.width, r.height);
            g2d.dispose();
        }
    }

    @Override
    public void paintChildren(Graphics g) {
        if (!this.isToDrawTabs()) {
            return;
        }
        if (this.myLastLayout != null && this.myLastLayout.moreRect != null) {
            this.myMoreIcon.paintIcon((Component)this.myUi, g);
        }
    }

    @Override
    public void update() {
        for (ContentTabLabel each : this.myTabs) {
            each.update();
        }
        this.updateIdLabel(this.myIdLabel);
    }

    @Override
    public void rebuild() {
        this.myUi.removeAll();
        this.myUi.add(this.myIdLabel);
        ToolWindowContentUi.initMouseListeners(this.myIdLabel, this.myUi, true);
        for (ContentTabLabel each : this.myTabs) {
            this.myUi.add(each);
            ToolWindowContentUi.initMouseListeners(each, this.myUi, false);
        }
    }

    @Override
    public void contentAdded(ContentManagerEvent event) {
        Content content = event.getContent();
        ContentTabLabel tab = content instanceof TabbedContent ? new TabbedContentTabLabel((TabbedContent)content, this) : new ContentTabLabel(content, this);
        this.myTabs.add(event.getIndex(), tab);
        this.myContent2Tabs.put(content, tab);
        if (content instanceof DnDTarget) {
            DnDTarget target2 = (DnDTarget)content;
            DnDSupport.createBuilder((JComponent)tab).setDropHandler((DnDDropHandler)target2).setTargetChecker((DnDTargetChecker)target2).setCleanUpOnLeaveCallback(() -> target2.cleanUpOnLeave()).install();
        }
    }

    @Override
    public void contentRemoved(ContentManagerEvent event) {
        ContentTabLabel tab = this.myContent2Tabs.get(event.getContent());
        if (tab != null) {
            this.myTabs.remove(tab);
            this.myContent2Tabs.remove(event.getContent());
        }
    }

    @Override
    public void showContentPopup(ListPopup listPopup) {
        Content selected = this.myUi.myManager.getSelectedContent();
        if (selected != null) {
            ContentTabLabel tab = this.myContent2Tabs.get(selected);
            listPopup.showUnderneathOf((Component)tab);
        } else {
            listPopup.showUnderneathOf((Component)this.myIdLabel);
        }
    }

    @Override
    public RelativeRectangle getRectangleFor(Content content) {
        ContentTabLabel label2 = this.myContent2Tabs.get(content);
        return new RelativeRectangle((Component)label2.getParent(), label2.getBounds());
    }

    @Override
    public Component getComponentFor(Content content) {
        return this.myContent2Tabs.get(content);
    }

    @Override
    public String getCloseActionName() {
        return UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]);
    }

    @Override
    public String getCloseAllButThisActionName() {
        return UIBundle.message((String)"tabbed.pane.close.all.tabs.but.this.action.name", (Object[])new Object[0]);
    }

    @Override
    public String getPreviousContentActionName() {
        return "Select Previous Tab";
    }

    @Override
    public String getNextContentActionName() {
        return "Select Next Tab";
    }

    static class LayoutData {
        int toFitWidth;
        int requiredWidth;
        Dimension layoutSize;
        boolean fullLayout = true;
        int moreRectWidth;
        ArrayList<ContentTabLabel> toLayout = new ArrayList();
        Collection<ContentTabLabel> toDrop = new HashSet<ContentTabLabel>();
        Rectangle moreRect;
        public int eachX;
        public int eachY;
        public int contentCount;

        LayoutData(ToolWindowContentUi ui2) {
            this.layoutSize = ui2.getSize();
            this.contentCount = ui2.myManager.getContentCount();
        }
    }
}

