/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.log.LogListener;
import com.intellij.remoteServer.agent.util.log.TerminalListener;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.runtime.log.TerminalHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.jetbrains.annotations.Nullable;

public class CloudLoggingHandlerImpl
implements CloudAgentLoggingHandler {
    private final HashMap<String, LogListener> myPipeName2LogListener;
    private final LoggingHandler myMainLoggingHandler;
    private final DeploymentLogManager myLogManager;

    public CloudLoggingHandlerImpl(DeploymentLogManager logManager) {
        this.myMainLoggingHandler = logManager.getMainLoggingHandler();
        this.myPipeName2LogListener = new HashMap();
        this.myLogManager = logManager;
    }

    public void println(String message) {
        this.myMainLoggingHandler.print(message + "\n");
    }

    public LogListener getOrCreateLogListener(String pipeName) {
        LogListener logListener = this.myPipeName2LogListener.get(pipeName);
        if (logListener == null) {
            LoggingHandler loggingHandler = this.myLogManager.addAdditionalLog(pipeName);
            logListener = new LogListenerImpl(loggingHandler);
            this.myPipeName2LogListener.put(pipeName, logListener);
        }
        return logListener;
    }

    public LogListener getOrCreateEmptyLogListener(String pipeName) {
        LogListenerImpl result2 = (LogListenerImpl)this.getOrCreateLogListener(pipeName);
        result2.clear();
        return result2;
    }

    public LogListener createConsole(String pipeName, final OutputStream consoleInput) {
        final LoggingHandler loggingHandler = this.myLogManager.addAdditionalLog(pipeName);
        loggingHandler.attachToProcess(new ProcessHandler(){

            protected void destroyProcessImpl() {
            }

            protected void detachProcessImpl() {
            }

            public boolean detachIsDefault() {
                return false;
            }

            @Nullable
            public OutputStream getProcessInput() {
                return consoleInput;
            }
        });
        return new LogListener(){

            public void lineLogged(String line) {
                loggingHandler.print(line);
            }
        };
    }

    public boolean isTtySupported() {
        return this.myLogManager.isTtySupported();
    }

    public TerminalListener createTerminal(String pipeName, OutputStream terminalInput, InputStream terminalOutput, InputStream stderr) {
        final TerminalHandler terminalHandler = this.myLogManager.addTerminal(pipeName, terminalOutput, terminalInput);
        return new TerminalListener(){

            public void close() {
                terminalHandler.close();
            }
        };
    }

    private static class LogListenerImpl
    implements LogListener {
        private final LoggingHandler myLoggingHandler;

        public LogListenerImpl(LoggingHandler loggingHandler) {
            this.myLoggingHandler = loggingHandler;
        }

        public void lineLogged(String line) {
            this.myLoggingHandler.print(line + "\n");
        }

        public void clear() {
            this.myLoggingHandler.clear();
        }
    }
}

