/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.Getter;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.SwingHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.function.BiFunction;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;

public interface ReadonlyFieldWithHistoryWithBrowseButton {
    public JComponent getComponent();

    public void set(@NotNull String var1);

    @NotNull
    public String get();

    public void addListener(Runnable var1);

    public void setPreferredWidthToFitText();

    public static class Builder {
        private BiFunction<ActionEvent, String, String> myActionListener;
        private Getter<List<String>> myHistoryProvider;
        private Convertor<TextFieldWithHistory, ListCellRenderer> myRendererCreator;

        public Builder withRenderer(@NotNull Convertor<TextFieldWithHistory, ListCellRenderer> convertor) {
            if (convertor == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myRendererCreator = convertor;
            return this;
        }

        public Builder withHistoryProvider(@NotNull Getter<List<String>> provider) {
            if (provider == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myHistoryProvider = provider;
            return this;
        }

        public Builder withActionListener(@NotNull BiFunction<ActionEvent, String, String> listener2) {
            if (listener2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myActionListener = listener2;
            return this;
        }

        public ReadonlyFieldWithHistoryWithBrowseButton build() {
            ListCellRenderer renderer;
            TextFieldWithHistoryWithBrowseButton field = new TextFieldWithHistoryWithBrowseButton();
            final TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)field.getChildComponent();
            textFieldWithHistory.setHistorySize(-1);
            textFieldWithHistory.setMinimumAndPreferredWidth(0);
            textFieldWithHistory.setEditable(false);
            ReadonlyFieldWithHistoryWithBrowseButton wrapper2 = Builder.createReadonlyFieldWrapper(field);
            if (this.myActionListener != null) {
                field.getButton().addActionListener(e -> {
                    String value = this.myActionListener.apply(e, wrapper2.get());
                    if (value != null) {
                        wrapper2.set(value);
                    }
                });
            }
            if (this.myHistoryProvider != null) {
                textFieldWithHistory.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        SwingHelper.setHistory(textFieldWithHistory, ContainerUtil.notNullize((List)((List)myHistoryProvider.get())), false);
                    }
                });
            }
            if (this.myRendererCreator != null && (renderer = (ListCellRenderer)this.myRendererCreator.convert((Object)textFieldWithHistory)) != null) {
                textFieldWithHistory.setRenderer(renderer);
            }
            return wrapper2;
        }

        @NotNull
        public static ReadonlyFieldWithHistoryWithBrowseButton createReadonlyFieldWrapper(final TextFieldWithHistoryWithBrowseButton field) {
            ReadonlyFieldWithHistoryWithBrowseButton readonlyFieldWithHistoryWithBrowseButton = new ReadonlyFieldWithHistoryWithBrowseButton(){

                @Override
                public JComponent getComponent() {
                    return field;
                }

                @Override
                public void set(@NotNull String text2) {
                    TextFieldWithHistory component;
                    if (text2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!(component = (TextFieldWithHistory)field.getChildComponent()).getHistory().contains(text2)) {
                        component.setTextAndAddToHistory(text2);
                    }
                    component.setSelectedItem((Object)text2);
                }

                @Override
                @NotNull
                public String get() {
                    Object item = ((TextFieldWithHistory)field.getChildComponent()).getSelectedItem();
                    String string = item == null ? "" : item.toString().trim();
                    if (string == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                @Override
                public void addListener(final Runnable listener2) {
                    ((TextFieldWithHistory)field.getChildComponent()).addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            listener2.run();
                        }
                    });
                }

                @Override
                public void setPreferredWidthToFitText() {
                    SwingHelper.setPreferredWidthToFitText(field);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "text";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/util/ui/ReadonlyFieldWithHistoryWithBrowseButton$Builder$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/util/ui/ReadonlyFieldWithHistoryWithBrowseButton$Builder$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "get";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "set";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            if (readonlyFieldWithHistoryWithBrowseButton == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return readonlyFieldWithHistoryWithBrowseButton;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "convertor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/ReadonlyFieldWithHistoryWithBrowseButton$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/ReadonlyFieldWithHistoryWithBrowseButton$Builder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createReadonlyFieldWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "withRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "withHistoryProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "withActionListener";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

