/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.util.ReflectionAssignabilityCache;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.ImplementationClassCache;
import com.intellij.util.xml.impl.InvocationCache;
import com.intellij.util.xml.impl.StaticGenericInfo;
import com.intellij.util.xml.impl.VisitorDescription;
import gnu.trove.THashSet;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DomApplicationComponent {
    private final Map<String, Set<DomFileDescription>> myRootTagName2FileDescription = FactoryMap.create(key -> new THashSet());
    private final Set<DomFileDescription> myAcceptingOtherRootTagNamesDescriptions = new THashSet();
    private final ImplementationClassCache myCachedImplementationClasses = new ImplementationClassCache(DomImplementationClassEP.EP_NAME);
    private final TypeChooserManager myTypeChooserManager = new TypeChooserManager();
    final ReflectionAssignabilityCache assignabilityCache = new ReflectionAssignabilityCache();
    private final Map<Class, DomElementsAnnotator> myClass2Annotator = ConcurrentFactoryMap.createMap(key -> {
        DomFileDescription desc = this.findFileDescription((Class)key);
        return desc == null ? null : desc.createAnnotator();
    });
    private final Map<Class, StaticGenericInfo> myGenericInfos = ConcurrentFactoryMap.createMap(StaticGenericInfo::new, ContainerUtil::createConcurrentSoftValueMap);
    private final Map<Class, InvocationCache> myInvocationCaches = ConcurrentFactoryMap.createMap(InvocationCache::new, ContainerUtil::createConcurrentSoftValueMap);
    private final Map<Class<? extends DomElementVisitor>, VisitorDescription> myVisitorDescriptions = ConcurrentFactoryMap.createMap(VisitorDescription::new);

    public DomApplicationComponent() {
        for (DomFileDescription description : (DomFileDescription[])Extensions.getExtensions((ExtensionPointName)DomFileDescription.EP_NAME)) {
            this.registerFileDescription(description);
        }
    }

    public static DomApplicationComponent getInstance() {
        return (DomApplicationComponent)ServiceManager.getService(DomApplicationComponent.class);
    }

    public int getCumulativeVersion(boolean forStubs) {
        int result2 = 0;
        for (DomFileDescription description : this.getAllFileDescriptions()) {
            if (forStubs) {
                if (!description.hasStubs()) continue;
                result2 += description.getStubVersion();
                result2 += description.getRootTagName().hashCode();
                continue;
            }
            result2 += description.getVersion();
            result2 += description.getRootTagName().hashCode();
        }
        return result2;
    }

    public final synchronized Set<DomFileDescription> getFileDescriptions(String rootTagName) {
        return this.myRootTagName2FileDescription.get(rootTagName);
    }

    public final synchronized Set<DomFileDescription> getAcceptingOtherRootTagNameDescriptions() {
        return this.myAcceptingOtherRootTagNamesDescriptions;
    }

    public final synchronized void registerFileDescription(DomFileDescription description) {
        this.myRootTagName2FileDescription.get(description.getRootTagName()).add(description);
        if (description.acceptsOtherRootTagNames()) {
            this.myAcceptingOtherRootTagNamesDescriptions.add(description);
        }
        Map implementations = description.getImplementations();
        for (Map.Entry entry : implementations.entrySet()) {
            this.registerImplementation((Class)entry.getKey(), (Class)entry.getValue(), null);
        }
        this.myTypeChooserManager.copyFrom(description.getTypeChooserManager());
    }

    public synchronized List<DomFileDescription> getAllFileDescriptions() {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (Set<DomFileDescription> descriptions : this.myRootTagName2FileDescription.values()) {
            result2.addAll(descriptions);
        }
        result2.addAll(this.myAcceptingOtherRootTagNamesDescriptions);
        return result2;
    }

    @Nullable
    private synchronized DomFileDescription findFileDescription(Class rootElementClass) {
        for (Set<DomFileDescription> descriptions : this.myRootTagName2FileDescription.values()) {
            for (DomFileDescription description : descriptions) {
                if (description.getRootElementClass() != rootElementClass) continue;
                return description;
            }
        }
        for (DomFileDescription description : this.myAcceptingOtherRootTagNamesDescriptions) {
            if (description.getRootElementClass() != rootElementClass) continue;
            return description;
        }
        return null;
    }

    public DomElementsAnnotator getAnnotator(Class rootElementClass) {
        return this.myClass2Annotator.get(rootElementClass);
    }

    @Nullable
    final Class<? extends DomElement> getImplementation(Class concreteInterface) {
        return this.myCachedImplementationClasses.get(concreteInterface);
    }

    public final void registerImplementation(Class<? extends DomElement> domElementClass, Class<? extends DomElement> implementationClass, @Nullable Disposable parentDisposable) {
        this.myCachedImplementationClasses.registerImplementation(domElementClass, implementationClass, parentDisposable);
    }

    public TypeChooserManager getTypeChooserManager() {
        return this.myTypeChooserManager;
    }

    public final StaticGenericInfo getStaticGenericInfo(Type type) {
        return this.myGenericInfos.get(ReflectionUtil.getRawType((Type)type));
    }

    final InvocationCache getInvocationCache(Class type) {
        return this.myInvocationCaches.get(type);
    }

    public final VisitorDescription getVisitorDescription(Class<? extends DomElementVisitor> aClass) {
        return this.myVisitorDescriptions.get(aClass);
    }
}

