/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphBuilder;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import com.intellij.vcs.log.graph.utils.impl.IntTimestampGetter;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SimpleGraphInfo<CommitId>
implements PermanentGraphInfo<CommitId> {
    @NotNull
    private final LinearGraph myLinearGraph;
    @NotNull
    private final GraphLayout myGraphLayout;
    @NotNull
    private final NotNullFunction<Integer, CommitId> myFunction;
    @NotNull
    private final TimestampGetter myTimestampGetter;
    @NotNull
    private final Set<Integer> myBranchNodeIds;

    private SimpleGraphInfo(@NotNull LinearGraph linearGraph, @NotNull GraphLayout graphLayout, @NotNull NotNullFunction<Integer, CommitId> function, @NotNull TimestampGetter timestampGetter, @NotNull Set<Integer> branchNodeIds) {
        if (linearGraph == null) {
            SimpleGraphInfo.$$$reportNull$$$0(0);
        }
        if (graphLayout == null) {
            SimpleGraphInfo.$$$reportNull$$$0(1);
        }
        if (function == null) {
            SimpleGraphInfo.$$$reportNull$$$0(2);
        }
        if (timestampGetter == null) {
            SimpleGraphInfo.$$$reportNull$$$0(3);
        }
        if (branchNodeIds == null) {
            SimpleGraphInfo.$$$reportNull$$$0(4);
        }
        this.myLinearGraph = linearGraph;
        this.myGraphLayout = graphLayout;
        this.myFunction = function;
        this.myTimestampGetter = timestampGetter;
        this.myBranchNodeIds = branchNodeIds;
    }

    public static <CommitId> SimpleGraphInfo<CommitId> build(@NotNull LinearGraph linearGraph, @NotNull GraphLayout oldLayout, @NotNull PermanentCommitsInfo<CommitId> permanentCommitsInfo, int permanentGraphSize, @NotNull Set<Integer> branchNodeIds, int visibleRow, int visibleRange) {
        if (linearGraph == null) {
            SimpleGraphInfo.$$$reportNull$$$0(5);
        }
        if (oldLayout == null) {
            SimpleGraphInfo.$$$reportNull$$$0(6);
        }
        if (permanentCommitsInfo == null) {
            SimpleGraphInfo.$$$reportNull$$$0(7);
        }
        if (branchNodeIds == null) {
            SimpleGraphInfo.$$$reportNull$$$0(8);
        }
        int start = Math.max(0, visibleRow - visibleRange);
        int end = Math.min(linearGraph.nodesCount(), start + 2 * visibleRange);
        ArrayList graphCommits = ContainerUtil.newArrayListWithCapacity((int)(end - start));
        ArrayList commitsIdMap = ContainerUtil.newArrayListWithCapacity((int)(end - start));
        for (int row = start; row < end; ++row) {
            int nodeId = linearGraph.getNodeId(row);
            CommitId commit = permanentCommitsInfo.getCommitId(nodeId);
            List parents = ContainerUtil.newSmartList();
            parents.addAll(ContainerUtil.mapNotNull(LinearGraphUtils.asLiteLinearGraph(linearGraph).getNodes(row, LiteLinearGraph.NodeFilter.DOWN), row1 -> {
                if (permanentCommitsInfo == null) {
                    SimpleGraphInfo.$$$reportNull$$$0(18);
                }
                if (linearGraph == null) {
                    SimpleGraphInfo.$$$reportNull$$$0(19);
                }
                if (row1 < start || row1 >= end) {
                    return null;
                }
                return permanentCommitsInfo.getCommitId(linearGraph.getNodeId((int)row1));
            }));
            graphCommits.add(GraphCommitImpl.createCommit(commit, parents, permanentCommitsInfo.getTimestamp(nodeId)));
            commitsIdMap.add(commit);
        }
        IntTimestampGetter timestampGetter = PermanentCommitsInfoImpl.createTimestampGetter(graphCommits);
        NotNullFunction<Integer, CommitId> commitIdMapping = SimpleGraphInfo.createCommitIdMapFunction(commitsIdMap);
        PermanentLinearGraphImpl newLinearGraph = PermanentLinearGraphBuilder.newInstance(graphCommits).build();
        int[] layoutIndexes = new int[end - start];
        ArrayList headNodeIndexes = ContainerUtil.newArrayList();
        TObjectIntHashMap<CommitId> commitIdToInteger = SimpleGraphInfo.reverseCommitIdMap(permanentCommitsInfo, permanentGraphSize);
        for (int row = start; row < end; ++row) {
            int layoutIndex;
            Object commitId = commitsIdMap.get(row - start);
            layoutIndexes[row - start] = layoutIndex = oldLayout.getLayoutIndex(commitIdToInteger.get(commitId));
            if (!LinearGraphUtils.asLiteLinearGraph(newLinearGraph).getNodes(row - start, LiteLinearGraph.NodeFilter.UP).isEmpty()) continue;
            headNodeIndexes.add(row - start);
        }
        ContainerUtil.sort((List)headNodeIndexes, Comparator.comparingInt(o -> layoutIndexes[o]));
        int[] starts = new int[headNodeIndexes.size()];
        for (int i = 0; i < starts.length; ++i) {
            starts[i] = layoutIndexes[(Integer)headNodeIndexes.get(i)];
        }
        GraphLayoutImpl newLayout = new GraphLayoutImpl(layoutIndexes, headNodeIndexes, starts);
        return new SimpleGraphInfo<CommitId>(newLinearGraph, newLayout, commitIdMapping, timestampGetter, LinearGraphUtils.convertIdsToNodeIndexes(linearGraph, branchNodeIds));
    }

    @NotNull
    private static <CommitId> NotNullFunction<Integer, CommitId> createCommitIdMapFunction(@NotNull List<CommitId> commitsIdMap) {
        if (commitsIdMap == null) {
            SimpleGraphInfo.$$$reportNull$$$0(9);
        }
        if (!commitsIdMap.isEmpty() && commitsIdMap.get(0) instanceof Integer) {
            int[] ints = new int[commitsIdMap.size()];
            for (int row = 0; row < commitsIdMap.size(); ++row) {
                ints[row] = (Integer)commitsIdMap.get(row);
            }
            IntegerCommitIdMapFunction integerCommitIdMapFunction = new IntegerCommitIdMapFunction(CompressedIntList.newInstance(ints));
            if (integerCommitIdMapFunction == null) {
                SimpleGraphInfo.$$$reportNull$$$0(10);
            }
            return integerCommitIdMapFunction;
        }
        CommitIdMapFunction<CommitId> commitIdMapFunction = new CommitIdMapFunction<CommitId>(commitsIdMap);
        if (commitIdMapFunction == null) {
            SimpleGraphInfo.$$$reportNull$$$0(11);
        }
        return commitIdMapFunction;
    }

    @NotNull
    private static <CommitId> TObjectIntHashMap<CommitId> reverseCommitIdMap(@NotNull PermanentCommitsInfo<CommitId> permanentCommitsInfo, int size) {
        if (permanentCommitsInfo == null) {
            SimpleGraphInfo.$$$reportNull$$$0(12);
        }
        TObjectIntHashMap result2 = new TObjectIntHashMap();
        for (int i = 0; i < size; ++i) {
            result2.put(permanentCommitsInfo.getCommitId(i), i);
        }
        TObjectIntHashMap tObjectIntHashMap = result2;
        if (tObjectIntHashMap == null) {
            SimpleGraphInfo.$$$reportNull$$$0(13);
        }
        return tObjectIntHashMap;
    }

    @Override
    @NotNull
    public PermanentCommitsInfo<CommitId> getPermanentCommitsInfo() {
        PermanentCommitsInfo permanentCommitsInfo = new PermanentCommitsInfo<CommitId>(){

            @Override
            @NotNull
            public CommitId getCommitId(int nodeId) {
                Object object = SimpleGraphInfo.this.myFunction.fun((Object)nodeId);
                if (object == null) {
                    1.$$$reportNull$$$0(0);
                }
                return object;
            }

            @Override
            public long getTimestamp(int nodeId) {
                return SimpleGraphInfo.this.myTimestampGetter.getTimestamp(nodeId);
            }

            @Override
            public int getNodeId(@NotNull CommitId commitId) {
                if (commitId == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (int id = 0; id < SimpleGraphInfo.this.myLinearGraph.nodesCount(); ++id) {
                    if (!SimpleGraphInfo.this.myFunction.fun((Object)id).equals(commitId)) continue;
                    return id;
                }
                return -1;
            }

            @Override
            @NotNull
            public Set<Integer> convertToNodeIds(@NotNull Collection<CommitId> heads) {
                if (heads == null) {
                    1.$$$reportNull$$$0(2);
                }
                HashSet result2 = ContainerUtil.newHashSet();
                for (int id = 0; id < SimpleGraphInfo.this.myLinearGraph.nodesCount(); ++id) {
                    if (!heads.contains(SimpleGraphInfo.this.myFunction.fun((Object)id))) continue;
                    result2.add(id);
                }
                HashSet hashSet = result2;
                if (hashSet == null) {
                    1.$$$reportNull$$$0(3);
                }
                return hashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "commitId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "heads";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCommitId";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convertToNodeIds";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getNodeId";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "convertToNodeIds";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (permanentCommitsInfo == null) {
            SimpleGraphInfo.$$$reportNull$$$0(14);
        }
        return permanentCommitsInfo;
    }

    @Override
    @NotNull
    public LinearGraph getLinearGraph() {
        LinearGraph linearGraph = this.myLinearGraph;
        if (linearGraph == null) {
            SimpleGraphInfo.$$$reportNull$$$0(15);
        }
        return linearGraph;
    }

    @Override
    @NotNull
    public GraphLayout getPermanentGraphLayout() {
        GraphLayout graphLayout = this.myGraphLayout;
        if (graphLayout == null) {
            SimpleGraphInfo.$$$reportNull$$$0(16);
        }
        return graphLayout;
    }

    @Override
    @NotNull
    public Set<Integer> getBranchNodeIds() {
        Set<Integer> set2 = this.myBranchNodeIds;
        if (set2 == null) {
            SimpleGraphInfo.$$$reportNull$$$0(17);
        }
        return set2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearGraph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphLayout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestampGetter";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchNodeIds";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldLayout";
                break;
            }
            case 7: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentCommitsInfo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitsIdMap";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitIdMapFunction";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseCommitIdMap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermanentCommitsInfo";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinearGraph";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermanentGraphLayout";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchNodeIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCommitIdMapFunction";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reverseCommitIdMap";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$build$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IntegerCommitIdMapFunction
    implements NotNullFunction<Integer, Integer> {
        private final IntList myCommitsIdMap;

        public IntegerCommitIdMapFunction(IntList commitsIdMap) {
            this.myCommitsIdMap = commitsIdMap;
        }

        @NotNull
        public Integer fun(Integer dom) {
            Integer n = this.myCommitsIdMap.get(dom);
            if (n == null) {
                IntegerCommitIdMapFunction.$$$reportNull$$$0(0);
            }
            return n;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo$IntegerCommitIdMapFunction", "fun"));
        }
    }

    private static class CommitIdMapFunction<CommitId>
    implements NotNullFunction<Integer, CommitId> {
        private final List<CommitId> myCommitsIdMap;

        public CommitIdMapFunction(List<CommitId> commitsIdMap) {
            this.myCommitsIdMap = commitsIdMap;
        }

        @NotNull
        public CommitId fun(Integer dom) {
            CommitId CommitId2 = this.myCommitsIdMap.get(dom);
            if (CommitId2 == null) {
                CommitIdMapFunction.$$$reportNull$$$0(0);
            }
            return CommitId2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo$CommitIdMapFunction", "fun"));
        }
    }
}

