/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyChangeSignatureQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyInitNewSignatureInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.new.init.signature", new Object[0]);
        if (string == null) {
            PyInitNewSignatureInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyInitNewSignatureInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PyInitNewSignatureInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyInitNewSignatureInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyInitNewSignatureInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyInitNewSignatureInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
            if (session2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session2);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            String functionName = node.getName();
            if (!"__new__".equals(functionName) && !"__init__".equals(functionName)) {
                return;
            }
            PyClass cls = node.getContainingClass();
            if (cls == null || !cls.isNewStyleClass(this.myTypeEvalContext)) {
                return;
            }
            List<PyFunction> complementaryMethods = this.findComplementaryMethods(cls, node);
            for (PyFunction complementaryMethod : complementaryMethods) {
                if (!PyUtil.isSignatureCompatibleTo(complementaryMethod, node, this.myTypeEvalContext) && !PyUtil.isSignatureCompatibleTo(node, complementaryMethod, this.myTypeEvalContext)) continue;
                return;
            }
            if (complementaryMethods.size() == 1) {
                this.registerIncompatibilityProblem(node, (LocalQuickFix)PyChangeSignatureQuickFix.forMismatchingMethods(node, complementaryMethods.get(0)));
            } else if (!complementaryMethods.isEmpty()) {
                this.registerIncompatibilityProblem(node, null);
            }
        }

        @NotNull
        private List<PyFunction> findComplementaryMethods(@NotNull PyClass cls, @NotNull PyFunction original) {
            if (cls == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (original == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            String complementaryName = "__new__".equals(original.getName()) ? "__init__" : "__new__";
            List<PyFunction> complementaryMethods = cls.multiFindMethodByName(complementaryName, true, this.myTypeEvalContext);
            for (PyFunction complementaryMethod : complementaryMethods) {
                PyClass complementaryMethodClass = complementaryMethod.getContainingClass();
                if (complementaryMethodClass != null && !PyUtil.isObjectClass(complementaryMethodClass) && !ContainerUtil.exists((Object[])Extensions.getExtensions(PyInspectionExtension.EP_NAME), extension -> {
                    if (original == null) {
                        Visitor.$$$reportNull$$$0(6);
                    }
                    return extension.ignoreInitNewSignatures(original, complementaryMethod);
                })) continue;
                List<PyFunction> list2 = Collections.emptyList();
                if (list2 == null) {
                    Visitor.$$$reportNull$$$0(3);
                }
                return list2;
            }
            List<PyFunction> list3 = complementaryMethods;
            if (list3 == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            return list3;
        }

        private void registerIncompatibilityProblem(@NotNull PyFunction function, @Nullable LocalQuickFix quickFix) {
            if (function == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            PyParameterList parameterList = function.getParameterList();
            String message = PyBundle.message("__new__".equals(function.getName()) ? "INSP.new.incompatible.to.init" : "INSP.init.incompatible.to.new", new Object[0]);
            if (quickFix != null) {
                this.registerProblem((PsiElement)parameterList, message, quickFix);
            } else {
                this.registerProblem((PsiElement)parameterList, message);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cls";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInitNewSignatureInspection$Visitor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInitNewSignatureInspection$Visitor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findComplementaryMethods";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findComplementaryMethods";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "registerIncompatibilityProblem";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$findComplementaryMethods$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

