/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import org.jetbrains.annotations.NotNull;

public abstract class RenamePyElementProcessor
extends RenamePsiElementProcessor {
    @Override
    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        PyElement container;
        if (element == null) {
            RenamePyElementProcessor.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            RenamePyElementProcessor.$$$reportNull$$$0(1);
        }
        if (conflicts == null) {
            RenamePyElementProcessor.$$$reportNull$$$0(2);
        }
        if ((container = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, ScopeOwner.class)) instanceof PyFile) {
            PyTargetExpression conflictingVariable;
            PyFunction conflictingFunction;
            PyFile pyFile = (PyFile)container;
            PyClass conflictingClass = pyFile.findTopLevelClass(newName);
            if (conflictingClass != null) {
                conflicts.putValue((Object)conflictingClass, (Object)("A class named '" + newName + "' is already defined in " + pyFile.getName()));
            }
            if ((conflictingFunction = pyFile.findTopLevelFunction(newName)) != null) {
                conflicts.putValue((Object)conflictingFunction, (Object)("A function named '" + newName + "' is already defined in " + pyFile.getName()));
            }
            if ((conflictingVariable = pyFile.findTopLevelAttribute(newName)) != null) {
                conflicts.putValue((Object)conflictingFunction, (Object)("A variable named '" + newName + "' is already defined in " + pyFile.getName()));
            }
        } else if (container instanceof PyClass) {
            PyTargetExpression conflictingAttribute;
            PyFunction conflictingFunction;
            PyClass pyClass = (PyClass)container;
            PyClass conflictingClass = pyClass.findNestedClass(newName, true);
            if (conflictingClass != null) {
                conflicts.putValue((Object)conflictingClass, (Object)("A class named '" + newName + "' is already defined in class '" + pyClass.getName() + "'"));
            }
            if ((conflictingFunction = pyClass.findMethodByName(newName, true, null)) != null) {
                conflicts.putValue((Object)conflictingFunction, (Object)("A function named '" + newName + "' is already defined in class '" + pyClass.getName() + "'"));
            }
            if ((conflictingAttribute = pyClass.findClassAttribute(newName, true, null)) != null) {
                conflicts.putValue((Object)conflictingAttribute, (Object)("An attribute named '" + newName + "' is already defined in class '" + pyClass.getName() + "'"));
            }
        }
    }

    @Override
    public String getHelpID(PsiElement element) {
        return "refactoring.renameDialogs";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "newName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "conflicts";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/refactoring/rename/RenamePyElementProcessor";
        objectArray[2] = "findExistingNameConflicts";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

