/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.MessageDecoder;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.FastCgiService;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "parseHeaders", "", "response", "Lio/netty/handler/codec/http/HttpResponse;", "buffer", "Lio/netty/buffer/ByteBuf;", "sendBadGateway", "channel", "Lio/netty/channel/Channel;", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "intellij.platform.builtInServer.impl"})
public final class FastCgiServiceKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final void sendBadGateway(Channel channel, HttpHeaders extraHeaders) {
        try {
            if (channel.isActive()) {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_GATEWAY;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.BAD_GATEWAY");
                Responses.send$default(httpResponseStatus, channel, null, null, extraHeaders, 6, null);
            }
        }
        catch (Throwable e) {
            NettyUtil.log(e, LOG);
        }
    }

    private static final void parseHeaders(HttpResponse response, ByteBuf buffer) {
        StringBuilder builder2 = new StringBuilder();
        while (buffer.isReadable()) {
            String value;
            byte b22;
            builder2.setLength(0);
            String key = null;
            boolean valueExpected = true;
            while ((b22 = buffer.readByte()) >= 0 && (char)b22 != '\n') {
                if ((char)b22 == '\r') continue;
                if (valueExpected && (char)b22 == ':') {
                    valueExpected = false;
                    key = builder2.toString();
                    builder2.setLength(0);
                    MessageDecoder.skipWhitespace(buffer);
                    continue;
                }
                builder2.append((char)b22);
            }
            CharSequence b22 = builder2;
            if (b22.length() == 0) {
                return;
            }
            b22 = key;
            if (b22 == null || b22.length() == 0) continue;
            String string = key;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.startsWith((String)string, (String)"http", (boolean)true) || StringsKt.startsWith((String)key, (String)"X-Accel-", (boolean)true)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder2.toString(), (String)"builder.toString()");
            if (StringsKt.equals((String)key, (String)"status", (boolean)true)) {
                String string2;
                int index = StringsKt.indexOf$default((CharSequence)value, (char)' ', (int)0, (boolean)false, (int)6, null);
                if (index == -1) {
                    LOG.warn("Cannot parse status: " + value);
                    response.setStatus(HttpResponseStatus.OK);
                    continue;
                }
                String string3 = value;
                int n = 0;
                HttpResponse httpResponse = response;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(n, index), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                httpResponse.setStatus(HttpResponseStatus.valueOf((int)Integer.parseInt(string2)));
                continue;
            }
            if (StringsKt.startsWith$default((String)key, (String)"http", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)key, (String)"HTTP", (boolean)false, (int)2, null)) continue;
            response.headers().add(key, (Object)value);
        }
    }

    static {
        Logger logger = Logger.getInstance(FastCgiService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$sendBadGateway(@NotNull Channel channel, @NotNull HttpHeaders extraHeaders) {
        FastCgiServiceKt.sendBadGateway(channel, extraHeaders);
    }

    public static final /* synthetic */ void access$parseHeaders(@NotNull HttpResponse response, @NotNull ByteBuf buffer) {
        FastCgiServiceKt.parseHeaders(response, buffer);
    }
}

