/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.datatypes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hsmf.datatypes.ChunkGroup;
import org.apache.poi.hsmf.datatypes.PropertiesChunk;
import org.apache.poi.util.LittleEndian;

public class MessagePropertiesChunk
extends PropertiesChunk {
    private long nextRecipientId;
    private long nextAttachmentId;
    private long recipientCount;
    private long attachmentCount;

    public MessagePropertiesChunk(ChunkGroup parentGroup) {
        super(parentGroup);
    }

    public long getNextRecipientId() {
        return this.nextRecipientId;
    }

    public long getNextAttachmentId() {
        return this.nextAttachmentId;
    }

    public long getRecipientCount() {
        return this.recipientCount;
    }

    public long getAttachmentCount() {
        return this.attachmentCount;
    }

    @Override
    public void readValue(InputStream stream) throws IOException {
        LittleEndian.readLong((InputStream)stream);
        this.nextRecipientId = LittleEndian.readUInt((InputStream)stream);
        this.nextAttachmentId = LittleEndian.readUInt((InputStream)stream);
        this.recipientCount = LittleEndian.readUInt((InputStream)stream);
        this.attachmentCount = LittleEndian.readUInt((InputStream)stream);
        LittleEndian.readLong((InputStream)stream);
        this.readProperties(stream);
    }

    @Override
    public void writeValue(OutputStream out) throws IOException {
        out.write(new byte[8]);
        LittleEndian.putUInt((long)this.nextRecipientId, (OutputStream)out);
        LittleEndian.putUInt((long)this.nextAttachmentId, (OutputStream)out);
        LittleEndian.putUInt((long)this.recipientCount, (OutputStream)out);
        LittleEndian.putUInt((long)this.attachmentCount, (OutputStream)out);
        out.write(new byte[8]);
        this.writeProperties(out);
    }
}

