/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.ko.KoreanTokenizer;
import org.apache.lucene.analysis.ko.dict.UserDictionary;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.IOUtils;

public class KoreanTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware {
    private static final String USER_DICT_PATH = "userDictionary";
    private static final String USER_DICT_ENCODING = "userDictionaryEncoding";
    private static final String DECOMPOUND_MODE = "decompoundMode";
    private static final String OUTPUT_UNKNOWN_UNIGRAMS = "outputUnknownUnigrams";
    private final String userDictionaryPath;
    private final String userDictionaryEncoding;
    private UserDictionary userDictionary;
    private final KoreanTokenizer.DecompoundMode mode;
    private final boolean outputUnknownUnigrams;

    public KoreanTokenizerFactory(Map<String, String> args) {
        super(args);
        this.userDictionaryPath = args.remove(USER_DICT_PATH);
        this.userDictionaryEncoding = args.remove(USER_DICT_ENCODING);
        this.mode = KoreanTokenizer.DecompoundMode.valueOf(this.get(args, DECOMPOUND_MODE, KoreanTokenizer.DEFAULT_DECOMPOUND.toString()).toUpperCase(Locale.ROOT));
        this.outputUnknownUnigrams = this.getBoolean(args, OUTPUT_UNKNOWN_UNIGRAMS, false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public void inform(ResourceLoader loader) throws IOException {
        if (this.userDictionaryPath != null) {
            try (InputStream stream = loader.openResource(this.userDictionaryPath);){
                String encoding = this.userDictionaryEncoding;
                if (encoding == null) {
                    encoding = IOUtils.UTF_8;
                }
                CharsetDecoder decoder = Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                InputStreamReader reader = new InputStreamReader(stream, decoder);
                this.userDictionary = UserDictionary.open(reader);
            }
        } else {
            this.userDictionary = null;
        }
    }

    public KoreanTokenizer create(AttributeFactory factory) {
        return new KoreanTokenizer(factory, this.userDictionary, this.mode, this.outputUnknownUnigrams);
    }
}

