/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.morfologik;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.morfologik.MorphosyntacticTagsAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class MorphosyntacticTagsAttributeImpl
extends AttributeImpl
implements MorphosyntacticTagsAttribute,
Cloneable {
    private List<StringBuilder> tags;

    @Override
    public List<StringBuilder> getTags() {
        return this.tags;
    }

    @Override
    public void clear() {
        this.tags = null;
    }

    public boolean equals(Object other) {
        if (other instanceof MorphosyntacticTagsAttribute) {
            return this.equal(this.getTags(), ((MorphosyntacticTagsAttribute)other).getTags());
        }
        return false;
    }

    private boolean equal(Object l1, Object l2) {
        return l1 == null ? l2 == null : l1.equals(l2);
    }

    public int hashCode() {
        return this.tags == null ? 0 : this.tags.hashCode();
    }

    @Override
    public void setTags(List<StringBuilder> tags) {
        this.tags = tags;
    }

    public void copyTo(AttributeImpl target) {
        ArrayList<StringBuilder> cloned = null;
        if (this.tags != null) {
            cloned = new ArrayList<StringBuilder>(this.tags.size());
            for (StringBuilder b : this.tags) {
                cloned.add(new StringBuilder(b));
            }
        }
        ((MorphosyntacticTagsAttribute)target).setTags(cloned);
    }

    public MorphosyntacticTagsAttributeImpl clone() {
        MorphosyntacticTagsAttributeImpl cloned = new MorphosyntacticTagsAttributeImpl();
        this.copyTo(cloned);
        return cloned;
    }

    public void reflectWith(AttributeReflector reflector) {
        reflector.reflect(MorphosyntacticTagsAttribute.class, "tags", this.tags);
    }
}

