/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace;

import java.lang.reflect.Constructor;
import org.apache.htrace.HTraceConfiguration;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.commons.logging.Log;
import org.apache.htrace.commons.logging.LogFactory;

public class SpanReceiverBuilder {
    static final Log LOG = LogFactory.getLog(SpanReceiverBuilder.class);
    public static final String SPAN_RECEIVER_CONF_KEY = "span.receiver";
    private static final String DEFAULT_PACKAGE = "org.apache.htrace.impl";
    private static final ClassLoader classLoader = SpanReceiverBuilder.class.getClassLoader();
    private final HTraceConfiguration conf;
    private boolean logErrors;
    private String spanReceiverClass;

    public SpanReceiverBuilder(HTraceConfiguration conf) {
        this.conf = conf;
        this.reset();
    }

    public SpanReceiverBuilder reset() {
        this.logErrors = true;
        this.spanReceiverClass = this.conf.get(SPAN_RECEIVER_CONF_KEY);
        return this;
    }

    public SpanReceiverBuilder spanReceiverClass(String spanReceiverClass) {
        this.spanReceiverClass = spanReceiverClass;
        return this;
    }

    public SpanReceiverBuilder logErrors(boolean logErrors) {
        this.logErrors = logErrors;
        return this;
    }

    private void logError(String errorStr) {
        if (!this.logErrors) {
            return;
        }
        LOG.error(errorStr);
    }

    private void logError(String errorStr, Throwable e) {
        if (!this.logErrors) {
            return;
        }
        LOG.error(errorStr, e);
    }

    public SpanReceiver build() {
        SpanReceiver spanReceiver = this.newSpanReceiver();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created new span receiver of type " + (spanReceiver == null ? "(none)" : spanReceiver.getClass().getName()));
        }
        return spanReceiver;
    }

    private SpanReceiver newSpanReceiver() {
        if (this.spanReceiverClass == null || this.spanReceiverClass.isEmpty()) {
            LOG.debug("No span receiver class specified.");
            return null;
        }
        String str = this.spanReceiverClass;
        if (!str.contains(".")) {
            str = "org.apache.htrace.impl." + str;
        }
        Class<?> cls = null;
        try {
            cls = classLoader.loadClass(str);
        }
        catch (ClassNotFoundException e) {
            this.logError("SpanReceiverBuilder cannot find SpanReceiver class " + str + ": disabling span receiver.");
            return null;
        }
        Constructor<?> ctor = null;
        try {
            ctor = cls.getConstructor(HTraceConfiguration.class);
        }
        catch (NoSuchMethodException e) {
            this.logError("SpanReceiverBuilder cannot find a constructor for class " + str + "which takes an HTraceConfiguration.  Disabling span " + "receiver.");
            return null;
        }
        try {
            LOG.debug("Creating new instance of " + str + "...");
            return (SpanReceiver)ctor.newInstance(this.conf);
        }
        catch (ReflectiveOperationException e) {
            this.logError("SpanReceiverBuilder reflection error when constructing " + str + ".  Disabling span receiver.", e);
            return null;
        }
        catch (Throwable e) {
            this.logError("SpanReceiverBuilder constructor error when constructing " + str + ".  Disabling span receiver.", e);
            return null;
        }
    }
}

