/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.CdcrLeaderStateManager;
import org.apache.solr.handler.CdcrParams;
import org.apache.solr.handler.CdcrProcessStateManager;
import org.apache.solr.handler.CdcrReplicatorScheduler;
import org.apache.solr.handler.CdcrReplicatorState;
import org.apache.solr.handler.CdcrRequestHandler;
import org.apache.solr.handler.CdcrStateManager;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.update.CdcrUpdateLog;
import org.apache.solr.util.TimeOut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CdcrReplicatorManager
implements CdcrStateManager.CdcrStateObserver {
    private static final int MAX_BOOTSTRAP_ATTEMPTS = 5;
    private static final int BOOTSTRAP_RETRY_DELAY_MS = 2000;
    private static final long BOOTSTRAP_TIMEOUT_SECONDS = 77760000L;
    private List<CdcrReplicatorState> replicatorStates;
    private final CdcrReplicatorScheduler scheduler;
    private CdcrProcessStateManager processStateManager;
    private CdcrLeaderStateManager leaderStateManager;
    private SolrCore core;
    private String path;
    private ExecutorService bootstrapExecutor;
    private volatile BootstrapStatusRunnable bootstrapStatusRunnable;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    CdcrReplicatorManager(SolrCore core, String path, SolrParams replicatorConfiguration, Map<String, List<SolrParams>> replicasConfiguration) {
        this.core = core;
        this.path = path;
        this.replicatorStates = new ArrayList<CdcrReplicatorState>();
        String myCollection = core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        List<SolrParams> targets = replicasConfiguration.get(myCollection);
        if (targets != null) {
            for (SolrParams params : targets) {
                String zkHost = params.get("zkHost");
                String targetCollection = params.get("target");
                CloudSolrClient client = new CloudSolrClient.Builder(Collections.singletonList(zkHost), Optional.empty()).sendUpdatesOnlyToShardLeaders().build();
                client.setDefaultCollection(targetCollection);
                this.replicatorStates.add(new CdcrReplicatorState(targetCollection, zkHost, client));
            }
        }
        this.scheduler = new CdcrReplicatorScheduler(this, replicatorConfiguration);
    }

    void setProcessStateManager(CdcrProcessStateManager processStateManager) {
        this.processStateManager = processStateManager;
        this.processStateManager.register(this);
    }

    void setLeaderStateManager(CdcrLeaderStateManager leaderStateManager) {
        this.leaderStateManager = leaderStateManager;
        this.leaderStateManager.register(this);
    }

    @Override
    public synchronized void stateUpdate() {
        if (this.leaderStateManager.amILeader() && this.processStateManager.getState().equals((Object)CdcrParams.ProcessState.STARTED)) {
            if (this.replicatorStates.size() > 0) {
                this.bootstrapExecutor = ExecutorUtil.newMDCAwareFixedThreadPool((int)this.replicatorStates.size(), (ThreadFactory)new SolrjNamedThreadFactory("cdcr-bootstrap-status"));
            }
            this.initLogReaders();
            this.scheduler.start();
            return;
        }
        this.scheduler.shutdown();
        if (this.bootstrapExecutor != null) {
            IOUtils.closeQuietly((Closeable)this.bootstrapStatusRunnable);
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.bootstrapExecutor);
        }
        this.closeLogReaders();
        Callable callable = this.core.getSolrCoreState().getCdcrBootstrapCallable();
        if (callable != null) {
            CdcrRequestHandler.BootstrapCallable bootstrapCallable = (CdcrRequestHandler.BootstrapCallable)callable;
            IOUtils.closeQuietly((Closeable)bootstrapCallable);
        }
    }

    List<CdcrReplicatorState> getReplicatorStates() {
        return this.replicatorStates;
    }

    private void initLogReaders() {
        String collectionName = this.core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        String shard = this.core.getCoreDescriptor().getCloudDescriptor().getShardId();
        CdcrUpdateLog ulog = (CdcrUpdateLog)this.core.getUpdateHandler().getUpdateLog();
        for (CdcrReplicatorState state : this.replicatorStates) {
            state.closeLogReader();
            try {
                long checkpoint = this.getCheckpoint(state);
                log.info("Create new update log reader for target {} with checkpoint {} @ {}:{}", new Object[]{state.getTargetCollection(), checkpoint, collectionName, shard});
                CdcrUpdateLog.CdcrLogReader reader = ulog.newLogReader();
                boolean seek = reader.seek(checkpoint);
                state.init(reader);
                if (seek) continue;
                String targetCollection = state.getTargetCollection();
                state.setBootstrapInProgress(true);
                log.info("Attempting to bootstrap target collection: {}, shard: {}", (Object)targetCollection, (Object)shard);
                this.bootstrapStatusRunnable = new BootstrapStatusRunnable(this.core, state);
                log.info("Submitting bootstrap task to executor");
                try {
                    this.bootstrapExecutor.submit(this.bootstrapStatusRunnable);
                }
                catch (Exception e) {
                    log.error("Unable to submit bootstrap call to executor", (Throwable)e);
                }
            }
            catch (IOException | SolrServerException | SolrException e) {
                log.warn("Unable to instantiate the log reader for target collection " + state.getTargetCollection(), e);
            }
            catch (InterruptedException e) {
                log.warn("Thread interrupted while instantiate the log reader for target collection " + state.getTargetCollection(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private long getCheckpoint(CdcrReplicatorState state) throws IOException, SolrServerException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CdcrParams.CdcrAction.COLLECTIONCHECKPOINT.toString()});
        QueryRequest request = new QueryRequest((SolrParams)params);
        request.setPath(this.path);
        NamedList response = state.getClient().request((SolrRequest)request);
        return (Long)response.get("checkpoint");
    }

    void closeLogReaders() {
        for (CdcrReplicatorState state : this.replicatorStates) {
            state.closeLogReader();
        }
    }

    void shutdown() {
        this.scheduler.shutdown();
        if (this.bootstrapExecutor != null) {
            IOUtils.closeQuietly((Closeable)this.bootstrapStatusRunnable);
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.bootstrapExecutor);
        }
        for (CdcrReplicatorState state : this.replicatorStates) {
            state.shutdown();
        }
        this.replicatorStates.clear();
    }

    private NamedList sendCdcrCommand(SolrClient client, CdcrParams.CdcrAction action, String ... params) throws SolrServerException, IOException {
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        solrParams.set("qt", new String[]{"/cdcr"});
        solrParams.set("action", new String[]{action.toString()});
        for (int i = 0; i < params.length - 1; i += 2) {
            solrParams.set(params[i], new String[]{params[i + 1]});
        }
        QueryRequest request = new QueryRequest((SolrParams)solrParams);
        return client.request((SolrRequest)request);
    }

    private void sendRequestRecoveryToFollowers(CdcrReplicatorState state) throws SolrServerException, IOException {
        Collection slices = state.getClient().getZkStateReader().getClusterState().getCollection(state.getTargetCollection()).getActiveSlices();
        for (Slice slice : slices) {
            Collection replicas = slice.getReplicas();
            for (Replica replica : replicas) {
                if (slice.getLeader().getCoreName().equals(replica.getCoreName())) continue;
                this.sendRequestRecoveryToFollower((SolrClient)state.getClient(), replica.getCoreName());
                log.info("RequestRecovery cmd is issued by core: " + replica.getCoreName() + " of shard: " + slice.getName() + "for target: " + state.getTargetCollection());
            }
        }
    }

    private NamedList sendRequestRecoveryToFollower(SolrClient client, String coreName) throws SolrServerException, IOException {
        CoreAdminRequest.RequestRecovery recoverRequestCmd = new CoreAdminRequest.RequestRecovery();
        recoverRequestCmd.setAction(CoreAdminParams.CoreAdminAction.REQUESTRECOVERY);
        recoverRequestCmd.setCoreName(coreName);
        return client.request((SolrRequest)recoverRequestCmd);
    }

    private static enum BootstrapStatus {
        SUBMITTED,
        RUNNING,
        COMPLETED,
        FAILED,
        NOTFOUND,
        CANCELLED,
        UNKNOWN;

    }

    private class BootstrapStatusRunnable
    implements Runnable,
    Closeable {
        private final CdcrReplicatorState state;
        private final String targetCollection;
        private final String shard;
        private final String collectionName;
        private final CdcrUpdateLog ulog;
        private final String myCoreUrl;
        private volatile boolean closed = false;

        BootstrapStatusRunnable(SolrCore core, CdcrReplicatorState state) {
            this.collectionName = core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
            this.shard = core.getCoreDescriptor().getCloudDescriptor().getShardId();
            this.ulog = (CdcrUpdateLog)core.getUpdateHandler().getUpdateLog();
            this.state = state;
            this.targetCollection = state.getTargetCollection();
            String baseUrl = core.getCoreContainer().getZkController().getBaseUrl();
            this.myCoreUrl = ZkCoreNodeProps.getCoreUrl((String)baseUrl, (String)core.getName());
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            try {
                Replica leader = this.state.getClient().getZkStateReader().getLeaderRetry(this.targetCollection, this.shard, 30000);
                String leaderCoreUrl = leader.getCoreUrl();
                HttpClient httpClient = this.state.getClient().getLbClient().getHttpClient();
                try (HttpSolrClient client = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(leaderCoreUrl).withHttpClient(httpClient)).build();){
                    CdcrReplicatorManager.this.sendCdcrCommand((SolrClient)client, CdcrParams.CdcrAction.CANCEL_BOOTSTRAP, new String[0]);
                }
                catch (SolrServerException e) {
                    log.error("Error sending cancel bootstrap message to target collection: {} shard: {} leader: {}", new Object[]{this.targetCollection, this.shard, leaderCoreUrl});
                }
            }
            catch (InterruptedException e) {
                log.error("Interrupted while closing BootstrapStatusRunnable", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int retries = 1;
            boolean success = false;
            try {
                while (!this.closed && this.sendBootstrapCommand() != BootstrapStatus.SUBMITTED) {
                    Thread.sleep(2000L);
                }
                TimeOut timeOut = new TimeOut(77760000L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
                while (!timeOut.hasTimedOut()) {
                    if (this.closed) {
                        log.warn("Cancelling waiting for bootstrap on target: {} shard: {} to complete", (Object)this.targetCollection, (Object)this.shard);
                        this.state.setBootstrapInProgress(false);
                        break;
                    }
                    BootstrapStatus status = this.getBoostrapStatus();
                    if (status == BootstrapStatus.RUNNING) {
                        try {
                            log.info("CDCR bootstrap running for {} seconds, sleeping for {} ms", (Object)(77760000L - timeOut.timeLeft(TimeUnit.SECONDS)), (Object)2000);
                            timeOut.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    if (status == BootstrapStatus.COMPLETED) {
                        log.info("CDCR bootstrap successful in {} seconds", (Object)(77760000L - timeOut.timeLeft(TimeUnit.SECONDS)));
                        long checkpoint = CdcrReplicatorManager.this.getCheckpoint(this.state);
                        log.info("Create new update log reader for target {} with checkpoint {} @ {}:{}", new Object[]{this.state.getTargetCollection(), checkpoint, this.collectionName, this.shard});
                        CdcrUpdateLog.CdcrLogReader reader1 = this.ulog.newLogReader();
                        reader1.seek(checkpoint);
                        CdcrReplicatorManager.this.sendRequestRecoveryToFollowers(this.state);
                        success = true;
                        break;
                    }
                    if (status == BootstrapStatus.FAILED) {
                        log.warn("CDCR bootstrap failed in {} seconds", (Object)(77760000L - timeOut.timeLeft(TimeUnit.SECONDS)));
                        if (retries >= 5) {
                            log.error("Unable to bootstrap the target collection: {}, shard: {} even after {} retries", new Object[]{this.targetCollection, this.shard, retries});
                            break;
                        }
                        log.info("Retry: {} - Attempting to bootstrap target collection: {} shard: {}", new Object[]{retries, this.targetCollection, this.shard});
                        while (!this.closed && this.sendBootstrapCommand() != BootstrapStatus.SUBMITTED) {
                            Thread.sleep(2000L);
                        }
                        timeOut = new TimeOut(77760000L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
                        ++retries;
                        continue;
                    }
                    if (status == BootstrapStatus.NOTFOUND || status == BootstrapStatus.CANCELLED) {
                        log.info("CDCR bootstrap " + (status == BootstrapStatus.NOTFOUND ? "not found" : "cancelled") + "in {} seconds", (Object)(77760000L - timeOut.timeLeft(TimeUnit.SECONDS)));
                        while (!this.closed && this.sendBootstrapCommand() != BootstrapStatus.SUBMITTED) {
                            Thread.sleep(2000L);
                        }
                        retries = 1;
                        timeOut = new TimeOut(77760000L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
                        continue;
                    }
                    if (status != BootstrapStatus.UNKNOWN && status != BootstrapStatus.SUBMITTED) continue;
                    log.info("CDCR bootstrap is " + (status == BootstrapStatus.UNKNOWN ? "unknown" : "submitted"), (Object)(77760000L - timeOut.timeLeft(TimeUnit.SECONDS)));
                    timeOut.sleep(2000L);
                }
            }
            catch (InterruptedException e) {
                log.info("Bootstrap thread interrupted");
                this.state.reportError(CdcrReplicatorState.ErrorType.INTERNAL);
                Thread.currentThread().interrupt();
            }
            catch (IOException | SolrServerException | SolrException e) {
                log.error("Unable to bootstrap the target collection " + this.targetCollection + " shard: " + this.shard, e);
                this.state.reportError(CdcrReplicatorState.ErrorType.BAD_REQUEST);
            }
            finally {
                if (success) {
                    log.info("Bootstrap successful, giving the go-ahead to replicator");
                    this.state.setBootstrapInProgress(false);
                }
            }
        }

        /*
         * Loose catch block
         */
        private BootstrapStatus sendBootstrapCommand() throws InterruptedException {
            BootstrapStatus bootstrapStatus;
            Throwable throwable;
            HttpSolrClient client;
            block20: {
                block21: {
                    Replica leader = this.state.getClient().getZkStateReader().getLeaderRetry(this.targetCollection, this.shard, 30000);
                    String leaderCoreUrl = leader.getCoreUrl();
                    HttpClient httpClient = this.state.getClient().getLbClient().getHttpClient();
                    client = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(leaderCoreUrl).withHttpClient(httpClient)).build();
                    throwable = null;
                    log.info("Attempting to bootstrap target collection: {} shard: {} leader: {}", new Object[]{this.targetCollection, this.shard, leaderCoreUrl});
                    NamedList response = CdcrReplicatorManager.this.sendCdcrCommand((SolrClient)client, CdcrParams.CdcrAction.BOOTSTRAP, new String[]{"masterUrl", this.myCoreUrl});
                    log.debug("CDCR Bootstrap response: {}", (Object)response);
                    String status = response.get(CoreAdminHandler.RESPONSE_STATUS).toString();
                    bootstrapStatus = BootstrapStatus.valueOf(status.toUpperCase(Locale.ROOT));
                    if (client == null) break block20;
                    if (throwable == null) break block21;
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                client.close();
            }
            return bootstrapStatus;
            {
                catch (Exception e) {
                    BootstrapStatus bootstrapStatus2;
                    block22: {
                        block23: {
                            log.error("Exception submitting bootstrap request", (Throwable)e);
                            bootstrapStatus2 = BootstrapStatus.UNKNOWN;
                            if (client == null) break block22;
                            if (throwable == null) break block23;
                            try {
                                client.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            break block22;
                        }
                        client.close();
                    }
                    return bootstrapStatus2;
                    catch (Throwable throwable4) {
                        try {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (client != null) {
                                    if (throwable != null) {
                                        try {
                                            client.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable.addSuppressed(throwable6);
                                        }
                                    } else {
                                        client.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                        catch (IOException e2) {
                            log.error("There shouldn't be an IOException while closing but there was!", (Throwable)e2);
                            return BootstrapStatus.UNKNOWN;
                        }
                    }
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private BootstrapStatus getBoostrapStatus() throws InterruptedException {
            try {
                Replica leader = this.state.getClient().getZkStateReader().getLeaderRetry(this.targetCollection, this.shard, 30000);
                String leaderCoreUrl = leader.getCoreUrl();
                HttpClient httpClient = this.state.getClient().getLbClient().getHttpClient();
                try (HttpSolrClient client = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(leaderCoreUrl).withHttpClient(httpClient)).build();){
                    NamedList response = CdcrReplicatorManager.this.sendCdcrCommand((SolrClient)client, CdcrParams.CdcrAction.BOOTSTRAP_STATUS, new String[0]);
                    String status = (String)response.get(CoreAdminHandler.RESPONSE_STATUS);
                    BootstrapStatus bootstrapStatus = BootstrapStatus.valueOf(status.toUpperCase(Locale.ROOT));
                    if (bootstrapStatus == BootstrapStatus.RUNNING) {
                        BootstrapStatus bootstrapStatus2 = BootstrapStatus.RUNNING;
                        return bootstrapStatus2;
                    }
                    if (bootstrapStatus == BootstrapStatus.COMPLETED) {
                        BootstrapStatus bootstrapStatus3 = BootstrapStatus.COMPLETED;
                        return bootstrapStatus3;
                    }
                    if (bootstrapStatus == BootstrapStatus.FAILED) {
                        BootstrapStatus bootstrapStatus4 = BootstrapStatus.FAILED;
                        return bootstrapStatus4;
                    }
                    if (bootstrapStatus == BootstrapStatus.NOTFOUND) {
                        log.warn("Bootstrap process was not found on target collection: {} shard: {}, leader: {}", new Object[]{this.targetCollection, this.shard, leaderCoreUrl});
                        BootstrapStatus bootstrapStatus5 = BootstrapStatus.NOTFOUND;
                        return bootstrapStatus5;
                    }
                    if (bootstrapStatus == BootstrapStatus.CANCELLED) {
                        BootstrapStatus bootstrapStatus6 = BootstrapStatus.CANCELLED;
                        return bootstrapStatus6;
                    }
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown status: " + status + " returned by BOOTSTRAP_STATUS command");
                }
            }
            catch (Exception e) {
                log.error("Exception during bootstrap status request", (Throwable)e);
                return BootstrapStatus.UNKNOWN;
            }
        }
    }
}

