/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.stats;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.stats.LocalStatsSource;
import org.apache.solr.search.stats.StatsCache;
import org.apache.solr.search.stats.StatsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStatsCache
extends StatsCache {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public StatsSource get(SolrQueryRequest req) {
        log.debug("## GET {}", (Object)req);
        return new LocalStatsSource();
    }

    @Override
    public void init(PluginInfo info) {
    }

    @Override
    public ShardRequest retrieveStatsRequest(ResponseBuilder rb) {
        log.debug("## RDR {}", (Object)rb.req);
        return null;
    }

    @Override
    public void mergeToGlobalStats(SolrQueryRequest req, List<ShardResponse> responses) {
        if (log.isDebugEnabled()) {
            log.debug("## MTGD {}", (Object)req);
            for (ShardResponse r : responses) {
                log.debug(" - {}", (Object)r);
            }
        }
    }

    @Override
    public void returnLocalStats(ResponseBuilder rb, SolrIndexSearcher searcher) {
        log.debug("## RLD {}", (Object)rb.req);
    }

    @Override
    public void receiveGlobalStats(SolrQueryRequest req) {
        log.debug("## RGD {}", (Object)req);
    }

    @Override
    public void sendGlobalStats(ResponseBuilder rb, ShardRequest outgoing) {
        log.debug("## SGD {}", (Object)outgoing);
    }
}

