/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.xslt;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.carrot2.util.xslt.StylesheetErrorListener;
import org.carrot2.util.xslt.TransformerErrorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class TemplatesPool {
    private static final Logger logger = LoggerFactory.getLogger(TemplatesPool.class);
    public static final String TEMPLATE_CACHING_PROPERTY = "template.caching";
    private static final Set<String> reportedProcessors = Collections.synchronizedSet(new HashSet());
    private volatile HashMap<String, Templates> stylesheets = new HashMap();
    private final boolean templateCaching;
    public final SAXTransformerFactory tFactory;

    public TemplatesPool() throws Exception {
        this(true);
    }

    public TemplatesPool(boolean templateCaching) throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        String processorClass = tFactory.getClass().getName();
        if (!reportedProcessors.contains(processorClass)) {
            logger.info("XSLT transformer factory: " + processorClass);
            reportedProcessors.add(processorClass);
        }
        if (!tFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") || !tFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
            throw new Exception("Required source types not supported by the transformer factory.");
        }
        if (!tFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature") || !tFactory.getFeature("http://javax.xml.transform.stream.StreamResult/feature")) {
            throw new Exception("Required result types not supported by the transformer factory.");
        }
        if (!(tFactory instanceof SAXTransformerFactory)) {
            throw new Exception("TransformerFactory not an instance of SAXTransformerFactory: " + tFactory.getClass().getName());
        }
        this.tFactory = (SAXTransformerFactory)tFactory;
        this.tFactory.setErrorListener(new StylesheetErrorListener());
        this.templateCaching = templateCaching;
    }

    public TransformerHandler getIdentityTransformerHandler() throws TransformerConfigurationException {
        return this.tFactory.newTransformerHandler();
    }

    public Templates getTemplate(String key) {
        if (!this.isCaching()) {
            return null;
        }
        return this.stylesheets.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTemplate(String key, Templates template) {
        if (!this.isCaching()) {
            return;
        }
        TemplatesPool templatesPool = this;
        synchronized (templatesPool) {
            HashMap<String, Templates> newMap = new HashMap<String, Templates>(this.stylesheets);
            newMap.put(key, template);
            this.stylesheets = newMap;
        }
    }

    private boolean isCaching() {
        String global = System.getProperty(TEMPLATE_CACHING_PROPERTY);
        if (global != null) {
            return Boolean.parseBoolean(global);
        }
        return this.templateCaching;
    }

    public Templates compileTemplate(String systemId) throws SAXException {
        StreamSource source = new StreamSource(systemId);
        try {
            return this.tFactory.newTemplates(source);
        }
        catch (Exception e) {
            throw new SAXException("Could not compile stylesheet: " + systemId, e);
        }
    }

    public Templates compileTemplate(InputStream stream) throws SAXException {
        StreamSource source = new StreamSource(stream);
        try {
            return this.tFactory.newTemplates(source);
        }
        catch (Exception e) {
            throw new SAXException("Could not compile stylesheet.", e);
        }
    }

    public TransformerHandler newTransformerHandler(Templates template) throws TransformerConfigurationException {
        TransformerHandler handler = this.tFactory.newTransformerHandler(template);
        handler.getTransformer().setErrorListener(new TransformerErrorListener());
        return handler;
    }

    public Transformer newTransformer(Templates t) throws TransformerConfigurationException {
        return this.newTransformerHandler(t).getTransformer();
    }
}

