/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import com.ibm.icu.text.Normalizer;
import com.thaiopensource.relaxng.impl.CombineValidator;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.SchemaResolver;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.prop.wrap.WrapProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nu.validator.checker.LanguageDetectingChecker;
import nu.validator.checker.XmlPiChecker;
import nu.validator.checker.jing.CheckerSchema;
import nu.validator.checker.schematronequiv.Assertions;
import nu.validator.gnu.xml.aelfred2.FatalSAXException;
import nu.validator.gnu.xml.aelfred2.SAXDriver;
import nu.validator.htmlparser.common.DocumentMode;
import nu.validator.htmlparser.common.DocumentModeHandler;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import nu.validator.htmlparser.sax.HtmlSerializer;
import nu.validator.htmlparser.sax.XmlSerializer;
import nu.validator.io.BoundedInputStream;
import nu.validator.io.DataUri;
import nu.validator.io.StreamBoundException;
import nu.validator.json.Serializer;
import nu.validator.localentities.LocalCacheEntityResolver;
import nu.validator.messages.GnuMessageEmitter;
import nu.validator.messages.JsonMessageEmitter;
import nu.validator.messages.MessageEmitterAdapter;
import nu.validator.messages.TextMessageEmitter;
import nu.validator.messages.TooManyErrorsException;
import nu.validator.messages.XhtmlMessageEmitter;
import nu.validator.messages.XmlMessageEmitter;
import nu.validator.servlet.BufferingRootNamespaceSniffer;
import nu.validator.servlet.CharsetEmitter;
import nu.validator.servlet.FormEmitter;
import nu.validator.servlet.NsFilterEmitter;
import nu.validator.servlet.OutlineBuildingXMLReaderWrapper;
import nu.validator.servlet.PageEmitter;
import nu.validator.servlet.ParserMode;
import nu.validator.servlet.RootNamespaceSniffer;
import nu.validator.servlet.Statistics;
import nu.validator.servlet.StatsEmitter;
import nu.validator.servlet.VerifierServlet;
import nu.validator.servlet.VerifierServletXMLReaderCreator;
import nu.validator.servlet.XhtmlOutlineEmitter;
import nu.validator.servlet.imagereview.ImageCollector;
import nu.validator.source.SourceCode;
import nu.validator.spec.Spec;
import nu.validator.spec.html5.Html5SpecBuilder;
import nu.validator.xml.AttributesImpl;
import nu.validator.xml.AttributesPermutingXMLReaderWrapper;
import nu.validator.xml.BaseUriTracker;
import nu.validator.xml.CharacterUtil;
import nu.validator.xml.CombineContentHandler;
import nu.validator.xml.ContentTypeParser;
import nu.validator.xml.DataUriEntityResolver;
import nu.validator.xml.IdFilter;
import nu.validator.xml.NamespaceDroppingXMLReaderWrapper;
import nu.validator.xml.NullEntityResolver;
import nu.validator.xml.PrudentHttpEntityResolver;
import nu.validator.xml.SystemErrErrorHandler;
import nu.validator.xml.TypedInputSource;
import nu.validator.xml.WiretapXMLReaderWrapper;
import nu.validator.xml.XhtmlSaxEmitter;
import nu.validator.xml.customelements.NamespaceChangingSchemaWrapper;
import nu.validator.xml.dataattributes.DataAttributeDroppingSchemaWrapper;
import nu.validator.xml.langattributes.XmlLangAttributeDroppingSchemaWrapper;
import nu.validator.xml.roleattributes.RoleAttributeFilteringSchemaWrapper;
import nu.validator.xml.templateelement.TemplateElementDroppingSchemaWrapper;
import org.apache.http.TruncatedChunkException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.log4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

class VerifierServletTransaction
implements DocumentModeHandler,
SchemaResolver {
    private static final Logger log4j;
    private static final Pattern SPACE;
    private static final Pattern JS_IDENTIFIER;
    private static final String[] JS_RESERVED_WORDS;
    private static final String[] CHARSETS;
    private static final char[][] CHARSET_DESCRIPTIONS;
    protected static final int HTML5_SCHEMA = 3;
    protected static final int XHTML1STRICT_SCHEMA = 2;
    protected static final int XHTML1TRANSITIONAL_SCHEMA = 1;
    protected static final int XHTML5_SCHEMA = 7;
    private static final char[] SERVICE_TITLE;
    private static final char[] LIVING_VERSION;
    private static final char[] VERSION;
    private static final char[] RESULTS_TITLE;
    private static final char[] FOR;
    private static final char[] ABOUT_THIS_SERVICE;
    private static final char[] SIMPLE_UI;
    private static final byte[] CSS_CHECKING_PROLOG;
    private static final byte[] CSS_CHECKING_EPILOG;
    private static final String USER_AGENT;
    private static Spec html5spec;
    private static int[] presetDoctypes;
    private static String[] presetLabels;
    private static String[] presetUrls;
    private static String[] presetNamespaces;
    private static final String[] KNOWN_CONTENT_TYPES;
    private static final String[] NAMESPACES_FOR_KNOWN_CONTENT_TYPES;
    private static final String[] ALL_CHECKERS;
    private static final String[] ALL_CHECKERS_HTML4;
    private long start = System.currentTimeMillis();
    protected final HttpServletRequest request;
    private final HttpServletResponse response;
    protected String document = null;
    private ParserMode parser = ParserMode.AUTO;
    private String profile = "";
    private boolean laxType = false;
    private boolean aboutLegacyCompat = false;
    private boolean xhtml1Doctype = false;
    private boolean html4Doctype = false;
    protected ContentHandler contentHandler;
    protected XhtmlSaxEmitter emitter;
    protected MessageEmitterAdapter errorHandler;
    protected final AttributesImpl attrs = new AttributesImpl();
    private OutputStream out;
    private PropertyMap jingPropertyMap;
    protected LocalCacheEntityResolver entityResolver;
    private static long lastModified;
    private static String[] preloadedSchemaUrls;
    private static Schema[] preloadedSchemas;
    private static final String cannotRecover = "Cannot recover after last error. Any further errors will be ignored.";
    private static final String changingEncoding = "Changing encoding at this point would need non-streamable behavior.";
    private static final String[] DENY_LIST;
    private static final String ABOUT_PAGE;
    private static final String HTML5_FACET;
    private static final String STYLE_SHEET;
    private static final String ICON;
    private static final String SCRIPT;
    private static final long SIZE_LIMIT;
    private static String systemFilterString;
    private static final String FILTER_FILE;
    protected String schemaUrls = null;
    protected Validator validator = null;
    private BufferingRootNamespaceSniffer bufferingRootNamespaceSniffer = null;
    private String contentType = null;
    protected HtmlParser htmlParser = null;
    protected SAXDriver xmlParser = null;
    protected XMLReader reader;
    protected TypedInputSource documentInput;
    protected PrudentHttpEntityResolver httpRes;
    protected DataUriEntityResolver dataRes;
    protected ContentTypeParser contentTypeParser;
    private Set<String> loadedValidatorUrls = new HashSet<String>();
    private boolean checkNormalization = false;
    private boolean rootNamespaceSeen = false;
    private OutputFormat outputFormat;
    private String postContentType;
    private boolean methodIsGet;
    private SourceCode sourceCode = new SourceCode();
    private Deque<OutlineBuildingXMLReaderWrapper.Section> outline;
    private Deque<OutlineBuildingXMLReaderWrapper.Section> headingOutline;
    private boolean showSource;
    private boolean showOutline;
    private boolean checkErrorPages;
    private boolean schemaIsDefault;
    private String userAgent;
    private BaseUriTracker baseUriTracker = null;
    private String charsetOverride = null;
    private Set<String> filteredNamespaces = new LinkedHashSet<String>();
    private LexicalHandler lexicalHandler;
    protected ImageCollector imageCollector;
    private boolean externalSchema = false;
    private boolean externalSchematron = false;
    private String schemaListForStats = null;

    protected static String scrub(CharSequence s) {
        return Normalizer.normalize(CharacterUtil.prudentlyScrubCharacterData(s), Normalizer.NFC);
    }

    private static boolean isDataAttributeDroppingSchema(String key) {
        return "http://s.validator.nu/xhtml5.rnc".equals(key) || "http://s.validator.nu/html5.rnc".equals(key) || "http://s.validator.nu/html5-all.rnc".equals(key) || "http://s.validator.nu/xhtml5-all.rnc".equals(key) || "http://s.validator.nu/html5-its.rnc".equals(key) || "http://s.validator.nu/xhtml5-rdfalite.rnc".equals(key) || "http://s.validator.nu/html5-rdfalite.rnc".equals(key);
    }

    private static boolean isXmlLangAllowingSchema(String key) {
        return "http://s.validator.nu/xhtml5.rnc".equals(key) || "http://s.validator.nu/html5.rnc".equals(key) || "http://s.validator.nu/html5-all.rnc".equals(key) || "http://s.validator.nu/xhtml5-all.rnc".equals(key) || "http://s.validator.nu/html5-its.rnc".equals(key) || "http://s.validator.nu/xhtml5-rdfalite.rnc".equals(key) || "http://s.validator.nu/html5-rdfalite.rnc".equals(key);
    }

    private static boolean isRoleAttributeFilteringSchema(String key) {
        return "http://s.validator.nu/xhtml5.rnc".equals(key) || "http://s.validator.nu/html5.rnc".equals(key) || "http://s.validator.nu/html5-all.rnc".equals(key) || "http://s.validator.nu/xhtml5-all.rnc".equals(key) || "http://s.validator.nu/html5-its.rnc".equals(key) || "http://s.validator.nu/xhtml5-rdfalite.rnc".equals(key) || "http://s.validator.nu/html5-rdfalite.rnc".equals(key);
    }

    private static boolean isTemplateElementDroppingSchema(String key) {
        return "http://s.validator.nu/xhtml5.rnc".equals(key) || "http://s.validator.nu/html5.rnc".equals(key) || "http://s.validator.nu/html5-all.rnc".equals(key) || "http://s.validator.nu/xhtml5-all.rnc".equals(key) || "http://s.validator.nu/html5-its.rnc".equals(key) || "http://s.validator.nu/xhtml5-rdfalite.rnc".equals(key) || "http://s.validator.nu/html5-rdfalite.rnc".equals(key);
    }

    private static boolean isCustomElementNamespaceChangingSchema(String key) {
        return "http://s.validator.nu/xhtml5.rnc".equals(key) || "http://s.validator.nu/html5.rnc".equals(key) || "http://s.validator.nu/html5-all.rnc".equals(key) || "http://s.validator.nu/xhtml5-all.rnc".equals(key) || "http://s.validator.nu/html5-its.rnc".equals(key) || "http://s.validator.nu/xhtml5-rdfalite.rnc".equals(key) || "http://s.validator.nu/html5-rdfalite.rnc".equals(key);
    }

    private static boolean isCheckerUrl(String url) {
        if ("http://c.validator.nu/all/".equals(url) || "http://hsivonen.iki.fi/checkers/all/".equals(url)) {
            return true;
        }
        if ("http://c.validator.nu/all-html4/".equals(url) || "http://hsivonen.iki.fi/checkers/all-html4/".equals(url)) {
            return true;
        }
        if ("http://c.validator.nu/base/".equals(url)) {
            return true;
        }
        if ("http://c.validator.nu/rdfalite/".equals(url)) {
            return true;
        }
        for (String checker : ALL_CHECKERS) {
            if (!checker.equals(url)) continue;
            return true;
        }
        return false;
    }

    VerifierServletTransaction(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    protected boolean willValidate() {
        if (this.methodIsGet) {
            return this.document != null;
        }
        return true;
    }

    void service() throws ServletException, IOException {
        String nsfilter;
        String charset;
        String filterUrl;
        String outFormat;
        this.methodIsGet = "GET".equals(this.request.getMethod()) || "HEAD".equals(this.request.getMethod());
        this.out = this.response.getOutputStream();
        try {
            this.request.setCharacterEncoding("utf-8");
        }
        catch (NoSuchMethodError e) {
            log4j.debug("Vintage Servlet API doesn't support setCharacterEncoding().", e);
        }
        if (!this.methodIsGet) {
            this.postContentType = this.request.getContentType();
            if (this.postContentType == null) {
                this.response.sendError(400, "Content-Type missing");
                return;
            }
            if (this.postContentType.trim().toLowerCase().startsWith("application/x-www-form-urlencoded")) {
                this.response.sendError(415, "application/x-www-form-urlencoded not supported. Please use multipart/form-data.");
                return;
            }
        }
        if ((outFormat = this.request.getParameter("out")) == null) {
            this.outputFormat = OutputFormat.HTML;
        } else if ("html".equals(outFormat)) {
            this.outputFormat = OutputFormat.HTML;
        } else if ("xhtml".equals(outFormat)) {
            this.outputFormat = OutputFormat.XHTML;
        } else if ("text".equals(outFormat)) {
            this.outputFormat = OutputFormat.TEXT;
        } else if ("gnu".equals(outFormat)) {
            this.outputFormat = OutputFormat.GNU;
        } else if ("xml".equals(outFormat)) {
            this.outputFormat = OutputFormat.XML;
        } else if ("json".equals(outFormat)) {
            this.outputFormat = OutputFormat.JSON;
        } else {
            this.response.sendError(400, "Unsupported output format");
            return;
        }
        if (!this.methodIsGet) {
            this.document = this.request.getHeader("Content-Location");
        }
        if (this.document == null) {
            this.document = this.request.getParameter("doc");
        }
        if (this.document == null) {
            this.document = this.request.getParameter("file");
        }
        String string = this.document = "".equals(this.document) ? null : this.document;
        if (this.document != null) {
            for (String domain : DENY_LIST) {
                if ("".equals(domain) || !this.document.contains(domain)) continue;
                this.response.sendError(429, "Too many requests");
                return;
            }
        }
        String callback = null;
        if (this.outputFormat == OutputFormat.JSON && (callback = this.request.getParameter("callback")) != null) {
            Matcher m = JS_IDENTIFIER.matcher(callback);
            if (m.matches()) {
                if (Arrays.binarySearch(JS_RESERVED_WORDS, callback) >= 0) {
                    this.response.sendError(400, "Callback is a reserved word.");
                    return;
                }
            } else {
                this.response.sendError(400, "Callback is not a valid ECMA 262 IdentifierName.");
                return;
            }
        }
        if (this.willValidate()) {
            this.response.setDateHeader("Expires", 0L);
            this.response.setHeader("Cache-Control", "no-cache");
        } else if (this.outputFormat == OutputFormat.HTML || this.outputFormat == OutputFormat.XHTML) {
            this.response.setDateHeader("Last-Modified", lastModified);
        } else {
            this.response.sendError(400, "No input document");
            return;
        }
        this.setup();
        String filterString = systemFilterString;
        String filterPatternParam = this.request.getParameter("filterpattern");
        if (filterPatternParam != null && !"".equals(filterPatternParam)) {
            filterString = "".equals(filterString) ? VerifierServletTransaction.scrub(filterPatternParam) : filterString + "|" + VerifierServletTransaction.scrub(filterPatternParam);
        }
        if ((filterUrl = this.request.getParameter("filterurl")) != null && !"".equals(filterUrl)) {
            try {
                String line;
                InputSource filterFile = new PrudentHttpEntityResolver(-1L, true, null).resolveEntity(null, filterUrl);
                StringBuilder sb = new StringBuilder();
                BufferedReader reader = new BufferedReader(new InputStreamReader(filterFile.getByteStream()));
                String[] pipe = "";
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    sb.append((String)pipe);
                    sb.append(line);
                    pipe = "|";
                }
                if (sb.length() != 0) {
                    filterString = !"".equals(filterString) ? VerifierServletTransaction.scrub(sb.toString()) : filterString + "|" + VerifierServletTransaction.scrub(sb.toString());
                }
            }
            catch (Exception e) {
                this.response.sendError(500, e.getMessage());
            }
        }
        Pattern filterPattern = null;
        if (!"".equals(filterString)) {
            filterPattern = Pattern.compile(filterString);
        }
        this.userAgent = this.request.getParameter("useragent") != null ? VerifierServletTransaction.scrub(this.request.getParameter("useragent")) : USER_AGENT;
        if (this.request.getParameter("acceptlanguage") != null) {
            this.request.setAttribute("http://validator.nu/properties/accept-language", VerifierServletTransaction.scrub(this.request.getParameter("acceptlanguage")));
        }
        Object inputType = this.request.getAttribute("nu.validator.servlet.MultipartFormDataFilter.type");
        this.showSource = this.request.getParameter("showsource") != null;
        this.showSource = this.showSource || "textarea".equals(inputType);
        boolean bl = this.showOutline = this.request.getParameter("showoutline") != null;
        if (this.request.getParameter("checkerrorpages") != null) {
            this.request.setAttribute("http://validator.nu/properties/ignore-response-status", true);
        }
        if (this.request.getParameter("showimagereport") != null) {
            this.imageCollector = new ImageCollector(this.sourceCode);
        }
        if ((charset = this.request.getParameter("charset")) != null && !"".equals(charset = VerifierServletTransaction.scrub(charset.trim()))) {
            this.charsetOverride = charset;
        }
        if ((nsfilter = this.request.getParameter("nsfilter")) != null) {
            for (String ns : SPACE.split(nsfilter)) {
                if (ns.length() <= 0) continue;
                this.filteredNamespaces.add(ns);
            }
        }
        boolean errorsOnly = "error".equals(this.request.getParameter("level"));
        boolean asciiQuotes = this.request.getParameter("asciiquotes") != null;
        int lineOffset = 0;
        String lineOffsetStr = this.request.getParameter("lineoffset");
        if (lineOffsetStr != null) {
            try {
                lineOffset = Integer.parseInt(lineOffsetStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            if (this.outputFormat == OutputFormat.HTML || this.outputFormat == OutputFormat.XHTML) {
                if (this.outputFormat == OutputFormat.HTML) {
                    this.response.setContentType("text/html; charset=utf-8");
                    this.contentHandler = new HtmlSerializer(this.out);
                } else {
                    this.response.setContentType("application/xhtml+xml");
                    this.contentHandler = new XmlSerializer(this.out);
                }
                this.emitter = new XhtmlSaxEmitter(this.contentHandler);
                this.errorHandler = new MessageEmitterAdapter(filterPattern, this.sourceCode, this.showSource, this.imageCollector, lineOffset, false, new XhtmlMessageEmitter(this.contentHandler));
                PageEmitter.emit(this.contentHandler, this);
            } else {
                if (this.outputFormat == OutputFormat.TEXT) {
                    this.response.setContentType("text/plain; charset=utf-8");
                    this.errorHandler = new MessageEmitterAdapter(filterPattern, this.sourceCode, this.showSource, null, lineOffset, false, new TextMessageEmitter(this.out, asciiQuotes));
                } else if (this.outputFormat == OutputFormat.GNU) {
                    this.response.setContentType("text/plain; charset=utf-8");
                    this.errorHandler = new MessageEmitterAdapter(filterPattern, this.sourceCode, this.showSource, null, lineOffset, false, new GnuMessageEmitter(this.out, asciiQuotes));
                } else if (this.outputFormat == OutputFormat.XML) {
                    this.response.setContentType("application/xml");
                    this.errorHandler = new MessageEmitterAdapter(filterPattern, this.sourceCode, this.showSource, null, lineOffset, false, new XmlMessageEmitter(new XmlSerializer(this.out)));
                } else if (this.outputFormat == OutputFormat.JSON) {
                    if (callback == null) {
                        this.response.setContentType("application/json; charset=utf-8");
                    } else {
                        this.response.setContentType("application/javascript; charset=utf-8");
                    }
                    this.errorHandler = new MessageEmitterAdapter(filterPattern, this.sourceCode, this.showSource, null, lineOffset, false, new JsonMessageEmitter(new Serializer(this.out), callback));
                } else {
                    throw new RuntimeException("Unreachable.");
                }
                this.errorHandler.setErrorsOnly(errorsOnly);
                this.validate();
            }
        }
        catch (SAXException e) {
            log4j.debug("SAXException: " + e.getMessage());
        }
    }

    protected void setup() throws ServletException {
        String parserStr;
        String preset = this.request.getParameter("preset");
        this.schemaUrls = preset != null && !"".equals(preset) ? preset : this.request.getParameter("schema");
        if (this.schemaUrls == null) {
            this.schemaUrls = "";
        }
        if ("html".equals(parserStr = this.request.getParameter("parser"))) {
            this.parser = ParserMode.HTML;
        } else if ("xmldtd".equals(parserStr)) {
            this.parser = ParserMode.XML_EXTERNAL_ENTITIES_NO_VALIDATION;
        } else if ("xml".equals(parserStr)) {
            this.parser = ParserMode.XML_NO_EXTERNAL_ENTITIES;
        } else if ("html5".equals(parserStr)) {
            this.parser = ParserMode.HTML;
        }
        this.laxType = this.request.getParameter("laxtype") != null;
    }

    private boolean isHtmlUnsafePreset() {
        if ("".equals(this.schemaUrls)) {
            return false;
        }
        boolean preset = false;
        for (String presetUrl : presetUrls) {
            if (!presetUrl.equals(this.schemaUrls)) continue;
            preset = true;
            break;
        }
        if (!preset) {
            return false;
        }
        return !this.schemaUrls.startsWith("http://s.validator.nu/xhtml10/xhtml-basic.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/xhtml10/xhtml-strict.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/xhtml10/xhtml-transitional.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/xhtml10/xhtml-frameset.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/html5.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/html5-all.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/html5-its.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/html5-rdfalite.rnc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validate() throws SAXException {
        boolean isHtmlOrXhtml;
        if (!this.willValidate()) {
            return;
        }
        boolean bl = isHtmlOrXhtml = this.outputFormat == OutputFormat.HTML || this.outputFormat == OutputFormat.XHTML;
        if (isHtmlOrXhtml) {
            try {
                this.out.flush();
            }
            catch (IOException e1) {
                throw new SAXException(e1);
            }
        }
        this.httpRes = new PrudentHttpEntityResolver(SIZE_LIMIT, this.laxType, this.errorHandler, this.request);
        this.httpRes.setUserAgent(this.userAgent);
        this.dataRes = new DataUriEntityResolver(this.httpRes, this.laxType, this.errorHandler);
        this.contentTypeParser = new ContentTypeParser(this.errorHandler, this.laxType);
        this.entityResolver = new LocalCacheEntityResolver(this.dataRes);
        this.setAllowRnc(true);
        this.setAllowCss(true);
        try {
            this.errorHandler.start(this.document);
            PropertyMapBuilder pmb = new PropertyMapBuilder();
            pmb.put(ValidateProperty.ERROR_HANDLER, this.errorHandler);
            pmb.put(ValidateProperty.ENTITY_RESOLVER, this.entityResolver);
            pmb.put(ValidateProperty.XML_READER_CREATOR, new VerifierServletXMLReaderCreator(this.errorHandler, this.entityResolver));
            pmb.put(ValidateProperty.SCHEMA_RESOLVER, this);
            RngProperty.CHECK_ID_IDREF.add(pmb);
            this.jingPropertyMap = pmb.toPropertyMap();
            this.tryToSetupValidator();
            this.setAllowRnc(false);
            this.loadDocAndSetupParser();
            this.setErrorProfile();
            this.contentType = this.documentInput.getType();
            if ("text/css".equals(this.contentType)) {
                String charset = "UTF-8";
                if (this.documentInput.getEncoding() != null) {
                    charset = this.documentInput.getEncoding();
                }
                ArrayList<InputStream> streams = new ArrayList<InputStream>();
                streams.add(new ByteArrayInputStream(CSS_CHECKING_PROLOG));
                streams.add(this.documentInput.getByteStream());
                streams.add(new ByteArrayInputStream(CSS_CHECKING_EPILOG));
                Enumeration e = Collections.enumeration(streams);
                this.documentInput.setByteStream(new SequenceInputStream(e));
                this.documentInput.setEncoding(charset);
                this.errorHandler.setLineOffset(-1);
                this.sourceCode.setIsCss();
                this.parser = ParserMode.HTML;
                this.loadDocAndSetupParser();
            }
            this.reader.setErrorHandler(this.errorHandler);
            this.sourceCode.initialize(this.documentInput);
            if (this.validator == null) {
                this.checkNormalization = true;
            }
            if (this.checkNormalization) {
                this.reader.setFeature("http://xml.org/sax/features/unicode-normalization-checking", true);
            }
            WiretapXMLReaderWrapper wiretap = new WiretapXMLReaderWrapper(this.reader);
            ContentHandler recorder = this.sourceCode.getLocationRecorder();
            if (this.baseUriTracker == null) {
                wiretap.setWiretapContentHander(recorder);
            } else {
                wiretap.setWiretapContentHander(new CombineContentHandler(recorder, this.baseUriTracker));
            }
            wiretap.setWiretapLexicalHandler((LexicalHandler)((Object)recorder));
            this.reader = wiretap;
            if (this.htmlParser != null) {
                this.htmlParser.addCharacterHandler(this.sourceCode);
                this.htmlParser.setMappingLangToXmlLang(true);
                this.htmlParser.setErrorHandler(this.errorHandler.getExactErrorHandler());
                this.htmlParser.setTreeBuilderErrorHandlerOverride(this.errorHandler);
                this.errorHandler.setHtml(true);
            } else if (this.xmlParser != null) {
                if (!this.filteredNamespaces.isEmpty()) {
                    this.reader = new NamespaceDroppingXMLReaderWrapper(this.reader, this.filteredNamespaces);
                }
                this.xmlParser.setErrorHandler(this.errorHandler.getExactErrorHandler());
                this.xmlParser.lockErrorHandler();
            } else {
                throw new RuntimeException("Bug. Unreachable.");
            }
            this.reader = new AttributesPermutingXMLReaderWrapper(this.reader);
            if (this.charsetOverride != null) {
                String charset = this.documentInput.getEncoding();
                if (charset == null) {
                    this.errorHandler.warning(new SAXParseException("Overriding document character encoding from none to \u201c" + this.charsetOverride + "\u201d.", null));
                } else {
                    this.errorHandler.warning(new SAXParseException("Overriding document character encoding from \u201c" + charset + "\u201d to \u201c" + this.charsetOverride + "\u201d.", null));
                }
                this.documentInput.setEncoding(this.charsetOverride);
            }
            if (this.showOutline) {
                this.reader = new OutlineBuildingXMLReaderWrapper(this.reader, this.request, false);
                this.reader = new OutlineBuildingXMLReaderWrapper(this.reader, this.request, true);
            }
            this.reader.parse(this.documentInput);
            if (this.showOutline) {
                this.outline = (Deque)this.request.getAttribute("http://validator.nu/properties/document-outline");
                this.headingOutline = (Deque)this.request.getAttribute("http://validator.nu/properties/heading-outline");
            }
        }
        catch (CannotFindPresetSchemaException pmb) {
        }
        catch (PrudentHttpEntityResolver.ResourceNotRetrievableException e) {
            log4j.debug(e.getMessage());
        }
        catch (ContentTypeParser.NonXmlContentTypeException e) {
            log4j.debug(e.getMessage());
        }
        catch (FatalSAXException e) {
            log4j.debug(e.getMessage());
        }
        catch (SocketTimeoutException e) {
            this.errorHandler.ioError(new IOException(e.getMessage(), null));
        }
        catch (ConnectTimeoutException e) {
            this.errorHandler.ioError(new IOException(e.getMessage(), null));
        }
        catch (TooManyErrorsException e) {
            this.errorHandler.fatalError(e);
        }
        catch (SAXException e) {
            String msg = e.getMessage();
            if (!cannotRecover.equals(msg) && !changingEncoding.equals(msg)) {
                log4j.debug("SAXException: " + e.getMessage());
            }
        }
        catch (IOException e) {
            isHtmlOrXhtml = false;
            if (e.getCause() instanceof TruncatedChunkException) {
                log4j.debug("TruncatedChunkException", e.getCause());
            } else {
                this.errorHandler.ioError(e);
            }
        }
        catch (IncorrectSchemaException e) {
            log4j.debug("IncorrectSchemaException", e);
            this.errorHandler.schemaError(e);
        }
        catch (RuntimeException e) {
            isHtmlOrXhtml = false;
            log4j.error("RuntimeException, doc: " + this.document + " schema: " + this.schemaUrls + " lax: " + this.laxType, e);
            this.errorHandler.internalError(e, "Oops. That was not supposed to happen. A bug manifested itself in the application internals. Unable to continue. Sorry. The admin was notified.");
        }
        catch (Error e) {
            isHtmlOrXhtml = false;
            log4j.error("Error, doc: " + this.document + " schema: " + this.schemaUrls + " lax: " + this.laxType, e);
            this.errorHandler.internalError(e, "Oops. That was not supposed to happen. A bug manifested itself in the application internals. Unable to continue. Sorry. The admin was notified.");
        }
        finally {
            this.errorHandler.end(this.successMessage(), this.failureMessage(), (String)this.request.getAttribute("http://validator.nu/properties/document-language"));
            this.gatherStatistics();
        }
        if (isHtmlOrXhtml) {
            XhtmlOutlineEmitter outlineEmitter = new XhtmlOutlineEmitter(this.contentHandler, this.outline, this.headingOutline);
            outlineEmitter.emitHeadings();
            outlineEmitter.emit();
            this.emitDetails();
            StatsEmitter.emit(this.contentHandler, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherStatistics() {
        Statistics stats = Statistics.STATISTICS;
        if (stats == null) {
            return;
        }
        Statistics statistics = stats;
        synchronized (statistics) {
            String langVal;
            String fieldName;
            String language;
            stats.incrementTotal();
            if (this.charsetOverride != null) {
                stats.incrementField(Statistics.Field.CUSTOM_ENC);
            }
            switch (this.parser) {
                case XML_EXTERNAL_ENTITIES_NO_VALIDATION: {
                    stats.incrementField(Statistics.Field.PARSER_XML_EXTERNAL);
                    break;
                }
            }
            if (!this.filteredNamespaces.isEmpty()) {
                stats.incrementField(Statistics.Field.XMLNS_FILTER);
            }
            if (this.laxType) {
                stats.incrementField(Statistics.Field.LAX_TYPE);
            }
            if (this.aboutLegacyCompat) {
                stats.incrementField(Statistics.Field.ABOUT_LEGACY_COMPAT);
            }
            if (this.xhtml1Doctype) {
                stats.incrementField(Statistics.Field.XHTML1_DOCTYPE);
            }
            if (this.html4Doctype) {
                stats.incrementField(Statistics.Field.HTML4_DOCTYPE);
            }
            if (this.imageCollector != null) {
                stats.incrementField(Statistics.Field.IMAGE_REPORT);
            }
            if (this.showSource) {
                stats.incrementField(Statistics.Field.SHOW_SOURCE);
            }
            if (this.showOutline) {
                stats.incrementField(Statistics.Field.SHOW_OUTLINE);
            }
            if (this.methodIsGet) {
                stats.incrementField(Statistics.Field.INPUT_GET);
            } else {
                stats.incrementField(Statistics.Field.INPUT_POST);
                Object inputType = this.request.getAttribute("nu.validator.servlet.MultipartFormDataFilter.type");
                if ("textarea".equals(inputType)) {
                    stats.incrementField(Statistics.Field.INPUT_TEXT_FIELD);
                } else if ("file".equals(inputType)) {
                    stats.incrementField(Statistics.Field.INPUT_FILE_UPLOAD);
                } else {
                    stats.incrementField(Statistics.Field.INPUT_ENTITY_BODY);
                }
            }
            if (this.documentInput != null && "text/css".equals(this.documentInput.getType())) {
                stats.incrementField(Statistics.Field.INPUT_CSS);
            } else if (this.documentInput != null && "image/svg+xml".equals(this.documentInput.getType())) {
                stats.incrementField(Statistics.Field.INPUT_SVG);
            } else if (this.htmlParser != null) {
                stats.incrementField(Statistics.Field.INPUT_HTML);
            } else if (this.xmlParser != null) {
                stats.incrementField(Statistics.Field.INPUT_XML);
            } else {
                stats.incrementField(Statistics.Field.INPUT_UNSUPPORTED);
            }
            switch (this.outputFormat) {
                case GNU: {
                    stats.incrementField(Statistics.Field.OUTPUT_GNU);
                    break;
                }
                case HTML: {
                    stats.incrementField(Statistics.Field.OUTPUT_HTML);
                    break;
                }
                case JSON: {
                    stats.incrementField(Statistics.Field.OUTPUT_JSON);
                    break;
                }
                case TEXT: {
                    stats.incrementField(Statistics.Field.OUTPUT_TEXT);
                    break;
                }
                case XHTML: {
                    stats.incrementField(Statistics.Field.OUTPUT_XHTML);
                    break;
                }
                case XML: {
                    stats.incrementField(Statistics.Field.OUTPUT_XML);
                    break;
                }
            }
            if (this.schemaListForStats == null) {
                stats.incrementField(Statistics.Field.LOGIC_ERROR);
            } else {
                boolean preset = false;
                for (int i = 0; i < presetUrls.length; ++i) {
                    if (!presetUrls[i].equals(this.schemaListForStats)) continue;
                    preset = true;
                    if (this.externalSchema || this.externalSchematron) {
                        stats.incrementField(Statistics.Field.LOGIC_ERROR);
                        break;
                    }
                    stats.incrementField(Statistics.Field.PRESET_SCHEMA);
                    switch (i) {
                        case 0: 
                        case 5: {
                            stats.incrementField(Statistics.Field.HTML5_SCHEMA);
                            break;
                        }
                        case 1: 
                        case 6: {
                            stats.incrementField(Statistics.Field.HTML5_RDFA_LITE_SCHEMA);
                            break;
                        }
                        case 2: {
                            stats.incrementField(Statistics.Field.HTML4_STRICT_SCHEMA);
                            break;
                        }
                        case 3: {
                            stats.incrementField(Statistics.Field.HTML4_TRANSITIONAL_SCHEMA);
                            break;
                        }
                        case 4: {
                            stats.incrementField(Statistics.Field.HTML4_FRAMESET_SCHEMA);
                            break;
                        }
                        case 7: {
                            stats.incrementField(Statistics.Field.XHTML1_COMPOUND_SCHEMA);
                            break;
                        }
                        case 8: {
                            stats.incrementField(Statistics.Field.SVG_SCHEMA);
                            break;
                        }
                        default: {
                            stats.incrementField(Statistics.Field.LOGIC_ERROR);
                            break;
                        }
                    }
                    break;
                }
                if (!preset && !this.externalSchema) {
                    stats.incrementField(Statistics.Field.BUILT_IN_NON_PRESET);
                }
            }
            if ("".equals(this.schemaUrls)) {
                stats.incrementField(Statistics.Field.AUTO_SCHEMA);
                if (this.externalSchema) {
                    stats.incrementField(Statistics.Field.LOGIC_ERROR);
                }
            } else if (this.externalSchema) {
                if (this.externalSchematron) {
                    stats.incrementField(Statistics.Field.EXTERNAL_SCHEMA_SCHEMATRON);
                } else {
                    stats.incrementField(Statistics.Field.EXTERNAL_SCHEMA_NON_SCHEMATRON);
                }
            } else if (this.externalSchematron) {
                stats.incrementField(Statistics.Field.LOGIC_ERROR);
            }
            if (this.request.getAttribute("http://validator.nu/properties/hgroup-found") != null && ((Boolean)this.request.getAttribute("http://validator.nu/properties/hgroup-found")).booleanValue()) {
                stats.incrementField(Statistics.Field.HGROUP_FOUND);
            }
            if (this.request.getAttribute("http://validator.nu/properties/style-element-errors-found") != null && ((Boolean)this.request.getAttribute("http://validator.nu/properties/style-element-errors-found")).booleanValue()) {
                stats.incrementField(Statistics.Field.STYLE_ELEMENT_ERRORS_FOUND);
            }
            if (this.request.getAttribute("http://validator.nu/properties/style-attribute-errors-found") != null && ((Boolean)this.request.getAttribute("http://validator.nu/properties/style-attribute-errors-found")).booleanValue()) {
                stats.incrementField(Statistics.Field.STYLE_ATTRIBUTE_ERRORS_FOUND);
            }
            if (this.request.getAttribute("http://validator.nu/properties/lang-found") != null && ((Boolean)this.request.getAttribute("http://validator.nu/properties/lang-found")).booleanValue()) {
                stats.incrementField(Statistics.Field.LANG_FOUND);
            }
            if (this.request.getAttribute("http://validator.nu/properties/lang-wrong") != null && ((Boolean)this.request.getAttribute("http://validator.nu/properties/lang-wrong")).booleanValue()) {
                stats.incrementField(Statistics.Field.LANG_WRONG);
            }
            if (this.request.getAttribute("http://validator.nu/properties/lang-empty") != null && ((Boolean)this.request.getAttribute("http://validator.nu/properties/lang-empty")).booleanValue()) {
                stats.incrementField(Statistics.Field.LANG_EMPTY);
            }
            if (!"".equals(language = (String)this.request.getAttribute("http://validator.nu/properties/document-language")) && language != null) {
                fieldName = "DETECTEDLANG_" + language.toUpperCase();
                if ("zh-hans".equals(language)) {
                    fieldName = "DETECTEDLANG_ZH_HANS";
                } else if ("zh-hant".equals(language)) {
                    fieldName = "DETECTEDLANG_ZH_HANT";
                } else if ("sr-latn".equals(language)) {
                    fieldName = "DETECTEDLANG_SR_LATN";
                } else if ("sr-cyrl".equals(language)) {
                    fieldName = "DETECTEDLANG_SR_CYRL";
                } else if ("uz-latn".equals(language)) {
                    fieldName = "DETECTEDLANG_UZ_LATN";
                } else if ("uz-cyrl".equals(language)) {
                    fieldName = "DETECTEDLANG_UZ_CYRL";
                }
                try {
                    stats.incrementField(stats.getFieldFromName(fieldName));
                }
                catch (IllegalArgumentException e) {
                    log4j.error(e.getMessage(), e);
                }
            }
            if ((langVal = (String)this.request.getAttribute("http://validator.nu/properties/lang-value")) != null) {
                if ("".equals(langVal)) {
                    stats.incrementField(Statistics.Field.LANG_EMPTY);
                } else {
                    fieldName = langVal.contains("_") ? "LANG_" + langVal.replace("_", "__").toUpperCase() : "LANG_" + langVal.replace("-", "_").toUpperCase();
                    try {
                        stats.incrementField(stats.getFieldFromName(fieldName));
                    }
                    catch (IllegalArgumentException e) {
                        stats.incrementField(Statistics.Field.LANG_OTHER);
                    }
                }
            }
        }
    }

    protected String successMessage() throws SAXException {
        return "The document validates according to the specified schema(s).";
    }

    protected String failureMessage() throws SAXException {
        return "There were errors.";
    }

    void emitDetails() throws SAXException {
        String type;
        Object inputType = this.request.getAttribute("nu.validator.servlet.MultipartFormDataFilter.type");
        String string = type = this.documentInput != null ? this.documentInput.getType() : "";
        if ("text/html".equals(type) || "text/html-sandboxed".equals(type)) {
            String charset;
            this.attrs.clear();
            this.emitter.startElementWithClass("div", "details");
            if (this.schemaIsDefault) {
                this.emitter.startElementWithClass("p", "msgschema");
                this.emitter.characters(String.format("Used the schema for %s.", this.getPresetLabel(3)));
                this.emitter.endElement("p");
            }
            this.emitter.startElementWithClass("p", "msgmediatype");
            if (!this.isHtmlUnsafePreset()) {
                this.emitter.characters("Used the HTML parser.");
            }
            if (this.methodIsGet && !"textarea".equals(inputType) && !"file".equals(inputType) && (charset = this.documentInput.getEncoding()) != null) {
                this.emitter.characters(String.format(" Externally specified character encoding was %s.", charset));
            }
            this.emitter.endElement("div");
        }
    }

    protected void tryToSetupValidator() throws SAXException, IOException, IncorrectSchemaException {
        this.validator = this.validatorByUrls(this.schemaUrls);
    }

    protected void setErrorProfile() {
        this.profile = this.request.getParameter("profile");
        HashMap<String, String> profileMap = new HashMap<String, String>();
        if ("pedagogical".equals(this.profile)) {
            profileMap.put("xhtml1", "warn");
        } else if ("polyglot".equals(this.profile)) {
            profileMap.put("xhtml1", "warn");
            profileMap.put("xhtml2", "warn");
        } else {
            return;
        }
        this.htmlParser.setErrorProfile(profileMap);
    }

    protected void loadDocAndSetupParser() throws SAXException, IOException, IncorrectSchemaException, SAXNotRecognizedException, SAXNotSupportedException {
        switch (this.parser) {
            case HTML: {
                if (this.isHtmlUnsafePreset()) {
                    String message = "The chosen preset schema is not appropriate for HTML.";
                    SAXException se = new SAXException(message);
                    this.errorHandler.schemaError(se);
                    throw se;
                }
                this.setAllowGenericXml(false);
                this.setAllowHtml(true);
                this.setAcceptAllKnownXmlTypes(false);
                this.setAllowXhtml(false);
                this.loadDocumentInput();
                this.newHtmlParser();
                int schemaId = 3;
                this.htmlParser.setDocumentModeHandler(this);
                this.reader = this.htmlParser;
                if (this.validator == null) {
                    this.validator = this.validatorByDoctype(schemaId);
                }
                if (this.validator == null) break;
                this.reader.setContentHandler(this.validator.getContentHandler());
                break;
            }
            case XML_EXTERNAL_ENTITIES_NO_VALIDATION: 
            case XML_NO_EXTERNAL_ENTITIES: {
                this.setAllowGenericXml(true);
                this.setAllowHtml(false);
                this.setAcceptAllKnownXmlTypes(true);
                this.setAllowXhtml(true);
                this.loadDocumentInput();
                this.setupXmlParser();
                break;
            }
            default: {
                this.setAllowGenericXml(true);
                this.setAllowHtml(true);
                this.setAcceptAllKnownXmlTypes(true);
                this.setAllowXhtml(true);
                this.loadDocumentInput();
                String type = this.documentInput.getType();
                if ("text/css".equals(type)) break;
                if ("text/html".equals(type) || "text/html-sandboxed".equals(type)) {
                    if (this.isHtmlUnsafePreset()) {
                        String message = "The Content-Type was \u201c" + type + "\u201d, but the chosen preset schema is not appropriate for HTML.";
                        SAXException se = new SAXException(message);
                        this.errorHandler.schemaError(se);
                        throw se;
                    }
                    this.newHtmlParser();
                    this.htmlParser.setDocumentModeHandler(this);
                    this.reader = this.htmlParser;
                    if (this.validator == null) break;
                    this.reader.setContentHandler(this.validator.getContentHandler());
                    break;
                }
                if (this.contentType != null && ("application/xml".equals(this.contentType) || "text/xml".equals(this.contentType) || Arrays.binarySearch(KNOWN_CONTENT_TYPES, this.contentType) > -1)) {
                    this.errorHandler.info("The Content-Type was \u201c" + type + "\u201d. Using the XML parser (not resolving external entities).");
                }
                this.setupXmlParser();
            }
        }
    }

    protected void newHtmlParser() {
        this.htmlParser = new HtmlParser();
        this.htmlParser.setCommentPolicy(XmlViolationPolicy.ALLOW);
        this.htmlParser.setContentNonXmlCharPolicy(XmlViolationPolicy.ALLOW);
        this.htmlParser.setContentSpacePolicy(XmlViolationPolicy.ALTER_INFOSET);
        this.htmlParser.setNamePolicy(XmlViolationPolicy.ALLOW);
        this.htmlParser.setStreamabilityViolationPolicy(XmlViolationPolicy.FATAL);
        this.htmlParser.setXmlnsPolicy(XmlViolationPolicy.ALTER_INFOSET);
        this.htmlParser.setMappingLangToXmlLang(true);
        this.htmlParser.setHeuristics(Heuristics.ALL);
    }

    protected Validator validatorByDoctype(int schemaId) throws SAXException, IOException, IncorrectSchemaException {
        if (schemaId == 0) {
            return null;
        }
        for (int i = 0; i < presetDoctypes.length; ++i) {
            if (presetDoctypes[i] != schemaId) continue;
            return this.validatorByUrls(presetUrls[i]);
        }
        throw new RuntimeException("Doctype mappings not initialized properly.");
    }

    protected void setupXmlParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        this.xmlParser = new SAXDriver();
        this.xmlParser.setCharacterHandler(this.sourceCode);
        if (this.lexicalHandler != null) {
            this.xmlParser.setProperty("http://xml.org/sax/properties/lexical-handler", this.lexicalHandler);
        }
        this.reader = new IdFilter(this.xmlParser);
        this.reader.setFeature("http://xml.org/sax/features/string-interning", true);
        this.reader.setFeature("http://xml.org/sax/features/external-general-entities", this.parser == ParserMode.XML_EXTERNAL_ENTITIES_NO_VALIDATION);
        this.reader.setFeature("http://xml.org/sax/features/external-parameter-entities", this.parser == ParserMode.XML_EXTERNAL_ENTITIES_NO_VALIDATION);
        if (this.parser == ParserMode.XML_EXTERNAL_ENTITIES_NO_VALIDATION) {
            this.reader.setEntityResolver(this.entityResolver);
        } else {
            this.reader.setEntityResolver(new NullEntityResolver());
        }
        if (this.validator == null) {
            this.bufferingRootNamespaceSniffer = new BufferingRootNamespaceSniffer(this);
            this.reader.setContentHandler(this.bufferingRootNamespaceSniffer);
        } else {
            this.reader.setContentHandler(new RootNamespaceSniffer(this, this.validator.getContentHandler()));
            this.reader.setDTDHandler(this.validator.getDTDHandler());
        }
    }

    private Validator validatorByUrls(String schemaList) throws SAXException, IOException, IncorrectSchemaException {
        System.setProperty("nu.validator.schema.rdfa-full", "0");
        this.schemaListForStats = schemaList;
        Validator v = null;
        String[] schemas = SPACE.split(schemaList);
        for (int i = schemas.length - 1; i > -1; --i) {
            String url = schemas[i];
            if ("http://s.validator.nu/html5-all.rnc".equals(url)) {
                System.setProperty("nu.validator.schema.rdfa-full", "1");
            }
            if ("http://c.validator.nu/all/".equals(url) || "http://hsivonen.iki.fi/checkers/all/".equals(url)) {
                for (String checker : ALL_CHECKERS) {
                    v = this.combineValidatorByUrl(v, checker);
                }
                continue;
            }
            if ("http://c.validator.nu/all-html4/".equals(url) || "http://hsivonen.iki.fi/checkers/all-html4/".equals(url)) {
                for (String checker : ALL_CHECKERS_HTML4) {
                    v = this.combineValidatorByUrl(v, checker);
                }
                continue;
            }
            v = this.combineValidatorByUrl(v, url);
        }
        if (this.imageCollector != null && v != null) {
            v = new CombineValidator(this.imageCollector, v);
        }
        return v;
    }

    private Validator combineValidatorByUrl(Validator val, String url) throws SAXException, IOException, IncorrectSchemaException {
        if (!"".equals(url)) {
            Validator v = this.validatorByUrl(url);
            val = val == null ? v : new CombineValidator(v, val);
        }
        return val;
    }

    private Validator validatorByUrl(String url) throws SAXException, IOException, IncorrectSchemaException {
        Schema sch;
        Validator validator;
        ContentHandler validatorContentHandler;
        if (this.loadedValidatorUrls.contains(url)) {
            return null;
        }
        this.loadedValidatorUrls.add(url);
        if ("http://s.validator.nu/xhtml5.rnc".equals(url) || "http://s.validator.nu/html5.rnc".equals(url) || "http://s.validator.nu/html5-all.rnc".equals(url) || "http://s.validator.nu/xhtml5-all.rnc".equals(url) || "http://s.validator.nu/html5-its.rnc".equals(url) || "http://s.validator.nu/xhtml5-rdfalite.rnc".equals(url) || "http://s.validator.nu/html5-rdfalite.rnc".equals(url)) {
            this.errorHandler.setSpec(html5spec);
        }
        if ((validatorContentHandler = (validator = (sch = this.resolveSchema(url, this.jingPropertyMap)).createValidator(this.jingPropertyMap)).getContentHandler()) instanceof XmlPiChecker) {
            this.lexicalHandler = (LexicalHandler)((Object)validatorContentHandler);
        }
        if (validatorContentHandler instanceof Assertions) {
            Assertions assertions = (Assertions)validatorContentHandler;
            assertions.setRequest(this.request);
            assertions.setSourceIsCss(this.sourceCode.getIsCss());
        }
        if (validatorContentHandler instanceof LanguageDetectingChecker) {
            LanguageDetectingChecker langdetect = (LanguageDetectingChecker)validatorContentHandler;
            langdetect.setRequest(this.request);
            langdetect.setHttpContentLanguageHeader(this.request.getHeader("Content-Language"));
        }
        return validator;
    }

    @Override
    public Schema resolveSchema(String url, PropertyMap options) throws SAXException, IOException, IncorrectSchemaException {
        int i = Arrays.binarySearch(preloadedSchemaUrls, url);
        if (i > -1) {
            Schema rv = preloadedSchemas[i];
            if (options.contains(WrapProperty.ATTRIBUTE_OWNER)) {
                if (rv instanceof CheckerSchema) {
                    this.errorHandler.error(new SAXParseException("A non-schema checker cannot be used as an attribute schema.", null, url, -1, -1));
                    throw new IncorrectSchemaException();
                }
            } else {
                return rv;
            }
        }
        this.externalSchema = true;
        TypedInputSource schemaInput = (TypedInputSource)this.entityResolver.resolveEntity(null, url);
        SchemaReader sr = null;
        sr = "application/relax-ng-compact-syntax".equals(schemaInput.getType()) ? CompactSchemaReader.getInstance() : new AutoSchemaReader();
        Schema sch = sr.createSchema(schemaInput, options);
        if (Statistics.STATISTICS != null && "com.thaiopensource.validate.schematron.SchemaImpl".equals(sch.getClass().getName())) {
            this.externalSchematron = true;
        }
        return sch;
    }

    private static Schema schemaByUrl(String url, EntityResolver resolver, PropertyMap pMap) throws SAXException, IOException, IncorrectSchemaException {
        TypedInputSource schemaInput;
        log4j.debug("Will load schema: " + url);
        try {
            schemaInput = (TypedInputSource)resolver.resolveEntity(null, url);
        }
        catch (ClassCastException e) {
            log4j.fatal(url, e);
            throw e;
        }
        SchemaReader sr = null;
        sr = "application/relax-ng-compact-syntax".equals(schemaInput.getType()) ? CompactSchemaReader.getInstance() : new AutoSchemaReader();
        Schema sch = sr.createSchema(schemaInput, pMap);
        return sch;
    }

    void emitTitle(boolean markupAllowed) throws SAXException {
        if (this.willValidate()) {
            this.emitter.characters(RESULTS_TITLE);
            this.emitter.characters(FOR);
            if (this.document != null && this.document.length() > 0) {
                this.emitter.characters(VerifierServletTransaction.scrub(this.shortenDataUri(this.document)));
            } else if (this.request.getAttribute("nu.validator.servlet.MultipartFormDataFilter.filename") != null) {
                this.emitter.characters("uploaded file " + VerifierServletTransaction.scrub(this.request.getAttribute("nu.validator.servlet.MultipartFormDataFilter.filename").toString()));
            } else {
                this.emitter.characters("contents of text-input area");
            }
        } else {
            this.emitter.characters(SERVICE_TITLE);
            if (markupAllowed && System.getProperty("nu.validator.servlet.service-name", "").equals("Validator.nu")) {
                this.emitter.startElement("span");
                this.emitter.characters(LIVING_VERSION);
                this.emitter.endElement("span");
            }
        }
    }

    protected String shortenDataUri(String uri) {
        if (DataUri.startsWithData(uri)) {
            return "data:\u2026";
        }
        return uri;
    }

    void emitForm() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("method", "get");
        if (this.isSimple()) {
            this.attrs.addAttribute("class", "simple");
        }
        this.emitter.startElement("form", this.attrs);
        this.emitFormContent();
        this.emitter.endElement("form");
    }

    protected boolean isSimple() {
        return false;
    }

    protected void emitFormContent() throws SAXException {
        FormEmitter.emit(this.contentHandler, this);
    }

    void emitSchemaField() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("name", "schema");
        this.attrs.addAttribute("id", "schema");
        this.attrs.addAttribute("pattern", "(?:(?:(?:https?://\\S+)|(?:data:\\S+))(?:\\s+(?:(?:https?://\\S+)|(?:data:\\S+)))*)?");
        this.attrs.addAttribute("title", "Space-separated list of schema URLs. (Leave blank to let the service guess.)");
        if (this.schemaUrls != null) {
            this.attrs.addAttribute("value", VerifierServletTransaction.scrub(this.schemaUrls));
        }
        this.emitter.startElement("input", this.attrs);
        this.emitter.endElement("input");
    }

    void emitDocField() throws SAXException {
        Object att;
        this.attrs.clear();
        this.attrs.addAttribute("type", "url");
        this.attrs.addAttribute("name", "doc");
        this.attrs.addAttribute("id", "doc");
        this.attrs.addAttribute("pattern", "(?:(?:https?://.+)|(?:data:.+))?");
        this.attrs.addAttribute("title", "Absolute URL (http, https or data only) of the document to be checked.");
        this.attrs.addAttribute("tabindex", "0");
        this.attrs.addAttribute("autofocus", "autofocus");
        if (this.document != null) {
            this.attrs.addAttribute("value", VerifierServletTransaction.scrub(this.document));
        }
        if ((att = this.request.getAttribute("nu.validator.servlet.MultipartFormDataFilter.type")) != null) {
            this.attrs.addAttribute("class", att.toString());
        }
        this.emitter.startElement("input", this.attrs);
        this.emitter.endElement("input");
    }

    void emitSchemaDuration() throws SAXException {
    }

    void emitDocDuration() throws SAXException {
    }

    void emitTotalDuration() throws SAXException {
        this.emitter.characters("" + (System.currentTimeMillis() - this.start));
    }

    void emitPresetOptions() throws SAXException {
        for (int i = 0; i < presetUrls.length; ++i) {
            this.emitter.option(presetLabels[i], presetUrls[i], false);
        }
    }

    void emitParserOptions() throws SAXException {
        this.emitter.option("Automatically from Content-Type", "", this.parser == ParserMode.AUTO);
        this.emitter.option("HTML", "html", this.parser == ParserMode.HTML);
        this.emitter.option("XML; don\u2019t load external entities", "xml", this.parser == ParserMode.XML_NO_EXTERNAL_ENTITIES);
        this.emitter.option("XML; load external entities", "xmldtd", this.parser == ParserMode.XML_EXTERNAL_ENTITIES_NO_VALIDATION);
    }

    void emitProfileOptions() throws SAXException {
        this.profile = this.request.getParameter("profile");
        this.emitter.option("Permissive: only what the spec requires", "", "".equals(this.profile));
        this.emitter.option("Pedagogical: suitable for teaching purposes", "pedagogical", "pedagogical".equals(this.profile));
        this.emitter.option("Polyglot: works both as HTML and as XML", "polyglot", "polyglot".equals(this.profile));
    }

    void emitLaxTypeField() throws SAXException {
        this.emitter.checkbox("laxtype", "yes", this.laxType);
    }

    void emitShowSourceField() throws SAXException {
        this.emitter.checkbox("showsource", "yes", this.showSource);
    }

    void emitShowOutlineField() throws SAXException {
        this.emitter.checkbox("showoutline", "yes", this.showOutline);
    }

    void emitShowImageReportField() throws SAXException {
        this.emitter.checkbox("showimagereport", "yes", this.imageCollector != null);
    }

    void emitCheckErrorPagesField() throws SAXException {
        this.emitter.checkbox("checkerrorpages", "yes", this.checkErrorPages);
    }

    void rootNamespace(String namespace, Locator locator) throws SAXException {
        if (this.validator == null) {
            int index = -1;
            for (int i = 0; i < presetNamespaces.length; ++i) {
                if (!namespace.equals(presetNamespaces[i])) continue;
                index = i;
                break;
            }
            if (index == -1) {
                String message = "Cannot find preset schema for namespace: \u201c" + namespace + "\u201d.";
                SAXException se = new SAXException(message);
                this.errorHandler.schemaError(se);
                throw new CannotFindPresetSchemaException();
            }
            String label = presetLabels[index];
            String urls = presetUrls[index];
            this.errorHandler.info("Using the preset for " + label + " based on the root namespace.");
            try {
                this.validator = this.validatorByUrls(urls);
            }
            catch (IncorrectSchemaException | IOException e) {
                throw new RuntimeException(e);
            }
            if (this.bufferingRootNamespaceSniffer == null) {
                throw new RuntimeException("Bug! bufferingRootNamespaceSniffer was null.");
            }
            this.bufferingRootNamespaceSniffer.setContentHandler(this.validator.getContentHandler());
        }
        if (!this.rootNamespaceSeen) {
            int i;
            this.rootNamespaceSeen = true;
            if (this.contentType != null && (i = Arrays.binarySearch(KNOWN_CONTENT_TYPES, this.contentType)) > -1 && !NAMESPACES_FOR_KNOWN_CONTENT_TYPES[i].equals(namespace)) {
                String message = "".equals(namespace) ? "\u201c" + this.contentType + "\u201d is not an appropriate Content-Type for a document whose root element is not in a namespace." : "\u201c" + this.contentType + "\u201d is not an appropriate Content-Type for a document whose root namespace is \u201c" + namespace + "\u201d.";
                SAXParseException spe = new SAXParseException(message, locator);
                this.errorHandler.warning(spe);
            }
        }
    }

    @Override
    public void documentMode(DocumentMode mode, String publicIdentifier, String systemIdentifier) throws SAXException {
        if (systemIdentifier != null) {
            if ("about:legacy-compat".equals(systemIdentifier)) {
                this.aboutLegacyCompat = true;
                this.errorHandler.warning(new SAXParseException("Documents should not use \u201cabout:legacy-compat\u201d, except if generated by legacy systems that can't output the standard \u201c<!DOCTYPE html>\u201d  doctype.", null));
            }
            if (systemIdentifier.contains("http://www.w3.org/TR/xhtml1")) {
                this.xhtml1Doctype = true;
            }
            if (systemIdentifier.contains("http://www.w3.org/TR/html4")) {
                this.html4Doctype = true;
            }
        }
        if (publicIdentifier != null && publicIdentifier.contains("-//W3C//DTD HTML 4")) {
            this.html4Doctype = true;
        }
        if (this.validator == null) {
            try {
                if ("yes".equals(this.request.getParameter("sniffdoctype"))) {
                    if ("-//W3C//DTD XHTML 1.0 Transitional//EN".equals(publicIdentifier)) {
                        this.errorHandler.info("XHTML 1.0 Transitional doctype seen. Appendix C is not supported. Proceeding anyway for your convenience. The parser is still an HTML parser, so namespace processing is not performed and \u201cxml:*\u201d attributes are not supported. Using the schema for " + this.getPresetLabel(1) + ".");
                        this.validator = this.validatorByDoctype(1);
                    } else if ("-//W3C//DTD XHTML 1.0 Strict//EN".equals(publicIdentifier)) {
                        this.errorHandler.info("XHTML 1.0 Strict doctype seen. Appendix C is not supported. Proceeding anyway for your convenience. The parser is still an HTML parser, so namespace processing is not performed and \u201cxml:*\u201d attributes are not supported. Using the schema for " + this.getPresetLabel(2) + ".");
                        this.validator = this.validatorByDoctype(2);
                    } else if ("-//W3C//DTD HTML 4.01 Transitional//EN".equals(publicIdentifier)) {
                        this.errorHandler.info("HTML 4.01 Transitional doctype seen. Using the schema for " + this.getPresetLabel(1) + ".");
                        this.validator = this.validatorByDoctype(1);
                    } else if ("-//W3C//DTD HTML 4.01//EN".equals(publicIdentifier)) {
                        this.errorHandler.info("HTML 4.01 Strict doctype seen. Using the schema for " + this.getPresetLabel(2) + ".");
                        this.validator = this.validatorByDoctype(2);
                    } else if ("-//W3C//DTD HTML 4.0 Transitional//EN".equals(publicIdentifier)) {
                        this.errorHandler.info("Legacy HTML 4.0 Transitional doctype seen.  Please consider using HTML 4.01 Transitional instead. Proceeding anyway for your convenience with the schema for " + this.getPresetLabel(1) + ".");
                        this.validator = this.validatorByDoctype(1);
                    } else if ("-//W3C//DTD HTML 4.0//EN".equals(publicIdentifier)) {
                        this.errorHandler.info("Legacy HTML 4.0 Strict doctype seen. Please consider using HTML 4.01 instead. Proceeding anyway for your convenience with the schema for " + this.getPresetLabel(2) + ".");
                        this.validator = this.validatorByDoctype(2);
                    }
                }
                if (this.validator == null) {
                    this.schemaIsDefault = true;
                    this.validator = this.validatorByDoctype(3);
                }
            }
            catch (IncorrectSchemaException | IOException e) {
                throw new RuntimeException(e);
            }
            ContentHandler ch = this.validator.getContentHandler();
            ch.setDocumentLocator(this.htmlParser.getDocumentLocator());
            ch.startDocument();
            this.reader.setContentHandler(ch);
        }
    }

    private String getPresetLabel(int schemaId) {
        for (int i = 0; i < presetDoctypes.length; ++i) {
            if (presetDoctypes[i] != schemaId) continue;
            return presetLabels[i];
        }
        return "unknown";
    }

    protected void setAcceptAllKnownXmlTypes(boolean acceptAllKnownXmlTypes) {
        this.contentTypeParser.setAcceptAllKnownXmlTypes(acceptAllKnownXmlTypes);
        this.dataRes.setAcceptAllKnownXmlTypes(acceptAllKnownXmlTypes);
        this.httpRes.setAcceptAllKnownXmlTypes(acceptAllKnownXmlTypes);
    }

    protected void setAllowGenericXml(boolean allowGenericXml) {
        this.contentTypeParser.setAllowGenericXml(allowGenericXml);
        this.httpRes.setAllowGenericXml(allowGenericXml);
        this.dataRes.setAllowGenericXml(allowGenericXml);
    }

    protected void setAllowHtml(boolean allowHtml) {
        this.contentTypeParser.setAllowHtml(allowHtml);
        this.httpRes.setAllowHtml(allowHtml);
        this.dataRes.setAllowHtml(allowHtml);
    }

    protected void setAllowCss(boolean allowCss) {
        this.contentTypeParser.setAllowCss(allowCss);
        this.httpRes.setAllowCss(allowCss);
        this.dataRes.setAllowCss(allowCss);
    }

    protected void setAllowRnc(boolean allowRnc) {
        this.contentTypeParser.setAllowRnc(allowRnc);
        this.httpRes.setAllowRnc(allowRnc);
        this.dataRes.setAllowRnc(allowRnc);
        this.entityResolver.setAllowRnc(allowRnc);
    }

    protected void setAllowXhtml(boolean allowXhtml) {
        this.contentTypeParser.setAllowXhtml(allowXhtml);
        this.httpRes.setAllowXhtml(allowXhtml);
        this.dataRes.setAllowXhtml(allowXhtml);
    }

    protected void loadDocumentInput() throws SAXException, IOException {
        if (this.documentInput != null) {
            return;
        }
        if (this.methodIsGet) {
            this.documentInput = (TypedInputSource)this.entityResolver.resolveEntity(null, this.document);
            this.errorHandler.setLoggingOk(true);
        } else {
            long len = this.request.getContentLength();
            if (len > SIZE_LIMIT) {
                throw new StreamBoundException("Resource size exceeds limit.");
            }
            this.documentInput = this.contentTypeParser.buildTypedInputSource(this.document, null, this.postContentType);
            this.documentInput.setByteStream(len < 0L ? new BoundedInputStream(this.request.getInputStream(), SIZE_LIMIT, this.document) : this.request.getInputStream());
            this.documentInput.setSystemId(this.request.getHeader("Content-Location"));
        }
        if (this.imageCollector != null) {
            this.baseUriTracker = new BaseUriTracker(this.documentInput.getSystemId(), this.documentInput.getLanguage());
            this.imageCollector.initializeContext(this.baseUriTracker);
        }
    }

    void emitStyle() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("href", STYLE_SHEET);
        this.attrs.addAttribute("rel", "stylesheet");
        this.emitter.startElement("link", this.attrs);
        this.emitter.endElement("link");
    }

    void emitIcon() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("href", ICON);
        this.attrs.addAttribute("rel", "icon");
        this.emitter.startElement("link", this.attrs);
        this.emitter.endElement("link");
    }

    void emitScript() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("src", SCRIPT);
        this.emitter.startElement("script", this.attrs);
        this.emitter.endElement("script");
    }

    void emitAbout() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("href", ABOUT_PAGE);
        this.emitter.startElement("a", this.attrs);
        this.emitter.characters(ABOUT_THIS_SERVICE);
        this.emitter.endElement("a");
    }

    void emitVersion() throws SAXException {
        this.emitter.characters(VERSION);
    }

    void emitUserAgentInput() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("name", "useragent");
        this.attrs.addAttribute("list", "useragents");
        this.attrs.addAttribute("value", this.userAgent);
        this.emitter.startElement("input", this.attrs);
        this.emitter.endElement("input");
    }

    void emitAcceptLanguageInput() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("id", "acceptlanguage");
        this.attrs.addAttribute("name", "acceptlanguage");
        this.emitter.startElement("input", this.attrs);
        this.emitter.endElement("input");
    }

    void emitOtherFacetLink() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("href", HTML5_FACET);
        this.emitter.startElement("a", this.attrs);
        this.emitter.characters(SIMPLE_UI);
        this.emitter.endElement("a");
    }

    void emitNsfilterField() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("name", "nsfilter");
        this.attrs.addAttribute("id", "nsfilter");
        this.attrs.addAttribute("pattern", "(?:.+:.+(?:\\s+.+:.+)*)?");
        this.attrs.addAttribute("title", "Space-separated namespace URIs for vocabularies to be filtered out.");
        if (!this.filteredNamespaces.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String ns : this.filteredNamespaces) {
                if (!first) {
                    sb.append(' ');
                }
                sb.append(ns);
                first = false;
            }
            this.attrs.addAttribute("value", VerifierServletTransaction.scrub(sb));
        }
        this.emitter.startElement("input", this.attrs);
        this.emitter.endElement("input");
    }

    void maybeEmitNsfilterField() throws SAXException {
        NsFilterEmitter.emit(this.contentHandler, this);
    }

    void emitCharsetOptions() throws SAXException {
        boolean found = false;
        for (int i = 0; i < CHARSETS.length; ++i) {
            String charset = CHARSETS[i];
            boolean selected = charset.equalsIgnoreCase(this.charsetOverride);
            this.emitter.option(CHARSET_DESCRIPTIONS[i], charset, selected);
            if (!selected) continue;
            found = true;
        }
        if (!found && this.charsetOverride != null) {
            this.emitter.option(this.charsetOverride, this.charsetOverride, true);
        }
    }

    void maybeEmitCharsetField() throws SAXException {
        CharsetEmitter.emit(this.contentHandler, this);
    }

    static {
        block26: {
            log4j = Logger.getLogger(VerifierServletTransaction.class);
            SPACE = Pattern.compile("\\s+");
            JS_IDENTIFIER = Pattern.compile("[\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}_\\$][\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}_\\$\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}]*");
            JS_RESERVED_WORDS = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "export", "extends", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "typeof", "var", "void", "volatile", "while", "with"};
            CHARSETS = new String[]{"UTF-8", "UTF-16", "Windows-1250", "Windows-1251", "Windows-1252", "Windows-1253", "Windows-1254", "Windows-1255", "Windows-1256", "Windows-1257", "Windows-1258", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-8859-13", "ISO-8859-15", "KOI8-R", "TIS-620", "GBK", "GB18030", "Big5", "Big5-HKSCS", "Shift_JIS", "ISO-2022-JP", "EUC-JP", "ISO-2022-KR", "EUC-KR"};
            CHARSET_DESCRIPTIONS = new char[][]{"UTF-8 (Global)".toCharArray(), "UTF-16 (Global)".toCharArray(), "Windows-1250 (Central European)".toCharArray(), "Windows-1251 (Cyrillic)".toCharArray(), "Windows-1252 (Western)".toCharArray(), "Windows-1253 (Greek)".toCharArray(), "Windows-1254 (Turkish)".toCharArray(), "Windows-1255 (Hebrew)".toCharArray(), "Windows-1256 (Arabic)".toCharArray(), "Windows-1257 (Baltic)".toCharArray(), "Windows-1258 (Vietnamese)".toCharArray(), "ISO-8859-1 (Western)".toCharArray(), "ISO-8859-2 (Central European)".toCharArray(), "ISO-8859-3 (South European)".toCharArray(), "ISO-8859-4 (Baltic)".toCharArray(), "ISO-8859-5 (Cyrillic)".toCharArray(), "ISO-8859-6 (Arabic)".toCharArray(), "ISO-8859-7 (Greek)".toCharArray(), "ISO-8859-8 (Hebrew)".toCharArray(), "ISO-8859-9 (Turkish)".toCharArray(), "ISO-8859-13 (Baltic)".toCharArray(), "ISO-8859-15 (Western)".toCharArray(), "KOI8-R (Russian)".toCharArray(), "TIS-620 (Thai)".toCharArray(), "GBK (Chinese, simplified)".toCharArray(), "GB18030 (Chinese, simplified)".toCharArray(), "Big5 (Chinese, traditional)".toCharArray(), "Big5-HKSCS (Chinese, traditional)".toCharArray(), "Shift_JIS (Japanese)".toCharArray(), "ISO-2022-JP (Japanese)".toCharArray(), "EUC-JP (Japanese)".toCharArray(), "ISO-2022-KR (Korean)".toCharArray(), "EUC-KR (Korean)".toCharArray()};
            LIVING_VERSION = "Living Validator".toCharArray();
            FOR = " for ".toCharArray();
            ABOUT_THIS_SERVICE = "About this Service".toCharArray();
            SIMPLE_UI = "Simplified Interface".toCharArray();
            CSS_CHECKING_PROLOG = "<!DOCTYPE html><html lang=''><title>s</title><style>\n".getBytes();
            CSS_CHECKING_EPILOG = "\n</style>".getBytes();
            KNOWN_CONTENT_TYPES = new String[]{"application/atom+xml", "application/docbook+xml", "application/xhtml+xml", "application/xv+xml", "image/svg+xml"};
            NAMESPACES_FOR_KNOWN_CONTENT_TYPES = new String[]{"http://www.w3.org/2005/Atom", "http://docbook.org/ns/docbook", "http://www.w3.org/1999/xhtml", "http://www.w3.org/1999/xhtml", "http://www.w3.org/2000/svg"};
            ALL_CHECKERS = new String[]{"http://c.validator.nu/table/", "http://c.validator.nu/nfc/", "http://c.validator.nu/text-content/", "http://c.validator.nu/unchecked/", "http://c.validator.nu/usemap/", "http://c.validator.nu/obsolete/", "http://c.validator.nu/xml-pi/", "http://c.validator.nu/unsupported/", "http://c.validator.nu/microdata/", "http://c.validator.nu/langdetect/"};
            ALL_CHECKERS_HTML4 = new String[]{"http://c.validator.nu/table/", "http://c.validator.nu/nfc/", "http://c.validator.nu/unchecked/", "http://c.validator.nu/usemap/"};
            DENY_LIST = System.getProperty("nu.validator.servlet.deny-list", "").split("\\s+");
            ABOUT_PAGE = System.getProperty("nu.validator.servlet.about-page", "https://about.validator.nu/");
            HTML5_FACET = (VerifierServlet.HTML5_HOST.isEmpty() ? "" : "//" + VerifierServlet.HTML5_HOST) + VerifierServlet.HTML5_PATH;
            STYLE_SHEET = System.getProperty("nu.validator.servlet.style-sheet", "style.css");
            ICON = System.getProperty("nu.validator.servlet.icon", "icon.png");
            SCRIPT = System.getProperty("nu.validator.servlet.script", "script.js");
            SIZE_LIMIT = Integer.parseInt(System.getProperty("nu.validator.servlet.max-file-size", "2097152"));
            systemFilterString = "";
            FILTER_FILE = System.getProperty("nu.validator.servlet.filterfile", "resources/message-filters.txt");
            try {
                int i;
                String line;
                log4j.debug("Starting static initializer.");
                lastModified = 0L;
                BufferedReader r = new BufferedReader(new InputStreamReader(LocalCacheEntityResolver.getPresetsAsStream(), "UTF-8"));
                LinkedList<String> doctypes = new LinkedList<String>();
                LinkedList<String> namespaces = new LinkedList<String>();
                LinkedList<String> labels = new LinkedList<String>();
                LinkedList<String> urls = new LinkedList<String>();
                Properties props = new Properties();
                log4j.debug("Reading miscellaneous properties.");
                props.load(VerifierServlet.class.getClassLoader().getResourceAsStream("nu/validator/localentities/files/misc.properties"));
                SERVICE_TITLE = (System.getProperty("nu.validator.servlet.service-name", props.getProperty("nu.validator.servlet.service-name", "Validator.nu")) + " ").toCharArray();
                RESULTS_TITLE = System.getProperty("nu.validator.servlet.results-title", props.getProperty("nu.validator.servlet.results-title", "Validation results")).toCharArray();
                VERSION = System.getProperty("nu.validator.servlet.version", props.getProperty("nu.validator.servlet.version", "Living Validator")).toCharArray();
                USER_AGENT = System.getProperty("nu.validator.servlet.user-agent", props.getProperty("nu.validator.servlet.user-agent", "Validator.nu/LV"));
                log4j.debug("Starting to loop over config file lines.");
                while ((line = r.readLine()) != null && !"".equals(line.trim())) {
                    String[] s = line.split("\t");
                    doctypes.add(s[0]);
                    namespaces.add(s[1]);
                    labels.add(s[2]);
                    urls.add(s[3]);
                }
                log4j.debug("Finished reading config.");
                String[] presetDoctypesAsStrings = doctypes.toArray(new String[0]);
                presetNamespaces = namespaces.toArray(new String[0]);
                presetLabels = labels.toArray(new String[0]);
                presetUrls = urls.toArray(new String[0]);
                log4j.debug("Converted config to arrays.");
                for (i = 0; i < presetNamespaces.length; ++i) {
                    String str = presetNamespaces[i];
                    VerifierServletTransaction.presetNamespaces[i] = "-".equals(str) ? null : presetNamespaces[i].intern();
                }
                log4j.debug("Prepared namespace array.");
                presetDoctypes = new int[presetDoctypesAsStrings.length];
                for (i = 0; i < presetDoctypesAsStrings.length; ++i) {
                    VerifierServletTransaction.presetDoctypes[i] = Integer.parseInt(presetDoctypesAsStrings[i]);
                }
                log4j.debug("Parsed doctype numbers into ints.");
                String prefix = System.getProperty("nu.validator.servlet.cachepathprefix");
                log4j.debug("The cache path prefix is: " + prefix);
                SystemErrErrorHandler eh = new SystemErrErrorHandler();
                LocalCacheEntityResolver er = new LocalCacheEntityResolver(new NullEntityResolver());
                er.setAllowRnc(true);
                PropertyMapBuilder pmb = new PropertyMapBuilder();
                pmb.put(ValidateProperty.ERROR_HANDLER, eh);
                pmb.put(ValidateProperty.ENTITY_RESOLVER, er);
                pmb.put(ValidateProperty.XML_READER_CREATOR, new VerifierServletXMLReaderCreator(eh, er));
                RngProperty.CHECK_ID_IDREF.add(pmb);
                PropertyMap pMap = pmb.toPropertyMap();
                log4j.debug("Parsing set up. Starting to read schemas.");
                TreeMap<String, Schema> schemaMap = new TreeMap<String, Schema>();
                schemaMap.put("http://c.validator.nu/table/", CheckerSchema.TABLE_CHECKER);
                schemaMap.put("http://hsivonen.iki.fi/checkers/table/", CheckerSchema.TABLE_CHECKER);
                schemaMap.put("http://c.validator.nu/nfc/", CheckerSchema.NORMALIZATION_CHECKER);
                schemaMap.put("http://hsivonen.iki.fi/checkers/nfc/", CheckerSchema.NORMALIZATION_CHECKER);
                schemaMap.put("http://c.validator.nu/debug/", CheckerSchema.DEBUG_CHECKER);
                schemaMap.put("http://hsivonen.iki.fi/checkers/debug/", CheckerSchema.DEBUG_CHECKER);
                schemaMap.put("http://c.validator.nu/text-content/", CheckerSchema.TEXT_CONTENT_CHECKER);
                schemaMap.put("http://hsivonen.iki.fi/checkers/text-content/", CheckerSchema.TEXT_CONTENT_CHECKER);
                schemaMap.put("http://c.validator.nu/usemap/", CheckerSchema.USEMAP_CHECKER);
                schemaMap.put("http://n.validator.nu/checkers/usemap/", CheckerSchema.USEMAP_CHECKER);
                schemaMap.put("http://c.validator.nu/unchecked/", CheckerSchema.UNCHECKED_SUBTREE_WARNER);
                schemaMap.put("http://s.validator.nu/html5/assertions.sch", CheckerSchema.ASSERTION_SCH);
                schemaMap.put("http://c.validator.nu/obsolete/", CheckerSchema.CONFORMING_BUT_OBSOLETE_WARNER);
                schemaMap.put("http://c.validator.nu/xml-pi/", CheckerSchema.XML_PI_CHECKER);
                schemaMap.put("http://c.validator.nu/unsupported/", CheckerSchema.UNSUPPORTED_CHECKER);
                schemaMap.put("http://c.validator.nu/microdata/", CheckerSchema.MICRODATA_CHECKER);
                schemaMap.put("http://c.validator.nu/rdfalite/", CheckerSchema.RDFALITE_CHECKER);
                schemaMap.put("http://c.validator.nu/langdetect/", CheckerSchema.LANGUAGE_DETECTING_CHECKER);
                for (String presetUrl : presetUrls) {
                    for (String url : SPACE.split(presetUrl)) {
                        if (schemaMap.get(url) != null || VerifierServletTransaction.isCheckerUrl(url)) continue;
                        Schema sch = VerifierServletTransaction.schemaByUrl(url, er, pMap);
                        schemaMap.put(url, sch);
                    }
                }
                log4j.debug("Schemas read.");
                preloadedSchemaUrls = new String[schemaMap.size()];
                preloadedSchemas = new Schema[schemaMap.size()];
                int i2 = 0;
                for (Map.Entry entry : schemaMap.entrySet()) {
                    VerifierServletTransaction.preloadedSchemaUrls[i2] = ((String)entry.getKey()).intern();
                    Schema s = (Schema)entry.getValue();
                    String u = (String)entry.getKey();
                    if (VerifierServletTransaction.isDataAttributeDroppingSchema(u)) {
                        s = new DataAttributeDroppingSchemaWrapper(s);
                    }
                    if (VerifierServletTransaction.isXmlLangAllowingSchema(u)) {
                        s = new XmlLangAttributeDroppingSchemaWrapper(s);
                    }
                    if (VerifierServletTransaction.isRoleAttributeFilteringSchema(u)) {
                        s = new RoleAttributeFilteringSchemaWrapper(s);
                    }
                    if (VerifierServletTransaction.isTemplateElementDroppingSchema(u)) {
                        s = new TemplateElementDroppingSchemaWrapper(s);
                    }
                    if (VerifierServletTransaction.isCustomElementNamespaceChangingSchema(u)) {
                        s = new NamespaceChangingSchemaWrapper(s);
                    }
                    VerifierServletTransaction.preloadedSchemas[i2] = s;
                    ++i2;
                }
                log4j.debug("Reading spec.");
                html5spec = Html5SpecBuilder.parseSpec(LocalCacheEntityResolver.getHtml5SpecAsStream());
                log4j.debug("Spec read.");
                if (!new File(FILTER_FILE).isFile()) break block26;
                log4j.debug("Reading filter file " + FILTER_FILE);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FILTER_FILE), "UTF-8"));){
                    String filterline;
                    StringBuilder sb = new StringBuilder();
                    String pipe = "";
                    while ((filterline = reader.readLine()) != null) {
                        if (filterline.startsWith("#")) continue;
                        sb.append(pipe);
                        sb.append(filterline);
                        pipe = "|";
                    }
                    if (sb.length() != 0) {
                        systemFilterString = "".equals(systemFilterString) ? sb.toString() : systemFilterString + "|" + sb.toString();
                    }
                }
                log4j.debug("Filter file read.");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    class CannotFindPresetSchemaException
    extends SAXException {
        CannotFindPresetSchemaException() {
        }
    }

    private static enum OutputFormat {
        HTML,
        XHTML,
        TEXT,
        XML,
        JSON,
        RELAXED,
        SOAP,
        UNICORN,
        GNU;

    }
}

