/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.BufferOverflowException;
import java.nio.CharBuffer;

final class StreamedText
implements CharSequence {
    private final Reader reader;
    private char[] buffer;
    private boolean expandableBuffer;
    private int bufferBegin = 0;
    private int readerPos = 0;
    private int minRequiredBufferBegin = 0;
    private int end = Integer.MAX_VALUE;
    public static int INITIAL_EXPANDABLE_BUFFER_SIZE = 8192;

    public StreamedText(Reader reader, char[] cArray) {
        this.reader = reader;
        this.setBuffer(cArray);
    }

    public StreamedText(Reader reader) {
        this(reader, null);
    }

    private StreamedText(char[] cArray, int n) {
        this.reader = null;
        this.buffer = cArray;
        this.expandableBuffer = false;
        this.end = n;
        this.readerPos = Integer.MAX_VALUE;
    }

    public StreamedText(char[] cArray) {
        this(cArray, cArray.length);
    }

    public StreamedText(CharBuffer charBuffer) {
        this(charBuffer.array(), charBuffer.length());
    }

    public StreamedText(CharSequence charSequence) {
        this(StreamedText.toCharArray(charSequence));
    }

    public StreamedText setBuffer(char[] cArray) {
        if (cArray != null) {
            this.buffer = cArray;
            this.expandableBuffer = false;
        } else {
            this.buffer = new char[INITIAL_EXPANDABLE_BUFFER_SIZE];
            this.expandableBuffer = true;
        }
        return this;
    }

    public boolean hasExpandableBuffer() {
        return this.expandableBuffer;
    }

    public char charAt(int n) {
        if (n >= this.readerPos) {
            this.readToPosition(n);
        }
        this.checkPos(n);
        return this.buffer[n - this.bufferBegin];
    }

    public void setMinRequiredBufferBegin(int n) {
        if (n < this.bufferBegin) {
            throw new IllegalArgumentException("Cannot set minimum required buffer begin to already discarded position " + n);
        }
        this.minRequiredBufferBegin = n;
    }

    public int getMinRequiredBufferBegin() {
        return this.minRequiredBufferBegin;
    }

    public int length() {
        if (this.end == Integer.MAX_VALUE) {
            throw new IllegalStateException("Length of streamed text cannot be determined until end of file has been reached");
        }
        return this.end;
    }

    public int getEnd() {
        return this.end;
    }

    private void prepareBufferRange(int n, int n2) {
        int n3 = n2 - 1;
        if (n3 > this.readerPos) {
            this.readToPosition(n3);
        }
        this.checkPos(n);
        if (n2 > this.end) {
            throw new IndexOutOfBoundsException();
        }
    }

    public void writeTo(Writer writer, int n, int n2) throws IOException {
        this.prepareBufferRange(n, n2);
        writer.write(this.buffer, n - this.bufferBegin, n2 - n);
    }

    public String substring(int n, int n2) {
        this.prepareBufferRange(n, n2);
        return new String(this.buffer, n - this.bufferBegin, n2 - n);
    }

    public CharSequence subSequence(int n, int n2) {
        return this.getCharBuffer(n, n2);
    }

    public CharBuffer getCharBuffer(int n, int n2) {
        this.prepareBufferRange(n, n2);
        return CharBuffer.wrap(this.buffer, n - this.bufferBegin, n2 - n);
    }

    public String toString() {
        throw new UnsupportedOperationException("Streamed text can not be converted to a string");
    }

    public String getDebugInfo() {
        return "Buffer size: \"" + this.buffer.length + "\", bufferBegin=" + this.bufferBegin + ", minRequiredBufferBegin=" + this.minRequiredBufferBegin + ", readerPos=" + this.readerPos;
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    public int getBufferBegin() {
        return this.bufferBegin;
    }

    private void checkPos(int n) {
        if (n < this.bufferBegin) {
            throw new IllegalStateException("StreamedText position " + n + " has been discarded");
        }
        if (n >= this.end) {
            throw new IndexOutOfBoundsException();
        }
    }

    public int getBufferOverflowPosition() {
        return this.minRequiredBufferBegin + this.buffer.length;
    }

    private void readToPosition(int n) {
        try {
            if (n >= this.bufferBegin + this.buffer.length) {
                if (n >= this.minRequiredBufferBegin + this.buffer.length) {
                    if (!this.expandableBuffer) {
                        throw new BufferOverflowException();
                    }
                    this.expandBuffer(n - this.minRequiredBufferBegin + 1);
                }
                this.discardUsedText();
            }
            while (this.readerPos <= n) {
                int n2 = this.reader.read(this.buffer, this.readerPos - this.bufferBegin, this.bufferBegin + this.buffer.length - this.readerPos);
                if (n2 == -1) {
                    this.end = this.readerPos;
                    break;
                }
                this.readerPos += n2;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void expandBuffer(int n) throws IOException {
        int n2 = this.buffer.length * 2;
        if (n2 < n) {
            n2 = n;
        }
        char[] cArray = new char[n2];
        this.shiftBuffer(this.buffer, cArray);
        this.buffer = cArray;
    }

    private void discardUsedText() throws IOException {
        if (this.minRequiredBufferBegin == this.bufferBegin) {
            return;
        }
        this.shiftBuffer(this.buffer, this.buffer);
    }

    private void shiftBuffer(char[] cArray, char[] cArray2) throws IOException {
        int n = this.minRequiredBufferBegin - this.bufferBegin;
        int n2 = this.readerPos - this.bufferBegin;
        for (int i = n; i < n2; ++i) {
            cArray2[i - n] = cArray[i];
        }
        this.bufferBegin = this.minRequiredBufferBegin;
        while (this.readerPos < this.bufferBegin) {
            long l = this.reader.skip(this.bufferBegin - this.readerPos);
            if (l == 0L) {
                this.end = this.readerPos;
                break;
            }
            this.readerPos = (int)((long)this.readerPos + l);
        }
    }

    String getCurrentBufferContent() {
        return this.substring(this.bufferBegin, Math.min(this.end, this.readerPos));
    }

    private static char[] toCharArray(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return ((String)charSequence).toCharArray();
        }
        char[] cArray = new char[charSequence.length()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = charSequence.charAt(i);
        }
        return cArray;
    }
}

