/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AuditEvent;
import com.puppycrawl.tools.checkstyle.AuditListener;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.OutputStream;
import java.io.PrintWriter;

public class DefaultLogger
implements AuditListener {
    private static final int BUFFER_CUSHION = 12;
    private final PrintWriter mInfoWriter;
    private final boolean mCloseInfo;
    private final PrintWriter mErrorWriter;
    private final boolean mCloseError;

    public DefaultLogger(OutputStream aOS, boolean aCloseStreamsAfterUse) {
        this(aOS, aCloseStreamsAfterUse, aOS, false);
    }

    public DefaultLogger(OutputStream aInfoStream, boolean aCloseInfoAfterUse, OutputStream aErrorStream, boolean aCloseErrorAfterUse) {
        this.mCloseInfo = aCloseInfoAfterUse;
        this.mCloseError = aCloseErrorAfterUse;
        this.mInfoWriter = new PrintWriter(aInfoStream);
        this.mErrorWriter = aInfoStream == aErrorStream ? this.mInfoWriter : new PrintWriter(aErrorStream);
    }

    public void addError(AuditEvent aEvt) {
        SeverityLevel severityLevel = aEvt.getSeverityLevel();
        if (!SeverityLevel.IGNORE.equals(severityLevel)) {
            String fileName = aEvt.getFileName();
            String message = aEvt.getMessage();
            int bufLen = fileName.length() + message.length() + 12;
            StringBuffer sb = new StringBuffer(bufLen);
            sb.append(fileName);
            sb.append(':').append(aEvt.getLine());
            if (aEvt.getColumn() > 0) {
                sb.append(':').append(aEvt.getColumn());
            }
            if (SeverityLevel.WARNING.equals(severityLevel)) {
                sb.append(": warning");
            }
            sb.append(": ").append(message);
            this.mErrorWriter.println(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addException(AuditEvent aEvt, Throwable aThrowable) {
        PrintWriter printWriter = this.mErrorWriter;
        synchronized (printWriter) {
            this.mErrorWriter.println("Error auditing " + aEvt.getFileName());
            aThrowable.printStackTrace(this.mErrorWriter);
        }
    }

    public void auditStarted(AuditEvent aEvt) {
        this.mInfoWriter.println("Starting audit...");
    }

    public void fileFinished(AuditEvent aEvt) {
    }

    public void fileStarted(AuditEvent aEvt) {
    }

    public void auditFinished(AuditEvent aEvt) {
        this.mInfoWriter.println("Audit done.");
        this.closeStreams();
    }

    protected void closeStreams() {
        this.mInfoWriter.flush();
        if (this.mCloseInfo) {
            this.mInfoWriter.close();
        }
        this.mErrorWriter.flush();
        if (this.mCloseError) {
            this.mErrorWriter.close();
        }
    }
}

