#!/bin/sh
#/*
# * Copyrighy (c) 1999 CLE Project. All rights reserved.
# * Copyright (c) 1999 Yuan-Chung Cheng. All rights reserved.
# *
# *   Modified by Chih-Wei Huang         January 6, 2000
# *
# * Redistribution and use in source and binary forms, with or without
# * modification, are permitted provided that the following conditions
# * are met:
# * 1. Redistributions of source code must retain the above copyright
# *    notice, this list of conditions and the following disclaimer.
# * 2. Redistributions in binary form must reproduce the above copyright
# *    notice, this list of conditions and the following disclaimer in the
# *    documentation and/or other materials provided with the distribution.
# * 3. All advertising materials mentioning features or use of this software
# *    must display the following acknowledgement:
# *      This product includes software developed by
# *      Yuan-Chung Cheng and contributors for CLE Project
# * 4. Neither the name of the Author nor the names of contributors
# *    may be used to endorse or promote products derived from this software
# *    without specific prior written permission.
# *
# * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# * SUCH DAMAGE.
# */

# The system depended variables...

VERSION=0.9.3

export PREFIX; PREFIX=/usr/local
export PATH; PATH=/bin:/sbin:/usr/bin:/usr/sbin:$PREFIX/bin:$PREFIX/sbin
export DefaultFontPath; DefaultFontPath=$PREFIX/share/fonts/TrueType
export ScriptDir; ScriptDir=$PREFIX/share/ttfm
export ScriptSubfix; ScriptSubfix="ttfm"
#KEEP_FONT="yes"	# FreeBSD's port/package system will handle this.

# USAGE

Usage()
{
    echo " " > /dev/stderr
    echo "True-Type Font Manager $VERSION" > /dev/stderr
    echo "       " > /dev/stderr
    echo "Usage: $0 [option]" > /dev/stderr
    echo "       " > /dev/stderr
    echo "       --add [module] <file>...    install ttf font" > /dev/stderr
    echo "       --remove [module] <file>... remove ttf font from the system" > /dev/stderr
    echo "       --list <module>... list all ttf fonts on the system" > /dev/stderr
    echo "       --modules          list all ttf manager modules on the system" > /dev/stderr
    echo "       --setdefault <module> <file> " > /dev/stderr
    echo "                          set default ming font of module to file" > /dev/stderr
    echo "       --setdefault_kai <module> <file> " > /dev/stderr
    echo "                          set default kai font of module to file" > /dev/stderr
    echo "       --initm <module>.. initialize modules" > /dev/stderr
    echo "       --help             show this info" > /dev/stderr
}

# check the system requirement...
check_system()
{
    # ttfinfo
    TTFINFO=`which ttfinfo`
    if [ -z $TTFINFO ] ; then
	echo "Can't find ttfinfo, please install ttfinfo first." > /dev/stderr
	exit 1
    fi

    # ScriptDir
    
    if [ ! -d $ScriptDir ] ; then
	echo "Script directory $ScriptDir does not exist." > /dev/stderr
	echo "Please check out your system setup." > /dev/stderr
	exit 1
    fi

    # DefaultFontPath
    if [ ! -d $DefaultFontPath ] ; then
	echo "Create default font directory $DefaultFontPath." > /dev/stderr
	mkdir -p $DefaultFontPath
    fi
    
    # Install scripts
    
    INSTALLSCRIPT=`/bin/ls $ScriptDir/*.${ScriptSubfix}`
    
    if [ "z$INSTALLSCRIPT" = "z" ] ; then
	echo "Can't find any TTFM modules." > /dev/stderr
	exit 1
    fi
}

list_fonts()
{
    check_system;

    # $@ modules list.
    if [ $# -lt 1 ] ; then
        MODLIST="$INSTALLSCRIPT"
    else
        MODLIST="$@"
    fi

    for i in $MODLIST ; do
        modulename=`basename $i .${ScriptSubfix}`
        MOD="${ScriptDir}/${modulename}.${ScriptSubfix}"
        if [ -x "$MOD" ] ; then
            # run script
            $MOD --name
	    $MOD --list
	else
            echo "$MOD is not executable, ignored." > /dev/stderr
	fi
    done
}

list_modules()
{
    check_system;

    for i in $INSTALLSCRIPT ;
    do
        if [ -x $i ] ; then
            # module name
	    echo `basename $i .${ScriptSubfix}` 
            #$i --name
	else
            echo "$i is not executable, ignored." > /dev/stderr
	fi
    done
}

setdefault_fonts()
{

    if [ $# -lt 2 ] ; then
        echo "Too few arguments." > /dev/stderr
	Usage;
	exit 1;
    fi

    check_system;

    # $1=module  $2=fontfile

    modulename=`basename $1 .${ScriptSubfix}`
    fontfile=`basename $2`
    
    # Does this module exist?
    if [ ! -x "${ScriptDir}/${modulename}.${ScriptSubfix}" ] ; then
        echo "Module $1 does not exist." > /dev/stderr
	exit 1
    fi

    # Check whether this font has installed for this module
    
    i=`${ScriptDir}/${modulename}.${ScriptSubfix} --list | grep -e "$fontfile"`
    if [ -z "$i" ] ; then
        echo "Font $fontfile is not installed in module $1." > /dev/stderr
        echo "Please use --add first." > /dev/stderr
	exit 1
    fi

    # Set the default font... :p
    if [ $face = "kai" ]; then
        ${ScriptDir}/${modulename}.${ScriptSubfix} --setdefault_kai $2
    else
        ${ScriptDir}/${modulename}.${ScriptSubfix} --setdefault $2
    fi
}


add_fonts()
{
    check_system;
    if [ -x "$ScriptDir/$1" ]; then
        INSTALLSCRIPT="$ScriptDir/$1"
        shift 1
    elif [ -x "$ScriptDir/$1.ttfm" ]; then
        INSTALLSCRIPT="$ScriptDir/$1.ttfm"
        shift 1
    fi

    # Run for every fontfiles...
    for FONTFILE in $*; do
	FONTFILENAME=`basename "$FONTFILE"`
	FONTFILEPATH=`dirname "$FONTFILE"`
        [ $FONTFILEPATH = '.' ] && FONTFILEPATH=`pwd`    # --add *
	
	# Just make a link, don't copy, since CJK fonts are usually big.
	if [ ! -r "$DefaultFontPath/$FONTFILENAME" ] ; then
	    ln -sf "$FONTFILEPATH/$FONTFILENAME" "$DefaultFontPath/$FONTFILENAME"
	fi
	
	# Get and save the font information
#	FONTINFOS=`$TTFINFO -c "$DefaultFontPath/$FONTFILENAME" | tr ' ' '?' `
	
#	if [ "z$FONTINFOS" = "z" ] ; then
#	    echo "Format of $FONTFILEPATH/$FONTFILE is not correct." > /dev/stderr
#	    continue;
#	fi
	
	# Export info as environment variable in a subshell
	(
#	for i in $FONTINFOS; do
#	    i=`echo $i |  tr '?' ' ' `
#	    eval "export $i"
#	done
	
	# Call modules with --add
	for i in $INSTALLSCRIPT; do
    	    echo $i
	        if [ -x $i ] ; then
	 	    $i --add "${DefaultFontPath}/${FONTFILENAME}" || {
			echo "Error in running $i to add $DefaultFontPath/$FONTFILENAME." > /dev/stderr
			}
	    else
		echo "$i is not executable, ignored." > /dev/stderr
		continue;
	    fi
	done
	)
	
    done
}


remove_fonts()
{
    check_system;
    if [ -x "$ScriptDir/$1" ]; then
        INSTALLSCRIPT="$ScriptDir/$1"
        shift 1
    elif [ -x "$ScriptDir/$1.ttfm" ]; then
        INSTALLSCRIPT="$ScriptDir/$1.ttfm"
        shift 1
    fi

    # Run for every fontfiles...
    for FONTFILE in $*; do
	FONTFILENAME=`basename $FONTFILE`

	# Does this file exist?
	if [ ! -r "$DefaultFontPath/$FONTFILENAME" ] && [ -z "`echo $FONTFILENAME |grep ^default`" ]; then
	    echo "Warning: $DefaultFontPath/$FONTFILENAME does not exist." > /dev/stderr
	fi
	
	# Call script with --remove
	for i in "$INSTALLSCRIPT"; do
	    if [ -x "$i" ] ; then
		$i --remove "$FONTFILENAME" || {
		    echo "Error in running $i to remove $DefaultFontPath/$FONTFILENAME." > /dev/stderr
		}
	    else
		echo "$i is not executable, ignored." > /dev/stderr
		continue;
	    fi
	done

        # We only remove those fonts in $DefaultFontPath which are symbolic.
        # Set the variable KEEP_FONT to keep it.
        filetype=`file "$DefaultFontPath/$FONTFILENAME" |grep -e "^$DefaultFontPath/$FONTFILENAME: symbolic link to"`
        [ "X$filetype" = "X" ] && KEEP_FONT=yes
        [ "X$KEEP_FONT" = "X" ] && rm -f "$DefaultFontPath/$FONTFILENAME"
    done
}

init_modules()
{
    if [ $# -lt 1 ] ; then
        echo "Too few arguments." > /dev/stderr
        Usage;
        exit 1;
    fi

    check_system;

    # $@ modules list. if $1 = all, initialize all modules
    # Hope there is no modules named 'all' :p

    if [ "$1" = "all" ]; then
        MODLIST="$INSTALLSCRIPT"
    else
        MODLIST="$@"
    fi

    for m in $MODLIST ; do
        modulename=`basename $m .${ScriptSubfix}`
        # Does this module exist?
        MOD="${ScriptDir}/${modulename}.${ScriptSubfix}"
        if [ ! -x "$MOD" ] ; then
            echo "Module $m is not executable, ignored." > /dev/stderr
            continue
        fi

        FONTLIST=`/bin/ls ${DefaultFontPath}/*.[Tt][Tt]?`
        for FONTFILE in $FONTLIST ; do
            FONTFILENAME=`basename $FONTFILE`

            # Check whether this font has installed for this module
            i=`$MOD --list | grep -e "$FONTFILENAME" `
            [ -z "$i" ] || continue

            # Get and save the font information
            FONTINFOS=`$TTFINFO -c $FONTFILE | tr ' ' '?' `

            # Ignore file that is not ttf
            [ "X$FONTINFOS" = "X" ] && continue

            # Export info as environment variable in a subshell
            (
            for i in $FONTINFOS ; do
                i=`echo $i |  tr '?' ' ' `
                eval "export $i"
            done

            $MOD --add ${DefaultFontPath}/${FONTFILENAME} || {
                echo "Error in running $i to add $DefaultFontPath/$FONTFILENAME." > /dev/stderr
            }
            )

        done
    done
}


## Start of main program

if [ "$#" = "0" ] ; then
    Usage;
    exit 1;
fi

MODE=$1
shift 1

case $MODE in 
--help)
    Usage;
    exit 0;
    ;;
--list)
    list_fonts $@;
    exit 0;
    ;;
--modules)
    list_modules;
    exit 0;
    ;;
--add)
    add_fonts $@;
    exit 0;
    ;;
--remove)
    remove_fonts $@;
    exit 0;
    ;;
--setdefault)
    face="ming"
    setdefault_fonts $@;
    exit 0;
    ;;
--setdefault_kai)
    face="kai"
    setdefault_fonts $@;
    exit 0
    ;;
--initm)
    init_modules $@;
    exit 0;
    ;;
esac

# wrong option,, show usage info...
Usage;
exit 1

# ChangeLog
#
# $Log: ttfm.sh,v $
# Revision 1.2  2001/01/31 09:34:46  keith
# Update to 0.9.3.
#
# Revision 1.1.1.1  2000/12/16 18:56:41  keith
# Import of TTFM 0.9.2
#
# Revision 1.5  2000/12/03 13:53:15  keith
# Adapted to FreeBSD
#
# Revision 1.4  2000/02/13 10:32:32  cwhuang
# my source
#
# Revision 1.2  2000/02/10 11:40:14  platin
# Log entry was added.
#
#
